/***************************************************************************
                         ogl_bp_regs.c  -  description
                             -------------------
    begin                : 
    copyright            : (C) 2005 by Duddie
    email                : duddie@walla.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. See also the license.txt file for *
 *   additional informations.                                              *
 *                                                                         *
 ***************************************************************************/

//*************************************************************************//
// History of changes:
//
// 2005/07/13 - Pete
// - 0xFFFFFF detection in pe_copy 
//
// 2005/06/05 - Pete
// - fog handling (not perfect) and alpha test handling (not perfect)
//
// 2005/05/30 - Pete
// - scissor handling
//
// 2005/05/28 - Pete
// - changed a lotta things related to "frame finished" handling
//
//*************************************************************************//

#include "stdafx.h"
#include "bp_regs.h"
#include "pe_interface.h"
#include "gx_cache.h"
#include "texture_conversion.h"
#include "texture_environment.h"
#include "texture_cache.h"
#include "ogl_generic.h"
#define _IN_BPREGS
#include "externals.h"

///////////////////////////////////////////////////////////////////////////
// GLOBALS

uint32  gp_bp_regs[256];

GLuint  texName;
GLuint  lookupTexName[8];
uint32  tx_mode0[8];
uint32  tx_paletted;
bp_efb_info efb_info;
uint8   bp_fog=0;
bool    bUseFog=false;

const uint32    bp_blend_sfactor_table[8] = 
{
    GL_ZERO, 
    GL_ONE, 
    GL_DST_COLOR, 
    GL_ONE_MINUS_DST_COLOR,
    GL_SRC_ALPHA, 
    GL_ONE_MINUS_SRC_ALPHA,
    GL_DST_ALPHA,
    GL_ONE_MINUS_DST_ALPHA
};

const uint32    bp_blend_dfactor_table[8] = 
{
    GL_ZERO, 
    GL_ONE, 
    GL_SRC_COLOR, 
    GL_ONE_MINUS_SRC_COLOR,
    GL_SRC_ALPHA, 
    GL_ONE_MINUS_SRC_ALPHA,
    GL_DST_ALPHA,
    GL_ONE_MINUS_DST_ALPHA
};

const uint32    bp_logic_op_table[16] = 
{
    GL_CLEAR,
    GL_AND,
    GL_AND_REVERSE,
    GL_COPY,
    GL_AND_INVERTED,
    GL_NOOP,
    GL_XOR,
    GL_OR,
    GL_NOR,
    GL_EQUIV,
    GL_INVERT,
    GL_OR_REVERSE,
    GL_COPY_INVERTED,
    GL_OR_INVERTED,
    GL_NAND,
    GL_SET
};

uint32 tex_width[8], tex_height[8];
uint8  tex_fmt[8];

uint32  bp_tex_addr;
uint32  bp_tlut_addr;
uint8   bp_tmem[0x10000];
uint32  bp_tmem_maddr;

uint8   bp_tlut_rgba32[4 * 256];
uint8   tex_tlut_rgba32[4 * 256];

uint8 tex_fmt_size[16] = 
{
    1, 2, 2, 4, 4, 4, 8, 1,
    1, 2, 4, 0, 0, 0, 0, 0,
};

void *assigned_texture[8];

///////////////////////////////////////////////////////////////////////////
// CODE

void tx_setmode(uint8 id)
{
 uint32 data = tx_mode0[id];

#ifdef AUX_ILLEGALCALLS
 if(vx_started) auxprintf("illegal glTexParameter!\n");
#endif

 switch(data & 0x3)
  {
   case 0:
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
    break;

   case 1:
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    break;

   case 2:
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_MIRRORED_REPEAT);
    break;
  }

 switch((data >> 2) & 0x3)
  {
   case 0:
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
    break;

   case 1:
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
    break;

   case 2:
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_MIRRORED_REPEAT);
    break;
  }


 // bit 7 - filter - SOMETHING WRONG
 // PETE: harhar, nothing wrong. but you cannot use a filter and still doing your shader palette lookup
 if(data & (1 << 7))
  {
   if ((tex_fmt[id] == TEX_FMT_C4 || tex_fmt[id] == TEX_FMT_C8))
    {
     glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
     glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
    }
   else
    {
     glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
     glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    }
  }
 else
  {
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
  }
}

///////////////////////////////////////////////////////////////////////////

void bp_init(void)
{
 efb_info.xfb_address=0;
 efb_info.top=0;
 efb_info.left=0;
 efb_info.bottom=479;
 efb_info.right=639;
 efb_info.yscale=0;
}

///////////////////////////////////////////////////////////////////////////

void SetScissor(uint32 data,int mode)
{
 static int sc_x0=0;
 static int sc_x1=0;
 static int sc_y0=0;
 static int sc_y1=0;
 static int sc_xoff=0;
 static int sc_yoff=0;

 switch(mode)
  {
   case 0:
    sc_x0=(data>>12)&0xfff;
    sc_y0=data&0xfff;
    break;

   case 1:
    sc_x1=(data>>12)&0xfff;
    sc_y1=data&0xfff;
    break;

   case 2:
    sc_yoff=((data>>10)&0x3ff)<<1;
    sc_xoff=(data&0x3ff)<<1;
    break;
  }

#ifdef AUX_ILLEGALCALLS
 if(vx_started) auxprintf("illegal glScissor!\n");
#endif

 glScissor(sc_x0-sc_xoff,
           480-(sc_y1-sc_yoff), // mmm... 480 is standard size
           (sc_x1-sc_x0),
           (sc_y1-sc_y0));
}

///////////////////////////////////////////////////////////////////////////

void SetFogValues(void)
{
 GLfloat A, B, C, A_f;
 uint32 b_expn, b_m, a_hex, c_hex;

 if(!bp_fog) return;

 a_hex  = gp_bp_regs[0xee]<<12;
 b_m    = gp_bp_regs[0xef]&0xffffff;
 b_expn = gp_bp_regs[0xf0]&0x1f;
 c_hex  = gp_bp_regs[0xf1]<<12;

 A_f    = *((GLfloat *)&a_hex);
 A      = A_f * (1<<b_expn);
 B      = ((GLfloat)b_m)/8388638.0f;
 C      = *((GLfloat *)&c_hex);

 while(b_expn<1) 
  {
   B /= 2.0f;
   b_expn++;
  }

 while(b_expn>1) 
  {
   B *= 2.0f;
   b_expn--;
  }

// - for exp modes... pfff, bad, wrong, bla
 glFogf(GL_FOG_DENSITY,C/10);

// - for lin mode
 if(A!=0 && C!=0)
  {
   float fz,nz,sz,ez;

   // mmm... farz and nearz... maybe from depth range? we set it fix here, investigate somewhen
   fz=1024;nz=16;

   sz=C*((fz*nz)/((fz-nz)*A));
   ez=(sz/C)+sz;

   glFogf(GL_FOG_START,sz);
   glFogf(GL_FOG_END,ez);

//   auxprintf("%d, %d;%d;%d\n",bp_fog,(int)(A*1000),(int)(B*1000),(int)(C*1000));
//   auxprintf("-> %d, %d\n",(int)(sz*1000),(int)(ez*1000));
  }
else
 {
// auxprintf("%d, %d;%d;%d\n",bp_fog,(int)(A*1000),(int)(B*1000),(int)(C*1000));
 }
                      
// auxprintf("Z %d,%d\n",
//            (int)((gp_xf_regs[0x101f].f/16777215.0f)*1000),
//            (int)((gp_xf_regs[0x101c].f/16777215.0f)*1000));
}

///////////////////////////////////////////////////////////////////////////

void gp_bp_write_reg32(uint32 reg, uint32 data)
{
 uint32 id;
 gp_bp_regs[reg] = data & 0x00ffffff;

//syslog(BP,"GP: BP_%02x     %06x\n", reg, data & 0x00ffffff);
 switch(reg)
  {//--------------------------------------------------//
   case 0x00:                                          
    // ???? ???? ccss ss?? ???? ????
    // c - culling mode
    // s - active texture environment stages - 1

    te_active_stages = ((data >> 10) & 0xf) + 1;
    te_modified = true;

#ifdef AUX_ILLEGALCALLS
    if(vx_started) auxprintf("illegal glCullFace!\n");
#endif

    switch((data >> 14) & 0x3)                        
     {
      case 0x0:
       glDisable(GL_CULL_FACE);
       glCullFace(GL_NONE);
       break;

      case 0x1:
       glEnable(GL_CULL_FACE);
       glCullFace(GL_FRONT);
       break;
 
      case 0x2:
       glEnable(GL_CULL_FACE);
       glCullFace(GL_BACK);
       break;

      case 0x3:
       glEnable(GL_CULL_FACE);
       glCullFace(GL_FRONT_AND_BACK);
       break;
     }
    break;
   //--------------------------------------------------//
/*
    0x06-0x0e: IND_MTXA0 - IND_MTXC2
*/
   //--------------------------------------------------//
/*
    0x0f: IND_IMASK
*/
   //--------------------------------------------------//
/*
    0x10-0x1f: IND_CMD0 - IND_CMDF
*/
   //--------------------------------------------------//
   case 0x20:
    SetScissor(data,0);
    break;
   //--------------------------------------------------//
   case 0x21:
    SetScissor(data,1);
    break;
   //--------------------------------------------------//
   case 0x22:

#ifdef AUX_ILLEGALCALLS
    if(vx_started) auxprintf("illegal glPointsize!\n");
#endif

    glPointSize(((data >> 8) & 0xff)/6.0f);
    break;
   //--------------------------------------------------//
/*
0x25 RAS1_SS0 - ind tex coord scale 0 
0x26 RAS1_SS1 - ind tex coord scale 1

   case 0x25:
    auxprintf("25: %08X\n",data);
    break;
   //--------------------------------------------------//
   case 0x26:
    auxprintf("26: %08X\n",data);
    break;

*/
   //--------------------------------------------------//
   case 0x28:
   case 0x29:
   case 0x2a:
   case 0x2b:
   case 0x2c:
   case 0x2d:
   case 0x2e:
   case 0x2f:
    {
     // Texture Coordinate, Texture Index, Color Selectors
     uint32 stage;
 
     stage = (reg & 0x7) << 1;
     if (tev_stage[stage + 0] != (data & 0xfff))
      {
       tev_stage[stage + 0] = data & 0xfff;
       tev_stage_modified = 0x3 << stage;
       te_modified = true;
      }
 
     if (tev_stage[stage + 1] != ((data >> 12) & 0xfff))
      {
       tev_stage[stage + 1] = (data >> 12) & 0xfff;
       tev_stage_modified = 0x3 << stage;
       te_modified = true;
      }
    } break;
   //--------------------------------------------------//
/*
    0x30-0x3f: SU_S/T/SIZE0...7 texture offset? size?
*/
/*
   case 0x30:
   case 0x32:
   case 0x34:
   case 0x36:
   case 0x38:
   case 0x3a:
   case 0x3c:
   case 0x3e:
//    auxprintf("s %d %08x\n",(reg & 0xf) >> 1,data);
    break;
   case 0x31:
   case 0x33:
   case 0x35:
   case 0x37:
   case 0x39:
   case 0x3b:
   case 0x3d:
   case 0x3f:
//    auxprintf("t %d %08x\n",((reg-1) & 0xf) >> 1,data);
    break;
*/

   //--------------------------------------------------//
   case 0x40:
    // ZMODE
    // bits 1-3 Depth Func
    // bit 0 - GL_DPETH_TEST (enable) 
    // bit 4 - glDepthMask (enable)
    // if GL_DEPTH_TEST should be disabled then disable DepthMask too

#ifdef AUX_ILLEGALCALLS
    if(vx_started) auxprintf("illegal glDepth...!\n");
#endif

    if(data & 0x1)
     {
      glEnable(GL_DEPTH_TEST);
      glDepthFunc(GL_NEVER + ((data >> 1) & 0x7));
      glDepthMask((GLboolean)((data >> 4) & 0x1));
     }
    else
     {
      glDisable(GL_DEPTH_TEST);
      glDepthMask(GL_FALSE);
     }
    break;
   //--------------------------------------------------//
   case 0x41:
    {
     // Blending
     // bit 0        - blending enabled
     // bit 5-7      - destination factor
     // bit 8-10     - source factor

     uint32 sfactor;
     uint32 dfactor;

     sfactor = bp_blend_sfactor_table[(data >> 8) & 0x7];
     dfactor = bp_blend_dfactor_table[(data >> 5) & 0x7];

     //syslog(BP,"Blending: %08x sf: %d df: %d\n", data, sfactor, dfactor);

//     if(data & (1 << 11))
//      {
// crazy taxi goes crazy on this !
//          syslog_warn(BP,("BlendOp set ???\n");
//      }

#ifdef AUX_ILLEGALCALLS
     if(vx_started) auxprintf("illegal glBlendFunc!\n");
#endif

        
     glBlendFunc(sfactor, dfactor);
     glLogicOp(bp_logic_op_table[(data >> 12) & 0xf]);
        
     if (data & 0x1)
          glEnable(GL_BLEND);
     else glDisable(GL_BLEND);

     if (data & 0x2)
          glEnable(GL_COLOR_LOGIC_OP);
     else glDisable(GL_COLOR_LOGIC_OP);
    }
   break;                                              
   //--------------------------------------------------//
/*
0x42 constant alpha... glConst
0x43 zformat
*/
#ifdef AUX_ILLEGALCALLS
   case 0x43:
    if(data&0x100) auxprintf("CONST ALPHA %x",data&0xff);
   break;
#endif
   //--------------------------------------------------//
   // PETE: setting finished at the right time
   case 0x45:                                          // draw done

     pe_finished = true;

	 // signal interrupt to CPU
     if(pe_irq_enable&2)
	  gxcbts[CBT_IRQ_SIGNAL].fn();
	 break;
   //--------------------------------------------------//
   case 0x47:

    //printf("BP: Token B %06x\n", data);
    //gx_cbs.gc_pe_set_token(0, (uint16)data);

    pe_write_register16(0x0e, (uint16)data);           // tokens are only 16bit

    if(pe_irq_enable&1)
     gxcbts[CBT_IRQ_SIGNAL].fn();

    break;
   //--------------------------------------------------//
   case 0x48:
    //printf("BP: Token A %06x\n", data);
    //gx_cbs.gc_pe_set_token(0, (uint16)data);

    pe_write_register16(0x0e, (uint16)data);           // tokens are only 16bit

    if(pe_irq_enable&1)
     gxcbts[CBT_IRQ_SIGNAL].fn();

    break;
   //--------------------------------------------------//
   // PETE: storing efb top left
   case 0x49:
    efb_info.top    = (data>>10) & 0x03ff; 
    efb_info.left   = data & 0x03ff;

#ifdef AUX_ENABLE
if(GetAsyncKeyState(VK_SHIFT)&32768)
 auxprintf("efb top left %d,%d\n",efb_info.top,efb_info.left);
#endif

    break;
   //--------------------------------------------------//
   // PETE: storing efb bottom right
   case 0x4a:
    efb_info.bottom = (data>>10) & 0x03ff; 
    efb_info.right  = data & 0x03ff;

#ifdef AUX_ENABLE
if(GetAsyncKeyState(VK_SHIFT)&32768)
 auxprintf("efb right bottom %d,%d\n",efb_info.right,efb_info.bottom);
#endif

    break;
   //--------------------------------------------------//
   // PETE: storing xfb address
   case 0x4b:
    efb_info.xfb_address=data<<5;
    break;
   //--------------------------------------------------//
   // PETE: storing y scale
   case 0x4e:
    efb_info.yscale=data;
    break;
   //--------------------------------------------------//
   case 0x50:
    {
     float a, r, g, b;

#ifdef AUX_ILLEGALCALLS
     if(vx_started) auxprintf("illegal glClearColor!\n");
#endif

     a = ((gp_bp_regs[0x4f] >> 8) & 0xff) / 255.0f;
     r = ((gp_bp_regs[0x4f]) & 0xff) / 255.0f;
     g = ((gp_bp_regs[0x50] >> 8) & 0xff) / 255.0f;
     b = ((gp_bp_regs[0x50]) & 0xff) / 255.0f;
     glClearColor(r, g, b, a);
    }
   break;
   //--------------------------------------------------//
   // PETE: added clear depth
   case 0x51:
    {
     GLclampd d=(GLclampd)(data&0x00ffffff)/16777215.0;

#ifdef AUX_ILLEGALCALLS
     if(vx_started) auxprintf("illegal glClearDepth!\n");
#endif

     glClearDepth(d);
    }
   //--------------------------------------------------//
   // PETE: added pe copy... most important register :)
   case 0x52:
    {
     if(data==0xFFFFFF) break;

#ifdef AUX_ENABLE
if(GetAsyncKeyState(VK_SHIFT)&32768)
 auxprintf("%08X, %d ------------------------------------\n",data,render_count);
#endif

     if(render_count)             
      {                       
       if(data&0x4000)               {ogl_finish_efb_render();}
       else                          ogl_finish_efb_texture();
      }
     if(data&0x0800)                 ogl_finish_efb_clear();
     render_count=0;
    }
   break;
   //--------------------------------------------------//
   case 0x59:
    SetScissor(data,2);
    break;
   //--------------------------------------------------//
   case 0x64:
    // transfer to tmem
    // memory address >> 5
    bp_tmem_maddr = (data << 5) & 0x01ffffff;
    break;
   //--------------------------------------------------//
   case 0x65:
    {
     uint32 offset = data & 0x3ff;
     uint32 size = 2560;
     uint32 i;
 
     //syslog(BP,"Transfer to TMEM %08x (%d) -> %04x\n", bp_tmem_maddr, size, offset);

     for (i = 0 ; i < size ; i++)
      {
       bp_tmem[offset + i] = gx_memory[bp_tmem_maddr + i];
      }
    }
   break;
   //--------------------------------------------------//
   case 0x80:
   case 0x81:
   case 0x82:
   case 0x83:
   case 0xa0:
   case 0xa1:
   case 0xa2:
   case 0xa3:

#ifdef AUX_ILLEGALCALLS
    if(vx_started) auxprintf("illegal glActivateTexture!\n");
#endif
 
    // TX_SETMODE0_In
    id = (reg & 0x3) + ((reg >= 0xa0)?4:0);
    tx_mode0[id] = data;
    glActiveTextureARB_Ex(GL_TEXTURE0_ARB + id);
    tx_setmode((uint8)id);
    break;
   //--------------------------------------------------//
   case 0x88:
   case 0x89:
   case 0x8a:
   case 0x8b:
   case 0xa8:
   case 0xa9:
   case 0xaa:
   case 0xab:

    // TX_SETIMAGE0_In
    // ffffhhhh hhhhhhww wwwwwwww
    // f - format, h - height, w - width

    id = (reg & 0x3) + ((reg >= 0xa8)?4:0);

    tex_width[id] = ((data & 0x3ff) + 1);
    tex_height[id] = ((data >> 10) & 0x3ff) + 1;
    tex_fmt[id] = ((data >> 20) & 0xf);

    //syslog(BP,"TX_SETIMAGE0_I%d w: %d h: %d f: %d\n", id, tex_width[id], tex_height[id], tex_fmt[id]);
    break;
  //--------------------------------------------------//
   case 0x94:
   case 0x95:
   case 0x96:
   case 0x97:
   case 0xb4: // TX_SETIMAGE3_I4
   case 0xb5:
   case 0xb6:
   case 0xb7:
    {
     // TX_SETIMAGE3_In
     bool tex_in_cache;

     id = (reg & 0x3) + ((reg >= 0xb4)?4:0);
        
     //glPixelStorei(GL_PACK_ALIGNMENT, 1);
     //syslog(BP,"texture %02x->%02x\n", reg, id);

#ifdef AUX_ILLEGALCALLS
     if(vx_started) auxprintf("illegal glBindTexture!\n");
#endif

     glActiveTextureARB_Ex(GL_TEXTURE0_ARB + id);
        
     bp_tex_addr = (data << 5) & 0x01ffffff;

     tex_in_cache = tc_check(bp_tex_addr, tex_width[id] * tex_height[id] * tex_fmt_size[tex_fmt[id]] / 2, &texName);

     glBindTexture(GL_TEXTURE_2D, texName);

     tx_setmode((uint8)id);

     if(tex_in_cache == 0)
      {
       void *  global_tbuf;
       int w2, h2;
 
       global_tbuf = convert_tex(bp_tex_addr + gx_memory, 
                                 tex_width[id], tex_height[id], 
                                 0, tex_fmt[id]);

       assigned_texture[id] = global_tbuf;
       calc_pow2(tex_width[id], tex_height[id], &w2, &h2);

       txc_upload_texture(tex_fmt[id], global_tbuf);
       tc_store_entry(bp_tex_addr, global_tbuf, texName);
       gx_cache_mark_valid(bp_tex_addr, tex_width[id] * tex_height[id] * tex_fmt_size[tex_fmt[id]] / 2);

//       free(global_tbuf);
      }

//#if WITH_PALETTED_AT_SHADER
     if (tex_fmt[id] == TEX_FMT_C4 || tex_fmt[id] == TEX_FMT_C8)
          tx_paletted |= (1 << id);
     else tx_paletted &= ~(1 << id);
//#endif
    } break;
   //--------------------------------------------------//
   case 0x98:
   case 0x99:
   case 0x9a:
   case 0x9b:
   case 0xb8:
   case 0xb9:
   case 0xba:
   case 0xbb:

    id = (reg & 0x3) + ((reg >= 0xb8)?4:0);

    bp_tlut_addr = data & 0x3ff;
    tex_convert_tlut((data >> 10) & 0x3, 256);   //&0xf instead?
            
#ifdef AUX_ILLEGALCALLS
    if(vx_started) auxprintf("illegal glBindTexture(pal)!\n");
#endif

//#if WITH_PALETTED_AT_SHADER
    glActiveTextureARB_Ex(GL_TEXTURE8_ARB + id);
        
    if(!lookupTexName[id])
     {
      glGenTextures(1, &lookupTexName[id]);
      glBindTexture(GL_TEXTURE_1D, lookupTexName[id]);
//    glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_WRAP_S, GL_REPEAT);
//    glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_WRAP_T, GL_REPEAT);
      // PETE: we need clamp on tlut texture!
      glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
      glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
      glTexImage1D(GL_TEXTURE_1D, 0, GL_RGBA, 256, 0, GL_RGBA, GL_UNSIGNED_BYTE, tex_tlut_rgba32);
     }
    else
     {
      glBindTexture(GL_TEXTURE_1D, lookupTexName[id]);
      glTexSubImage1D(GL_TEXTURE_1D, 0, 0, 256, GL_RGBA, GL_UNSIGNED_BYTE, tex_tlut_rgba32);
     }
                 
//#endif

    break;
   //--------------------------------------------------//
   case 0xc0:
   case 0xc1:
   case 0xc2:
   case 0xc3:
   case 0xc4:
   case 0xc5:
   case 0xc6:
   case 0xc7:
   case 0xc8:
   case 0xc9:
   case 0xca:
   case 0xcb:
   case 0xcc:
   case 0xcd:
   case 0xce:
   case 0xcf:
   case 0xd0:
   case 0xd1:
   case 0xd2:
   case 0xd3:
   case 0xd4:
   case 0xd5:
   case 0xd6:
   case 0xd7:
   case 0xd8:
   case 0xd9:
   case 0xda:
   case 0xdb:
   case 0xdc:
   case 0xdd:
   case 0xde:
   case 0xdf:
   // Stage Operands for color and alpha
    {
     uint32 stage;

     stage = (reg - 0xc0) / 2;
     if (te_combiner_regs[reg - 0xc0] != data)
      {
       te_combiner_regs[reg - 0xc0] = data;
       tev_stage_modified = 1 << stage;
       te_modified = true;
      }
    } break;
   //--------------------------------------------------//
   case 0xe0:
   case 0xe2:
   case 0xe4:
   case 0xe6:

    te_set_color_reg_ra(data,(uint8)((reg - 0xe0) / 2));
    break;
   //--------------------------------------------------//
   case 0xe1:
   case 0xe3:
   case 0xe5:
   case 0xe7:

    te_set_color_reg_gb(data,(uint8)((reg - 0xe1) / 2));
    break;
   //--------------------------------------------------//
/*
0xee-0xf2: fog stuff
*/

/*
   case 0xe8:
    auxprintf("e8: %08x\n",data);
    break;
   case 0xe9:
    auxprintf("e9: %08x\n",data);
    break;
   case 0xea:
    auxprintf("ea: %08x\n",data);
    break;
   case 0xeb:
    auxprintf("eb: %08x\n",data);
    break;
*/

/*
// mmm... we simply hope, that if A and B gets changed, C will be changed as well
   case 0xee:
   case 0xef:
   case 0xf0:
    if(bUseFog) SetFogValues();
    break;
*/

// f1: persp/ortho? in bit 20? what about the proj_mtx_mode?

   case 0xf1:
    {
     uint8 nfog;

     if(!bUseFog) break;

     nfog=(data>>21)&0x07;

     if(nfog!=bp_fog)
      {
       bp_fog=nfog;
       te_modified=true;
      }

     SetFogValues();                                   // we always set fog values here (C gets updated)
    }
   break;
   //--------------------------------------------------//
   case 0xf2:
    {
     GLfloat f[4];

     if(!bUseFog) break;

     f[0] = ((data >> 16) & 0xff)/255.0f;
     f[1] = ((data >> 8) & 0xff)/255.0f;
     f[2] = ((data >> 0) & 0xff)/255.0f;
     f[3] = 1.0f;

     glFogfv(GL_FOG_COLOR,f); 
    }
   break;

   //--------------------------------------------------//
   case 0xf3:
    {
     // Alpha Test
     uint32 op0,op1,logic,a0,a1;

// PETE: that's an hard one: two alpha funcs, AND(0)/OR(1)/XOR(2)/XNOR(3)-Logic
// investigate this!
// if it is getting used, we can maybe do some "op1 alpha test" in
// the fragment shader
//
// stuff we can emulate with standard OGL:
//
// if op1=7 and logic=0: nice, just use op0 (as OGL does it)
// if op0=7 and logic=0: nice, just use op1 (as OGL does it)
// if op0=op1 and logic<2 and a0=a1: nice, just use op1 (as OGL does it)
// if op0=4 (or op1=4) and logic=1: nice, just use !op (as OGL does it)
// if op=7 and logic=1: always (disable test)

     logic = (data >> 22) & 0x3;
     op0 = (data >> 16) & 0x7;
     op1 = (data >> 19) & 0x7;
     a0  = (data & 0xff);
     a1  = ((data>>8) & 0xff);

     op0 += GL_NEVER;
     op1 += GL_NEVER;

#ifdef AUX_ILLEGALCALLS
     if(vx_started) auxprintf("illegal glAlphaFunc!\n");
#endif

     if(logic==1 && (op0==GL_ALWAYS || op1==GL_ALWAYS))
      glDisable(GL_ALPHA_TEST);
     else
     if((op1==GL_ALWAYS && logic==0) || (op1==GL_NEVER && logic==1))
      {
       if(op0 != GL_ALWAYS)
        {
         glEnable(GL_ALPHA_TEST);
         glAlphaFunc(op0, ((GLclampf)a0)/255.0f);
        }
       else glDisable(GL_ALPHA_TEST);
      }
     else
     if((op0==GL_ALWAYS && logic==0) || (op0==GL_NEVER && logic==1))
      {
       if(op1 != GL_ALWAYS)
        {
         glEnable(GL_ALPHA_TEST);
         glAlphaFunc(op1, ((GLclampf)a1)/255.0f);
        }
       else glDisable(GL_ALPHA_TEST);
      }
     else
      {
#ifdef AUX_ILLEGALCALLS
       if(!(logic<2 && op0==op1 && a0==a1))
        auxprintf("alpha %d,%d (%d) %02X,%02X\n",op0-GL_NEVER,op1-GL_NEVER,logic,data&0xff,(data>>8)&0xff);
#endif
       // we simply do op0 right now 
       if(op0 != GL_ALWAYS)
        {
         glEnable(GL_ALPHA_TEST);
         glAlphaFunc(op0, (data & 0xff)/255.0f);
        }
       else glDisable(GL_ALPHA_TEST);
      }
   
    }
   break;
   //--------------------------------------------------//
/*
0xf4-0xf5: z texture
*/
   //--------------------------------------------------//
   case 0xf6:
   case 0xf7:
   case 0xf8:
   case 0xf9:
   case 0xfa:
   case 0xfb:
   case 0xfc:
   case 0xfd:
    {
     // Konstant selector and color exchange
     // two stages per register
     //  4 -  8  Konst Color Stage +0
     //  9 - 13  Konst Alpha Stage +0
     // 14 - 18  Konst Color Stage +1
     // 19 - 23  Konst Alpha Stage +1

     uint32 stage;   
     uint32 swap_table_id;

     stage = (reg - 0xf6) * 2;

     // now tev_konst will have 0000 00aa aaac cccc
     tev_konst[stage + 0] = (data >> 4) & 0x3ff;
     tev_konst[stage + 1] = (data >> 14) & 0x3ff;
     tev_konst_modified |= 0x3 << stage;
     te_modified = true;

     //syslog(BP,"Stage: %d KC0 %s KA0 %s KC1 %s KA1 %s\n", (reg - 0xf6) * 2, te_kcsel[(data >> 4) & 0x1f], te_kasel[(data >> 9) & 0x1f], te_kcsel[(data >> 14) & 0x1f], te_kasel[(data >> 19) & 0x1f]);
     //syslog(BP,"SWAP %d %d\n", (data >> 2) & 0x3, (data >> 0) & 0x3);
     
     swap_table_id = (reg - 0xf6) / 2;
     if (reg & 0x1)
      {
       te_swap_table[swap_table_id] = (te_swap_table[swap_table_id] & 0xf0) | (data & 0x0f);
      }
     else
      {
       te_swap_table[swap_table_id] = (te_swap_table[swap_table_id] & 0x0f) | ((data << 4) & 0xf0);
      }
    } break;
   //--------------------------------------------------//
    default:
     break;
   //--------------------------------------------------//
  }
}


///////////////////////////////////////////////////////////////////////////
