/***************************************************************************
                         gxGCEmuOGL.c  -  description
                             -------------------
    begin                : 21.05.2005
    copyright            : (C) 2005 by Pete Bernert
    email                : BlackDove@addcom.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. See also the license.txt file for *
 *   additional informations.                                              *
 *                                                                         *
 ***************************************************************************/

//*************************************************************************//
// History of changes:
//
// 2005/05/24 - Pete
// - moved the VI handling from main emu to plugin
//
// 2005/05/21 - Pete
// - created this plugin based on Duddie's gxOGL one... using plain C
//
//*************************************************************************//

#include "stdafx.h"
#include <stdio.h>
#include "gx_cache.h"
#include "gx_fifo_interface.h"
#include "pe_interface.h"
#include "bp_regs.h"
#include "texture_environment.h"
#include "texture_cache.h"
#include "fragment_shader_gen.h"
#include "video_interface.h"
#include "ogl_generic.h"
#include "cfg.h"         

#define _IN_GX

#include "externals.h"

///////////////////////////////////////////////////////////////////////////
// GLOBALS
///////////////////////////////////////////////////////////////////////////

uint8 * gx_memory;
gxcb_t  gxcbts[NUM_CBTS];
               
///////////////////////////////////////////////////////////////////////////
// GENERIC DLL FUNCS AND INTERFACE
///////////////////////////////////////////////////////////////////////////

HINSTANCE hInst=NULL;

#ifdef _GCC
int WINAPI DllMain(HINSTANCE hInstance, DWORD fdwReason, PVOID pvReserved)
{
 hInst=(HINSTANCE)hInstance;
 return TRUE;
}
#else
BOOL APIENTRY DllMain(HANDLE hModule,                  // DLL INIT
                      DWORD  dwReason, 
                      LPVOID lpReserved)
{
 hInst=(HINSTANCE)hModule;
 return TRUE;                                          // very quick :)
}
#endif

///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////

EXPORT_GCC bool CALLBACK GX_Init(uint8* mem)
{
 ReadConfig();

 gx_memory = mem;

 if(gx_cache_init()) return 0;   

 fsg_init();
 te_init();
 tc_init();
 pe_init();
 bp_init();

 return true;
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC bool CALLBACK GX_Open(HWND wnd)
{
 ogl_init(wnd);

 return true;
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC bool CALLBACK GX_Close(void)
{
 tc_close();

 ogl_close();

 return true;
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC bool CALLBACK GX_Shutdown(void)
{
 te_close();

 GX_Close();

 return true;
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC bool CALLBACK GX_RegisterCallback(gxcb_t *cbt)
{
 gxcbts[cbt->id].fn = cbt->fn;
 return true;
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC uint8 * CALLBACK GX_CacheGetTable(void)
{
 return gx_cache_table;
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC void CALLBACK GX_CacheSnoop(uint32 address)
{
 gx_cache_snoop(address);
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC void CALLBACK GX_CacheMarkInvalid(uint32 address, uint32 data)
{
 gx_cache_mark_invalid(address, data);
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC uint32 CALLBACK GX_PEReadRegister32(uint32 address)
{
 return pe_read_register32(address);
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC uint16 CALLBACK GX_PEReadRegister16(uint32 address)
{
 return pe_read_register16(address);
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC uint8 CALLBACK GX_PEReadRegister8(uint32 address)
{
 return pe_read_register8(address);
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC void CALLBACK GX_PEWriteRegister32(uint32 addr, uint32 data)
{
 pe_write_register32(addr, data);
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC void CALLBACK GX_PEWriteRegister16(uint32 addr, uint16 data)
{
 pe_write_register16(addr, data);
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC void CALLBACK GX_PEWriteRegister8(uint32 addr, uint8 data)
{
 pe_write_register8(addr, data);
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC uint32 CALLBACK GX_PECheckInterrupt(void)
{
 return pe_check_interrupt();
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC void CALLBACK GX_WriteFifo(uint8 * data, uint32 len)
{
 gx_write_fifo(data, len);                       
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC void CALLBACK GX_VIWriteRegister8(uint32 addr, uint8 data)
{
 vi_write_register8(addr, data);
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC void CALLBACK GX_VIWriteRegister16(uint32 addr, uint16 data)
{
 vi_write_register16(addr, data);
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC void CALLBACK GX_VIWriteRegister32(uint32 addr, uint32 data)
{
 vi_write_register32(addr, data);
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC uint8 CALLBACK GX_VIReadRegister8(uint32 addr)
{
 return vi_read_register8(addr);
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC uint16 CALLBACK GX_VIReadRegister16(uint32 addr)
{
 return vi_read_register16(addr);
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC uint32 CALLBACK GX_VIReadRegister32(uint32 addr)
{
 return vi_read_register32(addr);
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC bool CALLBACK GX_VICheckInterrupt(void)
{
 return vi_check_interrupt();
}

///////////////////////////////////////////////////////////////////////////

EXPORT_GCC void CALLBACK GX_VINextScanline(void)
{
 vi_next_scanline();
}

///////////////////////////////////////////////////////////////////////////

void gpu_exit(uint32 val,uint32 info)
{
 printf("[GPU PLUGIN] gpu_exitting on fatal error (%d)\n",info);
 exit(val);
}

///////////////////////////////////////////////////////////////////////////
