/***************************************************************************
                          fps.c  -  description
                             -------------------
    begin                : 23.05.2005
    copyright            : (C) 2005 by Pete Bernert
    email                : BlackDove@addcom.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. See also the license.txt file for *
 *   additional informations.                                              *
 *                                                                         *
 ***************************************************************************/

//*************************************************************************//
// History of changes:
//
// 2005/05/23 - Pete
// - added this fps handling from my PS1/PS2 plugins
//
//*************************************************************************//

#include "stdafx.h"

#include <stdio.h>
#include <mmsystem.h>
#include "fps.h"         
#include "video_interface.h"         
#define _IN_FPS 
#include "externals.h"         

BOOL          IsPerformanceCounter=FALSE;
LARGE_INTEGER CPUFrequency;
int           iUseFrameLimit=1;
uint32        ulKeybits=KEY_SHOWFPS;
float         fFrameRateHz=59.94f;
uint32        dwFrameRateTicks;
BOOL          bInitCap = TRUE; 
uint16        prev_dcr=0x300;

////////////////////////////////////////////////////////////////////////
// field with menu chars... like good old C64 time :)
////////////////////////////////////////////////////////////////////////

GLubyte texrasters[40][12]= {
                                
// 0,0 FPS
{0x00,0x60,0x60,0x60,0x60,0x60,0x7e,0x60,0x60,0x60,0x60,0x7f},
{0x00,0x18,0x18,0x18,0x18,0x18,0x1f,0x18,0x18,0x18,0x18,0x1f},
{0x00,0x03,0x06,0x00,0x00,0x00,0xc3,0x66,0x66,0x66,0x66,0xc3},
{0x00,0xf0,0x18,0x18,0x18,0x18,0xf0,0x00,0x00,0x00,0x18,0xf0},
// 4,0 0
{0x00,0x3c,0x66,0xc3,0xe3,0xf3,0xdb,0xcf,0xc7,0xc3,0x66,0x3c},
// 5,0 1
{0x00,0x7e,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x78,0x38,0x18},
// 6,0 2
{0x00,0xff,0xc0,0xc0,0x60,0x30,0x18,0x0c,0x06,0x03,0xe7,0x7e},
// 7,0 3

{0x00,0x7e,0xe7,0x03,0x03,0x07,0x7e,0x07,0x03,0x03,0xe7,0x7e},
// 0,1 4
{0x00,0x0c,0x0c,0x0c,0x0c,0x0c,0xff,0xcc,0x6c,0x3c,0x1c,0x0c},
// 1,1 5
{0x00,0x7e,0xe7,0x03,0x03,0x07,0xfe,0xc0,0xc0,0xc0,0xc0,0xff},
// 2,1 6
{0x00,0x7e,0xe7,0xc3,0xc3,0xc7,0xfe,0xc0,0xc0,0xc0,0xe7,0x7e},
// 3,1 7
{0x00,0x30,0x30,0x30,0x30,0x18,0x0c,0x06,0x03,0x03,0x03,0xff},
// 4,1 8
{0x00,0x7e,0xe7,0xc3,0xc3,0xe7,0x7e,0xe7,0xc3,0xc3,0xe7,0x7e},
// 5,1 9
{0x00,0x7e,0xe7,0x03,0x03,0x03,0x7f,0xe7,0xc3,0xc3,0xe7,0x7e},
// 6,1 smiley
{0x00,0x3c,0x42,0x99,0xa5,0x81,0xa5,0x81,0x42,0x3c,0x00,0x00},
// 7,1 sun
{0x00,0x08,0x49,0x2a,0x1c,0x7f,0x1c,0x2a,0x49,0x08,0x00,0x00},

// 0,2 fl + empty  box
{0xff,0x81,0x81,0x81,0xff,0x00,0x87,0x84,0x84,0xf4,0x84,0xf8},
// 1,2 fs + grey box
{0xff,0xab,0xd5,0xab,0xff,0x00,0x87,0x81,0x87,0xf4,0x87,0xf8},
// 2,2 od + filled box
{0xff,0xff,0xff,0xff,0xff,0x00,0x66,0x95,0x95,0x95,0x96,0x60},
// 3,2 fi + half grey box
{0xff,0xa1,0xd1,0xa1,0xff,0x00,0x82,0x82,0x82,0xe2,0x82,0xf8},
// 4,2 di + half filled box
{0xff,0xf1,0xf1,0xf1,0xff,0x00,0xe2,0x92,0x92,0x92,0x92,0xe0},
// 5,2 am  + grey box
{0xff,0xab,0xd5,0xab,0xff,0x00,0x95,0x95,0x95,0xf7,0x95,0x60},
// 6,2 ab  + filled box
{0xff,0xff,0xff,0xff,0xff,0x00,0x97,0x95,0x96,0xf5,0x96,0x60},
// 7,2 fa
{0x00,0x00,0x00,0x00,0x00,0x00,0x85,0x85,0x87,0xf5,0x82,0xf8},

// 0,3 fb
{0xff,0x8b,0x85,0x8b,0xff,0x00,0x82,0x82,0x82,0xe2,0x87,0xf8},
// 1,3 gf
{0xff,0x8f,0x8f,0x8f,0xff,0x00,0x74,0x94,0x96,0xb4,0x87,0x70},
// 2,3   
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
// 3,3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
// 4,3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
// 5,3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
// 6,3 tex pal smiley
{0x00,0x3c,0x7e,0xe7,0xdb,0xff,0xdb,0xff,0x7e,0x3c,0x00,0x00},
// 7,3
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

// 0,4 subtract blending (moon)
{0x00,0x06,0x1c,0x38,0x78,0x78,0x78,0x38,0x1c,0x06,0x00,0x00},
// 1,4 blurring
{0x00,0x7e,0x93,0xa5,0x93,0xc9,0x93,0xa5,0x93,0x7e,0x00,0x00},
// 2,4 (M)
{0xff,0x00,0xc3,0xc3,0xc3,0xdb,0xff,0xe7,0xc3,0x81,0x00,0xff},
// 3,4 (A)
{0xff,0x00,0xc3,0xc3,0xff,0xc3,0xc3,0x66,0x3c,0x18,0x00,0xff},
// 4,4 blank
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
// 5,4
{0x00,0xfe,0xc5,0x62,0x35,0x18,0x0c,0xc6,0xc6,0x7c,0x00,0x00},
// 6,4  <-
{0x00,0x00,0x00,0x00,0x00,0x10,0x30,0x7f,0xff,0x7f,0x30,0x10},
// 7,4 .
{0x00,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};

////////////////////////////////////////////////////////////////////////
// create stuff for fonts 
////////////////////////////////////////////////////////////////////////

GLuint gTexFontName=0;
char   szDispBuf[32];

void MakeFPSMenu(void)
{
 GLubyte TexBytes[64][64][3];
 int x,y,i,j,n=0; GLubyte col,IB;

 glPixelStorei(GL_UNPACK_ALIGNMENT,1);
 glPixelStorei(GL_PACK_ALIGNMENT,1);
 
 memset(TexBytes,0,64*64*3);

 for(y=0;y<5;y++)
  {                    
   for(x=0;x<8;x++,n++)
    {
     for(i=0;i<12;i++)
      {
       IB=texrasters[n][i];
       for(j=0;j<8;j++)
        {
         if(IB&(1<<(7-j))) col=255; else col=0;
         TexBytes[y*12+i][x*8+j][0]=col;
         TexBytes[y*12+i][x*8+j][1]=col;
         TexBytes[y*12+i][x*8+j][2]=col;
        }
      }
    }
  }

 glGenTextures(1, &gTexFontName);
 glBindTexture(GL_TEXTURE_2D, gTexFontName);
 glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
 glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
 glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
 glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
 glTexImage2D(GL_TEXTURE_2D, 0, 3, 64, 64, 0, GL_RGB,
              GL_UNSIGNED_BYTE,TexBytes);

 strcpy(szDispBuf,"000.0");
}

////////////////////////////////////////////////////////////////////////
// kill existing lists
////////////////////////////////////////////////////////////////////////

void KillFPSMenu(void)
{
 if(gTexFontName) 
  {glDeleteTextures(1,&gTexFontName);gTexFontName=0;}
}

////////////////////////////////////////////////////////////////////////

#define DRAWTEXCHAR glTexCoord2f(fX1/256.0f,fY2/256.0f);glVertex3f(fXS1,fYS2,1.0f);glTexCoord2f(fX1/256.0f,fY1/256.0f);glVertex3f(fXS1,fYS1,1.0f);glTexCoord2f(fX2/256.0f,fY1/256.0f);glVertex3f(fXS2,fYS1,1.0f);glTexCoord2f(fX2/256.0f,fY2/256.0f);glVertex3f(fXS2,fYS2,1.0f);

void DisplayFPSMenu(void)
{
 if(!(ulKeybits&KEY_SHOWFPS)) return;

/*

 // alternative fps display in window caption

 if(0)                                                 
  {
   if(!(gsrc.iFrame%10)) SetWindowText(hwGSWin,szDispBuf);
  }
 else
*/
  {
   int iX,iY,i;
   GLfloat fX1,fY1,fX2,fY2,fYS1,fYS2,fXS1,fXS2,fXS,fXSC,fYSC,fYD;

   glDepthFunc(GL_ALWAYS);

   glBindTexture(GL_TEXTURE_2D,gTexFontName);          // now set font texture
 
   fYD=fYSC=1.0f;
   fYS1=12.0f*fYSC;fYSC*=13.0f;
   fYS2=0.0f;
   fXS=1.0f;
   fXSC= 8.0f*fXS;fXS*=10.0f;
   fXS1=0.0f;
   fXS2=10.0f*fXS;                                     // size for one plugin config option

   glColor4ub(0xff,0xff,0,0xff);

   glBegin(GL_QUADS);
 
   glTexCoord2f(128.0f/256.0f,240.0f/256.0f);          // make blank
   glVertex3f(fXS1,fYS2,0.5f);
   glTexCoord2f(128.0f/256.0f,192.0f/256.0f);
   glVertex3f(fXS1,fYSC,0.5f);
   glTexCoord2f(160.0f/256.0f,192.0f/256.0f);
   glVertex3f(fXS2,fYSC,0.5f);
   glTexCoord2f(160.0f/256.0f,240.0f/256.0f);
   glVertex3f(fXS2,fYS2,0.5f);
  
   fXS1=0.0f;fXS2=4.0f*fXSC;                           // draw fps
   fX1=0.0f;  fX2=128.0f;
   fY1=0.0f; fY2=48.0f;
   DRAWTEXCHAR;
 
   fYSC=fXS1=3.0f*fXS;                                 // start pos of numbers
 
   i=0;do                                              // paint fps numbers
    {
     iX=4;iY=4;
     if(szDispBuf[i]>='0' && szDispBuf[i]<='3')
      {iX=4+szDispBuf[i]-'0';iY=0;}
     else
     if(szDispBuf[i]>='4' && szDispBuf[i]<='9')
      {iX=szDispBuf[i]-'4';iY=1;}
     else
     if(szDispBuf[i]=='.')
      {iX=7;iY=4;}
     else
     if(szDispBuf[i]==0) break;

     fX1=(GLfloat)iX*32.0f;  fX2=fX1+32.0f;
     fY1=(GLfloat)iY*48.0f; fY2=fY1+48.0f;
     fXS1+=fXS;
     fXS2=fXS1+fXSC;
 
     DRAWTEXCHAR;
  
     i++;
    }
   while(i);
 
   glEnd();
  }
}
 
////////////////////////////////////////////////////////////////////////

void FrameCap (void)
{
 static DWORD curticks, lastticks, _ticks_since_last_update;
 static DWORD TicksToWait = 0;
 static LARGE_INTEGER  CurrentTime;
 static LARGE_INTEGER  LastTime;
 static BOOL SkipNextWait = FALSE;
 BOOL Waiting = TRUE;

 //---------------------------------------------------------
 if(bInitCap)
  {
   bInitCap=FALSE;
   if (IsPerformanceCounter)
    QueryPerformanceCounter(&LastTime);
   lastticks = timeGetTime();
   TicksToWait=0;
   return;
  }
 //---------------------------------------------------------

 if (IsPerformanceCounter)
  {
   QueryPerformanceCounter(&CurrentTime);
   _ticks_since_last_update = CurrentTime.LowPart - LastTime.LowPart;

   curticks = timeGetTime();
   if(_ticks_since_last_update>(CPUFrequency.LowPart>>1))   
    {
     if(curticks < lastticks)
          _ticks_since_last_update = dwFrameRateTicks+TicksToWait+1;
     else _ticks_since_last_update = (CPUFrequency.LowPart * (curticks - lastticks))/1000;
    }

   if ((_ticks_since_last_update > TicksToWait) || 
       (CurrentTime.LowPart < LastTime.LowPart))
    {
     LastTime.HighPart = CurrentTime.HighPart;
     LastTime.LowPart  = CurrentTime.LowPart;

     lastticks=curticks;

     if((_ticks_since_last_update-TicksToWait) > dwFrameRateTicks)
          TicksToWait=0;
     else TicksToWait=dwFrameRateTicks-(_ticks_since_last_update-TicksToWait);
    }
   else
    {
     while (Waiting)
      {
       QueryPerformanceCounter(&CurrentTime);
       _ticks_since_last_update = CurrentTime.LowPart - LastTime.LowPart;

//---------------------------------------------------------
   curticks = timeGetTime();
   if(_ticks_since_last_update>(CPUFrequency.LowPart>>1))   
    {
     if(curticks < lastticks)
          _ticks_since_last_update = TicksToWait+1;
     else _ticks_since_last_update = (CPUFrequency.LowPart * (curticks - lastticks))/1000;
    }
//---------------------------------------------------------

       if ((_ticks_since_last_update > TicksToWait) || 
           (CurrentTime.LowPart < LastTime.LowPart))
        {
         Waiting = FALSE;

         lastticks=curticks;

         LastTime.HighPart = CurrentTime.HighPart;
         LastTime.LowPart = CurrentTime.LowPart;
         TicksToWait = dwFrameRateTicks;
        }
      }
    }
  }
 else
  {
   curticks = timeGetTime();
   _ticks_since_last_update = curticks - lastticks;

   if ((_ticks_since_last_update > TicksToWait) || 
       (curticks < lastticks))
    {
     lastticks = curticks;

     if((_ticks_since_last_update-TicksToWait) > dwFrameRateTicks)
          TicksToWait=0;
     else TicksToWait=dwFrameRateTicks-(_ticks_since_last_update-TicksToWait);
    }
   else
    {
     while (Waiting)
      {
       curticks = timeGetTime();
       _ticks_since_last_update = curticks - lastticks;
       if ((_ticks_since_last_update > TicksToWait) ||
           (curticks < lastticks))
        {
         Waiting = FALSE;
         lastticks = curticks;
         TicksToWait = dwFrameRateTicks;
        }
      }
    }
  }
}

////////////////////////////////////////////////////////////////////////

void calcfps(void)                                     // fps calculations
{
 static DWORD curticks,_ticks_since_last_update,lastticks;
 static long   fps_cnt = 0;
 static DWORD  fps_tck = 1;
 static LARGE_INTEGER  CurrentTime;
 static LARGE_INTEGER  LastTime;
 static long   fpsskip_cnt = 0;
 static DWORD  fpsskip_tck = 1;
 static float  fps_cur;

 if(IsPerformanceCounter)
  {
   QueryPerformanceCounter(&CurrentTime);
   _ticks_since_last_update=CurrentTime.LowPart-LastTime.LowPart;

   //--------------------------------------------------//
   curticks = timeGetTime();
   if(_ticks_since_last_update>(CPUFrequency.LowPart>>1))   
    _ticks_since_last_update = (CPUFrequency.LowPart * (curticks - lastticks))/1000;
   lastticks=curticks;
   //--------------------------------------------------//

   LastTime.HighPart = CurrentTime.HighPart;
   LastTime.LowPart = CurrentTime.LowPart;
  }
 else
  {
   curticks = timeGetTime();
   _ticks_since_last_update=curticks-lastticks;

   lastticks = curticks;
  }

 fps_tck += _ticks_since_last_update;

 if(++fps_cnt==10)
  {
   if(IsPerformanceCounter)
    fps_cur = ((float)CPUFrequency.LowPart) / ((float)fps_tck) *10.0f;
   else
    fps_cur = (float)10000/(float)fps_tck;

   fps_cnt = 0;
   fps_tck = 1;

   sprintf(szDispBuf,"%04.1f",fps_cur);

   if(iUseFrameLimit && fps_cur>fFrameRateHz)          // optical adjust ;) avoids flickering fps display
    fps_cur=fFrameRateHz;
  }
}

////////////////////////////////////////////////////////////////////////

void CheckFrameRate(void)
{                           
 if((fb_dcr&0x300)!=prev_dcr)
  {
   prev_dcr=fb_dcr&0x300;
   if(prev_dcr==0x100) fFrameRateHz=50.0f;
   else                fFrameRateHz=59.94f;

   if(IsPerformanceCounter)
        dwFrameRateTicks=(DWORD)(CPUFrequency.LowPart / fFrameRateHz);
   else dwFrameRateTicks=(1000 / (DWORD)fFrameRateHz);
  }

 if(iUseFrameLimit) FrameCap();                        // frame limit? do it
 if(ulKeybits&KEY_SHOWFPS) calcfps();                  // show fps? calc fps display
}                      

////////////////////////////////////////////////////////////////////////

void InitFPS(void)
{
 fFrameRateHz=59.94f;

 if (QueryPerformanceFrequency (&CPUFrequency))        // timer mode
      IsPerformanceCounter = TRUE;
 else IsPerformanceCounter = FALSE;

 if(IsPerformanceCounter)
      dwFrameRateTicks=(DWORD)(CPUFrequency.LowPart / fFrameRateHz);
 else dwFrameRateTicks=(1000 / (DWORD)fFrameRateHz);
}

////////////////////////////////////////////////////////////////////////



