/***************************************************************************
                          cp_regs.c  -  description
                             -------------------
    begin                : 
    copyright            : (C) 2005 by Duddie
    email                : duddie@walla.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. See also the license.txt file for *
 *   additional informations.                                              *
 *                                                                         *
 ***************************************************************************/

//*************************************************************************//
// History of changes:
//
//*************************************************************************//

#include "stdafx.h"
#include "cp_regs.h"
#include "vertex_processor.h"
#define _IN_CPREGS
#include "externals.h"

///////////////////////////////////////////////////////////////////////////
// GLOBALS

uint32  gp_cp_regs[256];

///////////////////////////////////////////////////////////////////////////
// CODE

void gp_cp_write_reg(uint32 reg, uint32 data)
{
 gp_cp_regs[reg] = data;

 switch(reg)
  {
   case 0xa0:
    vx_invalidate_cache(reg & 0xf);
    break;

   case 0xa1:
    vx_invalidate_cache(reg & 0xf);
    break;

   case 0xa2:
    vx_invalidate_cache(reg & 0xf);
    break;

   case 0xa4:
    vx_invalidate_cache(reg & 0xf);
    break;

   default:
    break;
  }
}

///////////////////////////////////////////////////////////////////////////
