/*====================================================================

filename:     gx_plugin.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#pragma once

#include <Windows.h>

#define GX_CACHE_BLOCKSHIFT (5)


extern uint8 *gx_cache_table;

bool gx_plugin_init(char *name);

#define NUM_CBTS	1
#define CBT_IRQ_SIGNAL	0

typedef struct
{
	uint32 id;
	void (*fn)(void);
} gxcb_t;

extern gxcb_t gxcbts[];

typedef void	(CALLBACK* LPFNGXREGISTERCALLBACK)(gxcb_t *cbt);

typedef void	(CALLBACK* LPFNGXCACHEMARKINVALID)(uint32 address, uint32 size);
typedef void	(CALLBACK* LPFNGXCACHESNOOP)(uint32 address);
typedef uint32	(CALLBACK* LPFNGXPECHECKINTERRUPT)(void);
typedef bool	(CALLBACK* LPFNGXINIT)(uint8 *mem);
typedef bool	(CALLBACK* LPFNGXOPEN)(HWND wnd);

typedef uint8*	(CALLBACK* LPFNGXCACHEGETTABLE)();

typedef void	(CALLBACK* LPFNGXPEWRITEREGISTER32)(uint32 address, uint32 data);
typedef void	(CALLBACK* LPFNGXPEWRITEREGISTER16)(uint32 address, uint16 data);
typedef void	(CALLBACK* LPFNGXPEWRITEREGISTER8)(uint32 address, uint8 data);

typedef uint32	(CALLBACK* LPFNGXPEREADREGISTER32)(uint32 address);
typedef uint16	(CALLBACK* LPFNGXPEREADREGISTER16)(uint32 address);
typedef uint8	(CALLBACK* LPFNGXPEREADREGISTER8)(uint32 address);

typedef void	(CALLBACK* LPFNGXWRITEFIFO)(uint8* data, uint32 len);

typedef void	(CALLBACK* LPFNGXVIWRITEREGISTER32)(uint32 address, uint32 data);
typedef void	(CALLBACK* LPFNGXVIWRITEREGISTER16)(uint32 address, uint16 data);
typedef void	(CALLBACK* LPFNGXVIWRITEREGISTER8)(uint32 address, uint8 data);

typedef uint32	(CALLBACK* LPFNGXVIREADREGISTER32)(uint32 address);
typedef uint16	(CALLBACK* LPFNGXVIREADREGISTER16)(uint32 address);
typedef uint8	(CALLBACK* LPFNGXVIREADREGISTER8)(uint32 address);

typedef bool	(CALLBACK* LPFNGXVICHECKINTERRUPT)(void);
typedef void	(CALLBACK* LPFNGXVINEXTSCANLINE)(void);

extern LPFNGXREGISTERCALLBACK GX_RegisterCallback;
extern LPFNGXCACHEMARKINVALID GX_CacheMarkInvalid;
extern LPFNGXCACHESNOOP GX_CacheSnoop;
extern LPFNGXPECHECKINTERRUPT GX_PECheckInterrupt;
extern LPFNGXPEWRITEREGISTER32 GX_PEWriteRegister32;
extern LPFNGXPEWRITEREGISTER16 GX_PEWriteRegister16;
extern LPFNGXPEWRITEREGISTER8 GX_PEWriteRegister8;
extern LPFNGXCACHEGETTABLE GX_CacheGetTable;

extern LPFNGXPEREADREGISTER32 GX_PEReadRegister32;
extern LPFNGXPEREADREGISTER16 GX_PEReadRegister16;
extern LPFNGXPEREADREGISTER8 GX_PEReadRegister8;
extern LPFNGXWRITEFIFO GX_WriteFifo;

extern LPFNGXVIWRITEREGISTER32 GX_VIWriteRegister32;
extern LPFNGXVIWRITEREGISTER16 GX_VIWriteRegister16;
extern LPFNGXVIWRITEREGISTER8 GX_VIWriteRegister8;
extern LPFNGXVIREADREGISTER32 GX_VIReadRegister32;
extern LPFNGXVIREADREGISTER16 GX_VIReadRegister16;
extern LPFNGXVIREADREGISTER8 GX_VIReadRegister8;
extern LPFNGXVICHECKINTERRUPT GX_VICheckInterrupt;
extern LPFNGXVINEXTSCANLINE GX_VINextScanline;

extern LPFNGXOPEN	GX_Open;
extern LPFNGXINIT	GX_Init;

bool gx_plugin_init(char *name);
