/*====================================================================

filename:     gx_plugin.cpp
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#include "config.h"
#include "system/types.h"
#include "gx_plugin.h"
#include "debug/tracers.h"
#include "cpu/trx_ppc_cpu.h"

uint8 *gx_cache_table;

gxcb_t gxcbts[NUM_CBTS];

LPFNGXREGISTERCALLBACK GX_RegisterCallback;
LPFNGXCACHEGETTABLE GX_CacheGetTable;
LPFNGXCACHEMARKINVALID GX_CacheMarkInvalid;
LPFNGXCACHESNOOP GX_CacheSnoop;

LPFNGXPECHECKINTERRUPT GX_PECheckInterrupt;

LPFNGXPEWRITEREGISTER32 GX_PEWriteRegister32;
LPFNGXPEWRITEREGISTER16 GX_PEWriteRegister16;
LPFNGXPEWRITEREGISTER8 GX_PEWriteRegister8;

LPFNGXPEREADREGISTER32 GX_PEReadRegister32;
LPFNGXPEREADREGISTER16 GX_PEReadRegister16;
LPFNGXPEREADREGISTER8 GX_PEReadRegister8;

LPFNGXWRITEFIFO GX_WriteFifo;

LPFNGXVIWRITEREGISTER32 GX_VIWriteRegister32;
LPFNGXVIWRITEREGISTER16 GX_VIWriteRegister16;
LPFNGXVIWRITEREGISTER8 GX_VIWriteRegister8;

LPFNGXVIREADREGISTER32 GX_VIReadRegister32;
LPFNGXVIREADREGISTER16 GX_VIReadRegister16;
LPFNGXVIREADREGISTER8 GX_VIReadRegister8;

LPFNGXVICHECKINTERRUPT GX_VICheckInterrupt;
LPFNGXVINEXTSCANLINE GX_VINextScanline;

LPFNGXOPEN	GX_Open;
LPFNGXINIT	GX_Init = (LPFNGXINIT)0x1234;

HINSTANCE gx_lib_instance;

void gxp_get_address(void **ptr, char *fname)
{
	*ptr = (void *) GetProcAddress(gx_lib_instance, fname);
	if (*ptr == NULL)
		syslog_error(GX_PLUGIN, "Plugin does not support function '%s'\n", fname);
}

bool gx_plugin_init(char *name)
{
	gx_lib_instance = LoadLibrary(name);
	if(gx_lib_instance == NULL) 
		syslog_error(GX_PLUGIN, "Cannot open gx plugin '%s'\n", name);

	gxp_get_address((void **)&GX_RegisterCallback, "GX_RegisterCallback");
	gxp_get_address((void **)&GX_Init, "GX_Init");
	gxp_get_address((void **)&GX_Open, "GX_Open");

	gxp_get_address((void **)&GX_CacheGetTable, "GX_CacheGetTable");
	gxp_get_address((void **)&GX_CacheMarkInvalid, "GX_CacheMarkInvalid");
	gxp_get_address((void **)&GX_CacheSnoop, "GX_CacheSnoop");

	gxp_get_address((void **)&GX_PEWriteRegister32, "GX_PEWriteRegister32");
	gxp_get_address((void **)&GX_PEWriteRegister16, "GX_PEWriteRegister16");
	gxp_get_address((void **)&GX_PEWriteRegister8, "GX_PEWriteRegister8");
	gxp_get_address((void **)&GX_PEReadRegister32, "GX_PEReadRegister32");
	gxp_get_address((void **)&GX_PEReadRegister16, "GX_PEReadRegister16");
	gxp_get_address((void **)&GX_PEReadRegister8, "GX_PEReadRegister8");

	gxp_get_address((void **)&GX_PECheckInterrupt, "GX_PECheckInterrupt");
	gxp_get_address((void **)&GX_WriteFifo, "GX_WriteFifo");

	gxp_get_address((void **)&GX_VIWriteRegister32, "GX_VIWriteRegister32");
	gxp_get_address((void **)&GX_VIWriteRegister16, "GX_VIWriteRegister16");
	gxp_get_address((void **)&GX_VIWriteRegister8, "GX_VIWriteRegister8");
	gxp_get_address((void **)&GX_VIReadRegister32, "GX_VIReadRegister32");
	gxp_get_address((void **)&GX_VIReadRegister16, "GX_VIReadRegister16");
	gxp_get_address((void **)&GX_VIReadRegister8, "GX_VIReadRegister8");
	gxp_get_address((void **)&GX_VICheckInterrupt, "GX_VICheckInterrupt");
	gxp_get_address((void **)&GX_VINextScanline, "GX_VINextScanline");

	// register callbacks with plugin
	// plugin needs to be able to signal interrupts to the CPU
	gxcbts[CBT_IRQ_SIGNAL].id = CBT_IRQ_SIGNAL;
	gxcbts[CBT_IRQ_SIGNAL].fn = trx_ppc_signal_interrupt;

	GX_RegisterCallback(gxcbts);
	return true;
}