/*====================================================================

filename:     processor_interface.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#pragma once
#include "system/types.h"
void pi_init(void);
void pi_close(void);
void pi_write_register8(uint32 addr, uint8 data);
void pi_write_register16(uint32 addr, uint16 data);
void pi_write_register32(uint32 addr, uint32 data);
uint8 pi_read_register8(uint32 addr);
uint16 pi_read_register16(uint32 addr);
uint32 pi_read_register32(uint32 addr);
bool pi_check_interrupt_lines(void);
void pi_schedule_irq(uint32 irq, uint32 count, void (*callback)(void));

extern uint32 pi_fifo_start;
extern uint32 pi_fifo_end;
extern uint32 pi_fifo_writepointer;

#define	PI_MAX_IRQ_SOURCES	(3)
#define PI_IRQ_SI			(0)
#define PI_IRQ_DI			(1)
#define PI_IRQ_DSPI_AI		(2)

