/*====================================================================

filename:     dsp_interface_defines.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#pragma once

#define ARAM_SIZE	(16*1024*1024)

#define DSPI_REGS_SIZE	256

// mailbox in (cpu->dsp)
#define	DSPI_REG_MB_CPU				0x00
#define	DSPI_REG_MB_CPU_H			0x00
#define	DSPI_REG_MB_CPU_L			0x02

// mailbox out (dsp->cpu)
#define	DSPI_REG_MB_DSP				0x04
#define	DSPI_REG_MB_DSP_H			0x04
#define	DSPI_REG_MB_DSP_L			0x06

#define DSPI_REG_AI_DSP_CSR			0x0a
#define DSPI_REG_AI_DMA_ADDR		0x30
#define DSPI_REG_AI_DMA_CR			0x36

#define DSPI_REG_AR_DMA_MMADDR		0x20
#define DSPI_REG_AR_DMA_ARADDR		0x24
#define DSPI_REG_AR_DMA_CNT			0x28
#define DSPI_REG_AR_DMA_CNT_H		0x28
#define DSPI_REG_AR_DMA_CNT_L		0x2a

#define DSPI_REG_UINT32(A)		*((uint32 *)(dspi_regs + (A)))
#define DSPI_REG_UINT16(A)		*((uint16 *)(dspi_regs + (A)))
#define DSPI_REG_UINT8(A)		*((uint8 *)(dspi_regs + (A)))

#define DSPI_WRITE_UINT32(A, D)	DSPI_REG_UINT32(A) = byteswap32((D))
#define DSPI_WRITE_UINT16(A, D)	DSPI_REG_UINT16(A) = byteswap16((D))
#define DSPI_WRITE_UINT8(A, D)	DSPI_REG_UINT8(A) = (uint8)(D)

#define DSPI_READ_UINT32(A)		(byteswap32(DSPI_REG_UINT32(A)))
#define DSPI_READ_UINT16(A)		(byteswap16(DSPI_REG_UINT16(A)))
#define DSPI_READ_UINT8(A)		(DSPI_REG_UINT8(A))



#define AIDCR_ARDMA         (1 << 9)        // ARAM dma in progress
#define AIDCR_DSPINTMSK     (1 << 8)        // * interrupt mask   (RW)
#define AIDCR_DSPINT        (1 << 7)        // * interrupt active (RWC)
#define AIDCR_ARINTMSK      (1 << 6)
#define AIDCR_ARINT         (1 << 5)
#define AIDCR_AIINTMSK      (1 << 4)
#define AIDCR_AIINT         (1 << 3)
#define AIDCR_HALT          (1 << 2)        // halt DSP
#define AIDCR_PIINT         (1 << 1)        // assert DSP PI interrupt
#define AIDCR_RES           (1 << 0)        // reset DSP

