/*====================================================================

filename:     gcm_loader.cpp
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#include <stdio.h>
#include "system/types.h"
#include "hardware/memory_interface.h"
#include "gcm_loader.h"
#include "gcm_wrapper.h"
#include "elf_loader.h"
#include "debug/tracers.h"

char gcm_bb2[0x32];

// function returns address it loaded FST
bool gcm_load_fst(uint8 *mem)
{
	uint32 off, len, len2, len3;
	uint32 arenahi;

	if (gcm_is_open() == false)
		return false;
	gcm_read(gcm_bb2, 0x420, 0x20);

	off = byteswap32(((uint32 *)gcm_bb2)[1]);
	len = byteswap32(((uint32 *)gcm_bb2)[2]);
	len2 = byteswap32(((uint32 *)gcm_bb2)[3]);
	uint32 pos = byteswap32(((uint32 *)gcm_bb2)[4]);

	printf("FST: unk: %08x off: %08x size: %08x size2: %08x pos: %08x\n", byteswap32(((uint32 *)gcm_bb2)[0]), off, len, len2, pos);
	len3 = (len2 + 31) & ~31;
	printf("Adjusted len: %08x\n", len3);
	arenahi = 0x81800000 - len3;
	printf("New ArenaHi set to: %08x\n", arenahi);
	gcm_read((char *)gMemory + (arenahi & 0x0fffffff), off, len);
	mem_write32(0x00000038, arenahi);
	mem_write32(0x0000003c, len2);	// or len3!!!
	return true;
}


bool gcm_load_file(char *filename, uint8 *mem, uint32 &entry_point)
{
	gcm_open(filename);
	gcm_print_info(true);

	gcm_load_fst(gMemory);
	
	elf_file *elf = NULL;

	elf = elf_create(gMemory);
	elf_enabledebug(elf, false);
	if (!elf_open(elf, "gcmload.elf"))
	{
		syslog_error(MAIN,"Cant open: %s\n", "gcmload.elf");
	}
	elf_loadheaders(elf);
	entry_point = elf_getentrypoint(elf);

	return true;
}