/*====================================================================

filename:     elf_loader.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/

#ifndef _ELF_LOADER_H
#define _ELF_LOADER_H

#include <stdio.h>
#include "elf.h"
#include "system/types.h"

typedef struct
{
	Elf32_Sym	*symbols;
	Elf32_Ehdr	header;
	Elf32_Phdr	*program_header;
	Elf32_Shdr	*section_header;
	FILE		*file_in;
	char		*sections_names;
	char		*symbol_names;
	uint8		*memory;
	int			count;
	bool		debug;
} elf_file;


elf_file * elf_create(uint8 *mem);
void elf_free(elf_file *elf);

void elf_enabledebug(elf_file *elf, bool debug);

bool elf_open(elf_file *elf, char *name);
void elf_close(elf_file *elf);

int elf_loadheaders(elf_file *elf);
int elf_loadprogramheaders(elf_file *elf);
int elf_loadsectionheaders(elf_file * elf);

uint32 elf_getentrypoint(elf_file * elf);
char * elf_getfunctionname(elf_file * elf, uint32 addr);
uint32 elf_getfunctionaddr(elf_file * elf, char *name);

bool elf_hassymbols(elf_file * elf);

uint32 elf_get_top(elf_file * elf);

#endif // _ELF_LOADER_H