/*====================================================================

filename:     gdsp_interface.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#pragma once

#define GDSP_MBOX_CPU	0
#define GDSP_MBOX_DSP	1

uint32	gdsp_mbox_peek(uint8 mbx);
void	gdsp_mbox_write_h(uint8 mbx, uint16 val);
void	gdsp_mbox_write_l(uint8 mbx, uint16 val);
uint16	gdsp_mbox_read_h(uint8 mbx);
uint16	gdsp_mbox_read_l(uint8 mbx);

void	gdsp_ifx_init(void);

void	gdsp_idma_in(uint16 dsp_addr, uint32 addr, uint32 size);
