/*====================================================================

filename:     syslog.cpp
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "config.h"
#include "syslog.h"
#include "tracers.h"

char *log_id[LOG_TYPE_MAX]={
	"[MAIN]",
	"[LOAD]",
	"[CPU]",
	"[IO_CORE]",
	"[CMP]",
	"[EXI]",
	"[ARAM]",
	"[DSPI]",
	"[DI]",
	"[SI]",
	"[CP]",
	"[TE]",
	"[MC]",
	"[VI]",
	"[BP]",
	"[VX]",
	"[GX]",
	"[XF]",
	"[WGL]",
	"[GX_PLUGIN]"
};

uint32 log_trace_on[LOG_TYPE_MAX];

static	char tmpbuf[255];

void syslog_output(char *text)
{
	tmpbuf[254] = 0;
	printf(text);
}

#if WITH_LOGGING
void syslog(int type, char *fmt,...)
{
	va_list marker;
	va_start(marker,fmt);

	if(log_trace_on[type])
	{
		syslog_output(log_id[type]);
		vsprintf(tmpbuf, fmt, marker );
		syslog_output(tmpbuf);
	}
	va_end(marker);
}
#endif

void syslog_error(int type, char *fmt,...)
{
	va_list marker;
	va_start(marker,fmt);
	vsprintf(tmpbuf, fmt, marker );
	va_end(marker);

	syslog_output(log_id[type]);
	syslog_output("<ERROR> ");
	syslog_output(tmpbuf);
	fflush(stdout);
	exit(0);
}

void syslog_warn(int type, char *fmt,...)
{
	va_list marker;
	va_start(marker,fmt);
	vsprintf(tmpbuf, fmt, marker );
	va_end(marker);
	syslog_output(log_id[type]);
	syslog_output("<WARNING> ");
	syslog_output(tmpbuf);
}
