/*====================================================================

filename:     profiler.h
project:      GCemu
created:      2004-6-18
mail:		  duddie@walla.com

Copyright (c) 2005 Duddie & Tratax

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

====================================================================*/
#pragma once

#define WITH_REAL_DSP			0
#define WITH_DSP_ON_THREAD		1

#if !WITH_REAL_DSP
#undef WITH_DSP_ON_THREAD
#define WITH_DSP_ON_THREAD		0
#endif

// 4096 - 32 spare bytes
#define GPU_FIFO_SIZE	4064

enum ecpumodes
{
	CPU_RECOMPILER,
	CPU_INTERPRETER,
	CPU_SELFCHECKMODE
};

// runtime configuration options
extern int	config_cpumode; // part of CPU actually
extern int	config_disable_sse2;
extern int  config_stackinram;
extern int	config_skipidle;
extern int config_region; 
extern int	config_instructions_per_line;
extern int	config_debugasm;
extern int	config_constantaddress;
// hotkey logging button
extern int config_hotkeylogging;
extern int config_debug;

// switching between D3D(0) or OpenGL(1) plugins at start
extern char config_gpuplugin[255];

#define VART_bool   0
#define VART_INT    1
#define VART_FUNC   2
#define VART_FUNCP  3

typedef struct
{
    int     type;
    char    *name;
	char	short_name;
    int     *var;
    int     value;
    int     (*function)(char *);    
    char    *description;
}variable_def_t;

void config_init(void);
int config_help(char *a);
unsigned char config_variable(char *varname);
