	AREA wram_code0, CODE, READWRITE

	INCLUDE equates.h
	INCLUDE gbz80mac.h
	INCLUDE cart.h
	INCLUDE memory.h
	INCLUDE io.h
	INCLUDE lcd.h
	INCLUDE sound.h

	IMPORT |wram_globals0$$Base|
	IMPORT ui	;ui.c
	IMPORT quickload	;sram.c
	IMPORT quicksave	;sram.c

	EXPORT XGB_RAM
	EXPORT XGB_HRAM
	EXPORT XGB_SRAM
	EXPORT XGB_VRAM
	EXPORT GBC_EXRAM
	
	EXPORT emu_reset
	EXPORT run
	EXPORT op_table
	EXPORT default_scanlinehook
	EXPORT cpustate
	EXPORT rommap
	EXPORT frametotal
	EXPORT sleeptime
	EXPORT novblankwait
	EXPORT request_gb_type
	EXPORT line145_to_end
	[ SPEEDHACKS
	EXPORT num_speedhacks
	EXPORT speedhacks
	EXPORT cpuhack_reset
	]
	EXPORT g_hackflags
	EXPORT g_doubletimer
	EXPORT gb_mode
	EXPORT g_doublespeed
	EXPORT g_cyclesperscanline
	
	EXPORT g_readmem_tbl
	EXPORT g_writemem_tbl

;----------------------------------------------------------------------------
_GO;	Continue running
;----------------------------------------------------------------------------
	fetch 0
;----------------------------------------------------------------------------
_ED;	DEBUG					;actually invalid opcode
;----------------------------------------------------------------------------
;	mov r0,#1
;	strb r0,debugstop
debugwait
;	ldrb r0,debugstop
;	cmp r0,#0
;	bne debugwait
;	fetch 0
;----------------------------------------------------------------------------
_xx;	???					;invalid opcode
;----------------------------------------------------------------------------
	[ DEBUG
		adr r0,_xx
		mov r1,#0
		bl debug_
	]
	fetch 4
;----------------------------------------------------------------------------
_40;	LD B,B
_49;	LD C,C
_52;	LD D,D
_5B;	LD E,E
_64;	LD H,H
_6D;	LD L,L
_7F;	LD A,A
;----------------------------------------------------------------------------
_00;   NOP
;----------------------------------------------------------------------------
	fetch 4
;----------------------------------------------------------------------------
_01;	LD BC,#nnnn
;----------------------------------------------------------------------------
	opLDIM16
	mov gb_bc,r0,lsl#16
	fetch 16
;----------------------------------------------------------------------------
_02;	LD (BC),A	write A to (BC)
;----------------------------------------------------------------------------
	mov r0,gb_a,lsr#24
	mov addy,gb_bc,lsr#16
	writemem
	fetch 8
;----------------------------------------------------------------------------
_03;	INC BC
;----------------------------------------------------------------------------
	opINC16 gb_bc
	fetch 8
;----------------------------------------------------------------------------
_04;	INC B
;----------------------------------------------------------------------------
	opINC8H gb_bc
;----------------------------------------------------------------------------
_05;	DEC B
;----------------------------------------------------------------------------
	opDEC8H gb_bc
;----------------------------------------------------------------------------
_06;	LD B,#nn
;----------------------------------------------------------------------------
	opLDIM8H gb_bc
;----------------------------------------------------------------------------
_07;	RLCA	rotate accu left
;----------------------------------------------------------------------------
	mov gb_flg,#0
	adds gb_a,gb_a,gb_a
	orrcs gb_flg,gb_flg,#PSR_C
	orrcs gb_a,gb_a,#0x01000000
	fetch 4
;----------------------------------------------------------------------------
_08;	LD (nnnn),SP	write SP to (nnnn)
;----------------------------------------------------------------------------
	ldrb addy,[gb_pc],#1
	ldrb r0,[gb_pc],#1
	orr addy,addy,r0,lsl#8
	ldrb r0,gb_sp+2
	writemem
	add addy,addy,#1		;Might be changed!!!
	ldrb r0,gb_sp+3
	writemem
	fetch 20
;----------------------------------------------------------------------------
_09;	ADD HL,BC
;----------------------------------------------------------------------------
	opADD16 gb_bc
;----------------------------------------------------------------------------
_0A;	LD A,(BC)
;----------------------------------------------------------------------------
	mov addy,gb_bc,lsr#16
	readmem
	mov gb_a,r0,lsl#24
	fetch 8
;----------------------------------------------------------------------------
_0B;	DEC BC
;----------------------------------------------------------------------------
	opDEC16 gb_bc
	fetch 8
;----------------------------------------------------------------------------
_0C;	INC C
;----------------------------------------------------------------------------
	opINC8L gb_bc
;----------------------------------------------------------------------------
_0D;	DEC C
;----------------------------------------------------------------------------
	opDEC8L gb_bc
;----------------------------------------------------------------------------
_0E;	LD C,#nn
;----------------------------------------------------------------------------
	opLDIM8L gb_bc
;----------------------------------------------------------------------------
_0F;	RRCA	rotate accu right
;----------------------------------------------------------------------------
	mov gb_flg,#0
	movs gb_a,gb_a,lsr#25
	orrcs gb_flg,gb_flg,#PSR_C
	orrcs gb_a,gb_a,#0x00000080
	mov gb_a,gb_a,lsl#24
	fetch 4
;----------------------------------------------------------------------------
_10;	STOP	stops the processor until an (joypad) interrupt.
;----------------------------------------------------------------------------
	ldrb r0,doublespeed
	tst r0,#1
	blne speedswitch
	
	b _noStop
;	b _76 ;halt instead?
	ldrb r1,gb_ime
	tst r1,#1			;no Halt if IRQ disabled.
	beq _noStop
	ldrb r0,gb_ic		;interrupt confirm
	cmp r0,#0
	movne r0,#0
	strneb r0,gb_ic
	subeq gb_pc,gb_pc,#1
	moveq cycles,#0
_noStop
	add gb_pc,gb_pc,#1
	fetch 4
;----------------------------------------------------------------------------
_11;	LD DE,#nnnn
;----------------------------------------------------------------------------
	opLDIM16
	mov gb_de,r0,lsl#16
	fetch 16
;----------------------------------------------------------------------------
_12;	LD (DE),A	write A to (DE)
;----------------------------------------------------------------------------
	mov r0,gb_a,lsr#24
	mov addy,gb_de,lsr#16
	writemem
	fetch 8
;----------------------------------------------------------------------------
_13;	INC DE
;----------------------------------------------------------------------------
	opINC16 gb_de
	fetch 8
;----------------------------------------------------------------------------
_14;	INC D
;----------------------------------------------------------------------------
	opINC8H gb_de
;----------------------------------------------------------------------------
_15;	DEC D
;----------------------------------------------------------------------------
	opDEC8H gb_de
;----------------------------------------------------------------------------
_16;	LD D,#nn
;----------------------------------------------------------------------------
	opLDIM8H gb_de
;----------------------------------------------------------------------------
_17;	RLA	rotate accu left through C
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_C
	mov gb_flg,#0			;clear flags
	orrne gb_a,gb_a,#0x00800000
	adds gb_a,gb_a,gb_a
	orrcs gb_flg,gb_flg,#PSR_C
	fetch 4
;----------------------------------------------------------------------------
_18;	JR *	relative jump
;----------------------------------------------------------------------------
	ldrsb r0,[gb_pc],#1
	add gb_pc,gb_pc,r0
	fetch 8
;----------------------------------------------------------------------------
_19;	ADD HL,DE
;----------------------------------------------------------------------------
	opADD16 gb_de
;----------------------------------------------------------------------------
_1A;	LD A,(DE)
;----------------------------------------------------------------------------
	mov addy,gb_de,lsr#16
	readmem
	mov gb_a,r0,lsl#24
	fetch 8
;----------------------------------------------------------------------------
_1B;	DEC DE
;----------------------------------------------------------------------------
	opDEC16 gb_de
	fetch 8
;----------------------------------------------------------------------------
_1C;	INC E
;----------------------------------------------------------------------------
	opINC8L gb_de
;----------------------------------------------------------------------------
_1D;	DEC E
;----------------------------------------------------------------------------
	opDEC8L gb_de
;----------------------------------------------------------------------------
_1E;	LD E,#nn
;----------------------------------------------------------------------------
	opLDIM8L gb_de
;----------------------------------------------------------------------------
_1F;	RRA	rotate accu right through C
;----------------------------------------------------------------------------
	msr cpsr_f,gb_flg	;get C
	mov gb_flg,#0		;clear flags
	mov gb_a,gb_a,rrx
	tst gb_a,#0x00800000
	orrne gb_flg,gb_flg,#PSR_C
	bic gb_a,gb_a,#0x00800000
	fetch 4

	[ SPEEDHACKS
;binary search through hacks list
checkjump
	ldr r0,lastbank
	sub gb_pc,gb_pc,r0
	mov r1,#0
	ldr r2,numspeedhacks
	ldr addy,speedhacks_p
checkjump_loop
	add r0,r1,r2
	mov r0,r0,lsr#1
	ldrh lr,[addy,r0]
	cmp lr,gb_pc
	beq checkjump_foundit
	subgt r2,r0,#1
	addlt r1,r0,#1
	cmp r1,r2
	ble checkjump_loop
checkjump_foundit
	subeq cycles,cycles,#100*CYCLE
	ldr r0,lastbank
	add gb_pc,gb_pc,r0
	b nojump_20x

;----------------------------------------------------------------------------
_20x;	JR NZ,*	jump if not zero - speedhack version
;----------------------------------------------------------------------------
	ldrsb r0,[gb_pc],#1
	tst gb_flg,#PSR_Z
	bne nojump_20x
	add gb_pc,gb_pc,r0
	sub cycles,cycles,#4*CYCLE
	cmp r0,#-11
	bgt checkjump
nojump_20x
	fetch 8
	]
;----------------------------------------------------------------------------
_20;	JR NZ,*	jump if not zero
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_Z
	ldrsb r0,[gb_pc],#1
	addeq gb_pc,gb_pc,r0
	subeq cycles,cycles,#4*CYCLE
;	cmpeq r0,#-4
;	andeq cycles,cycles,#CYC_MASK
	fetch 8
;----------------------------------------------------------------------------
_21;	LD HL,#nnnn
;----------------------------------------------------------------------------
	opLDIM16
	mov gb_hl,r0,lsl#16
	fetch 16
;----------------------------------------------------------------------------
_22;	LDI (HL),A	write A to (HL), incr HL
;----------------------------------------------------------------------------
	mov r0,gb_a,lsr#24
	writememHL
	add gb_hl,gb_hl,#0x00010000
	fetch 8
;----------------------------------------------------------------------------
_23;	INC HL
;----------------------------------------------------------------------------
	opINC16 gb_hl
	fetch 8
;----------------------------------------------------------------------------
_24;	INC H
;----------------------------------------------------------------------------
	opINC8H gb_hl
;----------------------------------------------------------------------------
_25;	DEC H
;----------------------------------------------------------------------------
	opDEC8H gb_hl
;----------------------------------------------------------------------------
_26;	LD H,#nn
;----------------------------------------------------------------------------
	opLDIM8H gb_hl
;----------------------------------------------------------------------------
_27;	DAA	decimal adjust ackumulator
;----------------------------------------------------------------------------
	mov r0,#0

	and r1,gb_a,#0x0F000000
	cmp r1,#0x0A000000
	orrpl r0,r0,#0x06000000
	cmppl gb_a,#0x90000000
	cmpmi gb_a,#0xA0000000
	orrhs gb_flg,gb_flg,#PSR_C			;C
noextra
	tst gb_flg,#PSR_h					;half carry.
	orrne r0,r0,#0x06000000

	tst gb_flg,#PSR_C					;carry.
	orrne r0,r0,#0x60000000

	tst gb_flg,#PSR_n					;check if last instruction was add or sub.
	bne doSUBconv

doADDconv
	and gb_flg,gb_flg,#PSR_C+PSR_n	;keep C & n
	adds gb_a,gb_a,r0
	orreq gb_flg,gb_flg,#PSR_Z
	cmp r1,#0x0A000000
	orrpl gb_flg,gb_flg,#PSR_h
	fetch 4

doSUBconv
	and gb_flg,gb_flg,#PSR_C+PSR_n+PSR_h	;keep C & n & H
	subs gb_a,gb_a,r0
	orreq gb_flg,gb_flg,#PSR_Z
	cmp r1,#0x06000000
	bicpl gb_flg,gb_flg,#PSR_h
	fetch 4
	[ SPEEDHACKS
;----------------------------------------------------------------------------
_28x;	JR Z,*	jump if zero - speedhack version
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_Z
	ldrsb r0,[gb_pc],#1
	beq nojump_28x
	add gb_pc,gb_pc,r0
	sub cycles,cycles,#4*CYCLE
	cmp r0,#-11
	bgt checkjump
nojump_28x
	fetch 8
	]
;----------------------------------------------------------------------------
_28;	JR Z,*	jump if zero
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_Z
	ldrsb r0,[gb_pc],#1
;	beq _28_
	addne gb_pc,gb_pc,r0
	subne cycles,cycles,#4*CYCLE
;	cmp r0,#-4
;	andeq cycles,cycles,#CYC_MASK
_28_
	fetch 8
;----------------------------------------------------------------------------
_29;	ADD HL,HL
;----------------------------------------------------------------------------
	opADD16_2
;----------------------------------------------------------------------------
_2A;	LDI A,(HL)	load A from (HL), incr HL
;----------------------------------------------------------------------------
	readmemHL
	add gb_hl,gb_hl,#0x00010000
	mov gb_a,r0,lsl#24
	fetch 8
;----------------------------------------------------------------------------
_2B;	DEC HL
;----------------------------------------------------------------------------
	opDEC16 gb_hl
	fetch 8
;----------------------------------------------------------------------------
_2C;	INC L
;----------------------------------------------------------------------------
	opINC8L gb_hl
;----------------------------------------------------------------------------
_2D;	DEC L
;----------------------------------------------------------------------------
	opDEC8L gb_hl
;----------------------------------------------------------------------------
_2E;	LD L,#nn
;----------------------------------------------------------------------------
	opLDIM8L gb_hl
;----------------------------------------------------------------------------
_2F;	CPL	complement A
;----------------------------------------------------------------------------
	eor gb_a,gb_a,#0xFF000000
	orr gb_flg,gb_flg,#PSR_n|PSR_h		;set n & h
	fetch 4
	[ SPEEDHACKS
;----------------------------------------------------------------------------
_30x;	JR NC,*	jump if no carry - speedhack version
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_C
	ldrsb r0,[gb_pc],#1
	bne nojump_30x
	add gb_pc,gb_pc,r0
	sub cycles,cycles,#4*CYCLE
	cmp r0,#-11
	bgt checkjump
nojump_30x
	fetch 8
	]
;----------------------------------------------------------------------------
_30;	JR NC,*	jump if no carry
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_C
	ldrsb r0,[gb_pc],#1
	addeq gb_pc,gb_pc,r0
	subeq cycles,cycles,#4*CYCLE
	fetch 8
;----------------------------------------------------------------------------
_31;	LD SP,#nnnn
;----------------------------------------------------------------------------
	opLDIM16
	mov r0,r0,lsl#16
	str r0,gb_sp
	fetch 16
;----------------------------------------------------------------------------
_32;	LDD (HL),A	write A to (HL), decr HL
;----------------------------------------------------------------------------
	mov r0,gb_a,lsr#24
	writememHL
	sub gb_hl,gb_hl,#0x00010000
	fetch 8
;----------------------------------------------------------------------------
_33;	INC SP
;----------------------------------------------------------------------------
	ldr r0,gb_sp
	opINC16 r0
	str r0,gb_sp
	fetch 8
;----------------------------------------------------------------------------
_34;	INC (HL)
;----------------------------------------------------------------------------
	readmemHL
	opINC8b
	writemem
	fetch 12
;----------------------------------------------------------------------------
_35;	DEC (HL)
;----------------------------------------------------------------------------
	readmemHL
	opDEC8b
	writemem
	fetch 12
;----------------------------------------------------------------------------
_36;	LD (HL),#nn
;----------------------------------------------------------------------------
	ldrb r0,[gb_pc],#1
	writememHL
	fetch 12
;----------------------------------------------------------------------------
_37;	SCF	set carry flag
;----------------------------------------------------------------------------
	and gb_flg,gb_flg,#PSR_Z	;clear n & h, keep zero
	orr gb_flg,gb_flg,#PSR_C	;set carry.
	fetch 4
	[ SPEEDHACKS
;----------------------------------------------------------------------------
_38x;	JR C,*	jump if carry - speedhack version
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_C
	ldrsb r0,[gb_pc],#1
	beq nojump_38x
	add gb_pc,gb_pc,r0
	sub cycles,cycles,#4*CYCLE
	cmp r0,#-11
	bgt checkjump
nojump_38x
	fetch 8
	]
;----------------------------------------------------------------------------
_38;	JR C,*	jump if carry
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_C
	ldrsb r0,[gb_pc],#1
	addne gb_pc,gb_pc,r0
	subne cycles,cycles,#4*CYCLE
	fetch 8
;----------------------------------------------------------------------------
_39;	ADD HL,SP
;----------------------------------------------------------------------------
	ldr r0,gb_sp
	opADD16 r0
;----------------------------------------------------------------------------
_3A;	LDD A,(HL)	load A from (HL), decr HL
;----------------------------------------------------------------------------
	readmemHL
	sub gb_hl,gb_hl,#0x00010000
	mov gb_a,r0,lsl#24
	fetch 8
;----------------------------------------------------------------------------
_3B;	DEC SP
;----------------------------------------------------------------------------
	ldr r0,gb_sp
	opDEC16 r0
	str r0,gb_sp
	fetch 8
;----------------------------------------------------------------------------
_3C;	INC A
;----------------------------------------------------------------------------
	opINC8A
;----------------------------------------------------------------------------
_3D;	DEC A
;----------------------------------------------------------------------------
	opDEC8A
;----------------------------------------------------------------------------
_3E;	LD A,#nn
;----------------------------------------------------------------------------
	ldrb r0,[gb_pc],#1
	mov gb_a,r0,lsl#24
	fetch 8
;----------------------------------------------------------------------------
_3F;	CCF	complement carry flag
;----------------------------------------------------------------------------
	and gb_flg,gb_flg,#PSR_Z|PSR_C	;clear n & h, keep zero & carry.
	eor gb_flg,gb_flg,#PSR_C	;complement carry.
	fetch 4
;----------------------------------------------------------------------------
;_40;	LD B,B
;----------------------------------------------------------------------------
;	fetch 4
;----------------------------------------------------------------------------
_41;	LD B,C
;----------------------------------------------------------------------------
	and gb_bc,gb_bc,#0x00FF0000
	orr gb_bc,gb_bc,gb_bc,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_42;	LD B,D
;----------------------------------------------------------------------------
	and gb_bc,gb_bc,#0x00FF0000
	and r0,gb_de,#0xFF000000
	orr gb_bc,gb_bc,r0
	fetch 4
;----------------------------------------------------------------------------
_43;	LD B,E
;----------------------------------------------------------------------------
	and gb_bc,gb_bc,#0x00FF0000
	orr gb_bc,gb_bc,gb_de,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_44;	LD B,H
;----------------------------------------------------------------------------
	and gb_bc,gb_bc,#0x00FF0000
	and r0,gb_hl,#0xFF000000
	orr gb_bc,gb_bc,r0
	fetch 4
;----------------------------------------------------------------------------
_45;	LD B,L
;----------------------------------------------------------------------------
	and gb_bc,gb_bc,#0x00FF0000
	orr gb_bc,gb_bc,gb_hl,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_46;	LD B,(HL)
;----------------------------------------------------------------------------
	readmemHL
	and gb_bc,gb_bc,#0x00FF0000
	orr gb_bc,gb_bc,r0,lsl#24
	fetch 8
;----------------------------------------------------------------------------
_47;	LD B,A
;----------------------------------------------------------------------------
	and gb_bc,gb_bc,#0x00FF0000
	orr gb_bc,gb_bc,gb_a
	fetch 4
;----------------------------------------------------------------------------
_48;	LD C,B
;----------------------------------------------------------------------------
	and gb_bc,gb_bc,#0xFF000000
	orr gb_bc,gb_bc,gb_bc,lsr#8
	fetch 4
;----------------------------------------------------------------------------
;_49;	LD C,C
;----------------------------------------------------------------------------
;	fetch 4
;----------------------------------------------------------------------------
_4A;	LD C,D
;----------------------------------------------------------------------------
	and gb_bc,gb_bc,#0xFF000000
	orr gb_bc,gb_bc,gb_de,lsr#8
	bic gb_bc,gb_bc,#0x0000FF00
	fetch 4
;----------------------------------------------------------------------------
_4B;	LD C,E
;----------------------------------------------------------------------------
	and gb_bc,gb_bc,#0xFF000000
	and r0,gb_de,#0x00FF0000
	orr gb_bc,gb_bc,r0
	fetch 4
;----------------------------------------------------------------------------
_4C;	LD C,H
;----------------------------------------------------------------------------
	and gb_bc,gb_bc,#0xFF000000
	orr gb_bc,gb_bc,gb_hl,lsr#8
	bic gb_bc,gb_bc,#0x0000FF00
	fetch 4
;----------------------------------------------------------------------------
_4D;	LD C,L
;----------------------------------------------------------------------------
	and gb_bc,gb_bc,#0xFF000000
	and r0,gb_hl,#0x00FF0000
	orr gb_bc,gb_bc,r0
	fetch 4
;----------------------------------------------------------------------------
_4E;	LD C,(HL)
;----------------------------------------------------------------------------
	readmemHL
	and gb_bc,gb_bc,#0xFF000000
	orr gb_bc,gb_bc,r0,lsl#16
	fetch 8
;----------------------------------------------------------------------------
_4F;	LD C,A
;----------------------------------------------------------------------------
	and gb_bc,gb_bc,#0xFF000000
	orr gb_bc,gb_bc,gb_a,lsr#8
	fetch 4
;----------------------------------------------------------------------------
_50;	LD D,B
;----------------------------------------------------------------------------
	and gb_de,gb_de,#0x00FF0000
	and r0,gb_bc,#0xFF000000
	orr gb_de,gb_de,r0
	fetch 4
;----------------------------------------------------------------------------
_51;	LD D,C
;----------------------------------------------------------------------------
	and gb_de,gb_de,#0x00FF0000
	orr gb_de,gb_de,gb_bc,lsl#8
	fetch 4
;----------------------------------------------------------------------------
;_52;	LD D,D
;----------------------------------------------------------------------------
;	fetch 4
;----------------------------------------------------------------------------
_53;	LD D,E
;----------------------------------------------------------------------------
	and gb_de,gb_de,#0x00FF0000
	orr gb_de,gb_de,gb_de,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_54;	LD D,H
;----------------------------------------------------------------------------
	and gb_de,gb_de,#0x00FF0000
	and r0,gb_hl,#0xFF000000
	orr gb_de,gb_de,r0
	fetch 4
;----------------------------------------------------------------------------
_55;	LD D,L
;----------------------------------------------------------------------------
	and gb_de,gb_de,#0x00FF0000
	orr gb_de,gb_de,gb_hl,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_56;	LD D,(HL)
;----------------------------------------------------------------------------
	readmemHL
	and gb_de,gb_de,#0x00FF0000
	orr gb_de,gb_de,r0,lsl#24
	fetch 8
;----------------------------------------------------------------------------
_57;	LD D,A
;----------------------------------------------------------------------------
	and gb_de,gb_de,#0x00FF0000
	orr gb_de,gb_de,gb_a
	fetch 4
;----------------------------------------------------------------------------
_58;	LD E,B
;----------------------------------------------------------------------------
	and gb_de,gb_de,#0xFF000000
	orr gb_de,gb_de,gb_bc,lsr#8
	bic gb_de,gb_de,#0x0000FF00
	fetch 4
;----------------------------------------------------------------------------
_59;	LD E,C
;----------------------------------------------------------------------------
	and gb_de,gb_de,#0xFF000000
	and r0,gb_bc,#0x00FF0000
	orr gb_de,gb_de,r0
	fetch 4
;----------------------------------------------------------------------------
_5A;	LD E,D
;----------------------------------------------------------------------------
	and gb_de,gb_de,#0xFF000000
	orr gb_de,gb_de,gb_de,lsr#8
	fetch 4
;----------------------------------------------------------------------------
;_5B;	LD E,E
;----------------------------------------------------------------------------
;	fetch 4
;----------------------------------------------------------------------------
_5C;	LD E,H
;----------------------------------------------------------------------------
	and gb_de,gb_de,#0xFF000000
	orr gb_de,gb_de,gb_hl,lsr#8
	bic gb_de,gb_de,#0x0000FF00
	fetch 4
;----------------------------------------------------------------------------
_5D;	LD E,L
;----------------------------------------------------------------------------
	and gb_de,gb_de,#0xFF000000
	and r0,gb_hl,#0x00FF0000
	orr gb_de,gb_de,r0
	fetch 4
;----------------------------------------------------------------------------
_5E;	LD E,(HL)
;----------------------------------------------------------------------------
	readmemHL
	and gb_de,gb_de,#0xFF000000
	orr gb_de,gb_de,r0,lsl#16
	fetch 8
;----------------------------------------------------------------------------
_5F;	LD E,A
;----------------------------------------------------------------------------
	and gb_de,gb_de,#0xFF000000
	orr gb_de,gb_de,gb_a,lsr#8
	fetch 4
;----------------------------------------------------------------------------
_60;	LD H,B
;----------------------------------------------------------------------------
	and gb_hl,gb_hl,#0x00FF0000
	and r0,gb_bc,#0xFF000000
	orr gb_hl,gb_hl,r0
	fetch 4
;----------------------------------------------------------------------------
_61;	LD H,C
;----------------------------------------------------------------------------
	and gb_hl,gb_hl,#0x00FF0000
	orr gb_hl,gb_hl,gb_bc,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_62;	LD H,D
;----------------------------------------------------------------------------
	and gb_hl,gb_hl,#0x00FF0000
	and r0,gb_de,#0xFF000000
	orr gb_hl,gb_hl,r0
	fetch 4
;----------------------------------------------------------------------------
_63;	LD H,E
;----------------------------------------------------------------------------
	and gb_hl,gb_hl,#0x00FF0000
	orr gb_hl,gb_hl,gb_de,lsl#8
	fetch 4
;----------------------------------------------------------------------------
;_64;	LD H,H
;----------------------------------------------------------------------------
;	fetch 4
;----------------------------------------------------------------------------
_65;	LD H,L
;----------------------------------------------------------------------------
	and gb_hl,gb_hl,#0x00FF0000
	orr gb_hl,gb_hl,gb_hl,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_66;	LD H,(HL)
;----------------------------------------------------------------------------
	readmemHL
	and gb_hl,gb_hl,#0x00FF0000
	orr gb_hl,gb_hl,r0,lsl#24
	fetch 8
;----------------------------------------------------------------------------
_67;	LD H,A
;----------------------------------------------------------------------------
	and gb_hl,gb_hl,#0x00FF0000
	orr gb_hl,gb_hl,gb_a
	fetch 4
;----------------------------------------------------------------------------
_68;	LD L,B
;----------------------------------------------------------------------------
	and gb_hl,gb_hl,#0xFF000000
	orr gb_hl,gb_hl,gb_bc,lsr#8
	bic gb_hl,gb_hl,#0x0000FF00
	fetch 4
;----------------------------------------------------------------------------
_69;	LD L,C
;----------------------------------------------------------------------------
	and gb_hl,gb_hl,#0xFF000000
	and r0,gb_bc,#0x00FF0000
	orr gb_hl,gb_hl,r0
	fetch 4
;----------------------------------------------------------------------------
_6A;	LD L,D
;----------------------------------------------------------------------------
	and gb_hl,gb_hl,#0xFF000000
	orr gb_hl,gb_hl,gb_de,lsr#8
	bic gb_hl,gb_hl,#0x0000FF00
	fetch 4
;----------------------------------------------------------------------------
_6B;	LD L,E
;----------------------------------------------------------------------------
	and gb_hl,gb_hl,#0xFF000000
	and r0,gb_de,#0x00FF0000
	orr gb_hl,gb_hl,r0
	fetch 4
;----------------------------------------------------------------------------
_6C;	LD L,H
;----------------------------------------------------------------------------
	and gb_hl,gb_hl,#0xFF000000
	orr gb_hl,gb_hl,gb_hl,lsr#8
	fetch 4
;----------------------------------------------------------------------------
;_6D;	LD L,L
;----------------------------------------------------------------------------
;	fetch 4
;----------------------------------------------------------------------------
_6E;	LD L,(HL)
;----------------------------------------------------------------------------
	readmemHL
	and gb_hl,gb_hl,#0xFF000000
	orr gb_hl,gb_hl,r0,lsl#16
	fetch 8
;----------------------------------------------------------------------------
_6F;	LD L,A
;----------------------------------------------------------------------------
	and gb_hl,gb_hl,#0xFF000000
	orr gb_hl,gb_hl,gb_a,lsr#8
	fetch 4
;----------------------------------------------------------------------------
_70;	LD (HL),B
;----------------------------------------------------------------------------
	mov r0,gb_bc,lsr#24
	writememHL
	fetch 8
;----------------------------------------------------------------------------
_71;	LD (HL),C
;----------------------------------------------------------------------------
	mov r0,gb_bc,lsr#16
	and r0,r0,#0xFF
	writememHL
	fetch 8
;----------------------------------------------------------------------------
_72;	LD (HL),D
;----------------------------------------------------------------------------
	mov r0,gb_de,lsr#24
	writememHL
	fetch 8
;----------------------------------------------------------------------------
_73;	LD (HL),E
;----------------------------------------------------------------------------
	mov r0,gb_de,lsr#16
	and r0,r0,#0xFF
	writememHL
	fetch 8
;----------------------------------------------------------------------------
_74;	LD (HL),H
;----------------------------------------------------------------------------
	mov r0,gb_hl,lsr#24
	writememHL
	fetch 8
;----------------------------------------------------------------------------
_75;	LD (HL),L		special...
;----------------------------------------------------------------------------
	mov addy,gb_hl,lsr#16
	and r0,addy,#0xFF
	writemem
	fetch 8
;----------------------------------------------------------------------------
_76;	HALT, wait for interrupt.
;----------------------------------------------------------------------------
	ldrb r0,gb_ie
	ldrb r1,gb_if
	ands r0,r0,r1
	bne _noHalt
	sub gb_pc,gb_pc,#1
	mov cycles,#0
	fetch 4
_noHalt
	sub cycles,cycles,#4*CYCLE
	b checkMasterIRQ
;----------------------------------------------------------------------------
_77;	LD (HL),A
;----------------------------------------------------------------------------
	mov r0,gb_a,lsr#24
	writememHL
	fetch 8
;----------------------------------------------------------------------------
_78;	LD A,B
;----------------------------------------------------------------------------
	and gb_a,gb_bc,#0xFF000000
	fetch 4
;----------------------------------------------------------------------------
_79;	LD A,C
;----------------------------------------------------------------------------
	mov gb_a,gb_bc,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_7A;	LD A,D
;----------------------------------------------------------------------------
	and gb_a,gb_de,#0xFF000000
	fetch 4
;----------------------------------------------------------------------------
_7B;	LD A,E
;----------------------------------------------------------------------------
	mov gb_a,gb_de,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_7C;	LD A,H
;----------------------------------------------------------------------------
	and gb_a,gb_hl,#0xFF000000
	fetch 4
;----------------------------------------------------------------------------
_7D;	LD A,L
;----------------------------------------------------------------------------
	mov gb_a,gb_hl,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_7E;	LD A,(HL)
;----------------------------------------------------------------------------
	readmemHL
	mov gb_a,r0,lsl#24
	fetch 8
;----------------------------------------------------------------------------
;_7F;	LD A,A
;----------------------------------------------------------------------------
;	fetch 4
;----------------------------------------------------------------------------
_80;	ADD B
;----------------------------------------------------------------------------
	opADDH gb_bc
;----------------------------------------------------------------------------
_81;	ADD C
;----------------------------------------------------------------------------
	opADDL gb_bc
;----------------------------------------------------------------------------
_82;	ADD D
;----------------------------------------------------------------------------
	opADDH gb_de
;----------------------------------------------------------------------------
_83;	ADD E
;----------------------------------------------------------------------------
	opADDL gb_de
;----------------------------------------------------------------------------
_84;	ADD H
;----------------------------------------------------------------------------
	opADDH gb_hl
;----------------------------------------------------------------------------
_85;	ADD L
;----------------------------------------------------------------------------
	opADDL gb_hl
;----------------------------------------------------------------------------
_86;	ADD (HL)
;----------------------------------------------------------------------------
	readmemHL
	opADDb
;----------------------------------------------------------------------------
_87;	ADD A
;----------------------------------------------------------------------------
	opADDA
;----------------------------------------------------------------------------
_88;	ADC B
;----------------------------------------------------------------------------
	opADCH gb_bc
;----------------------------------------------------------------------------
_89;	ADC C
;----------------------------------------------------------------------------
	opADCL gb_bc
;----------------------------------------------------------------------------
_8A;	ADC D
;----------------------------------------------------------------------------
	opADCH gb_de
;----------------------------------------------------------------------------
_8B;	ADC E
;----------------------------------------------------------------------------
	opADCL gb_de
;----------------------------------------------------------------------------
_8C;	ADC H
;----------------------------------------------------------------------------
	opADCH gb_hl
;----------------------------------------------------------------------------
_8D;	ADC L
;----------------------------------------------------------------------------
	opADCL gb_hl
;----------------------------------------------------------------------------
_8E;	ADC (HL)
;----------------------------------------------------------------------------
	readmemHL
	opADCb
;----------------------------------------------------------------------------
_8F;	ADC A
;----------------------------------------------------------------------------
	opADCA
;----------------------------------------------------------------------------
_90;	SUB B
;----------------------------------------------------------------------------
	opSUBH gb_bc
;----------------------------------------------------------------------------
_91;	SUB C
;----------------------------------------------------------------------------
	opSUBL gb_bc
;----------------------------------------------------------------------------
_92;	SUB D
;----------------------------------------------------------------------------
	opSUBH gb_de
;----------------------------------------------------------------------------
_93;	SUB E
;----------------------------------------------------------------------------
	opSUBL gb_de
;----------------------------------------------------------------------------
_94;	SUB H
;----------------------------------------------------------------------------
	opSUBH gb_hl
;----------------------------------------------------------------------------
_95;	SUB L
;----------------------------------------------------------------------------
	opSUBL gb_hl
;----------------------------------------------------------------------------
_96;	SUB (HL)
;----------------------------------------------------------------------------
	readmemHL
	opSUBb
;----------------------------------------------------------------------------
_97;	SUB A
;----------------------------------------------------------------------------
	opSUBA
;----------------------------------------------------------------------------
_98;	SBC B
;----------------------------------------------------------------------------
	opSBCH gb_bc
;----------------------------------------------------------------------------
_99;	SBC C
;----------------------------------------------------------------------------
	opSBCL gb_bc
;----------------------------------------------------------------------------
_9A;	SBC D
;----------------------------------------------------------------------------
	opSBCH gb_de
;----------------------------------------------------------------------------
_9B;	SBC E
;----------------------------------------------------------------------------
	opSBCL gb_de
;----------------------------------------------------------------------------
_9C;	SBC H
;----------------------------------------------------------------------------
	opSBCH gb_hl
;----------------------------------------------------------------------------
_9D;	SBC L
;----------------------------------------------------------------------------
	opSBCL gb_hl
;----------------------------------------------------------------------------
_9E;	SBC (HL)
;----------------------------------------------------------------------------
	readmemHL
	opSBCb
;----------------------------------------------------------------------------
_9F;	SBC A
;----------------------------------------------------------------------------
	opSBCA
;----------------------------------------------------------------------------
_A0;	AND B
;----------------------------------------------------------------------------
	opANDH gb_bc
;----------------------------------------------------------------------------
_A1;	AND C
;----------------------------------------------------------------------------
	opANDL gb_bc
;----------------------------------------------------------------------------
_A2;	AND D
;----------------------------------------------------------------------------
	opANDH gb_de
;----------------------------------------------------------------------------
_A3;	AND E
;----------------------------------------------------------------------------
	opANDL gb_de
;----------------------------------------------------------------------------
_A4;	AND H
;----------------------------------------------------------------------------
	opANDH gb_hl
;----------------------------------------------------------------------------
_A5;	AND L
;----------------------------------------------------------------------------
	opANDL gb_hl
;----------------------------------------------------------------------------
_A6;	AND (HL)
;----------------------------------------------------------------------------
	readmemHL
	opANDb
;----------------------------------------------------------------------------
_A7;	AND A
;----------------------------------------------------------------------------
	opANDA
;----------------------------------------------------------------------------
_A8;	XOR B
;----------------------------------------------------------------------------
	opXORH gb_bc
;----------------------------------------------------------------------------
_A9;	XOR C
;----------------------------------------------------------------------------
	opXORL gb_bc
;----------------------------------------------------------------------------
_AA;	XOR D
;----------------------------------------------------------------------------
	opXORH gb_de
;----------------------------------------------------------------------------
_AB;	XOR E
;----------------------------------------------------------------------------
	opXORL gb_de
;----------------------------------------------------------------------------
_AC;	XOR H
;----------------------------------------------------------------------------
	opXORH gb_hl
;----------------------------------------------------------------------------
_AD;	XOR L
;----------------------------------------------------------------------------
	opXORL gb_hl
;----------------------------------------------------------------------------
_AE;	XOR (HL)
;----------------------------------------------------------------------------
	readmemHL
	opXORb
;----------------------------------------------------------------------------
_AF;	XOR A
;----------------------------------------------------------------------------
	opXORA
;----------------------------------------------------------------------------
_B0;	OR B
;----------------------------------------------------------------------------
	opORH gb_bc
;----------------------------------------------------------------------------
_B1;	OR C
;----------------------------------------------------------------------------
	opORL gb_bc
;----------------------------------------------------------------------------
_B2;	OR D
;----------------------------------------------------------------------------
	opORH gb_de
;----------------------------------------------------------------------------
_B3;	OR E
;----------------------------------------------------------------------------
	opORL gb_de
;----------------------------------------------------------------------------
_B4;	OR H
;----------------------------------------------------------------------------
	opORH gb_hl
;----------------------------------------------------------------------------
_B5;	OR L
;----------------------------------------------------------------------------
	opORL gb_hl
;----------------------------------------------------------------------------
_B6;	OR (HL)
;----------------------------------------------------------------------------
	readmemHL
	opORb
;----------------------------------------------------------------------------
_B7;	OR A
;----------------------------------------------------------------------------
	opORA
;----------------------------------------------------------------------------
_B8;	CP B
;----------------------------------------------------------------------------
	opCPH gb_bc
;----------------------------------------------------------------------------
_B9;	CP C
;----------------------------------------------------------------------------
	opCPL gb_bc
;----------------------------------------------------------------------------
_BA;	CP D
;----------------------------------------------------------------------------
	opCPH gb_de
;----------------------------------------------------------------------------
_BB;	CP E
;----------------------------------------------------------------------------
	opCPL gb_de
;----------------------------------------------------------------------------
_BC;	CP H
;----------------------------------------------------------------------------
	opCPH gb_hl
;----------------------------------------------------------------------------
_BD;	CP L
;----------------------------------------------------------------------------
	opCPL gb_hl
;----------------------------------------------------------------------------
_BE;	CP (HL)
;----------------------------------------------------------------------------
	readmemHL
	opCPb
;----------------------------------------------------------------------------
_BF;	CP A
;----------------------------------------------------------------------------
	opCPA
;----------------------------------------------------------------------------
_C0;	RET NZ
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_Z
	beq _C9_
	fetch 8
;----------------------------------------------------------------------------
_C1;	POP BC
;----------------------------------------------------------------------------
	pop16 gb_bc
	mov gb_bc,gb_bc,lsl#16
	fetch 12
;----------------------------------------------------------------------------
_C2;	JP NZ,$nnnn
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_Z
	beq _C3
	add gb_pc,gb_pc,#2
	fetch 12
;----------------------------------------------------------------------------
_C3;	JP $nnnn
;----------------------------------------------------------------------------
	ldrb r0,[gb_pc],#1
	ldrb r1,[gb_pc]
	orr gb_pc,r0,r1,lsl#8
	encodePC
	fetch 16
;----------------------------------------------------------------------------
_C4;	CALL NZ,$nnnn
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_Z
	beq _CD
	add gb_pc,gb_pc,#2
	fetch 12
;----------------------------------------------------------------------------
_C5;	PUSH BC
;----------------------------------------------------------------------------
	mov r0,gb_bc,lsr#16
	push16
	fetch 16
;----------------------------------------------------------------------------
_C6;	ADD #nn
;----------------------------------------------------------------------------
	ldrb r0,[gb_pc],#1
	opADDb
;----------------------------------------------------------------------------
_C7;	RST 0x00
_CF;	RST 0x08
_D7;	RST 0x10
_DF;	RST 0x18
_E7;	RST 0x20
_EF;	RST 0x28
_F7;	RST 0x30
_FF;	RST 0x38
;----------------------------------------------------------------------------
	and r1,r0,#0x38
	ldr r0,lastbank
	sub r0,gb_pc,r0
	mov gb_pc,r1
	push16
	encodePC
	fetch 16
;----------------------------------------------------------------------------
_C8;	RET Z
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_Z
	bne _C9_
	fetch 8
;----------------------------------------------------------------------------
_C9_;
	sub cycles,cycles,#4*CYCLE
;----------------------------------------------------------------------------
_C9;	RET
;----------------------------------------------------------------------------
	pop16 gb_pc
	encodePC
	fetch 16
;----------------------------------------------------------------------------
_CA;	JP Z,$nnnn
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_Z
	bne _C3
	add gb_pc,gb_pc,#2
	fetch 12
;----------------------------------------------------------------------------
_CC;	CALL Z,$nnnn
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_Z
	bne _CD
	add gb_pc,gb_pc,#2
	fetch 12
;----------------------------------------------------------------------------
_CD;	CALL $nnnn
;----------------------------------------------------------------------------
	ldrb r1,[gb_pc],#1
	ldrb r2,[gb_pc],#1
	ldr r0,lastbank
	sub r0,gb_pc,r0
	orr gb_pc,r1,r2,lsl#8
	push16
	encodePC
	fetch 24
;----------------------------------------------------------------------------
_CE;	ADC #nn
;----------------------------------------------------------------------------
	ldrb r0,[gb_pc],#1
	opADCb
;----------------------------------------------------------------------------
_D0;	RET NC
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_C
	beq _C9_
	fetch 8
;----------------------------------------------------------------------------
_D1;	POP DE
;----------------------------------------------------------------------------
	pop16 gb_de
	mov gb_de,gb_de,lsl#16
	fetch 12
;----------------------------------------------------------------------------
_D2;	JP NC,$nnnn
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_C
	beq _C3
	add gb_pc,gb_pc,#2
	fetch 12
;----------------------------------------------------------------------------
_D4;	CALL NC,$nnnn
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_C
	beq _CD
	add gb_pc,gb_pc,#2
	fetch 12
;----------------------------------------------------------------------------
_D5;	PUSH DE
;----------------------------------------------------------------------------
	mov r0,gb_de,lsr#16
	push16
	fetch 16
;----------------------------------------------------------------------------
_D6;	SUB #nn
;----------------------------------------------------------------------------
	ldrb r0,[gb_pc],#1
	opSUBb
;----------------------------------------------------------------------------
_D8;	RET C
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_C
	bne _C9_
	fetch 8
;----------------------------------------------------------------------------
;_D9;	RETI		move to _FB
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
_DA;	JP C,$nnnn
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_C
	bne _C3
	add gb_pc,gb_pc,#2
	fetch 12
;----------------------------------------------------------------------------
_DC;	CALL C,$nnnn
;----------------------------------------------------------------------------
	tst gb_flg,#PSR_C
	bne _CD
	add gb_pc,gb_pc,#2
	fetch 12
;----------------------------------------------------------------------------
_DE;	SBC #nn
;----------------------------------------------------------------------------
	ldrb r0,[gb_pc],#1
	opSBCb
;----------------------------------------------------------------------------
_E0;	LD ($FF00+nn),A
;----------------------------------------------------------------------------
	ldrb r2,[gb_pc],#1
	mov r0,gb_a,lsr#24
	bl IO_High_W
	fetch 12
;----------------------------------------------------------------------------
_E1;	POP HL
;----------------------------------------------------------------------------
	pop16 gb_hl
	mov gb_hl,gb_hl,lsl#16
	fetch 12
;----------------------------------------------------------------------------
_E2;	LD ($FF00+C),A
;----------------------------------------------------------------------------
	mov r2,gb_bc,lsr#16
	and r2,r2,#0xFF
	mov r0,gb_a,lsr#24
	bl IO_High_W
	fetch 8
;----------------------------------------------------------------------------
_E5;	PUSH HL
;----------------------------------------------------------------------------
	mov r0,gb_hl,lsr#16
	push16
	fetch 16
;----------------------------------------------------------------------------
_E6;	AND #nn
;----------------------------------------------------------------------------
	ldrb r0,[gb_pc],#1
	opANDb
;----------------------------------------------------------------------------
_E8;	ADD SP,dd
;----------------------------------------------------------------------------
	ldrsb r0,[gb_pc],#1
	ldr r2,gb_sp
	eor r1,r2,r0,lsl#16		;prepare for h check.
	adds r2,r2,r0,lsl#16
	str r2,gb_sp
	eor gb_flg,r1,r2
	and gb_flg,gb_flg,#PSR_h
	orrcs gb_flg,gb_flg,#PSR_C
	fetch 12
;----------------------------------------------------------------------------
_E9;	JP HL
;----------------------------------------------------------------------------
	mov gb_pc,gb_hl,lsr#16
	encodePC
	fetch 4
;----------------------------------------------------------------------------
_EA;	LD (nnnn),A	write A to (nnnn)
;----------------------------------------------------------------------------
	ldrb addy,[gb_pc],#1
	ldrb r0,[gb_pc],#1
	orr addy,addy,r0,lsl#8
	mov r0,gb_a,lsr#24
	writemem
	fetch 16
;----------------------------------------------------------------------------
_EE;	XOR #nn
;----------------------------------------------------------------------------
	ldrb r0,[gb_pc],#1
	opXORb
;----------------------------------------------------------------------------
_F0;	LD A,($FF00+nn)
;----------------------------------------------------------------------------
	ldrb r2,[gb_pc],#1
	bl IO_High_R
	mov gb_a,r0,lsl#24
	fetch 12
;----------------------------------------------------------------------------
_F1;	POP AF
;----------------------------------------------------------------------------
	popAF
	decodeFLG
	fetch 12
;----------------------------------------------------------------------------
_F2;	LD A,($FF00+C)
;----------------------------------------------------------------------------
	mov r2,gb_bc,lsr#16
	and r2,r2,#0xFF
	bl IO_High_R
	mov gb_a,r0,lsl#24
	fetch 8
;----------------------------------------------------------------------------
_F3;	DI, disable interrupt
;----------------------------------------------------------------------------
	mov r0,#0
	strb r0,gb_ime
	fetch 4
;----------------------------------------------------------------------------
_F5;	PUSH AF
;----------------------------------------------------------------------------
	encodeFLG
	orr r0,r0,gb_a,lsr#16
	push16
	fetch 16
;----------------------------------------------------------------------------
_F6;	OR #nn
;----------------------------------------------------------------------------
	ldrb r0,[gb_pc],#1
	opORb
;----------------------------------------------------------------------------
_F8;	LD HL,SP+dd
;----------------------------------------------------------------------------
	ldrsb r0,[gb_pc],#1
	ldr r2,gb_sp
	eor r1,r2,r0,lsl#16
	adds gb_hl,r2,r0,lsl#16
	eor gb_flg,r1,gb_hl
	and gb_flg,gb_flg,#PSR_h
	orrcs gb_flg,gb_flg,#PSR_C
	fetch 12
;----------------------------------------------------------------------------
_F9;	LD SP,HL
;----------------------------------------------------------------------------
	str gb_hl,gb_sp
	fetch 8
;----------------------------------------------------------------------------
_FA;	LD A,(nnnn)	load A from (nnnn)
;----------------------------------------------------------------------------
	ldrb addy,[gb_pc],#1
	ldrb r0,[gb_pc],#1
	orr addy,addy,r0,lsl#8
	readmem
	mov gb_a,r0,lsl#24
	fetch 16
;----------------------------------------------------------------------------
_D9;	RETI, return and enable interrupt
;----------------------------------------------------------------------------
	pop16 gb_pc
	encodePC
	sub cycles,cycles,#12*CYCLE		;total of 16 cycles
;----------------------------------------------------------------------------
_FB;	EI, enable interrupt
;----------------------------------------------------------------------------
	mov r0,#1
	strb r0,gb_ime
	sub cycles,cycles,#4*CYCLE
	b checkIRQ
;----------------------------------------------------------------------------
_FE;	CP #nn
;----------------------------------------------------------------------------
	ldrb r0,[gb_pc],#1
	opCPb
;----------------------------------------------------------------------------
_CB;	Extensions
;----------------------------------------------------------------------------
	ldrb r0,[gb_pc],#1
	ldr pc,[pc,r0,lsl#2]
	DCD 0
;----------------------------------------------------------------------------
cb_table
	DCD _CB00,_CB01,_CB02,_CB03,_CB04,_CB05,_CB06,_CB07,_CB08,_CB09,_CB0A,_CB0B,_CB0C,_CB0D,_CB0E,_CB0F
	DCD _CB10,_CB11,_CB12,_CB13,_CB14,_CB15,_CB16,_CB17,_CB18,_CB19,_CB1A,_CB1B,_CB1C,_CB1D,_CB1E,_CB1F
	DCD _CB20,_CB21,_CB22,_CB23,_CB24,_CB25,_CB26,_CB27,_CB28,_CB29,_CB2A,_CB2B,_CB2C,_CB2D,_CB2E,_CB2F
	DCD _CB30,_CB31,_CB32,_CB33,_CB34,_CB35,_CB36,_CB37,_CB38,_CB39,_CB3A,_CB3B,_CB3C,_CB3D,_CB3E,_CB3F
	DCD _CB40,_CB41,_CB42,_CB43,_CB44,_CB45,_CB46,_CB47,_CB40,_CB41,_CB42,_CB43,_CB44,_CB45,_CB46,_CB47
	DCD _CB40,_CB41,_CB42,_CB43,_CB44,_CB45,_CB46,_CB47,_CB40,_CB41,_CB42,_CB43,_CB44,_CB45,_CB46,_CB47
	DCD _CB40,_CB41,_CB42,_CB43,_CB44,_CB45,_CB46,_CB47,_CB40,_CB41,_CB42,_CB43,_CB44,_CB45,_CB46,_CB47
	DCD _CB40,_CB41,_CB42,_CB43,_CB44,_CB45,_CB76,_CB47,_CB40,_CB41,_CB42,_CB43,_CB44,_CB45,_CB46,_CB47
	DCD _CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CB86,_CB87,_CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CB86,_CB87
	DCD _CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CB86,_CB87,_CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CB86,_CB87
	DCD _CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CB86,_CB87,_CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CB86,_CB87
	DCD _CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CB86,_CB87,_CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CB86,_CB87
	DCD _CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBC6,_CBC7,_CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBC6,_CBC7
	DCD _CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBC6,_CBC7,_CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBC6,_CBC7
	DCD _CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBC6,_CBC7,_CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBC6,_CBC7
	DCD _CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBC6,_CBC7,_CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBC6,_CBC7
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
_CB46;		BIT x,(HL)	, actually CB-46,4E,56,5E,66,6E & 7E
;------------------------------------------------------------------------------
	readmemHL
	mov r2,r0,lsl#16
	ldrb r0,[gb_pc,#-1]
	opBITL r2
	fetch 12
;----------------------------------------------------------------------------
_CB47;		BIT x,A		, actually CB-47,4F,57,5F,67,6F,77 & 7F
;----------------------------------------------------------------------------
	opBITH gb_a
	fetch 8
;------------------------------------------------------------------------------
_CB76;		BIT 6,(HL)
;------------------------------------------------------------------------------
	readmemHL
	and gb_flg,gb_flg,#PSR_C	;keep C
	orr gb_flg,gb_flg,#PSR_h	;set h
	tst r0,#0x40
	orreq gb_flg,gb_flg,#PSR_Z	;Z
	fetch 12
;------------------------------------------------------------------------------


;----------------------------------------------------------------------------
run	;r0=0 to return after frame
;----------------------------------------------------------------------------
	mov r1,#0
	strb r1,novblankwait

	str r0,dontstop
	tst r0,#1
	stmeqfd sp!,{gb_flg-gb_pc,globalptr,gb_zpage,lr}

	ldr globalptr,=|wram_globals0$$Base|
	ldr gb_zpage,=XGB_RAM
	b line0x
;----------------------------------------------------------------------------
;cycles ran out
;----------------------------------------------------------------------------
line0
	adr r2,cpuregs
	stmia r2,{gb_flg-gb_pc}	;save 6502 state
waitformulti
	ldr r1,=REG_P1		;refresh input every frame
	ldrh r0,[r1]
		eor r0,r0,#0xff
		eor r0,r0,#0x300	;r0=button state (raw)
	ldr r1,AGBjoypad
	eor r1,r1,r0
	and r1,r1,r0		;r1=button state (0->1)
	str r0,AGBjoypad

	ldr r2,dontstop
	cmp r2,#0
	ldmeqfd sp!,{gb_flg-gb_pc,globalptr,gb_zpage,lr}	;exit here if doing single frame:
	bxeq lr							;return to rommenu()

	;----anything from here til line0x won't get executed while rom menu is active---

	mov r2,#REG_BASE
	mov r3,#0x0110				;was 0x0310
	strh r3,[r2,#REG_BLDCNT]	;stop darkened screen,OBJ blend to BG0/1
	mov r3,#0x1000				;BG0/1=16, OBJ=0
	strh r3,[r2,#REG_BLDALPHA]	;Alpha values

	adr lr,line0x		;return here after doing L/R + SEL/START

	tst r1,#0x300		;if L or R was pressed
	tstne r0,#0x100
	tstne r0,#0x200		;and both L+R are held..
	ldrne r1,=ui
	bxne r1			;do menu


	ands r3,r0,#0x300		;if either L or R is pressed (not both)
	eornes r3,r3,#0x300
	bicne r0,r0,#0x0c		;	hide sel,start from NES
	str r0,XGBjoypad
	beq line0x		;skip ahead if neither or both are pressed

;	tst r0,#0x200
;	tstne r1,#4		;L+SEL for BG adjust
;	ldrne r2,adjustblend
;	addne r2,r2,#1
;	strne r2,adjustblend

	tst r0,#0x200		;L?
	tstne r1,#8		;START?
	ldrb r2,novblankwait	;0=Normal, 1=No wait, 2=Slomo
	addne r2,r2,#1
	cmp r2,#3
	moveq r2,#0
	strb r2,novblankwait

	tst r0,#0x100		;R?
	tstne r1,#8		;START:
	ldrne r1,=quickload
	bxne r1

	tst r0,#0x100		;R?
	tstne r1,#4		;SELECT:
	ldrne r1,=quicksave
	bxne r1
line0x
	bl refreshNESjoypads	;Z=1 if communication ok
	bne waitformulti	;waiting on other GBA..

	ldr r0,AGBjoypad
	ldr r2,fiveminutes		;sleep after 5/10/30 minutes of inactivity
	cmp r0,#0				;(left out of the loop so waiting on multi-link
	ldrne r2,sleeptime		;doesn't accelerate time)
	subs r2,r2,#1
	str r2,fiveminutes
	bleq suspend

	mov r1,#0
	str r1,scanline		;reset scanline count
	bl newframe		;display update


 [ BUILD <> "DEBUG"
	ldrb r4,novblankwait
	teq r4,#1
	beq l03
l01
	mov r0,#0				;don't wait if not necessary
	mov r1,#1				;VBL wait
	swi 0x040000			; Turn of CPU until IRQ if not too late allready.
	teq r4,#2				;Check for slomo
	moveq r4,#0
	beq l01
l03
 ]
	ldr r0,fpsvalue
	add r0,r0,#1
	str r0,fpsvalue

	adr r0,cpuregs
	ldmia r0,{gb_flg-gb_pc}	;restore GB-Z80 state

;	ldrb r1,lcdctrl		;not liked by SML.
;	tst r1,#0x80
	ldrb r0,lcdstat		;
	and r0,r0,#0x78		;reset lcd mode flags (vblank/hblank/oam/lcd)
	strb r0,lcdstat		;

	ldr r0,cyclesperscanline
	add cycles,cycles,r0
	adr r0,line1_to_71
	str r0,nexttimeout
	mov r1,#0		;Scanline

	ldr pc,scanlinehook
line1_to_71 ;------------------------
	ldr r0,cyclesperscanline
	add cycles,cycles,r0

	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline
	cmp r1,#71
	ldrmi pc,scanlinehook
;--------------------------------------------- between 71 and 72

	ldrb r0,lcdctrl
	strb r0,lcdctrl0frame		;Chase HQ likes this

	adr addy,line72_to_143
	str addy,nexttimeout
	ldr pc,scanlinehook
line72_to_143 ;------------------------
	ldr r0,cyclesperscanline
	add cycles,cycles,r0

	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline
	cmp r1,#143
	ldrmi pc,scanlinehook

	adr addy,line144
	str addy,nexttimeout
	ldr pc,scanlinehook
line144 ;------------------------


 [ DEBUG
	mov r1,#REG_BASE			;darken screen during GB vblank
	mov r0,#0x00f1
	strh r0,[r1,#REG_BLDCNT]
	ldrh r0,[r1,#REG_VCOUNT]
	mov r1,#19
	bl debug_
 ]
	ldrb r0,lcdctrl		;LCD turned on?
	tst r0,#0x80
	beq novbirq

	ldrb r0,lcdstat		;vbl flag
	and r0,r0,#0x78
	orr r0,r0,#0x01
	strb r0,lcdstat		;vbl flag

	ldrb r0,gb_if
	orr r0,r0,#0x01		;1=VBL
	strb r0,gb_if
novbirq
	mov r0,#24*CYCLE
	add cycles,cycles,r0

	mov r1,#144
	str r1,scanline

	adr addy,VBL_Hook
	str addy,nexttimeout
	b _GO
VBL_Hook
	ldr r0,cyclesperscanline
	sub r0,r0,#24*CYCLE
	add cycles,cycles,r0

	adr addy,line145_to_end
	str addy,nexttimeout
	ldr pc,scanlinehook
line145_to_end ;------------------------
	ldr r0,cyclesperscanline
	add cycles,cycles,r0

	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline
	cmp r1,#153				;last scanline
	ldrmi pc,scanlinehook

	adr addy,line0
	str addy,nexttimeout
	ldr r0,frame
	add r0,r0,#1
	str r0,frame
	ldr pc,scanlinehook

;----------------------------------------------------------
default_scanlinehook
checkScanlineIRQ
	;screen turned on?  (not sure if this is correct)
	ldrb r2,lcdctrl
	tst r2,#0x80
	beq noScanlineIRQ
	
	ldrb r2,lcdstat
	and r0,r2,#0x09		;LCD stat HBlank IRQ/VBL.
	cmp r0,#0x08		;LCD stat HBlank IRQ.
	beq ScanlineIRQ
	ldr r1,scanline
	ldrb r0,lcdyc
	cmp r0,r1
	bne noScanlineIRQ
	tst r2,#0x40		;LCD stat LYC IRQ.
	beq noScanlineIRQ
ScanlineIRQ
	ldrb r0,gb_if
	orr r0,r0,#0x02		;2=LCD STAT
	strb r0,gb_if
noScanlineIRQ
;------------------

;------------------
checkTimerIRQ
	ldrb r2,doubletimer
	tst r2,#0x01
	ldrneb r2,doublespeed
	tstne r2,#0x80

	ldr r2,cyclesperscanline
	movne r2,r2,lsl#1
	
	ldr r0,dividereg
	add r0,r0,r2,lsl#12		;256th cycles.
	str r0,dividereg

	ldrb r1,timerctrl
	tst r1,#0x4
	beq noTimer
	ands r1,r1,#3
	moveq r1,#4
	mov r0,#18
	sub r1,r0,r1,lsl#1
	ldr r0,timercounter
	adds r0,r0,r2,lsl r1
	bcc noTimerIRQ
	ldrb r0,gb_if
	orr r0,r0,#0x04		;4=Timer
	strb r0,gb_if
	ldrb r0,timermodulo
	mov r0,r0,lsl#24
noTimerIRQ
	str r0,timercounter
noTimer
	ldrb r1,gb_if
	tst r1,#0x08			;Serial
	ldrneb r0,stctrl
	andne r0,r0,#0x7F		;Clear Serial Transfer flag.
	strneb r0,stctrl
;----------------------------------------------------------
checkMasterIRQ
;----------------------------------------------------------
	ldrb r2,gb_ime
	tst r2,#1
	beq _GO
;----------------------------------------------------------
checkIRQ
;----------------------------------------------------------
	ldrb r0,gb_ie
	ldrb r1,gb_if
	ands r0,r0,r1
	beq _GO
;----------------------------------------------------------
irqGBZ80
;----------------------------------------------------------
	ldrb r2,[gb_pc]
	cmp r2,#0x76			;Check if we're doing Halt.
;	cmpne r2,#0x10                  ;or STOP
	addeq gb_pc,gb_pc,#1	;get out of HALT
	mov r2,#0				;disable IRQ
	strb r2,gb_ime

	tst r0,#0x01			;VBlank
	movne r2,#0x40
	bicne r1,r1,#0x01		;clear the IRQ flag
	bne doIRQ

	tst r0,#0x02			;LCD Stat
	movne r2,#0x48
	bicne r1,r1,#0x02		;clear the  IRQ flag
	bne doIRQ

	tst r0,#0x04			;Timer
	movne r2,#0x50
	bicne r1,r1,#0x04		;clear the  IRQ flag
	bne doIRQ

	tst r0,#0x08			;Serial
	movne r2,#0x58
	bicne r1,r1,#0x08		;clear the  IRQ flag
	bne doIRQ

	tst r0,#0x10			;Joypad
	movne r2,#0x60
	bicne r1,r1,#0x10		;clear the  IRQ flag
	bne doIRQ

	and r1,r1,#0x1f			;unknown IRQ?
	mov r2,#0x40
doIRQ
	strb r1,gb_if
	ldr r0,lastbank
	sub r0,gb_pc,r0
	mov gb_pc,r2			;get IRQ vector

	push16					;save PC
	encodePC

	fetch 24
;----------------------------------------------------------------------------
fiveminutes DCD 5*60*60
sleeptime DCD 5*60*60
dontstop DCD 0
novblankwait DCB 0
request_gb_type DCB 2
;----------------------------------------------------------------------------
	AREA rom_code, CODE, READONLY

;----------------------------------------------------------------------------
_CB00;		RLC B
;----------------------------------------------------------------------------
	opRLCH gb_bc
;----------------------------------------------------------------------------
_CB01;		RLC C
;----------------------------------------------------------------------------
	opRLCL gb_bc
;----------------------------------------------------------------------------
_CB02;		RLC D
;----------------------------------------------------------------------------
	opRLCH gb_de
;----------------------------------------------------------------------------
_CB03;		RLC E
;----------------------------------------------------------------------------
	opRLCL gb_de
;----------------------------------------------------------------------------
_CB04;		RLC H
;----------------------------------------------------------------------------
	opRLCH gb_hl
;----------------------------------------------------------------------------
_CB05;		RLC L
;----------------------------------------------------------------------------
	opRLCL gb_hl
;----------------------------------------------------------------------------
_CB06;		RLC (HL)
;----------------------------------------------------------------------------
	readmemHL
	opRLCb
	writemem
	fetch 16
;----------------------------------------------------------------------------
_CB07;		RLC A
;----------------------------------------------------------------------------
	opRLC gb_a
	fetch 8
;----------------------------------------------------------------------------
_CB08;		RRC B
;----------------------------------------------------------------------------
	opRRCH gb_bc
;----------------------------------------------------------------------------
_CB09;		RRC C
;----------------------------------------------------------------------------
	opRRCL gb_bc
;----------------------------------------------------------------------------
_CB0A;		RRC D
;----------------------------------------------------------------------------
	opRRCH gb_de
;----------------------------------------------------------------------------
_CB0B;		RRC E
;----------------------------------------------------------------------------
	opRRCL gb_de
;----------------------------------------------------------------------------
_CB0C;		RRC H
;----------------------------------------------------------------------------
	opRRCH gb_hl
;----------------------------------------------------------------------------
_CB0D;		RRC L
;----------------------------------------------------------------------------
	opRRCL gb_hl
;----------------------------------------------------------------------------
_CB0E;		RRC (HL)
;----------------------------------------------------------------------------
	readmemHL
	opRRCb
	writemem
	fetch 16
;----------------------------------------------------------------------------
_CB0F;		RRC A
;----------------------------------------------------------------------------
	opRRCA
;----------------------------------------------------------------------------
_CB10;		RL B
;----------------------------------------------------------------------------
	opRLH gb_bc
;----------------------------------------------------------------------------
_CB11;		RL C
;----------------------------------------------------------------------------
	opRLL gb_bc
;----------------------------------------------------------------------------
_CB12;		RL D
;----------------------------------------------------------------------------
	opRLH gb_de
;----------------------------------------------------------------------------
_CB13;		RL E
;----------------------------------------------------------------------------
	opRLL gb_de
;----------------------------------------------------------------------------
_CB14;		RL H
;----------------------------------------------------------------------------
	opRLH gb_hl
;----------------------------------------------------------------------------
_CB15;		RL L
;----------------------------------------------------------------------------
	opRLL gb_hl
;----------------------------------------------------------------------------
_CB16;		RL (HL)
;----------------------------------------------------------------------------
	readmemHL
	opRLb
	writemem
	fetch 16
;----------------------------------------------------------------------------
_CB17;		RL A
;----------------------------------------------------------------------------
	opRL gb_a
	fetch 8
;----------------------------------------------------------------------------
_CB18;		RR B
;----------------------------------------------------------------------------
	opRRH gb_bc
;----------------------------------------------------------------------------
_CB19;		RR C
;----------------------------------------------------------------------------
	opRRL gb_bc
;----------------------------------------------------------------------------
_CB1A;		RR D
;----------------------------------------------------------------------------
	opRRH gb_de
;----------------------------------------------------------------------------
_CB1B;		RR E
;----------------------------------------------------------------------------
	opRRL gb_de
;----------------------------------------------------------------------------
_CB1C;		RR H
;----------------------------------------------------------------------------
	opRRH gb_hl
;----------------------------------------------------------------------------
_CB1D;		RR L
;----------------------------------------------------------------------------
	opRRL gb_hl
;----------------------------------------------------------------------------
_CB1E;		RR (HL)
;----------------------------------------------------------------------------
	readmemHL
	opRRb
	writemem
	fetch 16
;----------------------------------------------------------------------------
_CB1F;		RR A
;----------------------------------------------------------------------------
	opRR gb_a
	fetch 8
;----------------------------------------------------------------------------
_CB20;		SLA B
;----------------------------------------------------------------------------
	opSLAH gb_bc
;----------------------------------------------------------------------------
_CB21;		SLA C
;----------------------------------------------------------------------------
	opSLAL gb_bc
;----------------------------------------------------------------------------
_CB22;		SLA D
;----------------------------------------------------------------------------
	opSLAH gb_de
;----------------------------------------------------------------------------
_CB23;		SLA E
;----------------------------------------------------------------------------
	opSLAL gb_de
;----------------------------------------------------------------------------
_CB24;		SLA H
;----------------------------------------------------------------------------
	opSLAH gb_hl
;----------------------------------------------------------------------------
_CB25;		SLA L
;----------------------------------------------------------------------------
	opSLAL gb_hl
;----------------------------------------------------------------------------
_CB26;		SLA (HL)
;----------------------------------------------------------------------------
	readmemHL
	opSLAb
	writemem
	fetch 16
;----------------------------------------------------------------------------
_CB27;		SLA A
;----------------------------------------------------------------------------
	opSLAA
;----------------------------------------------------------------------------
_CB28;		SRA B
;----------------------------------------------------------------------------
	opSRAH gb_bc
;----------------------------------------------------------------------------
_CB29;		SRA C
;----------------------------------------------------------------------------
	opSRAL gb_bc
;----------------------------------------------------------------------------
_CB2A;		SRA D
;----------------------------------------------------------------------------
	opSRAH gb_de
;----------------------------------------------------------------------------
_CB2B;		SRA E
;----------------------------------------------------------------------------
	opSRAL gb_de
;----------------------------------------------------------------------------
_CB2C;		SRA H
;----------------------------------------------------------------------------
	opSRAH gb_hl
;----------------------------------------------------------------------------
_CB2D;		SRA L
;----------------------------------------------------------------------------
	opSRAL gb_hl
;----------------------------------------------------------------------------
_CB2E;		SRA (HL)
;----------------------------------------------------------------------------
	readmemHL
	opSRAb
	writemem
	fetch 16
;----------------------------------------------------------------------------
_CB2F;		SRA A
;----------------------------------------------------------------------------
	opSRAA
;----------------------------------------------------------------------------
_CB30;		SWAP B
;----------------------------------------------------------------------------
	opSWAPH gb_bc
;----------------------------------------------------------------------------
_CB31;		SWAP C
;----------------------------------------------------------------------------
	opSWAPL gb_bc
;----------------------------------------------------------------------------
_CB32;		SWAP D
;----------------------------------------------------------------------------
	opSWAPH gb_de
;----------------------------------------------------------------------------
_CB33;		SWAP E
;----------------------------------------------------------------------------
	opSWAPL gb_de
;----------------------------------------------------------------------------
_CB34;		SWAP H
;----------------------------------------------------------------------------
	opSWAPH gb_hl
;----------------------------------------------------------------------------
_CB35;		SWAP L
;----------------------------------------------------------------------------
	opSWAPL gb_hl
;----------------------------------------------------------------------------
_CB36;		SWAP (HL)
;----------------------------------------------------------------------------
	readmemHL
	opSWAPb
	writemem
	fetch 16
;----------------------------------------------------------------------------
_CB37;		SWAP A
;----------------------------------------------------------------------------
	opSWAPA
;----------------------------------------------------------------------------
_CB38;		SRL B
;----------------------------------------------------------------------------
	opSRLH gb_bc
;----------------------------------------------------------------------------
_CB39;		SRL C
;----------------------------------------------------------------------------
	opSRLL gb_bc
;----------------------------------------------------------------------------
_CB3A;		SRL D
;----------------------------------------------------------------------------
	opSRLH gb_de
;----------------------------------------------------------------------------
_CB3B;		SRL E
;----------------------------------------------------------------------------
	opSRLL gb_de
;----------------------------------------------------------------------------
_CB3C;		SRL H
;----------------------------------------------------------------------------
	opSRLH gb_hl
;----------------------------------------------------------------------------
_CB3D;		SRL L
;----------------------------------------------------------------------------
	opSRLL gb_hl
;----------------------------------------------------------------------------
_CB3E;		SRL (HL)
;----------------------------------------------------------------------------
	readmemHL
	opSRLx r0,r0,1
	writemem
	fetch 16
;----------------------------------------------------------------------------
_CB3F;		SRL A
;----------------------------------------------------------------------------
	opSRLA
;----------------------------------------------------------------------------
_CB40;		BIT x,B		, actually CB-40,48,50,58,60,68,70 & 78
;----------------------------------------------------------------------------
	opBITH gb_bc
	fetch 8
;----------------------------------------------------------------------------
_CB41;		BIT x,C		, actually CB-41,49,51,59,61,69,71 & 79
;----------------------------------------------------------------------------
	opBITL gb_bc
	fetch 8
;----------------------------------------------------------------------------
_CB42;		BIT x,D		, actually CB-42,4A,52,5A,62,6A,72 & 7A
;----------------------------------------------------------------------------
	opBITH gb_de
	fetch 8
;----------------------------------------------------------------------------
_CB43;		BIT x,E		, actually CB-43,4B,53,5B,63,6B,73 & 7B
;----------------------------------------------------------------------------
	opBITL gb_de
	fetch 8
;----------------------------------------------------------------------------
_CB44;		BIT x,H		, actually CB-44,4C,54,5C,64,6C,74 & 7C
;----------------------------------------------------------------------------
	opBITH gb_hl
	fetch 8
;----------------------------------------------------------------------------
_CB45;		BIT x,L		, actually CB-45,4D,55,5D,65,6D,75 & 7D
;----------------------------------------------------------------------------
	opBITL gb_hl
	fetch 8
;----------------------------------------------------------------------------
_CB80;		RES x,B		, actually CB-80,88,90,98,A0,A8,B0 & B8
;----------------------------------------------------------------------------
	opRESH gb_bc
	fetch 8
;----------------------------------------------------------------------------
_CB81;		RES x,C		, actually CB-81,89,81,89,A1,A9,B1 & B9
;----------------------------------------------------------------------------
	opRESL gb_bc
	fetch 8
;----------------------------------------------------------------------------
_CB82;		RES x,D		, actually CB-82,8A,92,9A,A2,AA,B2 & BA
;----------------------------------------------------------------------------
	opRESH gb_de
	fetch 8
;----------------------------------------------------------------------------
_CB83;		RES x,E		, actually CB-83,8B,93,9B,A3,AB,B3 & BB
;----------------------------------------------------------------------------
	opRESL gb_de
	fetch 8
;----------------------------------------------------------------------------
_CB84;		RES x,H		, actually CB-84,8C,94,9C,A4,AC,B4 & BC
;----------------------------------------------------------------------------
	opRESH gb_hl
	fetch 8
;----------------------------------------------------------------------------
_CB85;		RES x,L		, actually CB-85,8D,95,9D,A5,AD,B5 & BD
;----------------------------------------------------------------------------
	opRESL gb_hl
	fetch 8
;----------------------------------------------------------------------------
_CB86;		RES x,(HL)	, actually CB-86,8E,96,9E,A6,AE,B6 & BE
;----------------------------------------------------------------------------
	readmemHL
	mov r2,r0,lsl#16
	ldrb r0,[gb_pc,#-1]
	opRESL r2
	mov r0,r2,lsr#16
	writemem
	fetch 16
;----------------------------------------------------------------------------
_CB87;		RES x,A		, actually CB-87,8F,97,9F,A7,AF,B7 & BF
;----------------------------------------------------------------------------
	opRESH gb_a
	fetch 8
;----------------------------------------------------------------------------
_CBC0;		SET x,B		, actually CB-C0,C8,D0,D8,E0,E8,F0 & F8
;----------------------------------------------------------------------------
	opSETH gb_bc
	fetch 8
;----------------------------------------------------------------------------
_CBC1;		SET x,C		, actually CB-C1,C9,D1,D9,E1,E9,F1 & F9
;----------------------------------------------------------------------------
	opSETL gb_bc
	fetch 8
;----------------------------------------------------------------------------
_CBC2;		SET x,D		, actually CB-C2,CA,D2,DA,E2,EA,F2 & FA
;----------------------------------------------------------------------------
	opSETH gb_de
	fetch 8
;----------------------------------------------------------------------------
_CBC3;		SET x,E		, actually CB-C3,CB,D3,DB,E3,EB,F3 & FB
;----------------------------------------------------------------------------
	opSETL gb_de
	fetch 8
;----------------------------------------------------------------------------
_CBC4;		SET x,H		, actually CB-C4,CC,D4,DC,E4,EC,F4 & FC
;----------------------------------------------------------------------------
	opSETH gb_hl
	fetch 8
;----------------------------------------------------------------------------
_CBC5;		SET x,L		, actually CB-C5,CD,D5,DD,E5,ED,F5 & FD
;----------------------------------------------------------------------------
	opSETL gb_hl
	fetch 8
;----------------------------------------------------------------------------
_CBC6;		SET x,(HL)	, actually CB-C6,CE,D6,DE,E6,EE,F6 & FE
;----------------------------------------------------------------------------
	readmemHL
	mov r2,r0,lsl#16
	ldrb r0,[gb_pc,#-1]
	opSETL r2
	mov r0,r2,lsr#16
	writemem
	fetch 16
;----------------------------------------------------------------------------
_CBC7;		SET x,A		, actually CB-C7,CF,D7,DF,E7,EF,F7 & FF
;----------------------------------------------------------------------------
	opSETH gb_a
	fetch 8
;----------------------------------------------------------------------------


speedswitch
	ldrb r0,doublespeed
	bic r0,r0,#0x7F
	eors r0,r0,#0x80
	strb r0,doublespeed
	ldrb r0,doubletimer
	tstne r0,#0x02


;(DMG=456*CYCLE, CGB=912*CYCLE)
	movne r1,#DOUBLE_SPEED
	moveq r1,#SINGLE_SPEED
	str r1,cyclesperscanline
	bx lr

 [ PROFILE
profile_it
	ldr r0,lastbank
	sub r0,gb_pc,r0
;	sub r0,r0,#1
	bic r0,r0,#0x8000
	
	mov r0,r0,lsl#2
	ldr r1,profiler
	ldr r2,[r1,r0]
	add r2,r2,#1
	str r2,[r1,r0]
	bx lr
profile_reset
	ldr r0,profiler
	mov r1,#32768
	mov r2,#0
pr_loop
	str r2,[r0],#4
	subs r1,r1,#1
	bne pr_loop
	bx lr
 ]

	[ SPEEDHACKS
cpuhack_reset
	stmfd sp!,{r0-r7}
	ldr r0,hackflags
	tst r0,#CPUHACK	;load opcode set
	adr r1,normalops
	adrne r1,jmpops
	adr r3,opindex
	mov r4,#3
nr0	ldr r5,[r1,r4,lsl#2]
	ldr r6,[r3,r4,lsl#2]
	str r5,[r6]
	subs r4,r4,#1
	bpl nr0
	ldmfd sp!,{r0-r7}
	bx lr
	]
;----------------------------------------------------------------------------
emu_reset	;called by loadcart (r0-r9 are free to use)
;----------------------------------------------------------------------------
	str lr,[sp,#-4]!

	bl IO_reset
	bl Sound_reset
	bl GFX_reset
;---Speed - normal GB
	ldr r1,=456*CYCLE
	str r1,cyclesperscanline
cpu_reset
;---cpu reset
	[ SPEEDHACKS
	bl cpuhack_reset
	]
 [ PROFILE
	bl profile_reset
 ]
	ldrb r0,gbmode
	cmp r0,#0
	moveq gb_a,#0x01000000	;0x01=Normal GB/SGB, 0xFF=PocketGB/SGB2, 0x11=CGB/AGB.
	ldreq gb_bc,=0x00130000	;Breg->0=Normal,1=AGB
	movne gb_a,#0x11000000	;0x01=Normal GB/SGB, 0xFF=PocketGB/SGB2, 0x11=CGB/AGB.
	ldrne gb_bc,=0x00130000	;Breg->0=Normal,1=AGB
	cmp r0,#2
	ldreq gb_bc,=0x01130000	;Breg->0=Normal,1=AGB
	
	
	moveq gb_de,#0x00d80000
	movne gb_de,#0x00200000	;For Goomba detection, e=0x20
	ldr gb_hl,=0x014d0000
	mov gb_flg,#PSR_Z+PSR_C+PSR_h
	mov r0,#0
	IMPORT _FF70W
	bl _FF70W
	mov r1,#0
	strb r1,doublespeed
	str r1,gb_ime		;disable all IRQ
	str r1,timercounter	;reset timers
	str r1,timermodulo	;reset timers
	ldr r0,=0xfffe0000
	str r0,gb_sp		;SP=FFFE
	mov cycles,#0

	str r1,frame		;frame count reset

	;(clear irq/nmi/res source)...

	mov gb_pc,#0x100
;	mov gb_pc,#0		;for BIOS
	encodePC			;get RESET vector

	adr r0,cpuregs
	stmia r0,{gb_flg-gb_pc}
	ldr pc,[sp],#4

	[ SPEEDHACKS
normalops
	DCD _20,_28,_30,_38
jmpops
	DCD _20x,_28x,_30x,_38x
opindex
	DCD op_table+0x20*4,op_table+0x28*4,op_table+0x30*4,op_table+0x38*4
	]
;----------------------------------------------------------------------------
	AREA wram_globals0, CODE, READWRITE
;----------------------------------------------------------------------------
op_table
	DCD _00,_01,_02,_03,_04,_05,_06,_07,_08,_09,_0A,_0B,_0C,_0D,_0E,_0F
	DCD _10,_11,_12,_13,_14,_15,_16,_17,_18,_19,_1A,_1B,_1C,_1D,_1E,_1F
	DCD _20,_21,_22,_23,_24,_25,_26,_27,_28,_29,_2A,_2B,_2C,_2D,_2E,_2F
	DCD _30,_31,_32,_33,_34,_35,_36,_37,_38,_39,_3A,_3B,_3C,_3D,_3E,_3F
	DCD _40,_41,_42,_43,_44,_45,_46,_47,_48,_49,_4A,_4B,_4C,_4D,_4E,_4F
	DCD _50,_51,_52,_53,_54,_55,_56,_57,_58,_59,_5A,_5B,_5C,_5D,_5E,_5F
	DCD _60,_61,_62,_63,_64,_65,_66,_67,_68,_69,_6A,_6B,_6C,_6D,_6E,_6F
	DCD _70,_71,_72,_73,_74,_75,_76,_77,_78,_79,_7A,_7B,_7C,_7D,_7E,_7F
	DCD _80,_81,_82,_83,_84,_85,_86,_87,_88,_89,_8A,_8B,_8C,_8D,_8E,_8F
	DCD _90,_91,_92,_93,_94,_95,_96,_97,_98,_99,_9A,_9B,_9C,_9D,_9E,_9F
	DCD _A0,_A1,_A2,_A3,_A4,_A5,_A6,_A7,_A8,_A9,_AA,_AB,_AC,_AD,_AE,_AF
	DCD _B0,_B1,_B2,_B3,_B4,_B5,_B6,_B7,_B8,_B9,_BA,_BB,_BC,_BD,_BE,_BF
	DCD _C0,_C1,_C2,_C3,_C4,_C5,_C6,_C7,_C8,_C9,_CA,_CB,_CC,_CD,_CE,_CF
	DCD _D0,_D1,_D2,_xx,_D4,_D5,_D6,_D7,_D8,_D9,_DA,_xx,_DC,_xx,_DE,_DF
	DCD _E0,_E1,_E2,_xx,_xx,_E5,_E6,_E7,_E8,_E9,_EA,_xx,_xx,_ED,_EE,_EF
	DCD _F0,_F1,_F2,_F3,_xx,_F5,_F6,_F7,_F8,_F9,_FA,_FB,_xx,_xx,_FE,_FF
  ;readmem_tbl
g_readmem_tbl
	DCD mem_R00	;$0000	ROM-- Non switchable (in cartridge)
	DCD mem_R00	;$1000	ROM-- Non switchable (in cartridge)
	DCD mem_R20	;$2000	ROM/
	DCD mem_R20	;$3000	ROM/
	DCD mem_R40	;$4000	ROM-- Switchable (in cartridge)
	DCD mem_R40	;$5000	ROM-- Switchable (in cartridge)
	DCD mem_R60	;$6000	ROM/
	DCD mem_R60	;$7000	ROM/
	DCD mem_R80	;$8000	VRAM
	DCD mem_R80	;$9000	VRAM
	DCD mem_RA0	;$A000	ERAM/SRAM (in cartridge)
	DCD mem_RA0	;$B000	ERAM/SRAM (in cartridge)
	DCD mem_RC0	;$C000	WRAM
	DCD mem_RC0_2	;$D000	WRAM
	DCD IO_R	;$E000	IO
	DCD IO_R	;$F000	IO
  ;writemem_tbl
g_writemem_tbl
	DCD void	;$0000  filled in by initmapper.
	DCD void	;$1000  filled in by initmapper.
	DCD void	;$2000    /
	DCD void	;$3000    /
	DCD void	;$4000   /
	DCD void	;$5000   /
	DCD void	;$6000  /
	DCD void	;$7000  /
	DCD vram_W	;$8000
	DCD vram_W	;$9000
	DCD sram_W	;$A000	also RTC?
	DCD sram_W	;$B000	also RTC?
	DCD wram_W	;$C000
	DCD wram_W_2	;$D000
	DCD IO_W	;$E000
	DCD IO_W	;$F000
   ;memmap_tbl
rommap	% 8*4		;$0000-7FFF (rommap only used for savestates)
	DCD 0		;$8000
	DCD 0		;$9000
	DCD 0		;$A000
	DCD 0		;$B000
	DCD 0		;$C000
	DCD 0		;$D000
	DCD 0		;$E000
	DCD 0		;$F000

cpustate
	;group these together for save/loadstate
	% 7*4 ;cpuregs (flg,a,bc,de,hl,cycles,pc)
	DCD 0 ;gb_sp:
	DCB 0 ;gb_ime:	(interrupt master enable)
	DCB 0 ;gb_ie:	(interrupt enable, adr $FFFF)
	DCB 0 ;gb_if:	(interrupt flags, adr $FF0F)
	DCB 0 ;gb_ic:	(interrupt confirm, HALT)
	DCD 0 ;lastbank: last memmap added to PC (used to calculate current PC)

	DCD 0 ;dividereg
	DCD 0 ;timercounter
	DCB 0 ;timermodulo
	DCB 0 ;timerctrl
	DCB 0 ;stctrl
	DCB 0 ;debugstop
	DCD 0 ;nexttimeout:  jump here when cycles runs out
	DCD 0 ;scanlinehook
	DCD 0 ;scanline
frametotal		;let ui.c see frame count for savestates
	DCD 0 ;frame
g_cyclesperscanline
	DCD 0 ;cyclesperscanline (DMG=456*CYCLE, CGB=912*CYCLE)
 [ SPEEDHACKS
num_speedhacks
	DCD 0 ;numspeedhacks
	DCD speedhacks ;speedhacks_p
 ]
 [ PROFILE
	DCD 0x02008000 ;profiler
 ]
	DCB 0 ;rambank
g_doublespeed
	DCB 0 ;doublespeed
gb_mode
	DCB 0 ;gbmode
g_hackflags
	DCB 0 ;hackflags
g_doubletimer
	DCB 1 ;doubletimer
	DCB 0
	DCB 0
	DCB 0
;----------------------------------------------------------------------------
	END

