	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE gfx.h
	INCLUDE cart.h
	INCLUDE z80.h

	EXPORT IO_reset
	EXPORT Z80_IN
	EXPORT Z80_OUT
	EXPORT Z80_IN_C
	EXPORT Z80_OUT_C
	EXPORT joycfg
	EXPORT spriteinit
	EXPORT suspend
	EXPORT refreshEMUjoypads
	EXPORT resetSIO
	EXPORT thumbcall_r1
	EXPORT gettime
	EXPORT Bin2BCD
	EXPORT vbaprint
	EXPORT waitframe
	EXPORT LZ77UnCompVram
	EXPORT CheckGBAVersion


 AREA rom_code, CODE, READONLY ;-- - - - - - - - - - - - - - - - - - - - - -

vbaprint
	swi 0xFF0000		;!!!!!!! Doesn't work on hardware !!!!!!!
	bx lr
LZ77UnCompVram
	swi 0x120000
	bx lr
waitframe
VblWait
	mov r0,#0				;don't wait if not necessary
	mov r1,#1				;VBL wait
	swi 0x040000			; Turn of CPU until VBLIRQ if not too late allready.
	bx lr
CheckGBAVersion
	ldr r0,=0x5AB07A6E		;Fool proofing
	mov r12,#0
	swi 0x0D0000			;GetBIOSChecksum
	ldr r1,=0xABBE687E		;Proto GBA
	cmp r0,r1
	moveq r12,#1
	ldr r1,=0xBAAE187F		;Normal GBA
	cmp r0,r1
	moveq r12,#2
	ldr r1,=0xBAAE1880		;Nintendo DS
	cmp r0,r1
	moveq r12,#4
	mov r0,r12
	bx lr

scaleparms;	   NH     FH     NV     FV
	DCD 0x0000,0x0100,0xff01,0x0150,0xfeb6,OAM_BUFFER1+6,AGB_OAM+774
;----------------------------------------------------------------------------
IO_reset
;----------------------------------------------------------------------------
	adr r6,scaleparms		;set sprite scaling params
	ldmia r6,{r0-r6}

	mov r7,#2
scaleloop
	strh r1,[r5],#8				;buffer1, buffer2
	strh r0,[r5],#8
	strh r0,[r5],#8
	strh r3,[r5],#232
		strh r2,[r5],#8
		strh r0,[r5],#8
		strh r0,[r5],#8
		strh r3,[r5],#232
			strh r1,[r5],#8
			strh r0,[r5],#8
			strh r0,[r5],#8
			strh r4,[r5],#232
				strh r2,[r5],#8
				strh r0,[r5],#8
				strh r0,[r5],#8
				strh r4,[r5],#232
	subs r7,r7,#1
	bne scaleloop


	ldrb r0,emuflags+1
	;..to spriteinit
;----------------------------------------------------------------------------
spriteinit	;build yscale_lookup tbl (called by ui.c) r0=scaletype
;called by ui.c:  void spriteinit(char scaletype) (pass scaletype in r0 because globals ptr isn't set up to read it)
;----------------------------------------------------------------------------
	ldr r3,=YSCALE_LOOKUP
	cmp r0,#SCALED
	bpl si1

;------------------ unscaled
si5
	sub r3,r3,#16
	sub r2,r3,#224-160
	mov r0,#164
si2	strb r0,[r2],#1
	cmp r2,r3
	bne si2

	add r2,r3,#256+16
	mov r0,#-16
si3	strb r0,[r3],#1
	add r0,r0,#1
	cmp r0,#164
	movpl r0,#164
	cmp r2,r3
	bne si3
	bx lr

;------------------ scaled
si1
	sub r3,r3,#240-208
	mov r0,#0x0000c000		;0.75
	ldr r1,=0xffe50000		;-(16)*0.75
si4	mov r2,r1,lsr#16
	strb r2,[r3],#1
	add r1,r1,r0
	cmp r2,#0xe0
	bne si4
	bx lr
;----------------------------------------------------------------------------
suspend	;called from ui.c and z80.s
;----------------------------------------------------------------------------
	mov r3,#REG_BASE

	ldr r1,=REG_P1CNT
	ldr r0,=0xc00c			;interrupt on start+sel
	strh r0,[r3,r1]

	ldrh r1,[r3,#REG_SGCNT_L]
	strh r3,[r3,#REG_SGCNT_L]	;sound off

	ldrh r0,[r3,#REG_DISPCNT]
	orr r0,r0,#0x80
	strh r0,[r3,#REG_DISPCNT]	;LCD off

	swi 0x030000

	ldrh r0,[r3,#REG_DISPCNT]
	bic r0,r0,#0x80
	strh r0,[r3,#REG_DISPCNT]	;LCD on

	strh r1,[r3,#REG_SGCNT_L]	;sound on

	bx lr
;----------------------------------------------------------------------------
gettime	;called from ui.c
;----------------------------------------------------------------------------
	ldr r3,=0x080000c4		;base address for RTC
	mov r1,#1
	strh r1,[r3,#4]			;enable RTC
	mov r1,#7
	strh r1,[r3,#2]			;enable write

	mov r1,#1
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]			;State=Command

	mov r2,#0x65			;r2=Command, YY:MM:DD 00 hh:mm:ss
	mov addy,#8
RTCLoop1
	mov r1,#2
	and r1,r1,r2,lsr#6
	orr r1,r1,#4
	strh r1,[r3]
	mov r1,r2,lsr#6
	orr r1,r1,#5
	strh r1,[r3]
	mov r2,r2,lsl#1
	subs addy,addy,#1
	bne RTCLoop1

	mov r1,#5
	strh r1,[r3,#2]			;enable read
	mov r2,#0
	mov addy,#32
RTCLoop2
	mov r1,#4
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]
	ldrh r1,[r3]
	and r1,r1,#2
	mov r2,r2,lsr#1
	orr r2,r2,r1,lsl#30
	subs addy,addy,#1
	bne RTCLoop2

	mov r0,#0
	mov addy,#24
RTCLoop3
	mov r1,#4
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]
	ldrh r1,[r3]
	and r1,r1,#2
	mov r0,r0,lsr#1
	orr r0,r0,r1,lsl#22
	subs addy,addy,#1
	bne RTCLoop3

	bx lr
;----------------------------------------------------------------------------
Bin2BCD		;called from ui.c
;----------------------------------------------------------------------------
	stmfd sp!,{r4}

	mov r1,#0
	adr r3,BCD_table				;BCD
	ldr r12,=0x11111110				;carry count mask value

Bin2BCD_loop
	ldr r2,[r3],#4					;BCD (read BCD table)
	movs r0,r0,lsr#1				;test bit

	bcc Bin2BCD_loop_check
Bin2BCD_calc
	add r4,r2,r1					;r4 = r2 + r1
	eor r2,r1,r2					;r2 = r1 XOR r2
	eor r2,r4,r2					;r2 = r4 XOR r2
	bic r2,r12,r2					;r2 = 0x11111110 AND NOT r2
	orr r2,r2,r2,lsr#1				;r2 = r2 OR (r2 LSR 1)
	sub r1,r4,r2,lsr#2				;r1 = r4 -  (r2 LSR 2)

Bin2BCD_loop_check
	bne Bin2BCD_loop
	mov r0,r1

	ldmfd sp!,{r4}
	bx lr

BCD_table
	DCD 0x06666667
	DCD 0x06666668
	DCD 0x0666666a
	DCD 0x0666666e
	DCD 0x0666667c
	DCD 0x06666698
	DCD 0x066666ca
	DCD 0x0666678e
	DCD 0x066668bc
	DCD 0x06666b78
	DCD 0x0666768a
	DCD 0x066686ae
	DCD 0x0666a6fc
	DCD 0x0666e7f8
	DCD 0x0667c9ea
	DCD 0x06698dce
	DCD 0x066cbb9c
	DCD 0x067976d8
	DCD 0x068c87aa
	DCD 0x06b8a8ee
	DCD 0x076aebdc
	DCD 0x086fd7b8
	DCD 0x0a7fa96a
	DCD 0x0e9eec6e
	DCD 0x1cddd87c
	DCD 0x39bbaa98
	DCD 0x6d76eeca

;----------------------------------------------------------------------------
resetSIO	;r0=joycfg
;----------------------------------------------------------------------------
	bic r0,r0,#0x0f000000
	str r0,joycfg

	mov r2,#2		;only 2 players.
	mov r1,r0,lsr#29
	cmp r1,#0x6
	moveq r2,#4		;all 4 players
	cmp r1,#0x5
	moveq r2,#3		;3 players.
	str r2,nrplayers

	mov r2,#REG_BASE
	add r2,r2,#0x100

	mov r1,#0
	strh r1,[r2,#REG_RCNT]

	tst r0,#0x80000000
	moveq r1,#0x2000
	movne r1,   #0x6000
	addne r1,r1,#0x0002	;16bit multiplayer, 57600bps
	strh r1,[r2,#REG_SIOCNT]

	bx lr
;----------------------------------------------------------------------------
refreshEMUjoypads	;call every frame
;----------------------------------------------------------------------------

		ldr r4,frame
		movs r0,r4,lsr#2 ;C=frame&2 (autofire alternates every other frame)
	ldr r4,EMUjoypad
	mov r0,r4,lsr#4
		ldr r2,joycfg
		andcs r4,r4,r2
		movcss addy,r4,lsr#10	;L?
		andcs r4,r4,r2,lsr#16
	and r0,r0,#0x0f
	adr r1,rlud2lrud
	ldrb r0,[r1,r0]
	tst r4,#0x2					;B
	orrne r0,r0,#0x10			;Knife
	mov r1,#0
	mov r3,#0
	tst r4,#0x4					;Select
	orrne r3,r3,#0x40			;Coin
	tst r4,#0x8					;Start
	orrne r3,r3,#0x01			;Start
	tst r4,#0x1					;A
	orrne r0,r0,#0x20			;Shoot
	tst r2,#0x20000000			;Player2?
	movne r1,r0
	movne r0,#0
	movne r3,r3,lsl#1

	strb r3,joy0state
	strb r0,joy1state
	strb r1,joy2state
	ands r0,r0,#0		;Z=1
	mov pc,lr

joycfg DCD 0x40ff01ff ;byte0=auto mask, byte1=(saves R), byte2=R auto mask
;bit 31=single/multi, 30,29=1P/2P, 27=(multi) link active, 24=reset signal received
nrplayers DCD 0		;Number of players in multilink.
joySerial DCB 0
joy0state DCB 0
joy1state DCB 0
joy2state DCB 0
rlud2lrud	DCB 0x00,0x01,0x02,0x03, 0x08,0x09,0x0a,0x0b, 0x04,0x05,0x06,0x07, 0x0c,0x0d,0x0e,0x0f

;----------------------------------------------------------------------------
Input0_R		;Coins, Start & Service
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldrb r0,joy0state
	eor r0,r0,#0xFF
	mov pc,lr
;----------------------------------------------------------------------------
Input1_R		;Player1
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldrb r0,joy1state
	eor r0,r0,#0xFF
	mov pc,lr
;----------------------------------------------------------------------------
Input2_R		;Player2
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldrb r0,joy2state
	eor r0,r0,#0xFF
	mov pc,lr
;----------------------------------------------------------------------------
Input3_R
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldrb r0,dipswitch0
	eor r0,r0,#0xFF
	mov pc,lr
;----------------------------------------------------------------------------
Input4_R
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldrb r0,dipswitch1
	eor r0,r0,#0xFF
	mov pc,lr
;----------------------------------------------------------------------------
Input5_R
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldrb r0,dipswitch2
	eor r0,r0,#0xFF
	mov pc,lr

;----------------------------------------------------------------------------
;--------------------------------------------------
	INCLUDE visoly.s
 AREA wram_code1, CODE, READWRITE
;-- - - - - - - - - - - - - - - - - - - - - -

thumbcall_r1 bx r1

;----------------------------------------------------------------------------
Z80_IN_C
;----------------------------------------------------------------------------
	mov addy,z80_bc,lsr#16
;----------------------------------------------------------------------------
Z80_IN
;----------------------------------------------------------------------------
	and r1,addy,#0xFF
	cmp r1,#8
	ldrmi pc,[pc,r1,lsl#2]
;---------------------------
	b empty_IO_R
;io_read_tbl
	DCD Input0_R		;0
	DCD Input1_R		;1
	DCD Input2_R		;2
	DCD Input3_R		;3
	DCD Input4_R		;4
	DCD Input5_R		;5
	DCD empty_IO_R		;6
	DCD Protection_R	;7
;----------------------------------------------------------------------------
Protection_R
;----------------------------------------------------------------------------
	mov r11,r11					;No$GBA breakpoint
	mov r0,z80_de,lsr#24
	mov pc,lr



;----------------------------------------------------------------------------
Z80_OUT_C
;----------------------------------------------------------------------------
	mov addy,z80_bc,lsr#16
;----------------------------------------------------------------------------
Z80_OUT
;----------------------------------------------------------------------------
	and r1,addy,#0xFF
	cmp r1,#0xF
	ldrmi pc,[pc,r1,lsl#2]
;---------------------------
	b empty_IO_R
;io_read_tbl
	DCD empty_W			;0x0, SoundLatch
	DCD BankSwitch_W	;0x1
	DCD empty_W			;0x2
	DCD empty_W			;0x3, CoinLockOut?
	DCD Misc_W			;0x4, Coin, Flip, 2nd CPU reset, VideoControl
	DCD empty_W			;0x5
	DCD WatchDog_W		;0x6
	DCD Protection_W	;0x7
	DCD ScrollX_L		;0x8
	DCD ScrollX_H		;0x9
	DCD ScrollY_L		;0xA
	DCD ScrollY_H		;0xB
	DCD empty_W			;0xC
	DCD SwitchGfxBank_W	;0xD
	DCD ScreenLayout_W	;0xE
;----------------------------------------------------------------------------
BankSwitch_W
;----------------------------------------------------------------------------
	stmfd sp!,{r3,lr}

	and r3,r0,#0xF
	mov r3,r3,lsl#1
	add r1,r3,#4
	mov r0,#0x10
	bl HuMapper_

	add r1,r3,#5
	mov r0,#0x20
	bl HuMapper_

	ldmfd sp!,{r3,pc}
;----------------------------------------------------------------------------
Protection_W
;----------------------------------------------------------------------------
	mov r11,r11					;No$GBA breakpoint
	mov pc,lr

;----------------------------------------------------------------------------
Flip_W
;----------------------------------------------------------------------------
	strb r0,irqControl
	bx lr
;----------------------------------------------------------------------------
SwitchGfxBank_W
;----------------------------------------------------------------------------
	and r0,r0,#3
	eor r0,r0,#3
	strb r0,gfxBank
	bx lr
;----------------------------------------------------------------------------
ScreenLayout_W
;----------------------------------------------------------------------------
	strb r0,screenLayout
	bx lr
;----------------------------------------------------------------------------
WatchDog_W
;----------------------------------------------------------------------------
	bx lr
;----------------------------------------------------------------------------
Misc_W
;----------------------------------------------------------------------------
	tst r0,#1
	ldrne r1,coincounter0
	addne r1,r1,#1
	strne r1,coincounter0
	tst r0,#2
	ldrne r1,coincounter1
	addne r1,r1,#1
	strne r1,coincounter1

	bx lr
;----------------------------------------------------------------------------
	END
