	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE z80mac.h
	INCLUDE z80.h
	INCLUDE io.h
	INCLUDE gfx.h

	IMPORT findrom ;from main.c
	IMPORT pogoshell ;from main.c
	IMPORT pogosize ;from main.c

	EXPORT loadcart
	EXPORT HuMapper_
	EXPORT bg_finish
	EXPORT fg_finish
	EXPORT savestate
	EXPORT loadstate
	EXPORT g_emuflags
	EXPORT romstart
	EXPORT romnum
	EXPORT g_scaling
	EXPORT g_cartflags
	EXPORT g_dipswitch0
	EXPORT g_dipswitch1
	EXPORT g_dipswitch2
	EXPORT g_coin0
	EXPORT g_coin1
;-------------------------------------------------------------------------------
 AREA rom_code, CODE, READONLY
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
loadcart ;called from C:  r0=rom number, r1=emuflags
;-------------------------------------------------------------------------------
	stmfd sp!,{r0-r1,r4-r11,lr}

	ldr r1,=findrom
	bl thumbcall_r1
	add r3,r0,#48		;r0 now points to rom image (including header)

	ldr globalptr,=|wram_globals0$$Base|	;need ptr regs init'd

	ldmfd sp!,{r0-r1}
	str r0,romnumber
	str r1,emuflags

	ldr r1,=pogoshell
	ldrb r1,[r1]
	cmp r1,#0
	addeq r3,r3,#16		;If using rombuilder skip NES header.
						;r3=rombase til end of loadcart so DON'T FUCK IT UP
	ldrne r1,=pogosize
	ldrne r1,[r1]		;Size from Pogoshell
	ldreq r1,[r3,#-32]	;size of rom in bytes (from rombuilder).
	str r3,rombase		;set rom base
	add r0,r3,#0x48000	;0x48000
	str r0,vrombase0	;chr
	add r0,r0,#0x08000
	str r0,vrombase1	;tiles
	add r0,r0,#0x40000
	str r0,vrombase2	;spr


	ldr r4,=MEMMAPTBL_
	ldr r5,=RDMEMTBL_
	ldr r6,=WRMEMTBL_
	ldr r7,=rom_R0
	ldr r8,=rom_W
	mov r0,#0

tbloop1
;	and r1,r0,r2
	add r1,r3,r0,lsl#13
	str r1,[r4,r0,lsl#2]
	str r7,[r5,r0,lsl#2]
	str r8,[r6,r0,lsl#2]
	add r0,r0,#1
	cmp r0,#0x88
	bne tbloop1
resbg
	ldr r7,=empty_R
	ldr r8,=empty_W
tbloop2
	str r3,[r4,r0,lsl#2]
	str r7,[r5,r0,lsl#2]
	str r8,[r6,r0,lsl#2]
	add r0,r0,#1
	cmp r0,#0x100
	bne tbloop2


	ldr r1,=EMU_RAM+0x3000
	ldr r7,=ram_R6
	ldr r8,=ram_W6
	mov r0,#0xF8			;RAM6
	str r1,[r4,r0,lsl#2]	;MemMap
	str r7,[r5,r0,lsl#2]	;RdMem
	str r8,[r6,r0,lsl#2]	;WrMem
	add r1,r1,#0x2000

	ldr r7,=rom_R7
	ldr r8,=ram_W7
	mov r0,#0xF9			;RAM7
	str r1,[r4,r0,lsl#2]	;MemMap
	str r7,[r5,r0,lsl#2]	;RdMem
	str r8,[r6,r0,lsl#2]	;WrMem


	ldr r7,=empty_R
	ldr r8,=empty_W
	mov r0,#0xFF			;IO
	str r7,[r5,r0,lsl#2]	;RdMem
	str r8,[r6,r0,lsl#2]	;WrMem

	ldr r0,=default_scanlinehook
	str r0,scanlinehook

	mov z80_pc,#0			;(eliminates any encodePC errors during mapper*init)
	str z80_pc,lastbank

	adr r4,HuMapData
	mov r5,#0x80
HuDataLoop
	mov r0,r5
	ldrb r1,[r4],#1
	bl HuMapper_
	movs r5,r5,lsr#1
	bne HuDataLoop

	bl GFX_reset
	bl IO_reset
	bl CPU_reset
	ldmfd sp!,{r4-r11,lr}
	bx lr
;-------------------------------------------------------------------------------
HuMapData
	DCB 0xF9,0xF8,0x05,0x04,0x03,0x02,0x01,0x00			;Black Tiger
;	DCB 0xFF,0xF8,0x05,0x04,0x03,0x02,0x01,0x00			;Green Beret
;	DCB 0x07,0x06,0x05,0x04,0x01,0x00,0xFF,0xF8			;Renegade
;	DCB 0x00,0x00,0x00,0xF7,0x00,0x00,0xF8,0xFF			;PC-Engine
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
savestate	;called from ui.c.
;int savestate(void *here): copy state to <here>, return size
;-------------------------------------------------------------------------------
	stmfd sp!,{r4-r6,globalptr,lr}

	ldr globalptr,=|wram_globals0$$Base|

	ldr r2,rombase
	rsb r2,r2,#0				;adjust rom maps,etc so they aren't based on rombase
	bl fixromptrs				;(so savestates are valid after moving roms around)

	ldr r6,=STATEPTR			;r6=where to copy state
;	mov r6,r0					;r6=where to copy state
	mov r0,#0					;r0 holds total size (return value)

	adr r4,savelst				;r4=list of stuff to copy
	mov r3,#(lstend-savelst)/8	;r3=items in list
ss1	ldmia r4!,{r1,r2}			;r1=what to copy, r2=how much to copy
	add r0,r0,r2
ss0	ldr r5,[r1],#4
	str r5,[r6],#4
	subs r2,r2,#4
	bne ss0
	subs r3,r3,#1
	bne ss1

	ldr r2,rombase
	bl fixromptrs

	ldmfd sp!,{r4-r6,globalptr,lr}
	bx lr

savelst	DCD rominfo,8,EMU_RAM,0x4000,cpustate,96,gfxstate,8
lstend

fixromptrs	;add r2 to some things
	ldr r3,lastbank
	add r3,r3,r2
	str r3,lastbank

	ldr r3,cpuregs+6*4	;Z80 PC
	add r3,r3,r2
	str r3,cpuregs+6*4

	mov pc,lr
;-------------------------------------------------------------------------------
loadstate	;called from ui.c
;void loadstate(int rom#,u32 *stateptr)	 (stateptr must be word aligned)
;-------------------------------------------------------------------------------
	stmfd sp!,{r4-r7,globalptr,lr}

	mov r0,#0
	ldr r6,=STATEPTR			;r6=where state is at
;	mov r6,r1		;r6=where state is at
	ldr globalptr,=|wram_globals0$$Base|

	ldr r1,[r6]		;emuflags
	bl loadcart		;cart init

	mov r0,#(lstend-savelst)/8	;read entire state
	adr r4,savelst
ls1	ldmia r4!,{r1,r2}
ls0	ldr r5,[r6],#4
	str r5,[r1],#4
	subs r2,r2,#4
	bne ls0
	subs r0,r0,#1
	bne ls1

	ldr r2,rombase		;adjust ptr shit (see savestate above)
	bl fixromptrs

	mov r0,#1
	strb r0,sprmemreload

	ldmfd sp!,{r4-r7,globalptr,lr}
	bx lr



;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
bg_finish	;end of frame...
;-------------------------------------------------------------------------------
	stmfd sp!,{r3-r9,r11,r12,lr}

	ldr r4,=mem_dirtytbl
	ldrb r0,[r4]
	cmp r0,#0
	beq bg_cont

	ldr r0,scrlx
	ldr r1,scrlx_tmp
	eor r1,r0,r1,lsl#3
	bics r1,r1,#0xF
	movne r0,r0,lsr#3
	strne r0,scrlx_tmp
	bne bg_cont
	ldr r0,scrly
	ldr r1,scrly_tmp
	eor r1,r0,r1
	bics r1,r1,#0xF
	strne r0,scrly_tmp
	bne bg_cont
	ldr r0,windowtop+4
	ldr r1,windowtop+8
	eor r0,r0,r1
	bics r0,r0,#0xF
	ldmeqfd sp!,{r3-r9,r11,r12,pc}
bg_cont
	mov r0,#-1
	strb r0,[r4]

	ldr r7,=BGRTILELUT
	ldrb r0,bgrmemreload
	tst r0,#0xff
	beq nobgreload
	mov r0,r7				;r0=destination
	mov r1,#0				;r1=value
	mov r2,#1024			;2048/2 tile entries
	bl memset_				;clear lut
	strb r1,bgrmemreload	;clear bgr mem reload.
	mov r1,#0x20000
	str r1,bgrmemalloc		;clear bgr mem alloc.
nobgreload


	ldr r1,emuflags
	tst r1,#0x200
	ldreq r4,windowtop+4		;first scanline unscaled.
	ldrneb r4,ystart			;first scanline scaled.
	ldr r1,scrly
	add r4,r4,r1,asr#16
	moveq r0,#160
	movne r0,#224
	add r11,r4,r0				;r11 = sheight
	mov r8,#0x00000001			;tile adder
	orr r8,r8,#0x00010000		;tile adder

	ldrb r0,screenLayout
	cmp r0,#0
	bne bglo8x4
	beq bglo4x8
;-------------------------------------------------------------------------------
fg_finish	;end of frame...
;-------------------------------------------------------------------------------
	stmfd sp!,{r3-r9,r11,r12,lr}

	ldr r4,=mem_dirtytbl
	ldrb r0,[r4,#1]
	cmp r0,#0
	beq fg_cont
	ldr r0,windowtop+4
	ldr r1,windowtop+8
	eor r0,r0,r1
	bics r0,r0,#0xF
	ldmeqfd sp!,{r3-r9,r11,r12,pc}
fg_cont
	mov r0,#-1
	strb r0,[r4,#1]

	ldr r7,=CHRTILELUT
	ldrb r0,chrmemreload
	tst r0,#0xff
	beq nofgreload
	mov r0,r7				;r0=destination
	mov r1,#0				;r1=value
	mov r2,#2048			;2048 tile entries
	bl memset_				;clear lut
	strb r1,chrmemreload	;clear chr mem reload.
	mov r1,#0x20000
	str r1,chrmemalloc		;clear chr mem alloc.
nofgreload


	ldr r1,emuflags
	tst r1,#0x200
	ldreq r4,windowtop+4		;first scanline unscaled.
	ldrneb r4,ystart			;first scanline scaled.
	moveq r0,#160
	movne r0,#224
	add r11,r4,r0				;r11 = sheight

	b fglo2

;-------------------------------------------------------------------------------
 AREA wram_code4, CODE, READWRITE
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;bgchrfinish2	;end of frame...
;-------------------------------------------------------------------------------
bglo8x4
	and r0,r4,#0x0F0
	and r1,r4,#0x300
	add r0,r0,r1,lsl#3

	ldr r3,=EMU_RAM
	add r5,r3,r0,lsl#1			;128x64 tiles

	ldr r2,scrlx_tmp

	mov r9,#AGB_VRAM
	and r0,r4,#0xF0
	add r9,r9,r0,lsl#3
	mov r3,#16					;width/16
bgtrloop8x4
	and r2,r2,#0xFE
	orr r1,r2,r2,lsl#4			;move 0x20 to 0x200
	bic r1,r1,#0x01E0
	ldrh r6,[r5,r1]				;Read from BlackTiger Tilemap RAM
	bic r1,r6,#0xF800			;tilenum
	bl VRAM_bgr_16
	and r0,r0,#0xFF
	mov r0,r0,lsl#2
	tst r6,#0x8000				;Xflip
	orrne r0,r0,#0x0400
	and r6,r6,#0x7800
	eor r6,r6,#0x7800
	orr r0,r0,r6,lsl#1			;color bits
	orr r0,r0,r0,ror#16
	add r0,r0,#0x00020000

	movne r0,r0,ror#16

	orr r1,r2,r2,lsl#5			;move 0x20 to 0x400
	mov r1,r1,lsl#1
	bic r1,r1,#0x37C0
	str r0,[r1,r9]!				;Write to GBA Tilemap RAM
	orr r0,r0,r8
	str r0,[r1,#0x40]			;Write to GBA Tilemap RAM row 2
	add r2,r2,#2
	subs r3,r3,#1
	bne bgtrloop8x4

	add r4,r4,#0x10
	cmp r4,r11					;160*4/3=213.33333
	ble bglo8x4

	ldmfd sp!,{r3-r9,r11,r12,pc}

;-------------------------------------------------------------------------------
;bgchrfinish2	;end of frame...
;-------------------------------------------------------------------------------
bglo4x8
	and r0,r4,#0x0F0
	and r1,r4,#0x700
	add r0,r0,r1,lsl#2

	ldr r3,=EMU_RAM
	add r5,r3,r0,lsl#1			;128x64 tiles

	ldr r2,scrlx_tmp

	mov r9,#AGB_VRAM
	and r0,r4,#0xF0
	add r9,r9,r0,lsl#3
	mov r3,#16					;width/16
bgtrloop4x8
	and r2,r2,#0x7E
	orr r1,r2,r2,lsl#4			;move 0x20 to 0x200
	bic r1,r1,#0x01E0
	ldrh r6,[r5,r1]				;Read from BlackTiger Tilemap RAM
	bic r1,r6,#0xF800			;tilenum
	bl VRAM_bgr_16
	and r0,r0,#0xFF
	mov r0,r0,lsl#2
	tst r6,#0x8000				;Xflip
	orrne r0,r0,#0x0400
	and r6,r6,#0x7800
	eor r6,r6,#0x7800
	orr r0,r0,r6,lsl#1			;color bits
	orr r0,r0,r0,ror#16
	add r0,r0,#0x00020000

	movne r0,r0,ror#16

	orr r1,r2,r2,lsl#5			;move 0x20 to 0x400
	mov r1,r1,lsl#1
	bic r1,r1,#0x37C0
	str r0,[r1,r9]!				;Write to GBA Tilemap RAM
	orr r0,r0,r8
	str r0,[r1,#0x40]			;Write to GBA Tilemap RAM row 2
	add r2,r2,#2
	subs r3,r3,#1
	bne bgtrloop4x8

	add r4,r4,#0x10
	cmp r4,r11					;160*4/3=213.33333
	ble bglo4x8

	ldmfd sp!,{r3-r9,r11,r12,pc}

;----------------------------------------------------------------------------
VRAM_bgr_16;		takes tilenumber in r1, returns new tilenumber in r0
;----------------------------------------------------------------------------
	mov r1,r1,ror#1
	ldr r0,[r7,r1,lsl#2]
	add r0,r0,r1,lsr#31
	cmp r0,#0x10000
	movhi pc,lr			;allready cached
noluthit16
	ldr r0,bgrmemalloc
	str r0,[r7,r1,lsl#2]
	add r0,r0,r1,lsr#31
	stmfd sp!,{r0-r4,lr}

	and r0,r0,#0xFE
	add r12,r0,#2		;allways alloc 2 tiles
	strb r12,bgrmemalloc
	tst r12,#0x100
	movne r12,#0xab
	strneb r12,bgrmemreload

;----------------------------------------------------------------------------
do16

	ldr r2,vrombase1			;r3 = bitplane 2 & 3
	add r2,r2,r1,lsl#7
	add r3,r2,#0x20000
	ldr r4,=CHR_DECODE			;0x400
	mov r12,#AGB_VRAM			;r6=AGB BGR tileset
	orr r12,r12,#0x8000			;bgr ram
	add r12,r12,r0,lsl#7		;

bgr1
	ldrb r0,[r2],#1				;read plane 2 & 3
	ldr r0,[r4,r0,lsl#2]
	ldrb r1,[r3],#1				;read plane 0 & 1
	ldr r1,[r4,r1,lsl#2]
	orr r0,r0,r1,lsl#2
	strh r0,[r12],#2

	tst r12,#0xFE		;allways 2 16x16 tiles
	bne bgr1

cachehit16
	ldmfd sp!,{r0-r4,pc}

;-------------------------------------------------------------------------------
;fgchrfinish2	;end of frame...
;-------------------------------------------------------------------------------
fglo2

	ldr r4,=EMU_RAM+0x4000
	mov r5,#AGB_VRAM
	add r5,r5,#0x1000
	mov r3,#1024				;total tiles
fgtrloop
	ldrb r1,[r4,#0x400]			;Read from BlackTiger Charmap RAM
	ldrb r0,[r4],#1				;Read from BlackTiger Charmap RAM
	and r1,r1,#0xE0
	orr r1,r0,r1,lsl#3
	bl VRAM_chr_8
	orr r0,r0,#0x9000			;Color
	strh r0,[r5],#2				;Write to GBA Tilemap RAM
	subs r3,r3,#1
	bne fgtrloop


	ldmfd sp!,{r3-r9,r11,r12,pc}

;----------------------------------------------------------------------------
VRAM_chr_8;		takes tilenumber in r1, returns new tilenumber in r0
;----------------------------------------------------------------------------
	ldr r0,[r7,r1,lsl#2]
	cmp r0,#0x10000
	movhi pc,lr			;allready cached
noluthit8
	ldr r0,chrmemalloc
	str r0,[r7,r1,lsl#2]
	stmfd sp!,{r0-r2,lr}

	add r12,r0,#1		;alloc 1 tile
	tst r12,#0x200
	movne r12,#0x20000
	str r12,chrmemalloc
	ldrne r4,=mem_dirtytbl
	strneb r12,[r4,#1]			;Make sure FG is updated on next frame
	movne r12,#0xab
	strneb r12,chrmemreload
	bic r0,r0,#0x20000

;----------------------------------------------------------------------------
do8
	ldr r2,vrombase0			;r2 = bitplane 0 & 1
	add r1,r2,r1,lsl#4
	ldr r2,=CHR_DECODE			;0x400
	mov r12,#AGB_VRAM			;r6=AGB BGR tileset
	orr r12,r12,#0x4000			;bgr ram 1.5
	add r12,r12,r0,lsl#5		;

chr1
	ldrb r0,[r1],#1				;read plane 0 & 1
	ldr r0,[r2,r0,lsl#2]
	strh r0,[r12],#2

	tst r12,#0x1E
	bne chr1

	ldmfd sp!,{r0-r2,pc}

;----------------------------------------------------------------------------
HuMapper_	;rom paging..
;----------------------------------------------------------------------------
	stmfd sp!,{r3-r7}
	ldr r6,=MEMMAPTBL_
	ldr r2,[r6,r1,lsl#2]!
	ldr r3,[r6,#-1024]		;RDMEMTBL_
	ldr r4,[r6,#-2048]		;WRMEMTBL_

	mov r5,#0
	cmp r1,#0xF8
	movmi r5,#12

wr_tbl
	adr r6,readmem_tbl
	tst r0,#0xFF
	bne memaps				;safety
	b flush
memapl
	add r6,r6,#4
memap2
	add r3,r3,r5
	sub r2,r2,#0x2000
memaps
	movs r0,r0,lsr#1
	bcc memapl				;C=0
	strcs r3,[r6],#4		;readmem_tbl
	strcs r4,[r6,#28]		;writemem_tb
	strcs r2,[r6,#60]		;memmap_tbl
	bne memap2

;------------------------------------------
flush		;update cpu_pc & lastbank
;------------------------------------------
	ldr r1,lastbank
	sub z80_pc,z80_pc,r1
	encodePC

	ldmfd sp!,{r3-r7}
	mov pc,lr


;----------------------------------------------------------------------------
 AREA wram_globals2, CODE, READWRITE

romstart
	DCD 0 ;rombase
romnum
	DCD 0 ;romnumber
rominfo                 ;keep emuflags/BGmirror together for savestate/loadstate
g_emuflags	DCB 0 ;emuflags        (label this so UI.C can take a peek) see equates.h for bitfields
g_scaling	DCB SCALED_SPRITES ;(display type)
	% 2   ;(sprite follow val)
g_cartflags
	DCB 0 ;cartflags
g_dipswitch0
	DCB 0 ;dipswitch0
g_dipswitch1
	DCB 0 ;dipswitch1
g_dipswitch2
	DCB 0 ;dipswitch2
g_coin0
	DCD 0 ;coincounter0
g_coin1
	DCD 0 ;coincounter1
	DCD 0 ;vrombase0
	DCD 0 ;vrombase1
	DCD 0 ;vrombase2


;----------------------------------------------------------------------------
	END

