/***************************************************************************

	osd_key.c

	OSˑL[{[h

***************************************************************************/

#include "neogeocd.h"
#include <windowsx.h>
#include <dinput.h>
#include "win32.h"
#include "DirectInput.h"
#include "osd_key.h"


/***************************************************************************
	vg^Cv
 ***************************************************************************/

static void OnActivateApp(HWND hWnd, BOOL fActivate, DWORD dwThreadId);
static void OnKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags);
static void OnChar(HWND hWnd, TCHAR ch, int cRepeat);


/***************************************************************************
	[J\
 ***************************************************************************/

struct DIKEYBOARD
{
	LPDIRECTINPUTDEVICE  didKeyboard;
	byte                 key[256];
	unsigned             code[256];
	unsigned             count[256];
	TCHAR                chPressed;
};

static struct DIKEYBOARD dikey;

static struct KeyboardInfo keylist[] =
{
	{ DIK_ESCAPE,         KEYCODE_ESC,          "KEYCODE_ESC",           "ESC"            },
	{ DIK_1,              KEYCODE_1,            "KEYCODE_1",             "1"              },
	{ DIK_2,              KEYCODE_2,            "KEYCODE_2",             "2"              },
	{ DIK_3,              KEYCODE_3,            "KEYCODE_3",             "3"              },
	{ DIK_4,              KEYCODE_4,            "KEYCODE_4",             "4"              },
	{ DIK_5,              KEYCODE_5,            "KEYCODE_5",             "5"              },
	{ DIK_6,              KEYCODE_6,            "KEYCODE_6",             "6"              },
	{ DIK_7,              KEYCODE_7,            "KEYCODE_7",             "7"              },
	{ DIK_8,              KEYCODE_8,            "KEYCODE_8",             "8"              },
	{ DIK_9,              KEYCODE_9,            "KEYCODE_9",             "9"              },
	{ DIK_0,              KEYCODE_0,            "KEYCODE_0",             "0"              },
	{ DIK_MINUS,          KEYCODE_MINUS,        "KEYCODE_MINUS",         "-"              },
	{ DIK_EQUALS,         KEYCODE_EQUALS,       "KEYCODE_EQUALS",        "="              },
	{ DIK_BACK,           KEYCODE_BACKSPACE,    "KEYCODE_BACKSPACE",     "BACK SPACE"     },
	{ DIK_TAB,            KEYCODE_TAB,          "KEYCODE_TAB",           "TAB"            },
	{ DIK_Q,              KEYCODE_Q,            "KEYCODE_Q",             "Q"              },
	{ DIK_W,              KEYCODE_W,            "KEYCODE_W",             "W"              },
	{ DIK_E,              KEYCODE_E,            "KEYCODE_E",             "E"              },
	{ DIK_R,              KEYCODE_R,            "KEYCODE_R",             "R"              },
	{ DIK_T,              KEYCODE_T,            "KEYCODE_T",             "T"              },
	{ DIK_Y,              KEYCODE_Y,            "KEYCODE_Y",             "Y"              },
	{ DIK_U,              KEYCODE_U,            "KEYCODE_U",             "U"              },
	{ DIK_I,              KEYCODE_I,            "KEYCODE_I",             "I"              },
	{ DIK_O,              KEYCODE_O,            "KEYCODE_O",             "O"              },
	{ DIK_P,              KEYCODE_P,            "KEYCODE_P",             "P"              },
	{ DIK_LBRACKET,       KEYCODE_OPENBRACE,    "KEYCODE_OPENBRACE",     "["              },
	{ DIK_RBRACKET,       KEYCODE_CLOSEBRACE,   "KEYCODE_CLOSEBRACE",    "]"              },
	{ DIK_RETURN,         KEYCODE_ENTER,        "KEYCODE_ENTER",         "ENTER"          },
	{ DIK_LCONTROL,       KEYCODE_LCONTROL,     "KEYCODE_LCONTROL",      "LEFT CTRL"      },
	{ DIK_A,              KEYCODE_A,            "KEYCODE_A",             "A"              },
	{ DIK_S,              KEYCODE_S,            "KEYCODE_S",             "S"              },
	{ DIK_D,              KEYCODE_D,            "KEYCODE_D",             "D"              },
	{ DIK_F,              KEYCODE_F,            "KEYCODE_F",             "F"              },
	{ DIK_G,              KEYCODE_G,            "KEYCODE_G",             "G"              },
	{ DIK_H,              KEYCODE_H,            "KEYCODE_H",             "H"              },
	{ DIK_J,              KEYCODE_J,            "KEYCODE_J",             "J"              },
	{ DIK_K,              KEYCODE_K,            "KEYCODE_K",             "K"              },
	{ DIK_L,              KEYCODE_L,            "KEYCODE_L",             "L"              },
	{ DIK_SEMICOLON,      KEYCODE_SEMICOLON,    "KEYCODE_SEMICOLON",     ";"              },
	{ DIK_APOSTROPHE,     KEYCODE_QUOTE,        "KEYCODE_QUOTE",         "\""             },
	{ DIK_GRAVE,          KEYCODE_TILDE,        "KEYCODE_TILDE",         "~"              },
	{ DIK_LSHIFT,         KEYCODE_LSHIFT,       "KEYCODE_LSHIFT",        "LEFT SHIFT"     },
	{ DIK_BACKSLASH,      KEYCODE_BACKSLASH,    "KEYCODE_BACKSLASH",     "\\"             },
	{ DIK_Z,              KEYCODE_Z,            "KEYCODE_Z",             "Z"              },
	{ DIK_X,              KEYCODE_X,            "KEYCODE_X",             "X"              },
	{ DIK_C,              KEYCODE_C,            "KEYCODE_C",             "C"              },
	{ DIK_V,              KEYCODE_V,            "KEYCODE_V",             "V"              },
	{ DIK_B,              KEYCODE_B,            "KEYCODE_B",             "B"              },
	{ DIK_N,              KEYCODE_N,            "KEYCODE_N",             "N"              },
	{ DIK_M,              KEYCODE_M,            "KEYCODE_M",             "M"              },
	{ DIK_COMMA,          KEYCODE_COMMA,        "KEYCODE_COMMA",         ","              },
	{ DIK_PERIOD,         KEYCODE_PERIOD,       "KEYCODE_PERIOD",        "."              },
	{ DIK_SLASH,          KEYCODE_SLASH,        "KEYCODE_SLASH",         "/"              },
	{ DIK_RSHIFT,         KEYCODE_RSHIFT,       "KEYCODE_RSHIFT",        "RIGHT SHIFT"    },
	{ DIK_MULTIPLY,       KEYCODE_ASTERISK,     "KEYCODE_ASTERISK",      "*"              },
	{ DIK_LMENU,          KEYCODE_LALT,         "KEYCODE_LALT",          "LEFT ALT"       },
	{ DIK_SPACE,          KEYCODE_SPACE,        "KEYCODE_SPACE",         "SPACE"          },
	{ DIK_CAPITAL,        KEYCODE_CAPSLOCK,     "KEYCODE_CAPSLOCK",      "CAPS LOCK"      },
	{ DIK_F1,             KEYCODE_F1,           "KEYCODE_F1",            "F1"             },
	{ DIK_F2,             KEYCODE_F2,           "KEYCODE_F2",            "F2"             },
	{ DIK_F3,             KEYCODE_F3,           "KEYCODE_F3",            "F3"             },
	{ DIK_F4,             KEYCODE_F4,           "KEYCODE_F4",            "F4"             },
	{ DIK_F5,             KEYCODE_F5,           "KEYCODE_F5",            "F5"             },
	{ DIK_F6,             KEYCODE_F6,           "KEYCODE_F6",            "F6"             },
	{ DIK_F7,             KEYCODE_F7,           "KEYCODE_F7",            "F7"             },
	{ DIK_F8,             KEYCODE_F8,           "KEYCODE_F8",            "F8"             },
	{ DIK_F9,             KEYCODE_F9,           "KEYCODE_F9",            "F9"             },
	{ DIK_F10,            KEYCODE_F10,          "KEYCODE_F10",           "F10"            },
	{ DIK_NUMLOCK,        KEYCODE_NUMLOCK,      "KEYCODE_NUMLOCK",       "NUM LOCK"       },
	{ DIK_SCROLL,         KEYCODE_SCRLOCK,      "KEYCODE_SCRLOCK",       "SCROLL LOCK"    },
	{ DIK_NUMPAD7,        KEYCODE_7_PAD,        "KEYCODE_7_PAD",         "NUM PAD 7"      },
	{ DIK_NUMPAD8,        KEYCODE_8_PAD,        "KEYCODE_8_PAD",         "NUM PAD 8"      },
	{ DIK_NUMPAD9,        KEYCODE_9_PAD,        "KEYCODE_9_PAD",         "NUM PAD 9"      },
	{ DIK_SUBTRACT,       KEYCODE_MINUS_PAD,    "KEYCODE_MINUS_PAD",     "NUM PAD -"      },
	{ DIK_NUMPAD4,        KEYCODE_4_PAD,        "KEYCODE_4_PAD",         "NUM PAD 4"      },
	{ DIK_NUMPAD5,        KEYCODE_5_PAD,        "KEYCODE_5_PAD",         "NUM PAD 5"      },
	{ DIK_NUMPAD6,        KEYCODE_6_PAD,        "KEYCODE_6_PAD",         "NUM PAD 6"      },
	{ DIK_ADD,            KEYCODE_PLUS_PAD,     "KEYCODE_PLUS_PAD",      "NUM PAD +"      },
	{ DIK_NUMPAD1,        KEYCODE_1_PAD,        "KEYCODE_1_PAD",         "NUM PAD 1"      },
	{ DIK_NUMPAD2,        KEYCODE_2_PAD,        "KEYCODE_2_PAD",         "NUM PAD 2"      },
	{ DIK_NUMPAD3,        KEYCODE_3_PAD,        "KEYCODE_3_PAD",         "NUM PAD 3"      },
	{ DIK_NUMPAD0,        KEYCODE_0_PAD,        "KEYCODE_0_PAD",         "NUM PAD 0"      },
	{ DIK_DECIMAL,        KEYCODE_DEL_PAD,      "KEYCODE_DEL_PAD",       "NUM PAD DELETE" },
	{ DIK_OEM_102,        KEYCODE_OEM_102,      "KEYCODE_OEM_102",       "OEM 102?"       },
	{ DIK_F11,            KEYCODE_F11,          "KEYCODE_F11",           "F11"            },
	{ DIK_F12,            KEYCODE_F12,          "KEYCODE_F12",           "F12"            },
	{ DIK_F13,            KEYCODE_F13,          "KEYCODE_F13",           "F13"            },
	{ DIK_F14,            KEYCODE_F14,          "KEYCODE_F14",           "F14"            },
	{ DIK_F15,            KEYCODE_F15,          "KEYCODE_F15",           "F15"            },
	{ DIK_KANA,           KEYCODE_KANA,         "KEYCODE_KANA",          "KANA"           },
	{ DIK_ABNT_C1,        KEYCODE_ABNT_C1,      "KEYCODE_ABNT_C1",       "ABNT C1?"       },
	{ DIK_CONVERT,        KEYCODE_CONVERT,      "KEYCODE_CONVERT",       "CONVERT"        },
	{ DIK_NOCONVERT,      KEYCODE_NOCONVERT,    "KEYCODE_NOCONVERT",     "NO CONVERT"     },
	{ DIK_YEN,            KEYCODE_YEN,          "KEYCODE_YEN",           "\\"             },
	{ DIK_ABNT_C2,        KEYCODE_ABNT_C2,      "KEYCODE_ABNT_C2",       "ABNT C2?"       },
	{ DIK_NUMPADEQUALS,   KEYCODE_EQUALS_PAD,   "KEYCODE_EQUALS_PAD",    "NUM PAD ="      },
	{ DIK_PREVTRACK,      KEYCODE_PREVTRACK,    "KEYCODE_PREVTRACK",     "PREVIOUS TRACK" },
	{ DIK_AT,             KEYCODE_ATMARK,       "KEYCODE_ATMARK",        "@"              },
	{ DIK_COLON,          KEYCODE_COLON,        "KEYCODE_COLON",         ":"              },
	{ DIK_UNDERLINE,      KEYCODE_UNDERLINE,    "KEYCODE_UNDERLINE",     "_"              },
	{ DIK_KANJI,          KEYCODE_KANJI,        "KEYCODE_KANJI",         "KANJI"          },
	{ DIK_STOP,           KEYCODE_STOP,         "KEYCODE_STOP",          "STOP"           },
	{ DIK_AX,             KEYCODE_AX,           "KEYCODE_AX",            "AX?"            },
	{ DIK_UNLABELED,      KEYCODE_UNLABELED,    "KEYCODE_UNLABELED",     "J3100?"         },
	{ DIK_NEXTTRACK,      KEYCODE_NEXTTRACK,    "KEYCODE_NEXTTRACK",     "NEXT TRACK"     },
	{ DIK_NUMPADENTER,    KEYCODE_ENTER_PAD,    "KEYCODE_ENTER_PAD",     "NUM PAD ENTER"  },
	{ DIK_RCONTROL,       KEYCODE_RCONTROL,     "KEYCODE_RCONTROL",      "RIGHT CTRL"     },
	{ DIK_MUTE,           KEYCODE_MUTE,         "KEYCODE_MUTE",          "MUTE"           },
	{ DIK_CALCULATOR,     KEYCODE_CALCULATOR,   "KEYCODE_CALCULATOR",    "CALCULATOR"     },
	{ DIK_PLAYPAUSE,      KEYCODE_PLAYPAUSE,    "KEYCODE_PLAYPAUSE",     "PLAY/PAUSE"     },
	{ DIK_MEDIASTOP,      KEYCODE_MEDIASTOP,    "KEYCODE_MEDIASTOP",     "MEDIA STOP"     },
	{ DIK_VOLUMEDOWN,     KEYCODE_VOLUMEDOWN,   "KEYCODE_VOLUMEDOWN",    "VOLUME DOWN"    },
	{ DIK_VOLUMEUP,       KEYCODE_VOLUMEUP,     "KEYCODE_VOLUMEUP",      "VOLUME UP"      },
	{ DIK_WEBHOME,        KEYCODE_WEBHOME,      "KEYCODE_WEBHOME",       "WEB HOME"       },
	{ DIK_NUMPADCOMMA,    KEYCODE_COMMA_PAD,    "KEYCODE_COMMA_PAD",     "NUM PAD ,"      },
	{ DIK_DIVIDE,         KEYCODE_SLASH_PAD,    "KEYCODE_SLASH_PAD",     "NUM PAD /"      },
	{ DIK_SYSRQ,          KEYCODE_SYSRQ,        "KEYCODE_SYSRQ",         "PRINT SCREEN"   },
	{ DIK_RMENU,          KEYCODE_RALT,         "KEYCODE_RALT",          "RIGHT ALT"      },
	{ DIK_PAUSE,          KEYCODE_PAUSE,        "KEYCODE_PAUSE",         "PAUSE"          },
	{ DIK_HOME,           KEYCODE_HOME,         "KEYCODE_HOME",          "HOME"           },
	{ DIK_UP,             KEYCODE_UP,           "KEYCODE_UP",            "UP"             },
	{ DIK_PRIOR,          KEYCODE_PGUP,         "KEYCODE_PGUP",          "PAGE UP"        },
	{ DIK_LEFT,           KEYCODE_LEFT,         "KEYCODE_LEFT",          "LEFT"           },
	{ DIK_RIGHT,          KEYCODE_RIGHT,        "KEYCODE_RIGHT",         "RIGHT"          },
	{ DIK_END,            KEYCODE_END,          "KEYCODE_END",           "END"            },
	{ DIK_DOWN,           KEYCODE_DOWN,         "KEYCODE_DOWN",          "DOWN"           },
	{ DIK_NEXT,           KEYCODE_PGDN,         "KEYCODE_PGDN",          "PAGE DOWN"      },
	{ DIK_INSERT,         KEYCODE_INSERT,       "KEYCODE_INSERT",        "INSERT"         },
	{ DIK_DELETE,         KEYCODE_DEL,          "KEYCODE_DEL",           "DELETE"         },
	{ DIK_LWIN,           KEYCODE_LWIN,         "KEYCODE_LWIN",          "LEFT WINDOWS"   },
	{ DIK_RWIN,           KEYCODE_RWIN,         "KEYCODE_RWIN",          "RIGHT WINDOWS"  },
	{ DIK_APPS,           KEYCODE_APPS,         "KEYCODE_APPS",          "APPLICATIONS"   },
	{ DIK_POWER,          KEYCODE_POWER,        "KEYCODE_POWER",         "POWER"          },
	{ DIK_SLEEP,          KEYCODE_SLEEP,        "KEYCODE_SLEEP",         "SLEEP"          },
	{ DIK_WAKE,           KEYCODE_WAKE,         "KEYCODE_WAKE",          "WAKE"           },
	{ DIK_WEBSEARCH,      KEYCODE_WEBSEARCH,    "KEYCODE_WEBSEARCH",     "WEB SEARCH"     },
	{ DIK_WEBFAVORITES,   KEYCODE_WEBFAVORITES, "KEYCODE_WEBFAVORITES",  "WEB FAVORITES"  },
	{ DIK_WEBREFRESH,     KEYCODE_WEBREFRESH,   "KEYCODE_WEBREFRESH",    "WEB REFRESH"    },
	{ DIK_WEBSTOP,        KEYCODE_WEBSTOP,      "KEYCODE_WEBSTOP",       "WEB STOP"       },
	{ DIK_WEBFORWARD,     KEYCODE_WEBFORWARD,   "KEYCODE_WEBFORWARD",    "WEB FORWARD"    },
	{ DIK_WEBBACK,        KEYCODE_WEBBACK,      "KEYCODE_WEBBACK",       "WEB BACK"       },
	{ DIK_MYCOMPUTER,     KEYCODE_MYCOMPUTER,   "KEYCODE_MYCOMPUTER",    "MY COMPUTER"    },
	{ DIK_MAIL,           KEYCODE_MAIL,         "KEYCODE_MAIL",          "MAIL"           },
	{ DIK_MEDIASELECT,    KEYCODE_MEDIASELECT,  "KEYCODE_MEDIASELECT",   "MEDIA SELECT"   },

	{ DIK_PREVTRACK,      KEYCODE_CIRCUMFLEX,   "KEYCODE_CIRCUMFLEX",    "^"              },

	{ 0, 0, 0, 0 } /* end of table */
};


/***************************************************************************
	O[o֐
 ***************************************************************************/

/*------------------------------------------------------

	L[{[hJn

	  : Ȃ
	߂l: :OSD_OK  s:OSD_ERROR

 -----------------------------------------------------*/

int osd_keyboard_init(void)
{
	int i, j;

	dikey.didKeyboard = NULL;
	dikey.chPressed   = 0;

	for (i = 0; i < 256; i++)
	{
		dikey.key[i] = 0;
		dikey.count[i] = 0;
		dikey.code[i] = KEYCODE_UNKNOWN;
	}

	for (i = 0; keylist[i].name; i++)
	{
		for (j = KEYCODE_A; j < KEYCODE_NONE; j++)
		{
			if (j == keylist[i].standardcode)
			{
				dikey.code[j] = keylist[i].code;
				break;
			}
		}
	}

	osd_keyboard_reset();

	if (di == NULL)
	{
		// DirectInputĂȂꍇ̓G[
		logerror("DirectInput not inisialized.\n");
		return OSD_ERROR;
	}

	// foCX쐬
	if (IDirectInput_CreateDevice(di, &GUID_SysKeyboard, &dikey.didKeyboard, NULL) != DI_OK)
		goto error;

	// f[^`ݒ
	if (IDirectInputDevice_SetDataFormat(dikey.didKeyboard, &c_dfDIKeyboard) != DI_OK)
		goto error;

	// xݒ
	if (IDirectInputDevice_SetCooperativeLevel(dikey.didKeyboard, MyApp.m_hWnd, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND) != DI_OK)
		goto error;

	// gpvs
	IDirectInputDevice_Acquire(dikey.didKeyboard);

	return OSD_OK;

error:
	logerror("DirectInput keyboard initialization failed.\n");
	return OSD_ERROR;
}


/*------------------------------------------------------

	L[{[hI

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void osd_keyboard_exit(void)
{
	if (!dikey.didKeyboard)
		return;

	IDirectInputDevice_Unacquire(dikey.didKeyboard);
	IDirectInputDevice_Release(dikey.didKeyboard);

	dikey.didKeyboard = NULL;
}


/*------------------------------------------------------

	L[{[hZbg

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void osd_keyboard_reset(void)
{
	int i;

	for (i = 0; i < 14; i++)
	{
		key_code[0][i] = options.key[0][i];
		key_code[1][i] = options.key[1][i];
	}
}


/*------------------------------------------------------

	L[{[h̏XV

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void osd_poll_keyboard(void)
{
	HRESULT hResult;

	if (dikey.didKeyboard == NULL)
	   return;

	MyApp.ProcessMessages();

retry:

	// foCX擾
	hResult = IDirectInputDevice_GetDeviceState(dikey.didKeyboard, sizeof(dikey.key), &dikey.key);
	if (hResult == DIERR_INPUTLOST || hResult == DIERR_NOTACQUIRED)
	{
		// XgĂēxfoCXgpv
		if (IDirectInputDevice_Acquire(dikey.didKeyboard) == DI_OK)
			goto retry;
	}
}


/*------------------------------------------------------

	EFCgȂ̃L[擾

	  : int keycode  R[h
	߂l: 1:Ă 0:ĂȂ

 -----------------------------------------------------*/

int osd_is_key_pressed(int keycode)
{
	if (keycode == KEYCODE_UNKNOWN)
		return 0;

	return dikey.key[dikey.code[keycode]] != 0;
}


/*------------------------------------------------------

	EFCg̃L[擾

	  : int keycode  R[h
	߂l: 1:Ă 0:ĂȂ

 -----------------------------------------------------*/

int osd_is_key_pressed_memory(int keycode)
{
	int pressed;

	if (keycode == KEYCODE_UNKNOWN)
		return 0;

	pressed = dikey.key[dikey.code[keycode]];

	if (pressed)
	{
		if (dikey.count[dikey.code[keycode]] == 0)
		{
			dikey.count[dikey.code[keycode]] = 1;
		}
		else
			pressed = 0;
	}
	else
		dikey.count[dikey.code[keycode]] = 0;

	return pressed;
}


/*------------------------------------------------------

	L[{[h݂邩`FbN

	  : Ȃ
	߂l: 1: 0:Ȃ

 -----------------------------------------------------*/

int osd_keyboard_available(void)
{
	const GUID guidNULL = {0, 0, 0, {0, 0, 0, 0, 0, 0, 0, 0}};
	GUID guidDevice = guidNULL;

	if (di == NULL)
		return 0;

	/* enumerate for keyboard devices */
	if (IDirectInput_EnumDevices(di, DIDEVTYPE_KEYBOARD, inputEnumDeviceProc, &guidDevice, DIEDFL_ATTACHEDONLY) != DI_OK)
		return 0;

	if (!IsEqualGUID(&guidDevice, &guidNULL))
		return 1;

	return 0;
}


/*------------------------------------------------------

	ėpR[h񂩂ėpR[h擾

	  : char *name  ėpR[h
	߂l: ėpR[h

 -----------------------------------------------------*/

int osd_get_keycode_by_name(char *name)
{
	int i;

	for (i = 0; keylist[i].name; i++)
	{
		if (strcmp(name, keylist[i].name) == 0)
			return keylist[i].standardcode;
	}

	return KEYCODE_UNKNOWN;
}


/*------------------------------------------------------

	ėpR[hԍėpR[h擾

	  : int code   ėpR[h
	߂l: R[h̖O

 -----------------------------------------------------*/

const char *osd_get_keyname_by_code(int code)
{
	int i;

	for (i = 0; keylist[i].name; i++)
	{
		if (code == keylist[i].standardcode)
			return keylist[i].name;
	}

	return "KEYCODE_UNKNOWN";
}


/*------------------------------------------------------

	ėpR[hԍʕ\擾

	  : int code   ėpR[h
	߂l: ʕ\

 -----------------------------------------------------*/

const char *osd_keyboard_get_dispname(int code)
{
	int i;

	for (i = 0; keylist[i].name; i++)
	{
		if (code == keylist[i].standardcode)
			return keylist[i].dispname;
	}

	return "UNKNOWN";
}


/*--------------------------------------------------------

	L[{[hɊւWindow Message̎擾

	  : Ȃ
	߂l: ꍇ:TRUE Ȃꍇ:FALSE

 -------------------------------------------------------*/

BOOL Keyboard_OnMessage(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam, LRESULT *pResult)
{
	switch (Msg)
	{
		PEEK_MESSAGE(hWnd, WM_ACTIVATEAPP, OnActivateApp);
		HANDLE_MESSAGE(hWnd, WM_KEYDOWN,   OnKey);
		HANDLE_MESSAGE(hWnd, WM_KEYUP,     OnKey);
		HANDLE_MESSAGE(hWnd, WM_CHAR,      OnChar);
	}
	return FALSE;
}


/*-------------------------------------------------------- 

	EBhEANeBu/ANeBuɂȂ̏
	(WindowsbZ[W)

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

static void OnActivateApp(HWND hWnd, BOOL fActivate, DWORD dwThreadId)
{
	if (!dikey.didKeyboard)
		return;

	if (MyApp.m_bIsActive == TRUE)
		IDirectInputDevice_Acquire(dikey.didKeyboard);
	else
		IDirectInputDevice_Unacquire(dikey.didKeyboard);
}


/*-------------------------------------------------------- 

	L[Abv/_Eꂽ̏
	(WindowsbZ[W)

	  : Ȃ
	߂l: Ȃ

  ̂Ƃ뉽ĂȂł

 -------------------------------------------------------*/

static void OnKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags)
{
}


/*-------------------------------------------------------- 

	͂ꂽ̏
	(WindowsbZ[W)

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

static void OnChar(HWND hWnd, TCHAR ch, int cRepeat)
{
	dikey.chPressed = ch;
}
