;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; misc.asm
;
; CheckCPUID etc.
;
; for MSVC and GCC, use 'COFF' format:
;    nasmw -f win32 misc.asm
;
; for BCC32, use 'OMF' format:
;    nasmw -f obj misc.asm
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        BITS 32

        SECTION .text USE32 CLASS=CODE


;---------------------------------------------------------
;
; void CheckCPUID(void)
;
;---------------------------------------------------------
;
; CPUID̃`FbN
;
; SSE2A3DNow! Pro܂łΉĂ܂B
;
; unsigned ret = CheckCPUID();
; if (ret & HAS_MMX != 0)    MMX
; if (ret & HAS_MMX2 != 0)   Enhanced MMX
; if (ret & HAS_SSE != 0)    SSE
; if (ret & HAS_SSE2 != 0)   SSE2
; if (ret & HAS_3DNow != 0)  3DNow!
; if (ret & HAS_E3DNow != 0) Enhanced 3DNow!
;
; ƂŎgp܂B
;
;---------------------------------------------------------

%define HAS_MMX      0x00000001 ; MMX
%define HAS_MMX2     0x00000002 ; Enhanced MMX
%define HAS_SSE      0x00000010 ; Stream SIMD Extention
%define HAS_SSE2     0x00000020 ; Stream SIMD Extention 2
%define HAS_3DNow    0x00000100 ; 3DNow!
%define HAS_E3DNow   0x00000200 ; 3DNow! + Enhanced MMX
%define HAS_3DNowPro 0x00000310 ; Enhanced 3DNow! + SSE
%define HAS_RDTSC    0x00010000 ; RDSTC

;---------------------------------------------------------------------------
; check CPUID
;---------------------------------------------------------------------------

        GLOBAL _CheckCPUID
_CheckCPUID:
        push    ebx
        push    edx
        push    ecx
        push    esi

        xor     esi, esi
        pushfd
        pop     eax
        mov     edx, eax
        xor     eax, (1 << 21)
        push    eax
        popfd
        pushfd
        pop     eax
        mov     ecx, eax
        xor     eax, eax
        cmp     edx, ecx
        je      finish

        mov     eax, 0x80000001
        cpuid
        test    edx, (1 << 31) ; 3DNow!
        jz      E3DNow_check
        or      esi, HAS_3DNow
E3DNow_check:
        test    edx, (1 << 30) ; Enhanced 3DNow!
        jz      EMMX_check
        or      esi, HAS_E3DNow
EMMX_check:
        test    edx, (1 << 22) ; Enhanced MMX
        jz      MMX_check
        or      esi, HAS_MMX2
MMX_check:
        mov     eax, 1
        cpuid
        test    edx, (1 << 23) ; MMX
        jz      SSE_check
        or      esi, HAS_MMX
SSE_check:
        test    edx, (1 << 25) ; SSE
        jz      SSE2_check
        or      esi, HAS_MMX2
        or      esi, HAS_SSE
SSE2_check:
        test    edx, (1 << 26) ; SSE2
        jz      RDTSC_check
        or      esi, HAS_SSE2
RDTSC_check:
        test    edx, (1 << 5)  ; RDTSC
        jz      finish
        or      esi, HAS_RDTSC
finish:
        mov     eax, esi
        pop     esi
        pop     ecx
        pop     edx
        pop     ebx
        ret


;---------------------------------------------------------------------------
; RDTSC
;---------------------------------------------------------------------------

        GLOBAL _RDTSC
_RDTSC:
	rdtsc
	ret
