/***************************************************************************

	DirectDraw.c

	DirectDraw/I

***************************************************************************/

#ifndef DIRECTDRAW_H
#define DIRECTDRAW_H

#include <ddraw.h>

//-------------------------------------------------------------------------
// for GCC and borland
#ifdef NONAMELESSUNION

// DDPIXELFORMAT
#define dwRGBBitCount u1.dwRGBBitCount
#define dwRBitMask    u2.dwRBitMask
#define dwGBitMask    u3.dwGBitMask
#define dwBBitMask    u4.dwBBitMask

// DDSURFACEDESC
#define lPitch        u1.lPitch
#define dwRefreshRate u2.dwRefreshRate

// DDBLTFX
#define dwFillColor   u5.dwFillColor

#endif /* NONAMELESSUNION */
//------------------------------------------------------------------------


#define MAXMODES    256 /* Maximum number of DirectDraw Display modes. */

struct tDisplayMode
{
    DWORD m_dwWidth;
    DWORD m_dwHeight;
    DWORD m_dwBPP;
    DWORD m_dwRefreshRate;
};

struct tDisplayModes
{
    struct tDisplayMode m_Modes[MAXMODES];
    int m_nNumModes;
};


extern LPDIRECTDRAW2 dd;

int DirectDraw_Initialize(void);
void DirectDraw_Close(void);

void DirectDraw_CreateByIndex(int num_display);
struct tDisplayModes *DirectDraw_GetDisplayModes(void);

#endif /* DIRECTDRAW_H */
