/***************************************************************************

	spritef.c

	NEOGEO CD XvCg`揈(/fullmode2Ή)

***************************************************************************/

#ifndef SELF_INCLUDE

#define ARGSF	UINT32 *sprite, UINT16 *bm, UINT16 *paldata, int zy, int l

/******************************************************************************/

static UINT8 dda_y_skip[0x100][0x21][17];
static UINT8 yskip[0x100][0x21];
static UINT8 my_tbl[0x100][0x10];

/******************************************************************************/
#define SELF_INCLUDE
/******************************************************************************/

#ifdef OPAQUE
#undef OPAQUE
#endif

#define OPAQUE 0
	#define FLIPY 0
		#define FLIPX 0
			#include "spritef.c" /* opaque = no, flipx = no, flipy = no */
		#undef  FLIPX
		#define FLIPX 1
			#include "spritef.c" /* opaque = no, flipx = yes, flipy = no */
		#undef  FLIPX
	#undef  FLIPY
	#define FLIPY 1
		#define FLIPX 0
			#include "spritef.c" /* opaque = no, flipx = no, flipy = yes */
		#undef  FLIPX
		#define FLIPX 1
			#include "spritef.c" /* opaque = no, flipx = yes, flipy = yes */
		#undef  FLIPX
	#undef  FLIPY
#undef  OPAQUE

#define OPAQUE 1
	#define FLIPY 0
		#define FLIPX 0
			#include "spritef.c" /* opaque = yes, flipx = no, flipy = no */
		#undef  FLIPX
		#define FLIPX 1
			#include "spritef.c" /* opaque = yes, flipx = yes, flipy = no */
		#undef  FLIPX
	#undef  FLIPY
	#define FLIPY 1
		#define FLIPX 0
			#include "spritef.c" /* opaque = yes, flipx = no, flipy = yes */
		#undef  FLIPX
		#define FLIPX 1
			#include "spritef.c" /* opaque = yes, flipx = yes, flipy = yes */
		#undef  FLIPX
	#undef  FLIPY
#undef OPAQUE

/******************************************************************************/
#undef  SELF_INCLUDE
/******************************************************************************/

static void (*neo_draw_sprite_fast[2][4][16])(UINT32 *sprite, UINT16 *bm, UINT16 *paldata, int zy, int l) =
{
	{
		{
			draw_sprite_fast_0_0_1,  draw_sprite_fast_0_0_2,
			draw_sprite_fast_0_0_3,  draw_sprite_fast_0_0_4,
			draw_sprite_fast_0_0_5,  draw_sprite_fast_0_0_6,
			draw_sprite_fast_0_0_7,  draw_sprite_fast_0_0_8,
			draw_sprite_fast_0_0_9,  draw_sprite_fast_0_0_10,
			draw_sprite_fast_0_0_11, draw_sprite_fast_0_0_12,
			draw_sprite_fast_0_0_13, draw_sprite_fast_0_0_14,
			draw_sprite_fast_0_0_15, draw_sprite_fast_0_0_16
		},
		{
			draw_sprite_fast_0_1_1,  draw_sprite_fast_0_1_2,
			draw_sprite_fast_0_1_3,  draw_sprite_fast_0_1_4,
			draw_sprite_fast_0_1_5,  draw_sprite_fast_0_1_6,
			draw_sprite_fast_0_1_7,  draw_sprite_fast_0_1_8,
			draw_sprite_fast_0_1_9,  draw_sprite_fast_0_1_10,
			draw_sprite_fast_0_1_11, draw_sprite_fast_0_1_12,
			draw_sprite_fast_0_1_13, draw_sprite_fast_0_1_14,
			draw_sprite_fast_0_1_15, draw_sprite_fast_0_1_16
		},
		{
			draw_sprite_fast_0_2_1,  draw_sprite_fast_0_2_2,
			draw_sprite_fast_0_2_3,  draw_sprite_fast_0_2_4,
			draw_sprite_fast_0_2_5,  draw_sprite_fast_0_2_6,
			draw_sprite_fast_0_2_7,  draw_sprite_fast_0_2_8,
			draw_sprite_fast_0_2_9,  draw_sprite_fast_0_2_10,
			draw_sprite_fast_0_2_11, draw_sprite_fast_0_2_12,
			draw_sprite_fast_0_2_13, draw_sprite_fast_0_2_14,
			draw_sprite_fast_0_2_15, draw_sprite_fast_0_2_16
		},
		{
			draw_sprite_fast_0_3_1,  draw_sprite_fast_0_3_2,
			draw_sprite_fast_0_3_3,  draw_sprite_fast_0_3_4,
			draw_sprite_fast_0_3_5,  draw_sprite_fast_0_3_6,
			draw_sprite_fast_0_3_7,  draw_sprite_fast_0_3_8,
			draw_sprite_fast_0_3_9,  draw_sprite_fast_0_3_10,
			draw_sprite_fast_0_3_11, draw_sprite_fast_0_3_12,
			draw_sprite_fast_0_3_13, draw_sprite_fast_0_3_14,
			draw_sprite_fast_0_3_15, draw_sprite_fast_0_3_16
		}
	},
	{
		{
			draw_sprite_fast_1_0_1,  draw_sprite_fast_1_0_2,
			draw_sprite_fast_1_0_3,  draw_sprite_fast_1_0_4,
			draw_sprite_fast_1_0_5,  draw_sprite_fast_1_0_6,
			draw_sprite_fast_1_0_7,  draw_sprite_fast_1_0_8,
			draw_sprite_fast_1_0_9,  draw_sprite_fast_1_0_10,
			draw_sprite_fast_1_0_11, draw_sprite_fast_1_0_12,
			draw_sprite_fast_1_0_13, draw_sprite_fast_1_0_14,
			draw_sprite_fast_1_0_15, draw_sprite_fast_1_0_16
		},
		{
			draw_sprite_fast_1_1_1,  draw_sprite_fast_1_1_2,
			draw_sprite_fast_1_1_3,  draw_sprite_fast_1_1_4,
			draw_sprite_fast_1_1_5,  draw_sprite_fast_1_1_6,
			draw_sprite_fast_1_1_7,  draw_sprite_fast_1_1_8,
			draw_sprite_fast_1_1_9,  draw_sprite_fast_1_1_10,
			draw_sprite_fast_1_1_11, draw_sprite_fast_1_1_12,
			draw_sprite_fast_1_1_13, draw_sprite_fast_1_1_14,
			draw_sprite_fast_1_1_15, draw_sprite_fast_1_1_16
		},
		{
			draw_sprite_fast_1_2_1,  draw_sprite_fast_1_2_2,
			draw_sprite_fast_1_2_3,  draw_sprite_fast_1_2_4,
			draw_sprite_fast_1_2_5,  draw_sprite_fast_1_2_6,
			draw_sprite_fast_1_2_7,  draw_sprite_fast_1_2_8,
			draw_sprite_fast_1_2_9,  draw_sprite_fast_1_2_10,
			draw_sprite_fast_1_2_11, draw_sprite_fast_1_2_12,
			draw_sprite_fast_1_2_13, draw_sprite_fast_1_2_14,
			draw_sprite_fast_1_2_15, draw_sprite_fast_1_2_16
		},
		{
			draw_sprite_fast_1_3_1,  draw_sprite_fast_1_3_2,
			draw_sprite_fast_1_3_3,  draw_sprite_fast_1_3_4,
			draw_sprite_fast_1_3_5,  draw_sprite_fast_1_3_6,
			draw_sprite_fast_1_3_7,  draw_sprite_fast_1_3_8,
			draw_sprite_fast_1_3_9,  draw_sprite_fast_1_3_10,
			draw_sprite_fast_1_3_11, draw_sprite_fast_1_3_12,
			draw_sprite_fast_1_3_13, draw_sprite_fast_1_3_14,
			draw_sprite_fast_1_3_15, draw_sprite_fast_1_3_16
		}
	}
};


/******************************************************************************/

INLINE void neo_draw_gfx_fast(UINT16 **line, UINT16 *paldata, unsigned int code, 
		int flip, int sx, int sy, int zx, int zy, int opaque,
		const struct rectangle *clip)
{
	int oy, ey, skip, l = 0;
	UINT32 *fspr;

	oy = sy;
	ey = sy + zy - 1;

	if (sy < clip->min_y) sy = clip->min_y;
	if (ey > clip->max_y) ey = clip->max_y;

	zy = ey - sy + 1;
	skip = sy - oy;

#if ENABLE_SYSTEM_CHECK
	fspr = (UINT32 *)memory_region(REGION_GFX6);
#else
	fspr = (UINT32 *)memory_region(REGION_GFX2);
#endif

	if (flip & 0x02) /* Y flip */
	{
		fspr += (code + 1) * 32 - 2;

		while (skip)
		{
			fspr -= l_y_skip[l++];
			skip--;
		}
	}
	else
	{
		fspr += code * 32;

		while (skip)
		{
			fspr += l_y_skip[l++];
			skip--;
		}
	}

	(*neo_draw_sprite_fast[opaque][flip][zx])(fspr, line[sy] + sx, paldata, zy, l);
}


static void draw_sprites_fast(int start, int end, const struct rectangle *clip)
{
	int sx = 0, sy = 0, my = 0, zx = 0, zy = 0;
	int offs, count, y;
	int t1, t3;
	char fullmode = 0;
	UINT16 **line = scrbitmap.line;

	/* Draw sprites */
	for (count = start; count < end; count++)
	{
		int drawn_lines;

		t1 = neogeo_vidram16[(0x10400 >> 1) + count];
		t3 = neogeo_vidram16[(0x10000 >> 1) + count];

		/* If this bit is set this new column is placed next to last one */
		if (t1 & 0x40)
		{
			sx += zx + 1;
		}
		else /* nope it is a new block */
		{
			/* Number of tiles in this strip */
			my = t1 & 0x3f;

			if (my == 0x20)
				fullmode = 1;
			else if (my >= 0x21)
				fullmode = 2;	/* most games use 0x21, but  Alpha Mission II uses 0x3f */
			else
				fullmode = 0;

			/* Sprite scaling */
			zy = t3 & 0xff;

			if (zy < 0xff && my < 0x10)
			{
				my = my_tbl[zy][my];
			}
			else
			{
				if (my > 0x20) my = 0x20;
			}

			sy = 0x200 - (t1 >> 7);

			if (fullmode == 1 && zy == 0xff)
			{
				fullmode = 2;
			}

#if 0
			if (clip->max_y - clip->min_y > 8 ||	/* kludge to improve the ssideki games */
				clip->min_y == FIRST_VISIBLE_LINE)
			{
				if (sy > 0x100 + FIRST_VISIBLE_LINE)
					sy -= 0x200;

				if (fullmode == 2)
				{
					while (sy < 0) sy += 2 * (zy + 1);
				}
			}
#endif
			sx = neogeo_vidram16[(0x10800 >> 1) + count] >> 7;
		}

		/* Get new zoom for this column */
		zx = (t3 >> 8) & 0x0f;

		if (sx >= 0x1f0) sx -= 0x200;

		/* No point doing anything if tile strip is 0 */
		if (my == 0) continue;

		if (zy == 0) continue;

		if (sx >= 320) continue;

		offs = count << 6;
		drawn_lines = sy;

		/* my holds the number of tiles in each vertical multisprite block */
		for (y = 0; y < my; y++)
		{
			int zy2 = yskip[zy][y];

			switch (fullmode)
			{
			case 0: if (drawn_lines > 0x110) drawn_lines -= 0x200; break;
			case 1: if (y == 0x10) drawn_lines -= 2 * (zy + 1); break;
			case 2: if (drawn_lines >= 248) drawn_lines -= 2 * (zy + 1); break;
			}

			if (drawn_lines + zy2 > clip->min_y && drawn_lines <= clip->max_y)
			{
				int tileno  = neogeo_vidram16[offs++];
				int tileatr = neogeo_vidram16[offs++];

				if (tileatr & 0x8)
					tileno = (tileno & ~7) | (neogeo_frame_counter & 7);
				else
				if (tileatr & 0x4)
					tileno = (tileno & ~3) | (neogeo_frame_counter & 3);

				if (video_spr_usage[tileno])
				{
					int color = tileatr >> 8;

					l_y_skip = dda_y_skip[zy][y];

					neo_draw_gfx_fast(line,
						&video_palette[color << 4],
						tileno,
						tileatr & 0x03,
						sx, drawn_lines,
						zx, zy2,
						video_spr_usage[tileno] & 1,
						clip
					);
				}
			}
			else
			{
				offs += 2;
			}

			drawn_lines += zy2;
		}
	}
}


/******************************************************************************/

static void neogeo_init_sprite(void)
{
	int i, j, my, zy, line;
	int tile1, tile0, yoffs1, yoffs0;
	UINT8 *zoomy_rom;

	for (zy = 0; zy <= 0xff; zy++)
	{
		zoomy_rom = memory_region(REGION_GFX3) + (zy << 8);
		line = 0;

		for (i = 0; i < 0x10; i++)
		{
			yskip[zy][i] = 0;
			dda_y_skip[zy][i][0] = 0x10;

			for (j = 1; j < 0x10; j++)
			{
				dda_y_skip[zy][i][j] = 0;
			}
		}

		for (i = 0; i < zy + 1; i++)
		{
			yoffs1 = zoomy_rom[i] & 0x0f;
			tile1 = zoomy_rom[i] >> 4;

			if (line == 0)
			{
				dda_y_skip[zy][tile1][0] = yoffs1;
				yskip[zy][tile1]++;
				line = 1;
			}
			else
			{
				yoffs0 = zoomy_rom[i - 1] & 0x0f;
				tile0 = zoomy_rom[i - 1] >> 4;

				if (tile1 == tile0)
				{
					dda_y_skip[zy][tile1][line] = yoffs1 - yoffs0;
					yskip[zy][tile1]++;
					line++;
				}
				else
				{
					dda_y_skip[zy][tile0][line] = 0x10 - yoffs0;
					dda_y_skip[zy][tile1][0] = yoffs1;
					yskip[zy][tile1]++;
					line = 1;
				}
			}

			if (i == zy)
			{
				dda_y_skip[zy][tile1][line] = 0x10 - yoffs1;
			}
		}

#if 0
		for (my = 0; my < 0x10; my++)
		{
			if (zoomy_rom[my * 0x10] == 0xff)
				my_tbl[zy][my] = 0x10;
			else
				my_tbl[zy][my] = zoomy_rom[my * 0x10] >> 4;
		}
#else
		for (my = 0; my < 0x10; my++)
		{
			my_tbl[zy][my] = ((my * 16 * 256) / (zy + 1) + 15) / 16;
			if (my_tbl[zy][my] > 0x10)
				my_tbl[zy][my] = 0x10;
		}
#endif
	}

	for (zy = 0; zy <= 0xff; zy++)
	{
		for (my = 0x10; my <= 0x20; my++)
		{
			yskip[zy][my] = yskip[zy][my - 0x10];

			for (line = 0; line <= yskip[zy][my]; line++)
			{
				dda_y_skip[zy][my][line] = dda_y_skip[zy][my - 0x10][line];
			}
		}
	}

	for (zy = 0; zy < 0x100; zy++)
	{
		for (my = 0; my < 0x21; my++)
		{
			for (line = 0; line < 17; line++)
			{
				dda_y_skip[zy][my][line] *= 2;
			}
		}
	}
}

#undef ARG

/******************************************************************************/

#else	/* SELF_INCLUDE */

#define TILE(x)			tile = sprite[x];

#if (OPAQUE == 0)

#define B0(x, shift)	if (tile & 0x0f) bm[x] = paldata[tile & 0x0f];
#define BX(x, shift)	tile >>= (shift*4); B0(x, 0);

#if (FLIPX == 0 && FLIPY == 0)
#define FUNC_START(zx)	static void draw_sprite_fast_0_0_##zx(ARGSF)
#elif (FLIPX == 1 && FLIPY == 0)
#define FUNC_START(zx)	static void draw_sprite_fast_0_1_##zx(ARGSF)
#elif (FLIPX == 0 && FLIPY == 1)
#define FUNC_START(zx)	static void draw_sprite_fast_0_2_##zx(ARGSF)
#else
#define FUNC_START(zx)	static void draw_sprite_fast_0_3_##zx(ARGSF)
#endif

#else /* OPAQUE */

#define B0(x, shift)	bm[x] = paldata[tile & 0x0f];
#define BX(x, shift)	tile >>= (shift*4); B0(x, 0);

#if (FLIPX == 0 && FLIPY == 0)
#define FUNC_START(zx)	static void draw_sprite_fast_1_0_##zx(ARGSF)
#elif (FLIPX == 1 && FLIPY == 0)
#define FUNC_START(zx)	static void draw_sprite_fast_1_1_##zx(ARGSF)
#elif (FLIPX == 0 && FLIPY == 1)
#define FUNC_START(zx)	static void draw_sprite_fast_1_2_##zx(ARGSF)
#else
#define FUNC_START(zx)	static void draw_sprite_fast_1_3_##zx(ARGSF)
#endif

#endif /* OPAQUE */

#if (FLIPY == 0)

#define UPDATE_SPRITE_POS								\
{														\
	UINT32 tile;										\
														\
	while (zy--)										\
	{													\
		sprite += l_y_skip[l++];

#else /* FLIPY */

#define UPDATE_SPRITE_POS								\
{														\
	UINT32 tile;										\
														\
	while (zy--)										\
	{													\
		sprite -= l_y_skip[l++];

#endif /* FLIPY */

#define FUNC_END										\
		bm += line_gap;									\
	}													\
}


/*--------------------------------------------*/
/*  1 : -------- O------- :          0        */
/*  2 : ----O--- O------- :     4    0        */
/*  3 : ----O--- O---O--- :     4    0   4    */
/*  4 : --O-O--- O---O--- :   2 2    0   4    */
/*  5 : --O-O--- O---O-O- :   2 2    0   4 2  */
/*  6 : --O-O-O- O---O-O- :   2 2 2  0   4 2  */
/*  7 : --O-O-O- O-O-O-O- :   2 2 2  0 2 2 2  */
/*  8 : O-O-O-O- O-O-O-O- : 0 2 2 2  0 2 2 2  */
/*  9 : O-O-O-O- OOO-O-O- : 0 2 2 2  011 2 2  */
/* 10 : O-OOO-O- OOO-O-O- : 0 211 2  011 2 2  */
/* 11 : O-OOO-O- OOO-O-OO : 0 211 2  011 2 21 */
/* 12 : O-OOO-OO OOO-O-OO : 0 211 21 011 2 21 */
/* 13 : O-OOO-OO OOO-OOOO : 0 211 21 011 2111 */
/* 14 : OOOOO-OO OOO-OOOO : 01111 21 011 2111 */
/* 15 : OOOOO-OO OOOOOOOO : 01111 21 01111111 */
/* 16 : OOOOOOOO OOOOOOOO : 01111111 01111111 */
/*--------------------------------------------*/

#if (FLIPX == 0)

FUNC_START(1)
	UPDATE_SPRITE_POS
	TILE(1) B0( 0,0)
FUNC_END

FUNC_START(2)
	UPDATE_SPRITE_POS
	TILE(0) BX( 0,4)
	TILE(1) B0( 1,0)
FUNC_END

FUNC_START(3)
	UPDATE_SPRITE_POS
	TILE(0) BX( 0,4)
	TILE(1) B0( 1,0) BX( 2,4)
FUNC_END

FUNC_START(4)
	UPDATE_SPRITE_POS
	TILE(0) BX( 0,2) BX( 1,2)
	TILE(1) B0( 2,0) BX( 3,4)
FUNC_END

FUNC_START(5)
	UPDATE_SPRITE_POS
	TILE(0) BX( 0,2) BX( 1,2)
	TILE(1) B0( 2,0) BX( 3,4) BX( 4,2)
FUNC_END

FUNC_START(6)
	UPDATE_SPRITE_POS
	TILE(0) BX( 0,2) BX( 1,2) BX( 2,2)
	TILE(1) B0( 3,0) BX( 4,4) BX( 5,2)
FUNC_END

FUNC_START(7)
	UPDATE_SPRITE_POS
	TILE(0) BX( 0,2) BX( 1,2) BX( 2,2)
	TILE(1) B0( 3,0) BX( 4,2) BX( 5,2) BX( 6,2)
FUNC_END

FUNC_START(8)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,2) BX( 2,2) BX( 3,2)
	TILE(1) B0( 4,0) BX( 5,2) BX( 6,2) BX( 7,2)
FUNC_END

FUNC_START(9)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,2) BX( 2,2) BX( 3,2)
	TILE(1) B0( 4,0) BX( 5,1) BX( 6,1) BX( 7,2) BX( 8,2)
FUNC_END

FUNC_START(10)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,2) BX( 2,1) BX( 3,1) BX( 4,2)
	TILE(1) B0( 5,0) BX( 6,1) BX( 7,1) BX( 8,2) BX( 9,2)
FUNC_END

FUNC_START(11)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,2) BX( 2,1) BX( 3,1) BX( 4,2)
	TILE(1) B0( 5,0) BX( 6,1) BX( 7,1) BX( 8,2) BX( 9,2) BX(10,1)
FUNC_END

FUNC_START(12)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,2) BX( 2,1) BX( 3,1) BX( 4,2) BX( 5,1)
	TILE(1) B0( 6,0) BX( 7,1) BX( 8,1) BX( 9,2) BX(10,2) BX(11,1)
FUNC_END

FUNC_START(13)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,2) BX( 2,1) BX( 3,1) BX( 4,2) BX( 5,1)
	TILE(1) B0( 6,0) BX( 7,1) BX( 8,1) BX( 9,2) BX(10,1) BX(11,1) BX(12,1)
FUNC_END

FUNC_START(14)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,1) BX( 2,1) BX( 3,1) BX( 4,1) BX( 5,2) BX( 6,1)
	TILE(1) B0( 7,0) BX( 8,1) BX( 9,1) BX(10,2) BX(11,1) BX(12,1) BX(13,1)
FUNC_END

FUNC_START(15)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,1) BX( 2,1) BX( 3,1) BX( 4,1) BX( 5,2) BX( 6,1)
	TILE(1) B0( 7,0) BX( 8,1) BX( 9,1) BX(10,1) BX(11,1) BX(12,1) BX(13,1) BX(14,1)
FUNC_END

FUNC_START(16)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,1) BX( 2,1) BX( 3,1) BX( 4,1) BX( 5,1) BX( 6,1) BX( 7,1)
	TILE(1) B0( 8,0) BX( 9,1) BX(10,1) BX(11,1) BX(12,1) BX(13,1) BX(14,1) BX(15,1)
FUNC_END

#else /* FLIPX */

FUNC_START(1)
	UPDATE_SPRITE_POS
	TILE(1) B0( 0,0)
FUNC_END

FUNC_START(2)
	UPDATE_SPRITE_POS
	TILE(0) BX( 1,4)
	TILE(1) B0( 0,0)
FUNC_END

FUNC_START(3)
	UPDATE_SPRITE_POS
	TILE(0) BX( 2,4)
	TILE(1) B0( 1,0) BX( 0,4)
FUNC_END

FUNC_START(4)
	UPDATE_SPRITE_POS
	TILE(0) BX( 3,2) BX( 2,2)
	TILE(1) B0( 1,0) BX( 0,4)
FUNC_END

FUNC_START(5)
	UPDATE_SPRITE_POS
	TILE(0) BX( 4,2) BX( 3,2)
	TILE(1) B0( 2,0) BX( 1,4) BX( 0,2)
FUNC_END

FUNC_START(6)
	UPDATE_SPRITE_POS
	TILE(0) BX( 5,2) BX( 4,2) BX( 3,2)
	TILE(1) B0( 2,0) BX( 1,4) BX( 0,2)
FUNC_END

FUNC_START(7)
	UPDATE_SPRITE_POS
	TILE(0) BX( 6,2) BX( 5,2) BX( 4,2)
	TILE(1) B0( 3,0) BX( 2,2) BX( 1,2) BX( 0,2)
FUNC_END

FUNC_START(8)
	UPDATE_SPRITE_POS
	TILE(0) B0( 7,0) BX( 6,2) BX( 5,2) BX( 4,2)
	TILE(1) B0( 3,0) BX( 2,2) BX( 1,2) BX( 0,2)
FUNC_END

FUNC_START(9)
	UPDATE_SPRITE_POS
	TILE(0) B0( 8,0) BX( 7,2) BX( 6,2) BX( 5,2)
	TILE(1) B0( 4,0) BX( 3,1) BX( 2,1) BX( 1,2) BX( 0,2)
FUNC_END

FUNC_START(10)
	UPDATE_SPRITE_POS
	TILE(0) B0( 9,0) BX( 8,2) BX( 7,1) BX( 6,1) BX( 5,2)
	TILE(1) B0( 4,0) BX( 3,1) BX( 2,1) BX( 1,2) BX( 0,2)
FUNC_END

FUNC_START(11)
	UPDATE_SPRITE_POS
	TILE(0) B0(10,0) BX( 9,2) BX( 8,1) BX( 7,1) BX( 6,2)
	TILE(1) B0( 5,0) BX( 4,1) BX( 3,1) BX( 2,2) BX( 1,2) BX( 0,1)
FUNC_END

FUNC_START(12)
	UPDATE_SPRITE_POS
	TILE(0) B0(11,0) BX(10,2) BX( 9,1) BX( 8,1) BX( 7,2) BX( 6,1)
	TILE(1) B0( 5,0) BX( 4,1) BX( 3,1) BX( 2,2) BX( 1,2) BX( 0,1)
FUNC_END

FUNC_START(13)
	UPDATE_SPRITE_POS
	TILE(0) B0(12,0) BX(11,2) BX(10,1) BX( 9,1) BX( 8,2) BX( 7,1)
	TILE(1) B0( 6,0) BX( 5,1) BX( 4,1) BX( 3,2) BX( 2,1) BX( 1,1) BX( 0,1)
FUNC_END

FUNC_START(14)
	UPDATE_SPRITE_POS
	TILE(0) B0(13,0) BX(12,1) BX(11,1) BX(10,1) BX( 9,1) BX( 8,2) BX( 7,1)
	TILE(1) B0( 6,0) BX( 5,1) BX( 4,1) BX( 3,2) BX( 2,1) BX( 1,1) BX( 0,1)
FUNC_END

FUNC_START(15)
	UPDATE_SPRITE_POS
	TILE(0) B0(14,0) BX(13,1) BX(12,1) BX(11,1) BX(10,1) BX( 9,2) BX( 8,1)
	TILE(1) B0( 7,0) BX( 6,1) BX( 5,1) BX( 4,1) BX( 3,1) BX( 2,1) BX( 1,1) BX( 0,1)
FUNC_END

FUNC_START(16)
	UPDATE_SPRITE_POS
	TILE(0) B0(15,0) BX(14,1) BX(13,1) BX(12,1) BX(11,1) BX(10,1) BX( 9,1) BX( 8,1)
	TILE(1) B0( 7,0) BX( 6,1) BX( 5,1) BX( 4,1) BX( 3,1) BX( 2,1) BX( 1,1) BX( 0,1)
FUNC_END

#endif /* FLIPX */

#undef FUNC_START
#undef FUNC_END
#undef UPDATE_SPRITE_POS
#undef TILE
#undef B0
#undef BX

#endif /* SELF_INCLUDE */
