/***************************************************************************

  ym2610.h

  Header file for software emulation for YAMAHA YM-2610 sound generator

***************************************************************************/

#ifndef _YM2610_H_
#define _YM2610_H_

/* support OPN SSG type envelope mode */
#define FM_SEG_SUPPORT 0

/* for busy flag emulation , function FM_GET_TIME_NOW() should be */
/* return the present time in second unit with (double) value     */
/* in timer.c */
#define FM_GET_TIME_NOW() timer_get_time()

#define YM2610_NUMBUF 2  /* Left + Right */

typedef INT16  FMSAMPLE;
typedef UINT32 FMSAMPLE_MIX;

typedef void (*FM_TIMERHANDLER)(int channel, int count, double stepTime);
typedef void (*FM_IRQHANDLER)(int irq);

int  YM2610Init(int baseclock, int rate,
				void *pcmroma, int pcmasize,
				FM_TIMERHANDLER TimerHandler,
				FM_IRQHANDLER IRQHandler);

void  YM2610Reset(void);
void  YM2610Update(INT16 **buffer, int length);
int   YM2610Write(int addr, UINT8 value);
UINT8 YM2610Read(int addr);
int   YM2610TimerOver(int channel);

#endif /* _YM2610_H_ */
