/***************************************************************************

	cdrom.c

	NEOGEO CD CD-ROM

***************************************************************************/

#ifndef NEOGEO_CDROM_H
#define NEOGEO_CDROM_H

#define CDROM_NOTEXIST  0x000
#define CDROM_READY		0x001
#define CDROM_NOTREADY	0x002
#define CDROM_TRAYOPEN	0x010

enum {
	CDROM_IDLE = 0,
	CDROM_LOADING,
	CDROM_DONE,
	CDROM_LOADING_STATE_MAX
};


extern int cdrom_current_drive;
extern int cdrom_loading_state;
extern int cdrom_ipl_loading;

int  cdrom_init(void);
void cdrom_shutdown(void);
int  cdrom_check_state(int drive);
int  cdrom_get_state(int drive);
void cdrom_abort_loading(void);
int  cdrom_process_ipl(void);
void cdrom_load_files(void);
void cdrom_finish_load_files(void);
void cdrom_load_next_data(void);
int  cdrom_verify_disc(int drive);

#endif /* NEOGEO_CDROM_H */
