/***************************************************************************

	input.c

	̓foCX

***************************************************************************/

#ifndef INPUT_H
#define INPUT_H

#define MAX_PLAYER 2
#define MAX_BUTTON 14

#define PLAYER1		0
#define PLAYER2		1

#define UI_PLAYER1  1
#define UI_PLAYER2  2
#define UI_KEYBOARD 4
#define UI_JOYSTICK 8

#define UI_ALL      (UI_PLAYER1|UI_PLAYER2|UI_KEYBOARD|UI_JOYSTICK)
#define UI_KEYONLY  (UI_PLAYER1|UI_PLAYER2|UI_KEYBOARD)
#define UI_JOYONLY  (UI_PLAYER1|UI_PLAYER2|UI_JOYSTICK)
#define UI_P1ONLY   (UI_PLAYER1|UI_KEYBOARD|UI_JOYSTICK)
#define UI_P2ONLY   (UI_PLAYER2|UI_KEYBOARD|UI_JOYSTICK)

enum
{
	INPUT_UP = 0,
	INPUT_DOWN,
	INPUT_LEFT,
	INPUT_RIGHT,
	INPUT_SELECT,
	INPUT_CANCEL,
	INPUT_MAX
};

extern int key_code[MAX_PLAYER][MAX_BUTTON];
extern int joy_code[MAX_PLAYER][MAX_BUTTON];

int  input_init(void);
void input_shutdown(void);
void input_reset(void);

void update_input_port(void);
void update_autofire_flag(void);

void build_hotkey(void);

UINT16 read_controler1(void);
UINT16 read_controler2(void);

int input_ui_pressed(int code, int flag);
void input_ui_wait_keyclear(int interval);

#endif /* INPUT_H */
