/***************************************************************************

	z80intf.c

	Handling RAZE Z80 core.

***************************************************************************/

#ifndef Z80INTF_H
#define Z80INTF_H

#include "raze.h"

enum {
	Z80_PC=1, Z80_SP, Z80_AF, Z80_BC, Z80_DE, Z80_HL,
	Z80_IX, Z80_IY,	Z80_AF2, Z80_BC2, Z80_DE2, Z80_HL2,
	Z80_R, Z80_I, Z80_IM, Z80_IFF1, Z80_IFF2, Z80_HALT,
	Z80_NMI_STATE, Z80_IRQ_STATE, Z80_DC0, Z80_DC1, Z80_DC2, Z80_DC3
};

extern int z80_ICount;

void z80_init(void);
void z80_reset(int param);
void z80_exit(void);
int  z80_execute(int cycles);
void z80_burn(int cycles);
void z80_set_irq_line(int irqline, int state);
void z80_set_irq_callback(int (*callback)(int irqline));
void z80_enable(int enable);
void z80_save_context(void);
void z80_restore_context(void);

#endif /* Z80INTF_H */
