/***************************************************************************

	m68000.h

	M68000 CPU C^[tFCXpwb_	(ASM/Cp)

***************************************************************************/

#ifndef M68000__HEADER
#define M68000__HEADER

#include "osd_cpu.h"

enum
{
	/* NOTE: M68K_SP fetches the current SP, be it USP, ISP, or MSP */
	M68K_PC=1, M68K_SP, M68K_ISP, M68K_USP, M68K_MSP, M68K_SR, M68K_VBR,
	M68K_SFC, M68K_DFC, M68K_CACR, M68K_CAAR, M68K_PREF_ADDR, M68K_PREF_DATA,
	M68K_D0, M68K_D1, M68K_D2, M68K_D3, M68K_D4, M68K_D5, M68K_D6, M68K_D7,
	M68K_A0, M68K_A1, M68K_A2, M68K_A3, M68K_A4, M68K_A5, M68K_A6, M68K_A7
};

extern int m68k_ICount;

/* Redirect memory calls */

struct m68k_memory_interface
{
	offs_t		opcode_xor;						// Address Calculation
	UINT8		(*read8)(offs_t);				// Normal read 8 bit
	UINT16		(*read16)(offs_t);				// Normal read 16 bit
	UINT32		(*read32)(offs_t);				// Normal read 32 bit
	void		(*write8)(offs_t, UINT8);		// Write 8 bit
	void		(*write16)(offs_t, UINT16);		// Write 16 bit
	void		(*write32)(offs_t, UINT32);		// Write 32 bit
	void		(*changepc)(offs_t);			// Change PC routine

    // For Encrypted Stuff

	UINT8		(*read8pc)(offs_t);				// PC Relative read 8 bit
	UINT16		(*read16pc)(offs_t);			// PC Relative read 16 bit
	UINT32		(*read32pc)(offs_t);			// PC Relative read 32 bit

	UINT16		(*read16d)(offs_t);				// Direct read 16 bit
	UINT32		(*read32d)(offs_t);				// Direct read 32 bit
};

/* The MAME API for MC68000 */

#define MC68000_INT_NONE 0
#define MC68000_IRQ_1    1
#define MC68000_IRQ_2    2
#define MC68000_IRQ_3    3
#define MC68000_IRQ_4    4
#define MC68000_IRQ_5    5
#define MC68000_IRQ_6    6
#define MC68000_IRQ_7    7

#define MC68000_INT_ACK_AUTOVECTOR    -1
#define MC68000_INT_ACK_SPURIOUS      -2

#define m68000_ICount  m68k_ICount

#ifdef A68K0
extern const struct m68k_memory_interface a68k_memory_intf;

#define m68k_read_memory_8(address)          (*a68k_memory_intf.read8)(address)
#define m68k_read_memory_16(address)         (*a68k_memory_intf.read16)(address)
#define m68k_read_memory_32(address)         (*a68k_memory_intf.read32)(address)

#define m68k_write_memory_8(address, value)  (*a68k_memory_intf.write8)(address, value)
#define m68k_write_memory_16(address, value) (*a68k_memory_intf.write16)(address, value)
#define m68k_write_memory_32(address, value) (*a68k_memory_intf.write32)(address, value)
#endif

extern void m68000_init(void);
extern void m68000_reset(int param);
extern void m68000_exit(void);
extern int  m68000_execute(int cycles);
extern void m68000_set_irq_line(int irqline, int state);
extern unsigned m68000_get_reg(int regnum);
extern void m68000_set_reg(int regnum, unsigned value);
extern void m68000_set_irq_callback(int (*callback)(int irqline));
void m68000_save_context(void);
void m68000_restore_context(void);

#if (M68K_DEBUG == 1)
extern unsigned m68000_dasm(char *buffer, unsigned pc);
#endif

#ifndef A68K0
// C Core header
#include "m68kncdz.h"
#endif

#endif /* M68000__HEADER */
