/***************************************************************************

	win32.c

	32bit Windowsˑ

***************************************************************************/

#ifndef WIN32APP_H
#define WIN32APP_H

#include "osdepend.h"

#ifndef APPNAME
#define APPNAME "NEOGEO CDZ Emulator"
#endif

#ifndef APPVER
#define APPVER  "2005.12.25"
#endif


#define HANDLE_MESSAGE(hwnd, message, fn)                               \
    case (message):                                                     \
    {                                                                   \
        *pResult = HANDLE_##message((hwnd), (wParam), (lParam), (fn));  \
        return TRUE;                                                    \
    }

#define PEEK_MESSAGE(hwnd, message, fn)                                 \
    case (message):                                                     \
    {                                                                   \
        *pResult = HANDLE_##message((hwnd), (wParam), (lParam), (fn));  \
        return FALSE;                                                   \
    }


struct tMyApp
{
    HWND               m_hwndUI;
    HWND               m_hWnd;
    HICON              m_hIcon;
    HCURSOR            m_hCursor;
    const char         *m_Name;

    BOOL               m_bIsInitialized;
    BOOL               m_bIsActive;
    BOOL               m_bAutoPaused;
    int                m_nState;

    void               (*ProcessMessages)(void);
    BOOL               (*PumpAndReturnMessage)(MSG *pMsg);
    void               (*HandleAutoPause)(void);
};


extern struct tMyApp MyApp;

#endif /* WIN32APP_H */
