/***************************************************************************

	osd_video.c

	OSˑʕ`揈

***************************************************************************/

#include "neogeocd.h"
#include <ddraw.h>
#include <math.h>
#include <malloc.h>
#include "ticker.h"
#include "DirectDraw.h"
#include "blit.h"
#include "osd_video.h"


#define MAX_PALETTE			16
#define MAX_SCREEN			2

#define FLAG_INITIALIZING  (1 << 0)
#define FLAG_MINIMIZED     (1 << 1)
#define FLAG_RESIZED       (1 << 2)
#define FLAG_MOVED         (1 << 3)
#define FLAG_PAINTING      (1 << 4)
#define FLAG_LOSTFORCUS    (1 << 5)
#define FLAG_FULLSCREEN    (1 << 6)
#define FLAG_MODECHANGE    (1 << 7)

#define FRAMESKIP_LEVELS  12
#define FRAMES_TO_SKIP    20

// Platform SDKHANDLE_WM_SIZINGo^ĂȂ̂
#ifndef HANDLE_WM_SIZING
#define HANDLE_WM_SIZING(hwnd, wParam, lParam, fn) \
  (fn)((hwnd), (int)(wParam), (LPRECT)(lParam))
#endif


/***************************************************************************
	}N
 ***************************************************************************/

// w肳ꂽrgb̋Px̃sNZf[^쐬
#define MAKECOL(r, g, b)	(((r & 0xff) >> (8 - Red.m_nSize))   << Red.m_nShift   | \
							 ((g & 0xff) >> (8 - Green.m_nSize)) << Green.m_nShift | \
							 ((b & 0xff) >> (8 - Blue.m_nSize))  << Blue.m_nShift)

// w肳ꂽrgb̋Px̃sNZf[^쐬 (15bitpbgQƃe[up)
#define MAKECOL15(r, g, b)	(((r & 0xf8) << 7) | ((g & 0xf8) << 2) | ((b & 0xf8) >> 3))

// colŎw肳ꂽsNZf[^RGBɕ
#define GETR(col)			(((col & Red.m_dwMask  ) >> Red.m_nShift  )) << (8 - Red.m_nSize  )
#define GETG(col)			(((col & Green.m_dwMask) >> Green.m_nShift)) << (8 - Green.m_nSize)
#define GETB(col)			(((col & Blue.m_dwMask ) >> Blue.m_nShift )) << (8 - Blue.m_nSize )

// colŎw肳ꂽsNZf[^RGBɕ (15bitpbgQƃe[up)
#define GETR15(col)			((((col >> 10) & 0x1f) << 3) | ((col >> 12) & 0x07))
#define GETG15(col)			((((col >>  5) & 0x1f) << 3) | ((col >>  7) & 0x07))
#define GETB15(col)			((((col >>  0) & 0x1f) << 3) | ((col >>  2) & 0x07))


/***************************************************************************
	[J\
 ***************************************************************************/

typedef struct
{
    DWORD   m_Top;
    DWORD   m_Left;
    DWORD   m_Width;
    DWORD   m_Height;
} tRect;

struct tPixelInfo
{
	int		m_nShift;
	int		m_nSize;
	DWORD	m_dwMask;
};

struct tPaletteList
{
	UINT16	*palette;
	DWORD	size;
};

/***************************************************************************
	O[oϐ
 ***************************************************************************/

UINT32 *palette_lookup;
struct osd_bitmap scrbitmap;

/***************************************************************************
	[Jϐ
 ***************************************************************************/

// Ԍvp
static int					showfps;
static int					showfpstemp;
static char					fpsbuf[128];
static int					throttle;
static int					autoframeskip;
static int					frameskip;
static int					frameskip_counter;
static int					frameskipadjust;
static double				speed;
static double				ticks_per_frame;
static TICKER				prev_measure;
static TICKER				this_frame_base;
static TICKER				prev;
static int					frames_displayed;
static TICKER				start_time;
static TICKER				end_time;

// `̈
static tRect				visible_rect;
static RECT					rectPrimary;
static RECT					rectBack;
static int					screen_width;
static int					screen_height;
static int					adjusted_width;
static int					adjusted_height;

// EBhE
static DWORD				dwWindowStatus;

// IvV
static BOOL                sw_stretch2x;
static BOOL                scanlines;
static int                 scanline_brightness;
static BOOL                use_back_buffer;
static int                 hw_stretch;
static BOOL                triple_buffer;
static DWORD               flip_mode;
static BOOL                wait_vsync;
static int                 sleep_time;
static BOOL                use_system_memory;
static BOOL                emulation_mode;
static BOOL                enable_mmx;
static BOOL                enable_sse;
static BOOL                adjust_refreshrate;

// pbgAJ[
static struct tPaletteList	PaletteList[MAX_PALETTE];
static int					nPaletteNum;
static UINT16				*palette_lookup15;
static int					bytes_per_pixel;
static struct tPixelInfo	Red;
static struct tPixelInfo	Green;
static struct tPixelInfo	Blue;

// DirectDraw֘A
static IDirectDraw2			*pDDraw;
static IDirectDrawSurface	*pDDSFlip;
static IDirectDrawSurface	*pDDSPrimary;
static IDirectDrawSurface	*pDDSBack;
static IDirectDrawClipper	*pDDClipper;

// rbg}bv֘A
static struct osd_bitmap	*pVideoScreen[MAX_SCREEN];
static int					nScreenNum;
static BYTE					*pBitmapOffset;
static int					nBitmapPitch;
static BYTE					*pSurfaceOffset;
static int					nSurfacePitch;

// rbg}bv]֐
static bliter_func			bliter;

static int					resized_width;
static int					resized_height;


/***************************************************************************
	vg^Cv
 ***************************************************************************/

static void	VideoReset(void);
static int	AdjustVisibleRect(int min_x, int min_y, int max_x, int max_y);
static void	GetPixelInfo(DWORD dwMask, struct tPixelInfo* pPixelInfo);
static BOOL	FindDisplayMode(DWORD dwWidthIn, DWORD dwHeightIn, DWORD *pdwWidthOut, DWORD *pdwHeightOut);

static void	DrawSurface(int flag);
static void	ClearSurface(IDirectDrawSurface *pddSurface);
static BOOL	LockSurface(IDirectDrawSurface *pddSurface);
INLINE BOOL	UnlockSurface(IDirectDrawSurface *pddSurface);
static BOOL	RestoreSurface(void);

static BOOL	CheckVSync(void);
static void	CalcVBlank(void);

static void	CheckScreenRect(void);
static void	RefreshScreen(void);

static void	OnActivateApp(HWND hWnd, BOOL fActivate, DWORD dwThreadId);
static BOOL OnMove(HWND hWnd, WPARAM wParam, DWORD pos);
static BOOL	OnSize(HWND hWnd, int state, int cx, int cy);
static BOOL	OnSizing(HWND hWnd, int status, LPRECT rect);
static BOOL	OnPaint(HWND hWnd);
static BOOL	OnSetCursor(HWND hWnd, HWND hWndCursor, UINT codeHitTest, UINT msg);


/***************************************************************************
	O[o֐
 ***************************************************************************/

/*--------------------------------------------------------

	OSˑ̉ʏ

	  : Ȃ
	߂l: :OSD_OK  s:OSD_ERROR

 -------------------------------------------------------*/

int osd_video_init(int width, int height, struct rectangle *rect)
{
	nScreenNum          = 0;
	nPaletteNum         = 0;
	dwWindowStatus		= FLAG_INITIALIZING;

	// 񏉊Kvȕϐ̏
	VideoReset();

	// pbgQƃe[ům
	palette_lookup = (UINT32 *)malloc(sizeof(UINT32) * 32768);
	if (palette_lookup == NULL)
	{
		logerror("Could not allocate palette lookup table.\n");
		return OSD_ERROR;
	}

	// ʐ؂ւp15bitpbgQƃe[ům
	palette_lookup15 = (UINT16 *)malloc(sizeof(UINT16) * 32768);
	if (palette_lookup15 == NULL)
	{
		logerror("Could not allocate palette lookup table.\n");
		goto error1;
	}

	// z񓙂̏
	memset(pVideoScreen, 0, sizeof(pVideoScreen));
	memset(&PaletteList, 0, sizeof(PaletteList));
	memset(palette_lookup, 0, sizeof(UINT32) * 32768);
	memset(palette_lookup15, 0, sizeof(UINT16) * 32768);
	memset(&scrbitmap, 0, sizeof(struct osd_bitmap));
	memset(&Red,   0, sizeof(struct tPixelInfo));
	memset(&Green, 0, sizeof(struct tPixelInfo));
	memset(&Blue,  0, sizeof(struct tPixelInfo));
	memset(fpsbuf, 0, 64);

	// XN[̕\GAݒ
	visible_rect.m_Left   = rect->min_x;
	visible_rect.m_Top    = rect->min_y;
	visible_rect.m_Width  = (rect->max_x - rect->min_x) + 1;
	visible_rect.m_Height = (rect->max_y - rect->min_y) + 1;

	// XN[̊m
	if (osd_create_screen(width, height) == OSD_ERROR)
	{
		logerror("Could not allocate screen bitmap.\n");
		goto error2;
	}
	osd_set_screen(OSD_SCREEN);

	// fBXvC̍쐬
	if (osd_create_display(rect->min_x, rect->min_y, rect->max_x, rect->max_y) == OSD_OK)
		return OSD_OK;

	logerror("Could not create display.\n");
	osd_free_screen(OSD_SCREEN);
error2:
	free(palette_lookup15);
	palette_lookup15 = NULL;
error1:
	free(palette_lookup);
	palette_lookup = NULL;

	return OSD_ERROR;
}


/*--------------------------------------------------------

	OSˑ̉ʏI

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

void osd_video_exit(void)
{
	int i;

	dwWindowStatus = FLAG_INITIALIZING;

	ShowWindow(MyApp.m_hWnd, SW_HIDE);

	osd_close_display();

	for (i = 0; i < MAX_SCREEN; i++)
	{
		if (pVideoScreen[i] != NULL)
			osd_free_bitmap(pVideoScreen[i]);
	}

	if (palette_lookup15)
	{
		free(palette_lookup15);
		palette_lookup15 = NULL;
	}

	if (palette_lookup)
	{
		free(palette_lookup);
		palette_lookup = NULL;
	}

	memset(&PaletteList, 0, sizeof(PaletteList));

	if (frames_displayed > FRAMES_TO_SKIP)
		logerror("Avarage FPS: %f\n",  (double)TICKS_PER_SEC / (end_time - start_time) * (frames_displayed - FRAMES_TO_SKIP));
}


/*--------------------------------------------------------

	ėprbg}bv̊m

	  : int width   rbg}bv̕
	        int height  rbg}bv̍
	߂l: rbg}bṽ|C^

 -------------------------------------------------------*/

struct osd_bitmap *osd_alloc_bitmap(int width, int height)
{
	struct osd_bitmap *bitmap;

	bitmap = (struct osd_bitmap *)_aligned_malloc(sizeof(struct osd_bitmap), 32);

	if (bitmap)
	{
		UINT16 *bm;
		int    i;

		bitmap->width  = width;
		bitmap->height = height;
		width += 16;

		bm = (UINT16 *)_aligned_malloc((height + 2 * 16) * width * sizeof(UINT16), 32);
		if (bm == NULL)
		{
			_aligned_free(bitmap);
			return NULL;
		}

		memset(bm, 0, height * width * sizeof(UINT16));

		bitmap->line = (UINT16 **)_aligned_malloc((height + 2 * 16) * sizeof(UINT16 *), 32);
		if (bitmap->line == NULL)
		{
			_aligned_free(bm);
			_aligned_free(bitmap);
			return NULL;
		}

		for (i = 0; i < height + 2 * 16; i++)
			bitmap->line[i] = &bm[i * width];
		bitmap->line += 16;
		bitmap->_private = bm;
	}

	return bitmap;
}


/*--------------------------------------------------------

	rbg}bv̉

	  : struct osd_bitmap *bitmap rbg}bv
	߂l: Ȃ

 -------------------------------------------------------*/

void osd_free_bitmap(struct osd_bitmap *bitmap)
{
	if (bitmap)
	{
		bitmap->line -= 16;
		_aligned_free(bitmap->line);
		_aligned_free(bitmap->_private);
		_aligned_free(bitmap);
		bitmap = NULL;
	}
}


/*--------------------------------------------------------

	XN[̍쐬

	  : int width   XN[̕
	        int height  XN[̍
	߂l: :XN[ԍ s:0

 -------------------------------------------------------*/

int osd_create_screen(int width, int height)
{
	int no;

	if (nScreenNum == MAX_SCREEN)
		return 0;

	for (no = 0; no < MAX_SCREEN; no++)
	{
		if (pVideoScreen[no] == NULL)
			break;
	}

	pVideoScreen[no] = osd_alloc_bitmap(width, height);

	if (pVideoScreen[no])
	{
		nScreenNum++;

		return no + 1;
	}
	return 0;
}


/*--------------------------------------------------------

	w肵XN[ɕύX

	  : int no  XN[mێɎ擾ԍ
	߂l: Ȃ

 -------------------------------------------------------*/

void osd_set_screen(int no)
{
	if (no <= 0 || no > MAX_SCREEN || pVideoScreen[no - 1] == NULL)
		return;

	no--;

	scrbitmap.width    = pVideoScreen[no]->width;
	scrbitmap.height   = pVideoScreen[no]->height;
	scrbitmap._private = pVideoScreen[no]->_private;
	scrbitmap.line     = pVideoScreen[no]->line;

	// blitp̃ItZbgƃC̃f[^TCYvZ
	pBitmapOffset = &((UINT8 *)scrbitmap.line[visible_rect.m_Top])[visible_rect.m_Left * 2];
	nBitmapPitch = (UINT8 *)scrbitmap.line[1] - (UINT8 *)scrbitmap.line[0];
}


/*--------------------------------------------------------

	rbg}bv̉

	  : struct osd_bitmap *bitmap rbg}bv
	߂l: Ȃ

 -------------------------------------------------------*/

void osd_free_screen(int no)
{
	if (no <= 0 || no > MAX_SCREEN || pVideoScreen[no - 1] == NULL)
		return;

	no--;

	if (pVideoScreen[no])
	{
		osd_free_bitmap(pVideoScreen[no]);
		pVideoScreen[no] = NULL;
		nScreenNum--;
	}
}


/*--------------------------------------------------------

	XN[̃Rs[

	  : int no    Rs[̃XN[ԍ
	߂l: :OSD_OK  s:OSD_ERROR

  ݂̃XN[w肵ԍ̃XN[ɃRs[
    ܂Bƍ݂͌̃XN[ƓKvB

 -------------------------------------------------------*/

int osd_copy_screen(int no)
{
	int y, x;

	if (no <= 0 || no > MAX_SCREEN || pVideoScreen[no - 1] == NULL)
		return OSD_ERROR;

	no--;

	for (y = 0; y < scrbitmap.height; y++)
	{
		for (x = 0; x < scrbitmap.width; x++)
		{
			pVideoScreen[no]->line[y][x] = scrbitmap.line[y][x];
		}
	}

	return OSD_OK;
}


/*--------------------------------------------------------

	fBXvC̍쐬

	  : int left   ʍ[̈ʒu
	        int top    ʏ[̈ʒu
	        int right  ʉE[̈ʒu
	        int bottom ʉ[̈ʒu
	߂l: :OSD_OK  s:OSD_ERROR

 -------------------------------------------------------*/

int osd_create_display(int left, int top, int right, int bottom)
{
	DDSURFACEDESC ddSurfaceDesc;
	DDPIXELFORMAT ddPixelFormat;
	DWORD dwDestBpp;
	HRESULT hResult;
	tRect WindowRect;

	// DirectDraw Object쐬
	DirectDraw_CreateByIndex(emulation_mode ? -1 : 0);
	pDDraw = dd;
	if (pDDraw == NULL)
	{
		logerror("DirectDraw object cannot create.\n");
		return OSD_ERROR;
	}

	// `TCY̌vZ
	if (AdjustVisibleRect(left, top, right, bottom) != 0)
		goto error;

	// EBhEB
	ShowWindow(MyApp.m_hWnd, SW_HIDE);

	if (options.fullscreen)
	{
		// tXN[\

		int i, frame_rate = 60;

		// EBhEX^Cݒ(gȂ)
		SetWindowLong(MyApp.m_hWnd, GWL_STYLE, WS_POPUP);

		// EBhẼTCYƕ\ʒuݒ
		SetWindowPos(MyApp.m_hWnd, HWND_TOPMOST, 0, 0, GetSystemMetrics(SM_CXSCREEN) / 4, GetSystemMetrics(SM_CYSCREEN) / 4, 0);

		// DirectDraw̋[hݒ
		if (IDirectDraw2_SetCooperativeLevel(pDDraw, MyApp.m_hWnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN) != DD_OK)
		{
			logerror("IDirectDraw2.SetCooperativeLevel failed.\n");
			goto error;
		}

		// fBXvC[hݒ(60hzƃtbV[gw薳̌v2񎎂Ă݂)
		for (i = 0; i < 2; i++)
		{
			if (IDirectDraw2_SetDisplayMode(pDDraw, screen_width, screen_height, 16, frame_rate, 0) != DD_OK)
			{
				if (frame_rate == 0)
				{
			   		logerror("IDirectDraw2.SetDisplayMode failed.\n"
							"DirectDraw not support %dx%d (16 bpp) display mode\n",	screen_width, screen_height);

					goto error;
				}
				else
				{
					frame_rate = 0;
				}
			}
		}
	}
	else
	{
		// EBhE\

		// EBhEX^Cݒ
		SetWindowLong(MyApp.m_hWnd, GWL_STYLE, WS_OVERLAPPEDWINDOW | WS_BORDER);

		// EBhE̘glăEBhETCYƕ\ʒu(ʒ)vZ
		WindowRect.m_Width  = screen_width + (2 * GetSystemMetrics(SM_CXFRAME));
		WindowRect.m_Height = screen_height + (2 * GetSystemMetrics(SM_CYFRAME)) + GetSystemMetrics(SM_CYCAPTION);
		WindowRect.m_Left   = (GetSystemMetrics(SM_CXFULLSCREEN) - WindowRect.m_Width)  / 2;
		WindowRect.m_Top    = ((GetSystemMetrics(SM_CYFULLSCREEN) + GetSystemMetrics(SM_CYCAPTION)) - WindowRect.m_Height) / 2;

		// EBhẼTCYƕ\ʒuݒ
		SetWindowPos(MyApp.m_hWnd, HWND_NOTOPMOST, 0, 0, WindowRect.m_Width, WindowRect.m_Height, SWP_NOZORDER);

		// DirectDraw̋[hݒ
		if (IDirectDraw2_SetCooperativeLevel(pDDraw, MyApp.m_hWnd, DDSCL_NORMAL) != DD_OK)
		{
			logerror("IDirectDraw2.SetCooperativeLevel failed.\n");
			goto error;
		}

		// ݂̃fBXvC[h̏擾
		ddSurfaceDesc.dwSize = sizeof(ddSurfaceDesc);
		if (IDirectDraw2_GetDisplayMode(pDDraw, &ddSurfaceDesc) != DD_OK)
		{
			logerror("IDirectDraw2.GetDisplayMode failed.\n");
			goto error;
		}

		// 8bit(256F[ĥƂ̓G[
		if ((ddSurfaceDesc.ddpfPixelFormat.dwFlags & DDPF_PALETTEINDEXED8) ||
			(ddSurfaceDesc.ddpfPixelFormat.dwRBitMask == 0 &&
			 ddSurfaceDesc.ddpfPixelFormat.dwGBitMask == 0 &&
			 ddSurfaceDesc.ddpfPixelFormat.dwBBitMask == 0))
		{
			logerror("8bit color mode not supported.\n");
			goto error;
		}

		// 1sNZ̃rbg擾
		bytes_per_pixel = ddSurfaceDesc.ddpfPixelFormat.dwRGBBitCount / 8;
	}

	if (triple_buffer)
	{
		// gvobt@̓vC}T[tFX2̃obNobt@쐬
		memset(&ddSurfaceDesc, 0, sizeof(ddSurfaceDesc));
		ddSurfaceDesc.dwSize = sizeof(ddSurfaceDesc);
		ddSurfaceDesc.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
		ddSurfaceDesc.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX | DDSCAPS_VIDEOMEMORY;
		ddSurfaceDesc.dwBackBufferCount = 1;
		if (IDirectDraw2_CreateSurface(pDDraw, &ddSurfaceDesc, &pDDSFlip, NULL) != DD_OK)
		{
			logerror("IDirectDraw2.CreateSurface failed.\n");
			goto error;
		}

		// T[tFXbNłtbv[hݒ
		if (LockSurface(pDDSFlip) && UnlockSurface(pDDSFlip))
		{
			DDSCAPS ddscaps;

			memset(&ddscaps, 0, sizeof(ddscaps));
			ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
			if (IDirectDrawSurface2_GetAttachedSurface(pDDSFlip, &ddscaps, &pDDSPrimary) != DD_OK)
			{
				logerror("IDirectDrawSurface2.GetAttachedSurface failed.\n");
			 	goto error;
	 		}
		}
		else
		{
			// sgvobt@𖳌ɂāAvC}+obNobt@ɐݒύX
			IDirectDraw2_Release(pDDSFlip);
			triple_buffer   = FALSE;
			use_back_buffer = TRUE;
		}
	}

	if (pDDSFlip == NULL)
	{
		// ܂T[tFX쐬ĂȂ΁AƗvC}T[tFX쐬
		memset(&ddSurfaceDesc, 0, sizeof(ddSurfaceDesc));
		ddSurfaceDesc.dwSize = sizeof(ddSurfaceDesc);
		ddSurfaceDesc.dwFlags = DDSD_CAPS;
		ddSurfaceDesc.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
		if (IDirectDraw2_CreateSurface(pDDraw, &ddSurfaceDesc, &pDDSPrimary, NULL) != DD_OK)
		{
			logerror("IDirectDraw2.CreateSurface failed.\n");
			goto error;
		}
	}

	if (use_back_buffer)
	{
		// obNobt@̍쐬(VXegꍇ͂Őݒ)
		memset(&ddSurfaceDesc, 0, sizeof(ddSurfaceDesc));
		ddSurfaceDesc.dwSize = sizeof(ddSurfaceDesc);
		ddSurfaceDesc.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
		ddSurfaceDesc.dwWidth = adjusted_width;
		ddSurfaceDesc.dwHeight = adjusted_height;
		if (use_system_memory)
			ddSurfaceDesc.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
		else
			ddSurfaceDesc.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_VIDEOMEMORY;

		hResult = IDirectDraw2_CreateSurface(pDDraw, &ddSurfaceDesc, &pDDSBack, NULL);
		if (hResult != DD_OK)
		{
			if (use_system_memory == 0)
			{
				// rfIɊmۂłȂꍇ́AVXe
				ddSurfaceDesc.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
				hResult = IDirectDraw2_CreateSurface(pDDraw, &ddSurfaceDesc, &pDDSBack, NULL);
			}
			if (hResult != DD_OK)
			{
				logerror("IDirectDraw2.CreateSurface(back buffer) failed.\n");
				goto error;
			}
		}
	}
	else
	{
		// obNobt@gpȂƂ́AvC}T[tFXƃobNobt@𓯂
		pDDSBack = pDDSPrimary;
	}

	// sNZtH[}bg擾
	memset(&ddPixelFormat, 0, sizeof(DDPIXELFORMAT));
	ddPixelFormat.dwSize  = sizeof(DDPIXELFORMAT);
	ddPixelFormat.dwFlags = DDPF_RGB;
	if (IDirectDrawSurface2_GetPixelFormat(pDDSPrimary, &ddPixelFormat) != DD_OK)
	{
		logerror("IDirectDrawSurface2.GetPixelFormat failed.a\n");
		goto error;
	}

	// 擾sNZtH[}bgRGB̏擾
	GetPixelInfo(ddPixelFormat.dwRBitMask, &Red);
	GetPixelInfo(ddPixelFormat.dwGBitMask, &Green);
	GetPixelInfo(ddPixelFormat.dwBBitMask, &Blue);

	if (options.fullscreen == 0)
	{
		// EBhẼNbsÖ쐬
		if (IDirectDraw2_CreateClipper(pDDraw, 0, &pDDClipper, NULL) != DD_OK)
		{
			logerror("IDirectDraw2.CreateClipper failed.a\n");
			goto error;
		}

		// NbsÖ̃AvP[VɊ蓖
		if (IDirectDrawClipper_SetHWnd(pDDClipper, 0, MyApp.m_hWnd) != DD_OK)
		{
			logerror("IDirectDrawClipper.SetHWnd failed.a\n");
			goto error;
		}

		// NbsÖvC}T[tFXɓKp
		if (IDirectDrawSurface2_SetClipper(pDDSPrimary, pDDClipper) != DD_OK)
		{
			logerror("IDirectDrawSurface2.SetClipper failed.a\n");
			goto error;
		}
	}


	// p[Zgw̃XLC\p̋Px}XN쐬
	SetBrightmask(Red.m_nSize, Green.m_nSize, Blue.m_nSize, Red.m_nShift, Green.m_nShift, Blue.m_nShift);

	if (bytes_per_pixel == 2)
		dwDestBpp = Red.m_nSize + Green.m_nSize + Blue.m_nSize;
	else
		dwDestBpp = bytes_per_pixel * 8;

	// ʓ]֐ݒ
	bliter = SelectBliter(dwDestBpp, sw_stretch2x, scanlines, scanline_brightness, enable_mmx, enable_sse);
	if (bliter == NULL)
		goto error;

	// eT[tFXNA
	if (pDDSFlip)    ClearSurface(pDDSFlip);
	if (pDDSPrimary) ClearSurface(pDDSPrimary);
	if (pDDSBack)    ClearSurface(pDDSBack);

	// VSYNC҂ꍇ́AVBLANKԊuvZ
	if (wait_vsync)
		CalcVBlank();

	if (options.fullscreen)
		ShowWindow(MyApp.m_hWnd, SW_SHOW);

	resized_width = screen_width;
	resized_height = screen_height;

	// EBhE̕\ʒu`FbN
	if (options.fullscreen == 0)
		CheckScreenRect();

	dwWindowStatus &= ~FLAG_INITIALIZING;

	// tXN[̃tOꍇ́AŐݒ肵ȂƂȂƂɂȂ
	if (options.fullscreen == 0)
	{
		dwWindowStatus &= ~FLAG_FULLSCREEN;
		SetWindowPos(MyApp.m_hWnd, HWND_NOTOPMOST, WindowRect.m_Left, WindowRect.m_Top, WindowRect.m_Width, WindowRect.m_Height, SWP_NOZORDER);
		ShowWindow(MyApp.m_hWnd, SW_SHOW);
		UpdateWindow(MyApp.m_hWnd);
	}

	MyApp.m_bIsInitialized = TRUE;

	return OSD_OK;

error:
	osd_close_display();
	return OSD_ERROR;
}


/*--------------------------------------------------------

	fBXvC

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

void osd_close_display(void)
{
	int flag = 0;

	MyApp.m_bIsInitialized = FALSE;

	if (options.fullscreen == 0 && dwWindowStatus & FLAG_FULLSCREEN)
		flag = 1;

	if (flag)
		dwWindowStatus |= (FLAG_INITIALIZING & FLAG_FULLSCREEN);
	else
		dwWindowStatus |= FLAG_INITIALIZING;

	ShowWindow(MyApp.m_hWnd, SW_HIDE);

	if (pDDraw)
	{
		if (dwWindowStatus & FLAG_FULLSCREEN)
		{
			IDirectDraw2_SetCooperativeLevel(pDDraw, MyApp.m_hWnd, DDSCL_NORMAL);
			IDirectDraw2_RestoreDisplayMode(pDDraw);
		}

		if (pDDSBack)    ClearSurface(pDDSBack);
		if (pDDSPrimary) ClearSurface(pDDSPrimary);
		if (pDDSFlip)    ClearSurface(pDDSFlip);

		if (pDDClipper)
		{
			IDirectDrawClipper_Release(pDDClipper);
			pDDClipper = NULL;
		}

		if (pDDSBack)
		{
			if (pDDSBack == pDDSPrimary)
				pDDSPrimary = NULL;
			IDirectDrawSurface2_Release(pDDSBack);
			pDDSBack = NULL;
		}

		if (pDDSFlip)
		{
			IDirectDrawSurface2_Release(pDDSFlip);
			pDDSFlip = NULL;
			pDDSPrimary = NULL;
		}
		if (pDDSPrimary)
		{
			IDirectDrawSurface2_Release(pDDSPrimary);
			pDDSPrimary = NULL;
		}

		pDDraw = NULL;
	}

	if (flag)
		dwWindowStatus = (FLAG_INITIALIZING & FLAG_FULLSCREEN);
	else
		dwWindowStatus = FLAG_INITIALIZING;
}


/*--------------------------------------------------------

	fBXvC[h̕ύX

	  : Ȃ
	߂l: :OSD_OK  s:OSD_ERROR

 -------------------------------------------------------*/

int osd_change_display(void)
{
	int cdda_paused = 0;
	int i, j, x, y, r, g, b;
	int min_x, min_y, max_x, max_y;
	UINT16 pen;

	// TEh~
	if (osd_cdda_get_status() == CDDA_PLAY)
	{
		cdda_paused = 1;
		osd_cdda_pause();
	}
	osd_sound_enable(0);

	// ʂ15bitJ[ɂđޔ
	for (i = 0; i < MAX_SCREEN; i++)
	{
		if (pVideoScreen[i] != NULL)
		{
			for (y = 0; y < pVideoScreen[i]->height; y++)
			{
				for (x = 0; x < pVideoScreen[i]->width; x++)
				{
					pen = pVideoScreen[i]->line[y][x];
					osd_get_pen(pen, &r, &g, &b);
					pVideoScreen[i]->line[y][x] = MAKECOL15(r, g, b);
				}
			}
		}
	}

	// o^Ăpbg15bitJ[ɂđޔ
	for (i = 0; i < MAX_PALETTE; i++)
	{
		if (PaletteList[i].palette)
		{
			UINT16 *palette = PaletteList[i].palette;
			int size = PaletteList[i].size;

			for (j = 0; j < size; j++)
			{
				pen = palette[j];
				osd_get_pen(pen, &r, &g, &b);
				palette[j] = MAKECOL15(r, g, b);
			}
		}
	}

	// fBXvC
	osd_close_display();

	VideoReset();

	// XN[OSD_SCREENɐݒ
	osd_set_screen(OSD_SCREEN);

	min_x = visible_rect.m_Left;
	min_y = visible_rect.m_Top;
	max_x = visible_rect.m_Left + visible_rect.m_Width - 1;
	max_y = visible_rect.m_Top + visible_rect.m_Height - 1;

	// fBXvC̍쐬
	if (osd_create_display(min_x, min_y, max_x, max_y) == OSD_ERROR)
		return OSD_ERROR;

	if (bytes_per_pixel > 2)
	{
		// pbgQƃe[u쐬
		for (i = 0; i < 32768; i++)
		{
			pen = palette_lookup15[i];
			r = GETR15(pen);
			g = GETG15(pen);
			b = GETB15(pen);
			palette_lookup[pen] = MAKECOL(r, g, b);
		}
	}

	// ʂ𕜋A
	for (i = 0; i < MAX_SCREEN; i++)
	{
		if (pVideoScreen[i] != NULL)
		{
			for (y = 0; y < pVideoScreen[i]->height; y++)
			{
				for (x = 0; x < pVideoScreen[i]->width; x++)
				{
					pen = pVideoScreen[i]->line[y][x];
					r = GETR15(pen);
					g = GETG15(pen);
					b = GETB15(pen);
					pVideoScreen[i]->line[y][x] = osd_make_pen(r, g, b);
				}
			}
		}
	}

	// o^Ăpbg𕜋A
	for (i = 0; i < MAX_PALETTE; i++)
	{
		if (PaletteList[i].palette)
		{
			UINT16 *palette = PaletteList[i].palette;
			int size = PaletteList[i].size;

			for (j = 0; j < size; j++)
			{
				pen = palette[j];
				r = GETR15(pen);
				g = GETG15(pen);
				b = GETB15(pen);
				palette[j] = osd_make_pen(r, g, b);
			}
		}
	}

	UpdateWindow(MyApp.m_hWnd);

	// TEhĊJ
	osd_sound_enable(1);
	if (cdda_paused)
	{
		osd_cdda_resume();
	}

	return OSD_OK;
}


/*--------------------------------------------------------

	pbgo^

	  : UINT16 *palette   pbg̃|C^
	        int size          pbg̃TCY
	߂l: :OSD_OK  s:OSD_ERROR

 -------------------------------------------------------*/

int osd_register_palette(UINT16 *palette, int size)
{
	int i;

	if (nPaletteNum >= MAX_PALETTE)
		return OSD_ERROR;

	for (i = 0; i < MAX_PALETTE; i++)
	{
		if (PaletteList[i].palette == NULL)
			break;
	}

	PaletteList[i].palette = palette;
	PaletteList[i].size = size;
	nPaletteNum++;

	return OSD_OK;
}


/*--------------------------------------------------------

	pbgo^

	  : UINT16 *palette   pbg̃|C^
	߂l: Ȃ

 -------------------------------------------------------*/

void osd_unregister_palette(UINT16 *palette)
{
	int i;

	for (i = 0; i < MAX_PALETTE; i++)
	{
		if (PaletteList[i].palette == palette)
		{
			PaletteList[i].palette = NULL;
			PaletteList[i].size = 0;
			nPaletteNum--;
			break;
		}
	}
}


/*--------------------------------------------------------

	pbgݒ(pbgQƃe[u)

	  : int r       ԋPx
			int g       ΋Px
			int b       Px
	߂l: w肳ꂽFɑΉpbgQƔԍ

   ŏɍ쐬pbĝ

 -------------------------------------------------------*/

UINT16 osd_set_palette(int r, int g, int b)
{
	UINT16 color;

	if (bytes_per_pixel == 2)
	{
		color = MAKECOL(r, g, b);
	}
	else
	{
		color = MAKECOL15(r, g, b);
		palette_lookup[color] = MAKECOL(r, g, b);
	}

	palette_lookup15[MAKECOL15(r, g, b)] = MAKECOL15(r, g, b);

	return color;
}


/*--------------------------------------------------------

	sNZRGBɕ

	  : UINT16 pen   sNZ
	        int *r       ԋPx
	        int *g       ΋Px
	        int *b       Px
	߂l: Ȃ

 -------------------------------------------------------*/

void osd_get_pen(UINT16 pen, int *r, int *g, int *b)
{
	if (bytes_per_pixel == 2)
	{
		*r = GETR(pen);
		*g = GETG(pen);
		*b = GETB(pen);
	}
	else
	{
		*r = GETR15(pen);
		*g = GETG15(pen);
		*b = GETB15(pen);
	}
}


/*--------------------------------------------------------

	RGBsNZf[^쐬

	  : int r       ԋPx
	        int g       ΋Px
	        int b       Px
	߂l: 쐬sNZf[^

 -------------------------------------------------------*/

UINT16 osd_make_pen(int r, int g, int b)
{
	if (bytes_per_pixel == 2)
		return MAKECOL(r, g, b);
	else
		return MAKECOL15(r, g, b);
}


/*--------------------------------------------------------

	݂̃t[XLbv邩

	  : Ȃ
	߂l: 0:`悷 1:XLbv

 -------------------------------------------------------*/

int osd_skip_this_frame(void)
{
	static const int skiptable[FRAMESKIP_LEVELS][FRAMESKIP_LEVELS] =
	{
		{ 0,0,0,0,0,0,0,0,0,0,0,0 },
		{ 0,0,0,0,0,0,0,0,0,0,0,1 },
		{ 0,0,0,0,0,1,0,0,0,0,0,1 },
		{ 0,0,0,1,0,0,0,1,0,0,0,1 },
		{ 0,0,1,0,0,1,0,0,1,0,0,1 },
		{ 0,1,0,0,1,0,1,0,0,1,0,1 },
		{ 0,1,0,1,0,1,0,1,0,1,0,1 },
		{ 0,1,0,1,1,0,1,0,1,1,0,1 },
		{ 0,1,1,0,1,1,0,1,1,0,1,1 },
		{ 0,1,1,1,0,1,1,1,0,1,1,1 },
		{ 0,1,1,1,1,1,0,1,1,1,1,1 },
		{ 0,1,1,1,1,1,1,1,1,1,1,1 }
	};

	return skiptable[frameskip][frameskip_counter];
}


/*--------------------------------------------------------

	ʂ̍XV

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

void osd_update_video(int draw_screen)
{
	TICKER curr;

	if (dwWindowStatus & FLAG_INITIALIZING)
		return;

	if (dwWindowStatus & FLAG_PAINTING)
		return;

	if (frameskip_counter == 0)
		this_frame_base = prev_measure + (TICKER)((double)FRAMESKIP_LEVELS * (double)TICKS_PER_SEC / video_fps);

	if (osd_skip_this_frame() == 0)
	{
		int draw_flag = 0;

		if (draw_screen)
		{
			if ((dwWindowStatus & FLAG_FULLSCREEN) == 0)
				CheckScreenRect();

			if (triple_buffer)
				ClearSurface(pDDSPrimary);

			if (showfps || showfpstemp)
			{
				ui_set_text_color(UI_COLOR_NORMAL);
				ui_draw_text(fpsbuf, (visible_rect.m_Width - 1) - strlen(fpsbuf) * 8, 0);
			}

			if (triple_buffer && use_back_buffer)
				DrawSurface(draw_flag++);

			if (triple_buffer || use_back_buffer)
				DrawSurface(draw_flag++);
		}

		if (showfpstemp)
			showfpstemp--;

		if (osd_is_key_pressed_memory(KEYCODE_F11))
		{
			if (showfpstemp)
				showfpstemp = 0;
			else
				showfps ^= 1;
		}

		curr = (*ticker)();

		/* now wait until it's time to update the screen */
		if (throttle)
		{
			if (adjust_refreshrate)
			{
				TICKER target = this_frame_base + (int)((double)frameskip_counter * ticks_per_frame - ticks_per_frame * 0.02);

				if (sleep_time > 0)
				{
					Sleep(sleep_time);
					curr = ticker();
				}

				while (curr < target)
					curr = ticker();

				if ((dwWindowStatus & FLAG_FULLSCREEN) == 0)
					while (CheckVSync() == FALSE);

				curr = ticker();
			}
			else
			{
				TICKER target = this_frame_base + (int)((double)frameskip_counter * ticks_per_frame);

				if (curr - target < 0)
				{
					if (sleep_time > 0)
					{
						Sleep(sleep_time);
						curr = ticker();
					}

					while (curr - target < 0)
					{
						curr = ticker();
					}
				}

				if ((dwWindowStatus & FLAG_FULLSCREEN) == 0)
				{
					if (wait_vsync)
						while (CheckVSync() == FALSE);
				}
			}
		}

		if (draw_screen)
		{
			DrawSurface(draw_flag);
		}

		if ((dwWindowStatus & FLAG_FULLSCREEN) && wait_vsync)
			curr = ticker();

		/* for the FPS average calculation */
		if (++frames_displayed == FRAMES_TO_SKIP)
			start_time = curr;
		else
			end_time = curr;

		if (frameskip_counter == 0)
		{
			speed = (double)TICKS_PER_SEC / (video_fps * (double)(curr - prev_measure) / (double)(100 * FRAMESKIP_LEVELS));
			prev_measure = curr;
		}

		prev = curr;

		if (showfps || showfpstemp)
		{
			double fps;

			fps = (video_fps * (double)(FRAMESKIP_LEVELS - frameskip) * speed) / (double)(100 * FRAMESKIP_LEVELS);
			sprintf(fpsbuf, "%s%2d%4.0f%%%6.1f/%.1f fps", autoframeskip ? "auto" : "fskp", frameskip, speed, fps, video_fps);
		}

		if (throttle && autoframeskip &&  frameskip_counter == 0)
		{
			int adjspeed = (int)(speed + 0.5);

			/* adjust speed to video refresh rate if vsync is on */
			if (adjspeed >= 110.0)
			{
				frameskipadjust -= (int)((100.0 - speed) / 5.0);

				if (frameskip < 0)
					frameskip = 0;
			}
			else if (adjspeed <= 90)
			{
				frameskip += (int)((100.0 - speed) / 5.0);

				if (frameskip > FRAMESKIP_LEVELS - 1)
					frameskip = FRAMESKIP_LEVELS - 1;
			}
			else if (adjspeed >= 100)
			{
				frameskipadjust++;
				if (frameskipadjust >= 2)
				{
					if (frameskip > 0)
						frameskip--;
					frameskipadjust = 0;
				}
			}
			else
			{
				frameskipadjust--;
				if (frameskipadjust <= -2)
				{
					if (frameskip < FRAMESKIP_LEVELS - 1)
						frameskip++;
					frameskipadjust = 0;
				}
			}
		}
	}

	if (osd_is_key_pressed_memory(KEYCODE_F8))
	{
		if (autoframeskip)
		{
			autoframeskip = 0;
			frameskip = 0;
		}
		else
		{
			if (frameskip == FRAMESKIP_LEVELS - 1)
			{
				frameskip = 0;
				autoframeskip = 1;
			}
			else
				frameskip++;
		}

		if (showfps == 0)
			showfpstemp = 2 * 60;

		/* reset the frame counter every time the frameskip key is pressed, so */
		/* we'll measure the average FPS on a consistent status. */
		frames_displayed = 0;
	}

	if (osd_is_key_pressed_memory(KEYCODE_F9))
	{
		if (autoframeskip)
		{
			autoframeskip = 0;
			frameskip = FRAMESKIP_LEVELS - 1;
		}
		else
		{
			if (frameskip == 0)
				autoframeskip = 1;
			else
				frameskip--;
		}

		if (showfps == 0)
			showfpstemp = 2 * 60;

		/* reset the frame counter every time the frameskip key is pressed, so */
		/* we'll measure the average FPS on a consistent status. */
		frames_displayed = 0;
	}

	if (osd_is_key_pressed_memory(KEYCODE_F10))
	{
		throttle ^= 1;

		/* reset the frame counter every time the throttle key is pressed, so */
		/* we'll measure the average FPS on a consistent status. */
		frames_displayed = 0;
	}

	frameskip_counter = (frameskip_counter + 1) % FRAMESKIP_LEVELS;

	MyApp.HandleAutoPause();
	MyApp.ProcessMessages();
}


/*--------------------------------------------------------

	t[Ă邩Ԃ

	  : Ȃ
	߂l: 1:t[ 0:t[Ȃ

 -------------------------------------------------------*/

BOOL throttled(void)
{
	return throttle;
}


/*--------------------------------------------------------

	ʏɊւWindow Message̎擾

	  : Ȃ
	߂l: ꍇ:TRUE Ȃꍇ:FALSE

 -------------------------------------------------------*/

BOOL DirectDraw_OnMessage(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam, LRESULT* pResult)
{
	if (dwWindowStatus & FLAG_INITIALIZING)
		return FALSE;

	if (dwWindowStatus & FLAG_FULLSCREEN)
	{
		switch (Msg)
		{
			PEEK_MESSAGE(hWnd, WM_ACTIVATEAPP,  OnActivateApp);
			HANDLE_MESSAGE(hWnd, WM_SETCURSOR,  OnSetCursor);
		}
	}
	else
	{
		switch (Msg)
		{
			PEEK_MESSAGE(hWnd, WM_ACTIVATEAPP,  OnActivateApp);
			HANDLE_MESSAGE(hWnd, WM_MOVE,       OnMove);
			HANDLE_MESSAGE(hWnd, WM_SIZE,       OnSize);
			HANDLE_MESSAGE(hWnd, WM_SIZING,     OnSizing);
			HANDLE_MESSAGE(hWnd, WM_PAINT,      OnPaint);
		}
	}
	return FALSE;
}


/***************************************************************************
	[J֐
 ***************************************************************************/

/*--------------------------------------------------------

	ʏɊւϐ̏

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

static void VideoReset(void)
{
	// ϐ̏
	showfps				= 0;
	showfpstemp			= 0;
	throttle			= 1;
	autoframeskip		= 0;
	frameskip			= 0;
	frameskip_counter	= 0;
	frameskipadjust		= 0;
	speed				= 100.0;
	prev_measure		= 0;
	this_frame_base		= 0;
	prev				= 0;
	frames_displayed	= 0;
	start_time			= 0;
	end_time			= 0;
	ticks_per_frame     = (double)TICKS_PER_SEC / video_fps;

	rectPrimary.left    = 0;
	rectPrimary.top     = 0;
	rectPrimary.right   = 0;
	rectPrimary.bottom  = 0;

	rectBack.left       = 0;
	rectBack.top        = 0;
	rectBack.right      = 0;
	rectBack.bottom     = 0;

	screen_width        = 0;
	screen_height       = 0;
	adjusted_width      = 0;
	adjusted_height     = 0;
	resized_width       = 0;
	resized_height      = 0;

	pDDraw              = NULL;
	pDDSFlip            = NULL;
	pDDSPrimary         = NULL;
	pDDSBack            = NULL;
	pDDClipper          = NULL;

	bliter              = NULL;

	pBitmapOffset       = NULL;
	nBitmapPitch        = 0;
	pSurfaceOffset      = NULL;
	nSurfacePitch       = 0;
	bytes_per_pixel     = 2;

	sw_stretch2x        = options.sw_stretch2x;
	scanlines           = options.scanlines;
	scanline_brightness = options.sl_brightness;
	hw_stretch          = options.hw_stretch;
	use_system_memory   = options.use_sysmem;
	emulation_mode      = options.use_ddhel;
	wait_vsync          = options.wait_vsync;
	adjust_refreshrate  = FALSE;

	enable_mmx			= options.enable_mmx;
	enable_sse	 		= options.enable_sse;

	if (options.fullscreen)
	{
		triple_buffer  = options.use_triplebuffer;
		sleep_time     = -1;
	}
	else
	{
		triple_buffer  = FALSE;
		sleep_time     = options.sleep_time;
	}

	if (triple_buffer)
	{
		if (wait_vsync)
			flip_mode = DDFLIP_WAIT;
		else
			flip_mode = DDFLIP_NOVSYNC;
	}

	// EBhE쐬̃TCYhׁAƂ肠tXN[tO͗ĂĂ
	dwWindowStatus |= FLAG_FULLSCREEN;

	use_back_buffer = !options.fullscreen | !triple_buffer | hw_stretch;
}


/*--------------------------------------------------------

	ʕ`̈̐ݒ

	  : int min_x   ʍ[̈ʒu
	        int min_y   ʏ[̈ʒu
	        int max_x   ʉE[̈ʒu
	        int max_y   ʉ[̈ʒu
	߂l: Ȃ

 -------------------------------------------------------*/

static int AdjustVisibleRect(int min_x, int min_y, int max_x, int max_y)
{
	int width, height;
	int scale;

	width  = (max_x - min_x) + 1;
	height = (max_y - min_y) + 1;

	if (hw_stretch == 0)
		scale = 1;
	else
		scale = hw_stretch;

	if (sw_stretch2x == FALSE)
		scanlines = FALSE;

	// screen_ ̓fBXvC̉ʃTCYAadjusted_ ͓]̃TCY
	screen_width = adjusted_width = width;
	screen_height = adjusted_height = height;

	// \tgEFA2{g又w肳Ăꍇ2{
	if (sw_stretch2x)
	{
		screen_width *= 2;
		screen_height *= 2;

		adjusted_width *= 2;
		adjusted_height *= 2;
	}

	// n[hEFAg又w肳Ăꍇ͊g傷
	if (hw_stretch)
	{
		screen_width *= scale;
		screen_height *= scale;

		adjusted_width *= scale;
		adjusted_height *= scale;
	}

	if (options.fullscreen)
	{
		int i, left, top;
		BOOL bResult;

		if (triple_buffer && hw_stretch == 0)
			use_back_buffer = FALSE;

		for (i = scale; i >= 1; i--)
		{
			// screen_ ۂɑ݂fBXvC̉ʃTCYɕύX
			bResult = FindDisplayMode(adjusted_width, adjusted_height,
										(DWORD *)&screen_width,
										(DWORD *)&screen_height);

			if (bResult == TRUE)
				break;

			// sg嗦Ē
			scale--;
			screen_width = adjusted_width * scale;
			screen_height = adjusted_width * scale;
		}

		if (hw_stretch == 1)
		{
			// fBXvCTCYɃXgb`ꍇ
			rectPrimary.left   = 0;
			rectPrimary.top    = 0;
			rectPrimary.right  = screen_width;
			rectPrimary.bottom = screen_height;
		}
		else
		{
			// ㉺ƍE̗]vZ
			left = (screen_width - adjusted_width) / 2;
			top = (screen_height - adjusted_height) / 2;

			// rectPrimary͍ŏIIȓ]̉ʗ̈
			rectPrimary.left   = left;
			rectPrimary.top    = top;
			rectPrimary.right  = left + adjusted_width;
			rectPrimary.bottom = top  + adjusted_height;
		}
	}
	else
	{
		rectPrimary.left   = 0;
		rectPrimary.top    = 0;
		rectPrimary.right  = screen_width;
		rectPrimary.bottom = screen_height;
		use_back_buffer = TRUE;
	}

	// rectBack̓n[hEFAXgb`yуEBhE\pɓ]ꎞIȉʗ̈
	rectBack.left   = 0;
	rectBack.top    = 0;
	rectBack.right  = visible_rect.m_Width;
	rectBack.bottom = visible_rect.m_Height;

	// \tgEFAXgb`̏ꍇ̓obNobt@g
	if (sw_stretch2x)
	{
		rectBack.right *= 2;
		rectBack.bottom *= 2;
	}

	return 0;
}


/*--------------------------------------------------------

	݂̃fBXvC[h̃sNZ擾

	  : DWORD dwMask 擾F̃}XN
	        struct tPixelInfo *pPixelInfoint
	                     sNZ\̂̃|C^
	߂l: Ȃ

 -------------------------------------------------------*/

static void GetPixelInfo(DWORD dwMask, struct tPixelInfo *pPixelInfo)
{
	int nShift = 0;
	int nCount = 0;
	int i;

	pPixelInfo->m_dwMask = dwMask;

	while ((dwMask & 1) == 0 && nShift < sizeof(DWORD) * 8)
	{
		nShift++;
		dwMask >>= 1;
	}
	pPixelInfo->m_nShift = nShift;

	for (i = 0; i < sizeof(DWORD) * 8; i++)
	{
		if (dwMask & (1 << i))
			nCount++;
	}
	pPixelInfo->m_nSize = nCount;
}


/*--------------------------------------------------------

	vꂽʃTCYɍł߂fBXvC
	[hT

	  : DWORD dwWidthIn    vʂ̕
	        DWORD dwHeightIn   vʂ̍
	        DWORD *dwWidthOut  Ԃ|C^
	        DWORD *dwHeightOut Ԃ|C^
	߂l: Ȃ

 -------------------------------------------------------*/

static BOOL FindDisplayMode(DWORD dwWidthIn, DWORD dwHeightIn, DWORD *pdwWidthOut, DWORD *pdwHeightOut)
{
	struct tDisplayModes *pDisplayModes;
	int     i;
	BOOL    bFound = FALSE;
	DWORD   dwBestWidth  = 10000;
	DWORD   dwBestHeight = 10000;
	DWORD   dwBiggestWidth  = 0;
	DWORD   dwBiggestHeight = 0;

	pDisplayModes = DirectDraw_GetDisplayModes();

	for (i = 0; i < pDisplayModes->m_nNumModes; i++)
	{
		if (pDisplayModes->m_Modes[i].m_dwBPP != 16)
			continue;

		/* Find a mode big enough for input size. */
		if (dwWidthIn  <= pDisplayModes->m_Modes[i].m_dwWidth
		&&  dwHeightIn <= pDisplayModes->m_Modes[i].m_dwHeight)
		{
			/* Get the smallest display size. */
			if (pDisplayModes->m_Modes[i].m_dwWidth  < dwBestWidth
			||  pDisplayModes->m_Modes[i].m_dwHeight < dwBestHeight)
			{
				dwBestWidth  = pDisplayModes->m_Modes[i].m_dwWidth;
				dwBestHeight = pDisplayModes->m_Modes[i].m_dwHeight;
				bFound = TRUE;
			}
		}

		/*
			Keep track of the biggest size in case
			we can't find a mode that works.
		*/
		if (dwBiggestWidth  < pDisplayModes->m_Modes[i].m_dwWidth
		||  dwBiggestHeight < pDisplayModes->m_Modes[i].m_dwHeight)
		{
			dwBiggestWidth  = pDisplayModes->m_Modes[i].m_dwWidth;
			dwBiggestHeight = pDisplayModes->m_Modes[i].m_dwHeight;
		}
	}

	if (bFound)
	{
		*pdwWidthOut  = dwBestWidth;
		*pdwHeightOut = dwBestHeight;
	}

	return bFound;
}


/*-------------------------------------------------------- 

	T[tFX`揈

	  : int function  `揈̔ԍ
	߂l: :TRUE s:FALSE

 -------------------------------------------------------*/

static void DrawSurface(int function)
{
	switch (function)
	{
	case 0: // T[tFXɉzXN[̉摜]
		if (LockSurface(pDDSBack))
		{
			bliter(pBitmapOffset, pSurfaceOffset, nBitmapPitch, nSurfacePitch, visible_rect.m_Width, visible_rect.m_Height);
			UnlockSurface(pDDSBack);
		}
		break;

	case 1: // gvobt@Ftbvs   obNobt@gpFobNobt@vC}֓]
		if (use_back_buffer)
		{
			if (IDirectDrawSurface2_Blt(pDDSPrimary, &rectPrimary, pDDSBack, &rectBack, DDBLT_WAIT, NULL) == DDERR_SURFACELOST)
				IDirectDrawSurface2_Restore(pDDSPrimary);
		}
		else
		{
			if (IDirectDrawSurface2_Flip(pDDSFlip, NULL, flip_mode) == DDERR_SURFACELOST)
				IDirectDrawSurface2_Restore(pDDSFlip);
		}
		break;

	case 2: // gvobt@ + obNobt@gpFtbvs
		if (IDirectDrawSurface2_Flip(pDDSFlip, NULL, flip_mode) == DDERR_SURFACELOST)
			IDirectDrawSurface2_Restore(pDDSFlip);
		break;
	}
}


/*-------------------------------------------------------- 

	T[tFXNA

	  : IDirectDrawSurface *pddSurface T[tFX
	߂l: :TRUE s:FALSE

 -------------------------------------------------------*/

static void ClearSurface(IDirectDrawSurface *pddSurface)
{
	DDBLTFX ddBltFX;

	memset(&ddBltFX, 0, sizeof(DDBLTFX));
	ddBltFX.dwSize = sizeof(DDBLTFX);
	if (IDirectDrawSurface2_Blt(pddSurface, NULL, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &ddBltFX) == DDERR_SURFACELOST)
		IDirectDrawSurface2_Restore(pddSurface);
}


/*-------------------------------------------------------- 

	T[tFXbN

	  : IDirectDrawSurface *pddSurface T[tFX
	߂l: :TRUE s:FALSE

 -------------------------------------------------------*/

static BOOL LockSurface(IDirectDrawSurface *pddSurface)
{
	DDSURFACEDESC ddSurfaceDesc;

	ddSurfaceDesc.dwSize = sizeof(ddSurfaceDesc);
	if (IDirectDrawSurface2_Lock(pddSurface, NULL, &ddSurfaceDesc, DDLOCK_WAIT | DDLOCK_WRITEONLY, NULL) == DDERR_SURFACELOST)
	{
		IDirectDrawSurface2_Restore(pddSurface);
		return FALSE;
	}

	pSurfaceOffset = ddSurfaceDesc.lpSurface;
	nSurfacePitch = ddSurfaceDesc.lPitch;

	if (pddSurface == pDDSPrimary)
		pSurfaceOffset += nSurfacePitch * rectPrimary.top + bytes_per_pixel * rectPrimary.left;

	return TRUE;
}


/*-------------------------------------------------------- 

	T[tFXAbN

	  : IDirectDrawSurface *pddSurface T[tFX
	߂l: :TRUE s:FALSE

 -------------------------------------------------------*/

INLINE BOOL UnlockSurface(IDirectDrawSurface *pddSurface)
{
	return (IDirectDrawSurface2_Unlock(pddSurface, NULL) == DD_OK);
}


/*-------------------------------------------------------- 

	T[tFXXgĂ畜A

	  : Ȃ
	߂l: :TRUE s:FALSE

 -------------------------------------------------------*/

static BOOL RestoreSurface(void)
{
	IDirectDrawSurface *pddSurface;

	pddSurface = pDDSFlip ? pDDSFlip : pDDSPrimary;

	if (IDirectDrawSurface2_IsLost(pddSurface) == DDERR_SURFACELOST)
	{
		if (IDirectDrawSurface2_Restore(pddSurface) != DD_OK)
			return FALSE;
	}

	if (IDirectDrawSurface2_IsLost(pDDSBack) == DDERR_SURFACELOST)
	{
		if (IDirectDrawSurface2_Restore(pDDSBack) != DD_OK)
			return FALSE;
	}

	return TRUE;
}


/*-------------------------------------------------------- 

	VBLANK`FbN

	  : Ȃ
	߂l: VSYNC:TRUE ȊO:FALSE

 -------------------------------------------------------*/

static BOOL CheckVSync(void)
{
	BOOL bIsVBlank;
	DWORD dwScanLine;

	if (wait_vsync == 2)
	{
		if (IDirectDraw2_GetScanLine(pDDraw, &dwScanLine) == DD_OK)
		{
			if (dwScanLine > rectPrimary.bottom)
			{
				return TRUE;;
			}
		}
	}

	if (IDirectDraw2_GetVerticalBlankStatus(pDDraw, &bIsVBlank) != DD_OK)
		return FALSE;

	return bIsVBlank;
}


/*-------------------------------------------------------- 

	VBLANK`FbNs邩

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

static void CalcVBlank(void)
{
	BOOL bIsVBlank;
	double rate, prev_rate, refresh_rate;
	TICKER start, end;
	int limit = 6000, count, result = 1;

	if (IDirectDraw2_GetVerticalBlankStatus(pDDraw, &bIsVBlank) != DD_OK)
	{
		logerror("IDirectDraw2::GetVerticalBlankStatus failed. Disable wait VSYNC.\n");
		wait_vsync = 0;
		return;
	}

	if (options.fullscreen == 0)
	{
		if (IDirectDraw2_GetVerticalBlankStatus(pDDraw, &bIsVBlank) == DD_OK)
			wait_vsync = 2;
	}

	if (options.refreshrate == 2)
	{
		refresh_rate = 0;
		prev_rate = 0;
		count = 0;

		// 肷܂ő҂
		while (limit--)
		{
			// VSYNC҂
			do
			{
				IDirectDraw2_GetVerticalBlankStatus(pDDraw, &bIsVBlank);
			} while (bIsVBlank == FALSE);

			// VSYNCÎ҂
			do
			{
				IDirectDraw2_GetVerticalBlankStatus(pDDraw, &bIsVBlank);
			} while (bIsVBlank == TRUE);

			// ݂̃JE^擾
			start = (*ticker)();

			// VSYNC҂
			do
			{
				IDirectDraw2_GetVerticalBlankStatus(pDDraw, &bIsVBlank);
			} while (bIsVBlank == FALSE);

			// VSYNCÎ҂
			do
			{
				IDirectDraw2_GetVerticalBlankStatus(pDDraw, &bIsVBlank);
			} while (bIsVBlank == TRUE);

			// ݂̃JE^擾
			end = (*ticker)();

			// tbV[gvZ
			rate = (double)TICKS_PER_SEC / (double)(end - start);

			if (prev_rate != 0)
			{
				if ((rate >= prev_rate - 0.05) && (rate <= prev_rate + 0.05))
				{
					if (++count == 60);
					{
						refresh_rate = (rate + prev_rate) / 2;
						break;
					}
				}
				else
				{
					count = 0;
				}
			}

			prev_rate = rate;
		}

		if (refresh_rate == 0)
		{
			logerror("Your PC's refresh rate not stable. Disable refresh rate adjust PC option.\n");
			return;
		}

		adjust_refreshrate  = TRUE;

		if (refresh_rate >= 179.5 && refresh_rate <= 180.5)
		{
			video_fps = refresh_rate / 3;
		}
		else if (refresh_rate >= 119.5 && refresh_rate <= 120.5)
		{
			video_fps = refresh_rate / 2;
		}
		else if (refresh_rate >= 59.5 && refresh_rate <= 60.5)
		{
			video_fps = refresh_rate;
		}
		else
		{
			adjust_refreshrate  = FALSE;
			video_fps = 60.0;
			result = 0;
		}

		if (result)
		{
			wait_vsync = 1;
			ticks_per_frame = (double)TICKS_PER_SEC / video_fps;
		}

		logerror("Refresh rate = %4.1fHz\n", refresh_rate);
	}
}


/*-------------------------------------------------------- 

	݂̃EBhẼNCAg̈`FbN

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

static void CheckScreenRect(void)
{
	POINT p;
	RECT  rect;

	if (resized_width || resized_height)
	{
		screen_width  = resized_width;
		screen_height = resized_height;

		resized_width  = 0;
		resized_height = 0;
	}

	p.x = 0;
	p.y = 0;
	ClientToScreen(MyApp.m_hWnd, &p);
	rect.left   = p.x;
	rect.top    = p.y;
	rect.right  = p.x + screen_width;
	rect.bottom = p.y + screen_height;

	if ((dwWindowStatus & (FLAG_INITIALIZING | FLAG_RESIZED | FLAG_MOVED)) != 0)
		rectPrimary = rect;

	dwWindowStatus &= ~(FLAG_RESIZED | FLAG_MOVED);
}


/*-------------------------------------------------------- 

	EBhEĕ`悷

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

static void RefreshScreen(void)
{
	if (dwWindowStatus & FLAG_INITIALIZING)
		return;

	dwWindowStatus |= FLAG_PAINTING;

	CheckScreenRect();

	RestoreSurface();

	// rbg}bvvC}T[tFX or obNobt@
	DrawSurface(0);

	// obNobt@gpƂ̓obNobt@vC}ɓ]
	DrawSurface(1);

	dwWindowStatus &= ~FLAG_PAINTING;
}


/*-------------------------------------------------------- 

	EBhEANeBu/ANeBuɂȂ̏
	(WindowsbZ[W)

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

static void OnActivateApp(HWND hWnd, BOOL fActivate, DWORD dwThreadId)
{
	if (dwWindowStatus & FLAG_INITIALIZING)
		return;

	if (fActivate && MyApp.m_hWnd == hWnd)
	{
		// ANeBuɂȂ
		dwWindowStatus &= ~FLAG_LOSTFORCUS;
	}
	else if (!fActivate)
	{
		// tH[JX
		dwWindowStatus |= FLAG_LOSTFORCUS;
	}
}


/*--------------------------------------------------------

	EBhEړ̏
	(WindowsbZ[W)

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

static BOOL OnMove(HWND hWnd, WPARAM wParam, DWORD pos)
{
//	if (dwWindowStatus & FLAG_INITIALIZING)
//		return TRUE;

	dwWindowStatus |= FLAG_MOVED;

	// ʂĕ`
	RefreshScreen();

	return TRUE;
}


/*--------------------------------------------------------

	EBhETCYύX̏
	(WindowsbZ[W)

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

static BOOL OnSize(HWND hWnd, int state, int cx, int cy)
{
	if (dwWindowStatus & FLAG_INITIALIZING)
		return TRUE;

	dwWindowStatus |= FLAG_RESIZED;

	resized_width  = cx;
	resized_height = cy;

	if ((dwWindowStatus & FLAG_MINIMIZED) && state == SIZE_RESTORED)
	{
		dwWindowStatus &= ~FLAG_MINIMIZED;
	}
	else if (!(dwWindowStatus & FLAG_MINIMIZED) && state == SIZE_MINIMIZED)
	{
		dwWindowStatus |= FLAG_MINIMIZED;
	}

	RefreshScreen();

	return TRUE;
}


/*--------------------------------------------------------

	EBhETCYύX̏
	(WindowsbZ[W)

	  : Ȃ
	߂l: :TRUE :FALSE

	AXyNgŒ肵܂ܕύX܂
	  4̎̏̂@vȂ

 -------------------------------------------------------*/

static BOOL OnSizing(HWND hWnd, int status, LPRECT rect)
{
	LPRECT pRect = (LPRECT)rect;
	int width, height;
	BOOL bResized = FALSE;

	if (dwWindowStatus & FLAG_INITIALIZING)
		return TRUE;

	// ύX\̕ƍvZ
    width = pRect->right - pRect->left;
    height = pRect->bottom - pRect->top;

	// EBhE̘g̃TCY
	width -= 2 * GetSystemMetrics(SM_CXFRAME);
	height -= 2 * GetSystemMetrics(SM_CYFRAME) + GetSystemMetrics(SM_CYCAPTION);

	switch (status)
	{
	case WMSZ_TOP:
	case WMSZ_BOTTOM:
		// ύXꂽ̂ŕύX
		width = (height * visible_rect.m_Width) / visible_rect.m_Height;
		bResized = TRUE;
		break;

	case WMSZ_LEFT:
	case WMSZ_RIGHT:
		// ύXꂽ̂ōύX
		height = (width * visible_rect.m_Height) / visible_rect.m_Width;
		bResized = TRUE;
		break;

	case WMSZ_TOPLEFT:
	case WMSZ_TOPRIGHT:
	case WMSZ_BOTTOMLEFT:
	case WMSZ_BOTTOMRIGHT:
		// 4̏ꍇ́AύXꂽ̂Ƃď
		// AXyNg䂪ꍇ͏Ȃ悤ɂׂ
		width = (height * visible_rect.m_Width) / visible_rect.m_Height;
		bResized = TRUE;
		break;
	}

	if (bResized)
	{
		if ((width < visible_rect.m_Width / 2) || (height < visible_rect.m_Height / 2))
		{
			// Ȃ肷猳̃TCY̔ɂ
			width = visible_rect.m_Width / 2;
			height = visible_rect.m_Height / 2;
		}

		// EBhE̘g̃TCY߂
		width += 2 * GetSystemMetrics(SM_CXFRAME);
		height += 2 * GetSystemMetrics(SM_CYFRAME) + GetSystemMetrics(SM_CYCAPTION);

		// ύX\̃TCY㏑ĕύX
		pRect->right = pRect->left + width;
		pRect->bottom = pRect->top + height;

		return TRUE;
	}

	return FALSE;
}


/*--------------------------------------------------------

	ʂ̍ĕ`
	(WindowsbZ[W)

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

static BOOL OnPaint(HWND hWnd)
{
	PAINTSTRUCT ps;

	if (dwWindowStatus & FLAG_INITIALIZING)
		return TRUE;

	BeginPaint(hWnd, &ps);

	RefreshScreen();

	EndPaint(hWnd, &ps);

	return TRUE;
}


/*--------------------------------------------------------

	tXN[Ƀ}EXJ[\
	(WindowsbZ[W)

	  : Ȃ
	߂l: TRUE

 -------------------------------------------------------*/

static BOOL OnSetCursor(HWND hWnd, HWND hWndCursor, UINT codeHitTest, UINT msg)
{
	SetCursor(NULL);

	return TRUE;
}
