/***************************************************************************

	osd_cdda.c

	CDDAĐ

***************************************************************************/

#include "neogeocd.h"
#include "win32.h"
#include "ticker.h"
#include <mmsystem.h>

#define MAX_CDROM_TRACKS    99

#define NUMVOLUMEFADERS_MAX 0x40


/****************************************************************************
	}N
 ***************************************************************************/

#define MAKE_FRAMES(m, s, f)  ((((m * 60) + s) * 75) + f)

INLINE DWORD msf_to_frame(DWORD msf)
{
	int m, s, f;

	m = MCI_MSF_MINUTE(msf);
	s = MCI_MSF_SECOND(msf);
	f = MCI_MSF_FRAME(msf);
	return MAKE_FRAMES(m, s, f);
}


INLINE void frame_to_msf(DWORD msf, int *m, int *s, int *f)
{
	*f = msf % 75;
	*s = msf / 75;
	*m = *s / 60;
	*s %= 60;
}


/****************************************************************************
	[J֐
 ***************************************************************************/

static int osd_cdda_play(int start, int length);


/****************************************************************************
	[J\
 ***************************************************************************/

static struct cdrom_track_t
{
	int   type;
	DWORD start;
	DWORD end;
	DWORD length;
	DWORD lba;
	int   flag;
} tracks[MAX_CDROM_TRACKS];


/****************************************************************************
	[Jϐ
 ***************************************************************************/

// CDDAĐp
static MCIDEVICEID mciID  = 0;
static int current_status = CDDA_NOTREADY;
static int autoloop       = 0;
static int num_tracks     = 0;
static DWORD total_time   = 0;

static TICKER start_time  = 0;
static TICKER pause_time  = 0;

// vOĐp
static int program[100];
static int num_program = 0;
static int program_pos = 0;

// ~LT[{[p
static UINT mixerID[NUMVOLUMEFADERS_MAX];
static MIXERCONTROLDETAILS MCD[NUMVOLUMEFADERS_MAX];
static MIXERCONTROLDETAILS_UNSIGNED org_volumes[NUMVOLUMEFADERS_MAX];
static int num_mixer_controls = 0;


/***************************************************************************
	O[o֐
 ***************************************************************************/

/*------------------------------------------------------

	CDDA

	  : int drive  hCuA0ƂhCuԍ
	߂l: :OSD_OK G[:OSD_ERROR

    CDfBAꍇG[Ԃ܂

 -----------------------------------------------------*/

int osd_cdda_init(int drive)
{
	MCI_OPEN_PARMS mci_open;
	MCI_SET_PARMS mci_set;
	MCI_STATUS_PARMS mci_status;
	DWORD dwFlags;
	char device[3] = "x:";

	// 
	mciID          = 0;
	current_status = CDDA_NOTREADY;
	autoloop       = 0;
	num_tracks     = 0;
	total_time     = 0;
	start_time     = 0;
	pause_time     = 0;

	// gbNf[^
	memset(&tracks, 0, sizeof(tracks));

	memset(&mciID, 0, sizeof(MCIDEVICEID));

	device[0] = drive + 'A';

	mci_open.lpstrDeviceType = (LPCSTR)MCI_DEVTYPE_CD_AUDIO;
	mci_open.lpstrElementName = device;

	// ʂɋL\ŃI[v
	dwFlags = MCI_OPEN_TYPE | MCI_OPEN_SHAREABLE | MCI_OPEN_TYPE_ID | MCI_OPEN_ELEMENT;
	if (mciSendCommand(0, MCI_OPEN, dwFlags, (DWORD)&mci_open) != MMSYSERR_NOERROR)
	{
		// I[vɎsALsŎĂ݂
		dwFlags = MCI_OPEN_TYPE | MCI_OPEN_TYPE_ID | MCI_OPEN_ELEMENT;
		if (mciSendCommand(0, MCI_OPEN, dwFlags, (DWORD)&mci_open) != MMSYSERR_NOERROR)
		{
			return OSD_ERROR;
		}
	}
	mciID = mci_open.wDeviceID;

	// ԃtH[}bgMSF`ɐݒ
	mci_set.dwTimeFormat = MCI_FORMAT_MSF;
	if (mciSendCommand(mciID, MCI_SET, MCI_SET_TIME_FORMAT, (DWORD)&mci_set) != MMSYSERR_NOERROR)
	{
		goto error;
	}

	// Xe[^X擾
	mci_status.dwItem = MCI_STATUS_MODE;
	if (mciSendCommand(mciID, MCI_STATUS, MCI_STATUS_ITEM | MCI_WAIT, (DWORD)&mci_status) != MMSYSERR_NOERROR)
	{
		goto error;
	}

	if (mci_status.dwReturn != MCI_MODE_NOT_READY && mci_status.dwReturn != MCI_MODE_OPEN)
	{
		int i, m, s, f;
		DWORD start, length, track_gap = 0;

		// ÖׁAĐ~
		mciSendCommand(mciID, MCI_STOP, MCI_WAIT, (DWORD)NULL);

		// gbN擾
		mci_status.dwItem = MCI_STATUS_NUMBER_OF_TRACKS;
		if (mciSendCommand(mciID, MCI_STATUS, MCI_STATUS_ITEM | MCI_WAIT, (DWORD)&mci_status) != MMSYSERR_NOERROR)
		{
			goto error;
		}
		num_tracks = mci_status.dwReturn;

		for (i = 1; i <= num_tracks; i++)
		{
			// gbÑ^Cv擾
			mci_status.dwTrack = i;
			mci_status.dwItem  = MCI_CDA_STATUS_TYPE_TRACK;
			if (mciSendCommand(mciID, MCI_STATUS, MCI_STATUS_ITEM | MCI_TRACK | MCI_WAIT, (DWORD)&mci_status) != MMSYSERR_NOERROR)
			{
				goto error;
			}
			tracks[i].type = mci_status.dwReturn;

			// Jnʒu
			mci_status.dwItem = MCI_STATUS_POSITION;
			if (mciSendCommand(mciID, MCI_STATUS, MCI_STATUS_ITEM | MCI_TRACK | MCI_WAIT, (DWORD)&mci_status) != MMSYSERR_NOERROR)
			{
				goto error;
			}
			tracks[i].start = mci_status.dwReturn;
			if (i == 1)
			{
				// Œ̃Mbv̂̂lĂ܂
				track_gap = msf_to_frame(tracks[i].start);
			}

			// f[^
			mci_status.dwItem = MCI_STATUS_LENGTH;
			if (mciSendCommand(mciID, MCI_STATUS, MCI_STATUS_ITEM | MCI_TRACK | MCI_WAIT, (DWORD)&mci_status) != MMSYSERR_NOERROR)
			{
				goto error;
			}
			tracks[i].length = mci_status.dwReturn;

			// IʒuvZ
			start = msf_to_frame(tracks[i].start);
			length = msf_to_frame(tracks[i].length);
			frame_to_msf(start + (length - track_gap), &m, &s, &f);
			tracks[i].end = MCI_MAKE_MSF(m, s, f);

			// Đ
			tracks[0].length += length;
			total_time += length;
		}

		// TOCvZ
		for (i = 1; i <= num_tracks; i++)
		{
			m = MCI_MSF_MINUTE(tracks[i].start);
			s = MCI_MSF_SECOND(tracks[i].start);
			f = MCI_MSF_FRAME(tracks[i].start);

			tracks[i].lba = MAKE_FRAMES(m, s, f) - track_gap;
		}

		start = msf_to_frame(tracks[num_tracks].start);
		length = msf_to_frame(tracks[num_tracks].length);

		tracks[0].lba = (start + length + 1) - track_gap;

		frame_to_msf(tracks[0].lba, &m, &s, &f);

		current_status = CDDA_STOP;

		return OSD_OK;
	}

error:
	// gbNNA
	num_tracks = 0;
	total_time = 0;
	memset(&tracks, 0, sizeof(tracks));

	osd_cdda_exit();

	return OSD_ERROR;
}


/*------------------------------------------------------

	CDDAI

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void osd_cdda_exit(void)
{
	if (mciID != 0)
	{
		// ܂~
		mciSendCommand(mciID, MCI_STOP, MCI_WAIT, (DWORD)NULL);

		// ăN[Y
		mciSendCommand(mciID, MCI_CLOSE, MCI_WAIT, (DWORD)NULL);

		mciID          = 0;
		current_status = CDDA_NOTREADY;
		autoloop       = 0;
		num_tracks     = 0;
	}
}


/*------------------------------------------------------

	CDDA̍Đ(gbNw)

	  : int track    ĐgbN
	߂l: :OSD_OK G[:OSD_ERROR

 -----------------------------------------------------*/

int osd_cdda_play_track(int track)
{
	num_program = 1;
	program_pos = 1;
	program[1] = track;

	if (osd_cdda_play(tracks[program[program_pos]].start, tracks[program[program_pos]].end) == OSD_OK)
	{
		start_time = ticker();
		return OSD_OK;
	}
	return OSD_ERROR;
}


/*------------------------------------------------------

	CDDA̍Đ(wgbNŌ܂)

	  : int start_track  ĐJngbN
	߂l: :OSD_OK G[:OSD_ERROR

 -----------------------------------------------------*/

int osd_cdda_play_tracks(int start_track)
{
	int i;

	num_program = 1;
	program_pos = start_track;

	for (i = 1; i <= num_tracks; i++)
	{
		if (tracks[i].type == MCI_CDA_TRACK_AUDIO)
		{
			// I[fBIgbNȂvOXgɒǉ
			program[num_program] = i;
			num_program++;
		}
		else if (i < start_track)
		{
			// f[^gbNȂ̂ŁAĐJnʒu炷
			program_pos--;
		}
	}

	program[num_program] = 0;

	num_program--;

	if (osd_cdda_play(tracks[program[program_pos]].start, tracks[program[program_pos]].end) == OSD_OK)
	{
		start_time = ticker();
		return OSD_OK;
	}
	return OSD_ERROR;
}


/*------------------------------------------------------

	CDDA̍Đ(̋ȂĐ)

	  : Ȃ
	߂l: :OSD_OK G[:OSD_ERROR

 -----------------------------------------------------*/

int osd_cdda_play_next_track(void)
{
	if (program_pos < num_program)
	{
		program_pos++;

		if (osd_cdda_play(tracks[program[program_pos]].start, tracks[program[program_pos]].end) == OSD_OK)
		{
			start_time = ticker();
			return OSD_OK;
		}
	}
	return OSD_ERROR;
}


/*------------------------------------------------------

	CDDA̍Đ(ŐȂĐ)

	  : Ȃ
	߂l: :OSD_OK G[:OSD_ERROR

 -----------------------------------------------------*/

int osd_cdda_play_prev_track(void)
{
	if (program_pos > 1)
	{
		program_pos--;
		if (osd_cdda_play(tracks[program[program_pos]].start, tracks[program[program_pos]].end) == OSD_OK)
		{
			start_time = ticker();
			return OSD_OK;
		}
	}
	return OSD_ERROR;
}


/*------------------------------------------------------

	gbN̑

	  : int pos   Jnʒu(+b)
	߂l: :OSD_OK G[:OSD_ERROR

 -----------------------------------------------------*/

int osd_cdda_play_foward(int sec)
{
	int m, s, start, end, cur;

	// ݂̋Ȃ̍ĐJnʒu
	m = MCI_MSF_MINUTE(tracks[program[program_pos]].start);
	s = MCI_MSF_SECOND(tracks[program[program_pos]].start);
	start = m * 60 + s;

	// ݂̍Đʒu
	cur = start + (ticker() - start_time) / TICKS_PER_SEC;

	// ݂̋Ȃ̍ĐIʒu
	m = MCI_MSF_MINUTE(tracks[program[program_pos]].end);
	s = MCI_MSF_SECOND(tracks[program[program_pos]].end);
	end = m * 60 + s;

	// 肷b𑫂
	cur += sec;

	if (cur >= end)
	{
		if (program_pos < num_program)
		{
			program_pos++;

			// ̋Ȃ̍ĐJnʒu
			m = MCI_MSF_MINUTE(tracks[program[program_pos]].start);
			s = MCI_MSF_SECOND(tracks[program[program_pos]].start);
			cur = m * 60 + s;
		}
		else
			cur = end;
	}

	m = cur / 60;
	s = cur % 60;

	if (osd_cdda_play(MCI_MAKE_MSF(m, s, 0), tracks[program[program_pos]].end) == OSD_OK)
	{
		// X^[g̍ČvZ
		start_time = ticker() - (cur - start) * TICKS_PER_SEC;
		return OSD_OK;
	}
	return OSD_ERROR;
}


/*------------------------------------------------------

	gbN̊߂

	  : int pos   Jnʒu(-b)
	߂l: :OSD_OK G[:OSD_ERROR

 -----------------------------------------------------*/

int osd_cdda_play_rewind(int sec)
{
	int m, s, start, end, cur;

	// ݂̋Ȃ̍ĐJnʒu
	m = MCI_MSF_MINUTE(tracks[program[program_pos]].start);
	s = MCI_MSF_SECOND(tracks[program[program_pos]].start);
	start = m  * 60 + s;

	// ݂̍Đʒu
	cur = start + (ticker() - start_time) / TICKS_PER_SEC;

	// ߂b
	cur -= sec;

	if (cur < 0)
	{
		if (program_pos > 1)
		{
			program_pos--;

			// ŐȂ̍ĐIʒu
			m = MCI_MSF_MINUTE(tracks[program[program_pos]].end);
			s = MCI_MSF_SECOND(tracks[program[program_pos]].end);
			end = m * 60 + s;

			// ՂŎvẐŁAJnČvZ
			m = MCI_MSF_MINUTE(tracks[program[program_pos]].start);
			s = MCI_MSF_SECOND(tracks[program[program_pos]].start);
			start = m * 60 + s;

			cur += end;
		}
		else
			cur = 0;
	}

	m = cur / 60;
	s = cur % 60;

	if (osd_cdda_play(MCI_MAKE_MSF(m, s, 0), tracks[program[program_pos]].end) == OSD_OK)
	{
		// X^[g̍ČvZ
		start_time = ticker() - (cur - start) * TICKS_PER_SEC;
		return OSD_OK;
	}
	return OSD_ERROR;
}


/*------------------------------------------------------

	CDDÄꎞ~

	  : Ȃ
	߂l: :OSD_OK G[:OSD_ERROR

 -----------------------------------------------------*/

int osd_cdda_pause(void)
{
	if (current_status == CDDA_PLAY)
	{
		// |[Y
		if (mciSendCommand(mciID, MCI_PAUSE, MCI_WAIT, (DWORD)NULL) == MMSYSERR_NOERROR)
		{
			current_status = CDDA_PAUSE;
			pause_time = ticker();
			return OSD_OK;
		}
	}

	return OSD_ERROR;
}


/*------------------------------------------------------

	CDDA̍ĐĊJ

	  : Ȃ
	߂l: :OSD_OK G[:OSD_ERROR

 -----------------------------------------------------*/

int osd_cdda_resume(void)
{
	MCI_PLAY_PARMS mci_play;
	MCI_STATUS_PARMS mci_status;

	if (current_status == CDDA_PAUSE)
	{
		// ݈ʒu̎擾,ۑ
		mci_status.dwItem = MCI_STATUS_POSITION;
		if (mciSendCommand(mciID, MCI_STATUS, MCI_STATUS_ITEM | MCI_WAIT, (DWORD)&mci_status) == MMSYSERR_NOERROR)
		{
			// ĊJ
			mci_play.dwFrom = mci_status.dwReturn;
			mci_play.dwTo   = tracks[program[program_pos]].end;
			mci_play.dwCallback = (DWORD)MyApp.m_hWnd;;
			if (mciSendCommand(mciID, MCI_PLAY, MCI_FROM | MCI_TO | MCI_NOTIFY, (DWORD)&mci_play) == MMSYSERR_NOERROR)
			{
				current_status = CDDA_PLAY;
				start_time += ticker() - pause_time;
				pause_time = 0;
				return OSD_OK;
			}
		}
	}

	return OSD_ERROR;
}


/*------------------------------------------------------

	CDDA̒~

	  : Ȃ
	߂l: :OSD_OK G[:OSD_ERROR

 -----------------------------------------------------*/

int osd_cdda_stop(void)
{
	// ~
	if (mciSendCommand(mciID, MCI_STOP, MCI_WAIT, (DWORD)NULL) != MMSYSERR_NOERROR)
	{
		return OSD_ERROR;
	}

	current_status = CDDA_STOP;
	program_pos = 0;
	num_program = 0;
	start_time  = 0;
	pause_time  = 0;
	autoloop    = 0;

	return OSD_OK;
}


/*------------------------------------------------------

	CDDA̍Đ(vOĐ)

	  : int *program_list vOXg
	߂l: :OSD_OK G[:OSD_ERROR

 -----------------------------------------------------*/

int osd_cdda_play_program(int *program_list)
{
	int i;

	num_program = 1;

	i = 1;
	while (program_list[i])
	{
		program[num_program++] = program_list[i];
		if (num_program == 99)
			break;
		i++;
	}

	program[num_program] = -1;

	num_program--;
	program_pos = 1;

	if (osd_cdda_play(tracks[program[program_pos]].start, tracks[program[program_pos]].end) == OSD_OK)
	{
		start_time = ticker();
		return OSD_OK;
	}
	return OSD_ERROR;
}


/*------------------------------------------------------

	CDDA̍Đ(vOĐAio[w)

	  : int program_no   Đ郊Xgԍ
	߂l: :OSD_OK G[:OSD_ERROR

 -----------------------------------------------------*/

int osd_cdda_play_program_no(int program_no)
{
	program_pos = program_no;

	if (osd_cdda_play(tracks[program[program_pos]].start, tracks[program[program_pos]].end) == OSD_OK)
	{
		start_time = ticker();
		return OSD_OK;
	}
	return OSD_ERROR;
}


/*------------------------------------------------------

	CDDA̍Đ(vOLZ)

	  : Ȃ
	߂l: Ȃ

     vÕLẐݍsAĐ͂̂܂
       Ō̃gbN܂ős܂
       I[g[v܂

 -----------------------------------------------------*/

void osd_cdda_chancel_program(void)
{
	int i, start_track;

	num_program = 1;
	start_track = program[program_pos];
	program_pos = program[program_pos];

	for (i = 1; i <= num_tracks; i++)
	{
		if (tracks[i].type == MCI_CDA_TRACK_AUDIO)
		{
			// I[fBIgbNȂvOXgɒǉ
			program[num_program] = i;
			num_program++;
		}
		else if (i < start_track)
		{
			// f[^gbNȂ̂ŁAĐJnʒu炷
			program_pos--;
		}
	}

	program[num_program] = -1;

	num_program--;
}



/*------------------------------------------------------

	ĐoߎԎ擾

	  : int *minutes  i[|C^
	        int *seconds  bi[|C^
	߂l: :OSD_OK G[:OSD_ERROR

 -----------------------------------------------------*/

int osd_cdda_get_play_time(int *minutes, int *seconds)
{
	// MCI͎擾łȂꍇ(/߂)Ă܂蓖ĂɂȂȂ̂ŁAȊ
	TICKER play_sec;

	if (current_status == CDDA_PAUSE)
	{
		play_sec = (pause_time - start_time) / TICKS_PER_SEC;
	}
	else
	{
		play_sec = (ticker() - start_time) / TICKS_PER_SEC;
	}

	*minutes = play_sec / 60;
	*seconds = play_sec % 60;

	return OSD_OK;
}


/*------------------------------------------------------

	CDDAI[g[vݒ/

	  : int loop  I[g[vtO
	߂l: Ȃ

 -----------------------------------------------------*/

void osd_cdda_set_autoloop(int loop)
{
	autoloop = loop;
}


/*------------------------------------------------------

	CDDAĐXe[^X̎擾

	  : Ȃ
	߂l: CDDA_PLAY,STOP,PAUSE

 -----------------------------------------------------*/

int osd_cdda_get_status(void)
{
	return current_status;
}


/*------------------------------------------------------

	gbN擾

	  : Ȃ
	߂l: gbN

 -----------------------------------------------------*/

int osd_cdda_get_num_tracks(void)
{
	return num_tracks;
}


/*------------------------------------------------------

	gbN擾

	  : int track gbNԍ
	߂l: MSF`̃gbN

 -----------------------------------------------------*/

int osd_cdda_get_track_length(int track)
{
	return tracks[track].length;
}


/*------------------------------------------------------

	gbN̍Đb擾

	  : gbNԍ
	߂l: b

 -----------------------------------------------------*/

int osd_cdda_get_track_sec(int track)
{
	int m, s, f;

	m = MCI_MSF_MINUTE(tracks[track].length);
	s = MCI_MSF_SECOND(tracks[track].length);
	f = MCI_MSF_FRAME(tracks[track].length);

	return m * 60 + s + (f != 0);
}


/*------------------------------------------------------

	I[fBIgbN̑ĐԂ擾

	  : int *minutes  i[|C^
	        int *seconds  bi[|C^
	߂l: Ȃ

 -----------------------------------------------------*/

void osd_cdda_get_totaltime(int *minutes, int *seconds)
{
	int s, f;

	f = total_time % 75;
	s = total_time / 75;

	*minutes = s / 60;
	*seconds = (s % 60) + (f != 0);
}


/*------------------------------------------------------

	CDI[fBIgbNĂ邩`FbN

	  : Ȃ
	߂l: 1; 0:Ȃ

 -----------------------------------------------------*/

int osd_cdda_has_audio_track(void)
{
	int i;

	for (i = 1; i <= num_tracks; i++)
	{
		if (tracks[i].type == MCI_CDA_TRACK_AUDIO)
			return 1;
	}
	return 0;
}


/*------------------------------------------------------

	w肵gbN̎ނ擾

	  : int track   gbNԍ
	߂l: 1;I[fBIgbN 0:f[^gbN

 -----------------------------------------------------*/

int osd_cdda_get_track_type(int track)
{
	return (tracks[track].type == MCI_CDA_TRACK_AUDIO);
}


/*------------------------------------------------------

	݂̍ĐgbNԂ

	  : Ȃ
	߂l: ݂̃gbNԍ

 -----------------------------------------------------*/

int osd_cdda_get_current_track(void)
{
	if (current_status != CDDA_STOP)
		return program[program_pos];
	else
		return 0;
}


/*------------------------------------------------------

	݂̍ĐvOԍԂ

	  : Ȃ
	߂l: ݂̃vOԍ

 -----------------------------------------------------*/

int osd_cdda_get_current_program(void)
{
	if (current_status != CDDA_STOP)
		return program_pos;
	else
		return 0;
}


/*------------------------------------------------------

	gbNJnLBA擾

	  : int track gbNԍ
	߂l: LBA

 -----------------------------------------------------*/

int osd_cdda_get_track_lba(int track)
{
	return tracks[track].lba;
}


/*------------------------------------------------------

	CDDÃI[g[vp (Windows Message)

	߂l: :TRUE

 -----------------------------------------------------*/

BOOL CDDA_OnMessage(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam, LRESULT *pResult)
{
	switch (Msg)
	{
	case MM_MCINOTIFY:
		switch (wParam)
		{
		case MCI_NOTIFY_SUCCESSFUL:
			if (program_pos == num_program)
			{
				program_pos = 1;
				if (autoloop)
				{
					// ŏ̃f[^Đ
					osd_cdda_play(tracks[program[program_pos]].start, tracks[program[program_pos]].end);
					start_time = ticker();
					return TRUE;
				}

				// [vȂꍇ͒~
				current_status = CDDA_STOP;
			}
			else
			{
				// ̃f[^Đ
				program_pos++;
				osd_cdda_play(tracks[program[program_pos]].start, tracks[program[program_pos]].end);
				start_time = ticker();
			}
			return TRUE;
		}
	}
	return FALSE;
}


/*------------------------------------------------------

	CDDA~LT[Rg[̏

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void osd_cdda_init_volume(void)
{
	int i, j;
	int num_mixers;

	// {[~LT[̃foCX擾
	num_mixers = mixerGetNumDevs();

	for (i = 0; i < num_mixers; i++)
	{
		HMIXER hMixer;
		MIXERCAPS mxcaps;

		// ~LT[I[v
		if (mixerOpen(&hMixer, i, 0, 0, 0) != MMSYSERR_NOERROR)
			continue;

		// ~LT[̔\͎擾
		if (mixerGetDevCaps((UINT)hMixer, &mxcaps, sizeof(mxcaps)) != MMSYSERR_NOERROR)
		{
			mixerClose(hMixer);
			continue;
		}

		for (j = 0; j < (int)mxcaps.cDestinations; j++)
		{
			MIXERLINE mxl;
			int k, numcon;

			mxl.cbStruct = sizeof(mxl);
			mxl.dwDestination = j;

			// Co͏擾
			if (mixerGetLineInfo((HMIXEROBJ)hMixer, &mxl, MIXER_GETLINEINFOF_DESTINATION) != MMSYSERR_NOERROR)
				continue;

			numcon = mxl.cConnections;
			for (k = 0; k < numcon; k++)
			{
				mxl.cbStruct = sizeof(mxl);
				mxl.dwDestination = j;
				mxl.dwSource = k;

				// C͏擾
				if (mixerGetLineInfo((HMIXEROBJ)hMixer, &mxl, MIXER_GETLINEINFOF_SOURCE) != MMSYSERR_NOERROR)
					continue;

				// CDDAȂ珈𑱂
				if ((mxl.fdwLine & MIXERLINE_LINEF_SOURCE) && mxl.dwComponentType == MIXERLINE_COMPONENTTYPE_SRC_COMPACTDISC)
				{
					MIXERLINECONTROLS mxlc;
					MIXERCONTROL *pmxc;
					int l;

					mxl.cbStruct = sizeof(mxl);
					mxl.dwLineID = mxl.dwLineID;

					// CID擾
					if (mixerGetLineInfo((HMIXEROBJ)hMixer, &mxl, MIXER_GETLINEINFOF_LINEID) != MMSYSERR_NOERROR)
						continue;

					if (mxl.cControls == 0)
						continue;

					// CRg[m
					pmxc = (MIXERCONTROL *)malloc(sizeof(MIXERCONTROL) * mxl.cControls);
					mxlc.cbStruct = sizeof(mxlc);
					mxlc.dwLineID = mxl.dwLineID;
					mxlc.cControls = mxl.cControls;
					mxlc.cbmxctrl = sizeof(MIXERCONTROL);
					mxlc.pamxctrl = pmxc;
					if (mixerGetLineControls((HMIXEROBJ)hMixer, &mxlc, MIXER_GETLINECONTROLSF_ALL) != MMSYSERR_NOERROR)
					{
						free(pmxc);
						continue;
					}

					for (l = 0; l < (int)mxlc.cControls; l++)
					{
						// {[Rg[H
						if (pmxc[l].dwControlType == MIXERCONTROL_CONTROLTYPE_VOLUME)
						{
							MIXERCONTROLDETAILS *pmxcd = MCD + num_mixer_controls;

							mixerID[num_mixer_controls] = i;

							// {[Rg[łΏڍׂȃf[^擾I
							pmxcd->cbStruct       = sizeof(MIXERCONTROLDETAILS);
							pmxcd->dwControlID    = pmxc[l].dwControlID;
							pmxcd->cChannels      = 1;
							pmxcd->cMultipleItems = pmxc[l].cMultipleItems;
							pmxcd->cbDetails      = sizeof(MIXERCONTROLDETAILS_UNSIGNED);
							pmxcd->paDetails      = org_volumes + num_mixer_controls;
							if (mixerGetControlDetails((HMIXEROBJ)hMixer, pmxcd, 0L) == MMSYSERR_NOERROR)
								num_mixer_controls ++;
							break;
						}
					}
					free(pmxc);

					if (num_mixer_controls >= NUMVOLUMEFADERS_MAX)
						break;
				}
				if (num_mixer_controls >= NUMVOLUMEFADERS_MAX)
					break;
			}
			if (num_mixer_controls >= NUMVOLUMEFADERS_MAX)
				break;
		}
		mixerClose(hMixer);
		if (num_mixer_controls >= NUMVOLUMEFADERS_MAX)
			break;
	}
}


/*------------------------------------------------------

	CDDAʐݒ

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void osd_cdda_set_volume(int volume)
{
	int i;

	for (i = 0; i < num_mixer_controls; i++)
	{
		HMIXER hMixer;

		if (mixerOpen(&hMixer, mixerID[i], 0, 0, 0) == MMSYSERR_NOERROR)
		{
			MIXERCONTROLDETAILS mxcd = MCD[i];
			MIXERCONTROLDETAILS_UNSIGNED mxcd_u = org_volumes[i];

			mxcd.paDetails = &mxcd_u;
			mxcd_u.dwValue = volume;

			mixerSetControlDetails((HMIXEROBJ)hMixer, &mxcd, 0L);
			mixerClose(hMixer);
		}
	}
}



/*------------------------------------------------------

	ύXCDDAʂԂɖ߂

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void osd_cdda_restore_volume(void)
{
	int i;

	for (i = 0; i < num_mixer_controls; i++)
	{
		HMIXER hMixer;

		if (mixerOpen(&hMixer, mixerID[i], 0, 0, 0) == MMSYSERR_NOERROR)
		{
			mixerSetControlDetails((HMIXEROBJ)hMixer, MCD + i, 0L);
			mixerClose(hMixer);
		}
	}
}


/****************************************************************************
	[J֐
 ***************************************************************************/

/*------------------------------------------------------

	CDDA̍Đ

	  : int start    ĐJnʒu(MSF)
	        int end      ĐIʒu(MSF)
	        int loop     [vĐ=1,Ȃ=0
	߂l: :OSD_OK G[:OSD_ERROR

 -----------------------------------------------------*/

static int osd_cdda_play(int start, int end)
{
	MCI_PLAY_PARMS mci_play;

	mci_play.dwFrom = start;
	mci_play.dwTo = end;
	mci_play.dwCallback = (DWORD)MyApp.m_hWnd;
	if (mciSendCommand(mciID, MCI_PLAY, MCI_FROM | MCI_TO | MCI_NOTIFY, (DWORD)&mci_play) != MMSYSERR_NOERROR)
	{
		return OSD_ERROR;
	}

	current_status = CDDA_PLAY;

	return OSD_OK;
}



/*------------------------------------------------------

	CDDA̍Đ(KOF'96 NEOGEO Collection RgĐ)

	  : int track    ĐgbN
	߂l: :OSD_OK G[:OSD_ERROR

 -----------------------------------------------------*/

int kof96ngc_cdda_play_comment_track(int track)
{
	int m, s, f;

	num_program = 1;
	program_pos = 1;
	program[1] = track;

	if (tracks[track].flag == 0)
	{
		m = MCI_MSF_MINUTE(tracks[track].end);
		s = MCI_MSF_SECOND(tracks[track].end);
		f = MCI_MSF_FRAME(tracks[track].end);

		s -= 7;
		if (s < 0)
		{
			m--;
			s += 60;
		}

		tracks[track].end = MCI_MAKE_MSF(m, s, f);
		tracks[track].flag = 1;
	}

	if (osd_cdda_play(tracks[program[program_pos]].start, tracks[program[program_pos]].end) == OSD_OK)
	{
		start_time = ticker();
		return OSD_OK;
	}
	return OSD_ERROR;
}
