/***************************************************************************

	fileio.c

	t@Co,hCu擾

***************************************************************************/

#include "neogeocd.h"


/*------------------------------------------------------

	t@C̑݃`FbN

	  : const char *path `FbNt@C̃pX
	߂l: t@C̃TCY

 -----------------------------------------------------*/

int osd_file_exist(const char *path)
{
	struct stat stat_buffer;

	if (stat(path, &stat_buffer) == 0)
		return stat_buffer.st_size;
	else
		return 0;
}


/*------------------------------------------------------

	tH_݂Ȃꍇɍ쐬

	  : const char *path  쐬tH_
	߂l: :OSD_OK  s:OSD_ERROR

 -----------------------------------------------------*/

int osd_mkdir(const char *path)
{
	char *p, curdir[256], dir[256];

	getcwd(curdir, 255);

	if (chdir(path) == 0)
	{
		// łɑ݂
		chdir(curdir);
		return OSD_OK;
	}

	strcpy(dir, path);

	if (strchr(dir, ':'))
	{
		// hCuw肳Ă
		char tmp[256];
		int i;

		strcpy(tmp, path);

		p = strchr(tmp, ':') + 1;
		if (*p == '\\' || *p == '/') p++;

		*p = '\0';
		i = strlen(tmp);

		if (chdir(tmp) != 0)
			return OSD_ERROR;

		p = &dir[i];
	}
	else if (dir[0] == '\\' || dir[0] == '/')
	{
		// [gw肳Ă
		if (chdir("\\") != 0)
			return OSD_ERROR;

		p = &dir[1];
	}
	else
		p = dir;

	p = strtok(p, "/\\\0");
	while (p)
	{
		if (strcmp(p, ".") == 0)
		{
			// Ȃ
		}
		else if (strcmp(p, "..") == 0)
		{
			// ɖ߂
			if (chdir(p) != 0)
			{
				return OSD_ERROR;
			}
		}
		else  if (chdir(p) != 0)
		{
			// tH_쐬ĕύX
			if (mkdir(p) != 0)
			{
				// tH_쐬łȂ
				return OSD_ERROR;
			}
			else if (chdir(p) != 0)
			{
				// 쐬tH_ɕύXłȂ
				return OSD_ERROR;
			}
		}

		// ̃g[N̐؂o
		p = strtok(NULL, "/\\\0");
	}

	// ŏ̃tH_ɖ߂
	chdir(curdir);

	return OSD_OK;
}


/*------------------------------------------------------

	hCuʔ

	  : hCuԍ
	߂l: hCu̎

 -----------------------------------------------------*/

int osd_get_drive_type(int drive)
{
	int ret;
	char root[8] = "x:\\";

	root[0] = drive + 'A';

	switch (GetDriveType(root))
	{
	case DRIVE_NO_ROOT_DIR:
		ret = OSD_DRIVE_NOTFOUND;
		break;

	case DRIVE_REMOVABLE:
		ret = OSD_DRIVE_REMOVABLE;
		break;

	case DRIVE_FIXED:
		ret = OSD_DRIVE_FIXED;
		break;

	case DRIVE_REMOTE:
		ret = OSD_DRIVE_NETWORK;
		break;

	case DRIVE_CDROM:
		ret = OSD_DRIVE_CDROM;
		break;

	case DRIVE_RAMDISK:
		ret = OSD_DRIVE_RAMDISK;
		break;

	default:
		ret = OSD_DRIVE_UNKNOWN;
		break;
	}

	return ret;
}


/*------------------------------------------------------

	hCugp\`FbN

	  : hCuԍ
	߂l: OSD_OK:gp\ OSD_ERROR:gps

  [oufBȀꍇAGetDriveType()ł
    ۂɎgp\ʂłȂ߁A
    GetDiskFreeSpace1ZN^̃oCg
    擾A0ŖΎgp\ƂĂ܂B

 -----------------------------------------------------*/

int osd_drive_is_ready(int drive)
{
	char root[8] = "x:\\";
	DWORD dwBytesPerSect;

	root[0] = drive + 'A';

	GetDiskFreeSpace(root, NULL, &dwBytesPerSect, NULL, NULL);

	return (dwBytesPerSect != 0) ? OSD_OK : OSD_ERROR;
}


/*------------------------------------------------------

	gC̊JԌo

	  : hCuԍ
	߂l: 1:JĂ 0:Ă -1:os

 -----------------------------------------------------*/

int osd_get_tray_state(int drive)
{
	HANDLE hDevice;
	char buf[MAX_PATH+1];
	BOOL res = 0;

	// ŏ̏Ԃ擾
	if (osd_drive_is_ready(drive) == OSD_OK)
	{
		// fBAĂ̂ȂĂ̂Ń`FbNKvȂ
		return 0;
	}

	sprintf(buf, "\\\\.\\%c:", drive + 'A');

	hDevice = CreateFile(buf, GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
	if (hDevice != INVALID_HANDLE_VALUE)
	{
		DWORD nOutBufferSize;
		PREVENT_MEDIA_REMOVAL pmr;

		pmr.PreventMediaRemoval = TRUE;

		if (DeviceIoControl(hDevice, IOCTL_STORAGE_MEDIA_REMOVAL, &pmr, sizeof(pmr), NULL, 0, &nOutBufferSize, NULL) == 0)
		{
			CloseHandle(hDevice);
			return -1;
		}

		res = DeviceIoControl(hDevice, IOCTL_STORAGE_EJECT_MEDIA, NULL, 0, NULL, 0, &nOutBufferSize, NULL);

		pmr.PreventMediaRemoval = FALSE;
		DeviceIoControl(hDevice, IOCTL_STORAGE_MEDIA_REMOVAL, &pmr, sizeof(pmr), NULL,0, &nOutBufferSize, NULL);

		CloseHandle(hDevice);
	}
	else
		return -1;

	return (res != 0) ? 1 : 0;
}
