/***************************************************************************

	DirectDraw.c

	DirectDraw/I

***************************************************************************/

#include "osdepend.h"
#include <windowsx.h>
#include <ddraw.h>
#include "DirectDraw.h"


/***************************************************************************
	vg^Cv
 ***************************************************************************/

static BOOL WINAPI DDEnumInfo(GUID FAR *lpGUID, LPSTR lpDriverDescription, LPSTR lpDriverName, LPVOID lpContext, HMONITOR hm);
static HRESULT CALLBACK EnumDisplayModesCallback(DDSURFACEDESC *pddsd, LPVOID Context);
static void CalculateDisplayModes(void);


/***************************************************************************
	O[oϐ
 ***************************************************************************/

LPDIRECTDRAW2 dd = NULL;


/***************************************************************************
	[Jϐ
 ***************************************************************************/

#define MAX_DISPLAYS 8

static int num_displays = 0;

static LPGUID lpGUIDList[MAX_DISPLAYS];
static LPGUID lpCurrentGUID;

static struct tDisplayModes DisplayModes;


/***************************************************************************
	O[o֐
 ***************************************************************************/

/*--------------------------------------------------------

	DirectDraw̏

	  : Ȃ
	߂l: :OSD_OK  s:OSD_ERROR

 -------------------------------------------------------*/

int DirectDraw_Initialize(void)
{
	LPDIRECTDRAW ddx1;

	memset(&lpGUIDList, 0, sizeof(lpGUIDList));
	num_displays = 0;

	lpCurrentGUID = NULL;

	// DirectDraw1C^tF[X쐬
	if (DirectDrawCreate(NULL, &ddx1, NULL) != DD_OK)
	{
		logerror("DirectDrawCreate failed.\n");
		dd = NULL;
		return OSD_ERROR;
	}

	// DirectDraw2C^tF[X擾
	if (IDirectDraw_QueryInterface(ddx1, &IID_IDirectDraw2, (void **)&dd) != DD_OK)
	{
		logerror("DirectDraw::QueryInterface (DirectDraw2) failed.\n");
		dd = NULL;
		IDirectDraw_Release(ddx1);
		return OSD_ERROR;
	}

	// DirectDraw1C^tF[X
	IDirectDraw_Release(ddx1);

	// gp\ȃfBXvC̈ꗗ擾
	DirectDrawEnumerateEx(DDEnumInfo, NULL, DDENUM_ATTACHEDSECONDARYDEVICES | DDENUM_DETACHEDSECONDARYDEVICES);

	return OSD_OK;
}


/*--------------------------------------------------------

	DirectDraw̏I

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

void DirectDraw_Close(void)
{
	int i;

	for (i = 0; i < num_displays; i++)
	{
		if (lpGUIDList[i])
		{
			free(lpGUIDList[i]);
			lpGUIDList[i] = NULL;
		}
	}
	num_displays = 0;

	if (dd)
	{
		IDirectDraw2_Release(dd);
		dd = NULL;
	}
}


/*--------------------------------------------------------

	w肵fBXvCDirectDraw쐬

	  : int num_display  fBXvCԍ
	߂l: Ȃ

  -1w肷HELō쐬
    G[ǂ dd  NULL ǂŔf

 -------------------------------------------------------*/

void DirectDraw_CreateByIndex(int num_display)
{
	LPDIRECTDRAW ddx1;
	LPGUID lpGUID;

	// w肳ꂽfBXvCGUIDݒ
	if (num_display == -1)
	{
		// -1̏ꍇ́ADirectDraw HELgp
		lpGUID = (GUID FAR *)DDCREATE_EMULATIONONLY;
	}
	else
	{
		// ȊO͒ʏDirectDraw HALgp
		lpGUID = lpGUIDList[num_display];
	}

	// GUID̏ꍇ́AVɍ쐬KvȂ
	if (dd != NULL && lpCurrentGUID == lpGUID)
	{
		return;
	}

	// DirectDraw쐬ς݂̏ꍇ͉
	if (dd != NULL)
	{
		IDirectDraw2_Release(dd);
		dd = NULL;
	}

	// DirectDraw1C^tF[X擾
	if (DirectDrawCreate(lpGUID, &ddx1, NULL) != DD_OK)
	{
		logerror("DirectDrawCreate failed.\n");
		dd = NULL;
		DisplayModes.m_nNumModes = 0;
		return;
	}

	// DirectDraw7C^tF[X擾
	if (IDirectDraw_QueryInterface(ddx1, &IID_IDirectDraw2, (void **)&dd) != DD_OK)
	{
		logerror("DirectDraw::QueryInterface (DirectDraw2) failed.\n");
		dd = NULL;
		DisplayModes.m_nNumModes = 0;
		IDirectDraw_Release(ddx1);
		return;
	}

	// DirectDraw1C^tF[X
	IDirectDraw_Release(ddx1);

	lpCurrentGUID = lpGUID;

	// fBXvC[h̃`FbN
	CalculateDisplayModes();
}


/*--------------------------------------------------------

	fBXvC[ḧꗗ擾

	  : Ȃ
	߂l: fBXvC[h\

 -------------------------------------------------------*/

struct tDisplayModes *DirectDraw_GetDisplayModes(void)
{
	if (DisplayModes.m_nNumModes == 0)
		CalculateDisplayModes();

	return &DisplayModes;
}


/***************************************************************************
	[J֐
 ***************************************************************************/

/*--------------------------------------------------------

	gp\ȃfBXvC̈ꗗ擾
	(R[obN֐)

	  :
	߂l:

    A߂lDirectDraw̃wvQ

 -------------------------------------------------------*/

static BOOL WINAPI DDEnumInfo(GUID FAR *lpGUID, LPSTR lpDriverDescription, LPSTR lpDriverName, LPVOID lpContext, HMONITOR hm)
{
	if (lpGUID == NULL)
	{
		lpGUIDList[num_displays] = NULL;
	}
	else
	{
		lpGUIDList[num_displays] = (LPGUID)malloc(sizeof(GUID));
		memcpy(lpGUIDList[num_displays], lpGUID, sizeof(GUID));
	}

	num_displays++;
	if (num_displays == MAX_DISPLAYS)
		return DDENUMRET_CANCEL;
	else
		return DDENUMRET_OK;
}


/*--------------------------------------------------------

	݂̃fBXvC̃[hꗗ擾
	(R[obN֐)

	  :
	߂l:

    A߂lDirectDraw̃wvQ

 -------------------------------------------------------*/

static HRESULT CALLBACK EnumDisplayModesCallback(DDSURFACEDESC *pddsd, LPVOID Context)
{
	struct tDisplayModes *pDisplayModes = (struct tDisplayModes *)Context;

	if (pddsd->ddpfPixelFormat.dwRGBBitCount == 16)
	{
		pDisplayModes->m_Modes[pDisplayModes->m_nNumModes].m_dwWidth       = pddsd->dwWidth;
		pDisplayModes->m_Modes[pDisplayModes->m_nNumModes].m_dwHeight      = pddsd->dwHeight;
		pDisplayModes->m_Modes[pDisplayModes->m_nNumModes].m_dwBPP         = pddsd->ddpfPixelFormat.dwRGBBitCount;
		pDisplayModes->m_Modes[pDisplayModes->m_nNumModes].m_dwRefreshRate = pddsd->dwRefreshRate;
		pDisplayModes->m_nNumModes++;
	}

	if (pDisplayModes->m_nNumModes == MAXMODES)
		return DDENUMRET_CANCEL;
	else
		return DDENUMRET_OK;
}


/*--------------------------------------------------------

	fBXvC[ḧꗗ擾

	  :
	߂l:

    A߂lDirectDraw̃wvQ

 -------------------------------------------------------*/

static void CalculateDisplayModes(void)
{
	DisplayModes.m_nNumModes = 0;

	if (dd == NULL)
		return;

	IDirectDraw2_EnumDisplayModes(dd, DDEDM_REFRESHRATES, NULL, &DisplayModes, EnumDisplayModesCallback);
}
