/***************************************************************************

	osdepend.c

	OSˑ̊֐pwb_

***************************************************************************/

#ifndef OSDEPEND_H
#define OSDEPEND_H

#define OSNAME "Windows"

#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <direct.h>
#include <sys/stat.h>
#include <winioctl.h>
#include "osd_cpu.h"
#include "win32/win32.h"


#ifdef __LP64__
#define FPTR unsigned long   /* 64bit: sizeof(void *) is sizeof(long)  */
#else
#define FPTR unsigned int
#endif


#ifndef MAX_DRIVE
#define MAX_DRIVE 26
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1400)  /* Visual C++ 2005 */
#define chdir		_chdir
#define getcwd		_getcwd
#define mkdir		_mkdir
#define strdup		_strdup
#define stricmp		_stricmp
#define strnicmp	_strnicmp
#define swab		_swab
#endif

#if !defined(_MSC_VER) || (_MSC_VER < 1300) /* GCC or Visual C++ 6.0 */
#define _aligned_malloc(p, a)	malloc(p)
#define _aligned_free(p)		free(p)
#endif


/*------------------------------------------------------
  ֐sʂ̒l
 -----------------------------------------------------*/

enum
{
	OSD_ERROR = 0,
	OSD_OK
};


/*------------------------------------------------------
  AvP[VIǗ
 -----------------------------------------------------*/

enum
{
	OSD_EXEC = 0,	// s
	OSD_RESET,		// Zbg
	OSD_RESTART,	// G~[VċN
	OSD_REBOOT,		// AvP[VċN
	OSD_QUIT		// AvP[VI
};

int osd_get_app_state(void);
void osd_set_app_state(int state);


/*------------------------------------------------------
  ʏ
 -----------------------------------------------------*/

#define OSD_SCREEN 1

struct rectangle
{
	int min_x;
	int max_x;
	int min_y;
	int max_y;
};

struct osd_bitmap
{
	int width;
	int height;
	UINT16 *_private;
	UINT16 **line;
};

extern struct osd_bitmap scrbitmap;

// AI
int  osd_video_init(int width, int height, struct rectangle *rect);
void osd_video_exit(void);

// ėprbg}bvǗ
struct osd_bitmap *osd_alloc_bitmap(int width, int height);
void osd_free_bitmap(struct osd_bitmap *bitmap);

// XN[Ǘ
int  osd_create_screen(int width, int height);
void osd_set_screen(int no);
void osd_free_screen(int no);
int  osd_copy_screen(int no);

// fBXvCǗ
int  osd_create_display(int left, int top, int right, int bottom);
void osd_close_display(void);
int  osd_change_display(void);

// pbgǗ
int  osd_register_palette(UINT16 *palette, int size);
void osd_unregister_palette(UINT16 *palette);
UINT16 osd_set_palette(int r, int g, int b);
void osd_get_pen(UINT16 pen, int *r, int *g, int *b);
UINT16 osd_make_pen(int r, int g, int b);

// ʍXV
int  osd_skip_this_frame(void);
void osd_update_video(int draw_screen);


/*------------------------------------------------------
  L[{[h
 -----------------------------------------------------*/

struct KeyboardInfo
{
	unsigned code;
	unsigned standardcode;
	const char *name;
	const char *dispname;
};

enum
{
	KEYCODE_A, KEYCODE_B, KEYCODE_C, KEYCODE_D, KEYCODE_E, KEYCODE_F,
	KEYCODE_G, KEYCODE_H, KEYCODE_I, KEYCODE_J, KEYCODE_K, KEYCODE_L,
	KEYCODE_M, KEYCODE_N, KEYCODE_O, KEYCODE_P, KEYCODE_Q, KEYCODE_R,
	KEYCODE_S, KEYCODE_T, KEYCODE_U, KEYCODE_V, KEYCODE_W, KEYCODE_X,
	KEYCODE_Y, KEYCODE_Z, KEYCODE_0, KEYCODE_1, KEYCODE_2, KEYCODE_3,
	KEYCODE_4, KEYCODE_5, KEYCODE_6, KEYCODE_7, KEYCODE_8, KEYCODE_9,
	KEYCODE_0_PAD, KEYCODE_1_PAD, KEYCODE_2_PAD, KEYCODE_3_PAD, KEYCODE_4_PAD,
	KEYCODE_5_PAD, KEYCODE_6_PAD, KEYCODE_7_PAD, KEYCODE_8_PAD, KEYCODE_9_PAD,
	KEYCODE_F1, KEYCODE_F2, KEYCODE_F3, KEYCODE_F4, KEYCODE_F5,
	KEYCODE_F6, KEYCODE_F7, KEYCODE_F8, KEYCODE_F9, KEYCODE_F10,
	KEYCODE_F11, KEYCODE_F12,
	KEYCODE_ESC, KEYCODE_TILDE, KEYCODE_MINUS, KEYCODE_EQUALS, KEYCODE_BACKSPACE,
	KEYCODE_TAB, KEYCODE_OPENBRACE, KEYCODE_CLOSEBRACE, KEYCODE_ENTER, KEYCODE_COLON,
	KEYCODE_QUOTE, KEYCODE_BACKSLASH, KEYCODE_COMMA, KEYCODE_PERIOD,
	KEYCODE_SLASH, KEYCODE_SPACE, KEYCODE_INSERT, KEYCODE_DEL,
	KEYCODE_HOME, KEYCODE_END, KEYCODE_PGUP, KEYCODE_PGDN, KEYCODE_LEFT,
	KEYCODE_RIGHT, KEYCODE_UP, KEYCODE_DOWN,
	KEYCODE_SLASH_PAD, KEYCODE_ASTERISK, KEYCODE_MINUS_PAD, KEYCODE_PLUS_PAD,
	KEYCODE_DEL_PAD, KEYCODE_ENTER_PAD, KEYCODE_PAUSE,
	KEYCODE_LSHIFT, KEYCODE_RSHIFT, KEYCODE_LCONTROL, KEYCODE_RCONTROL,
	KEYCODE_LALT, KEYCODE_RALT, KEYCODE_SCRLOCK, KEYCODE_NUMLOCK, KEYCODE_CAPSLOCK,

	KEYCODE_SEMICOLON, KEYCODE_OEM_102, KEYCODE_F13, KEYCODE_F14, KEYCODE_F15,
	KEYCODE_KANA, KEYCODE_ABNT_C1, KEYCODE_CONVERT, KEYCODE_NOCONVERT,
	KEYCODE_YEN, KEYCODE_ABNT_C2, KEYCODE_EQUALS_PAD, KEYCODE_PREVTRACK,
	KEYCODE_ATMARK, KEYCODE_UNDERLINE, KEYCODE_KANJI, KEYCODE_STOP, KEYCODE_AX,
	KEYCODE_UNLABELED, KEYCODE_NEXTTRACK, KEYCODE_MUTE, KEYCODE_CALCULATOR,
	KEYCODE_PLAYPAUSE, KEYCODE_MEDIASTOP, KEYCODE_VOLUMEDOWN, KEYCODE_VOLUMEUP,
	KEYCODE_WEBHOME, KEYCODE_COMMA_PAD, KEYCODE_SYSRQ, KEYCODE_LWIN,
	KEYCODE_RWIN, KEYCODE_APPS, KEYCODE_POWER, KEYCODE_SLEEP, KEYCODE_WAKE,
	KEYCODE_WEBSEARCH, KEYCODE_WEBFAVORITES, KEYCODE_WEBREFRESH, KEYCODE_WEBSTOP,
	KEYCODE_WEBFORWARD, KEYCODE_WEBBACK, KEYCODE_MYCOMPUTER, KEYCODE_MAIL,
	KEYCODE_MEDIASELECT, KEYCODE_CIRCUMFLEX,

	KEYCODE_NONE = 0x8000, KEYCODE_UNKNOWN = 0xffff
};

// AI
int osd_keyboard_init(void);
void osd_keyboard_exit(void);
void osd_keyboard_reset(void);

// ͏XV
void osd_poll_keyboard(void);

// L[̓`FbN
int osd_is_key_pressed(int keycode);
int osd_is_key_pressed_memory(int keycode);

// ėpR[hƃR[h̕ϊ
int osd_get_keycode_by_name(char *name);
const char *osd_get_keyname_by_code(int code);
const char *osd_keyboard_get_dispname(int code);


/*------------------------------------------------------
  Q[Rg[[
 -----------------------------------------------------*/

struct JoystickInfo
{
	unsigned code;
	const char *name;
	const char *dispname;
};

enum
{
	JOY_AXIS_X_NEG,
	JOY_AXIS_X_POS,
	JOY_AXIS_Y_NEG,
	JOY_AXIS_Y_POS,
	JOY_AXIS_Z_NEG,
	JOY_AXIS_Z_POS,
	JOY_AXIS_RX_NEG,
	JOY_AXIS_RX_POS,
	JOY_AXIS_RY_NEG,
	JOY_AXIS_RY_POS,
	JOY_AXIS_RZ_NEG,
	JOY_AXIS_RZ_POS,
	JOY_BUTTON1,
	JOY_BUTTON2,
	JOY_BUTTON3,
	JOY_BUTTON4,
	JOY_BUTTON5,
	JOY_BUTTON6,
	JOY_BUTTON7,
	JOY_BUTTON8,
	JOY_BUTTON9,
	JOY_BUTTON10,
	JOY_BUTTON11,
	JOY_BUTTON12,
	JOY_BUTTON13,
	JOY_BUTTON14,
	JOY_BUTTON15,
	JOY_BUTTON16,
	JOY_UNKNOWN = 0xffff
};


// AI
int osd_joystick_init(void);
void osd_joystick_exit(void);
void osd_joystick_reset(void);

// Q[Rg[[蓖
void osd_set_joystick(void);

// ͏XV
void osd_poll_joystick(void);

// {^̓`FbN
int osd_is_joy_pressed(int keycode);
int osd_is_joy_pressed_memory(int joycode);

// ėpR[hƓR[h̕ϊ
int osd_make_internal_joycode(int player, int code);
int osd_restore_internal_joycode(int code);

// ėpR[hƃR[h̕ϊ
int osd_get_joycode_by_name(char *name);
const char *osd_get_joyname_by_code(int code);
const char *osd_joystick_get_dispnamee(int code);


/*------------------------------------------------------
  TEh
 -----------------------------------------------------*/

// I[fBIXg[
int osd_start_audio_stream(void);
void osd_stop_audio_stream(void);
int osd_update_audio_stream(INT16 *buffer);

// I[fBIL/؂ւ
void osd_sound_enable(int enable_it);

// j[̈ړ(WAV)ĐpBȂĂȂ
void osd_play_wav(unsigned char *wav);


/*------------------------------------------------------
  t@CyуhCu
 -----------------------------------------------------*/

enum {
	OSD_DRIVE_UNKNOWN = 0,
	OSD_DRIVE_NOTFOUND,
	OSD_DRIVE_REMOVABLE,
	OSD_DRIVE_FIXED,
	OSD_DRIVE_NETWORK,
	OSD_DRIVE_CDROM,
	OSD_DRIVE_RAMDISK,
	OSD_DRIVE_MAX
};

int osd_file_exist(const char *path);
int osd_mkdir(const char *path);
int osd_get_drive_type(int drive);
int osd_drive_is_ready(int drive);
int osd_get_tray_state(int drive);


/*------------------------------------------------------
  CDDA
 -----------------------------------------------------*/

// CDDȀ
enum
{
	CDDA_NOTREADY = 0,
	CDDA_PLAY,
	CDDA_STOP,
	CDDA_PAUSE,
	CDDA_STATUS_MAX
};

// AI
int  osd_cdda_init(int drive);
void osd_cdda_exit(void);

// {
int  osd_cdda_play_track(int track);
int  osd_cdda_play_tracks(int start_track);
int  osd_cdda_play_next_track(void);
int  osd_cdda_play_prev_track(void);
int  osd_cdda_play_foward(int sec);
int  osd_cdda_play_rewind(int sec);
int  osd_cdda_pause(void);
int  osd_cdda_resume(void);
int  osd_cdda_stop(void);

// vOĐ (NEOGEO CDp݂Ȃ)
int  osd_cdda_play_program(int *program_list);
int  osd_cdda_play_program_no(int program_no);
void osd_cdda_chancel_program(void);

// ĐԎ擾
int osd_cdda_get_play_time(int *minutes, int *seconds);

// I[g[vݒ
void osd_cdda_set_autoloop(int loop);

// CDDAf[^擾
int  osd_cdda_get_status(void);
int  osd_cdda_get_num_tracks(void);
int  osd_cdda_get_track_length(int track);
int  osd_cdda_get_track_sec(int track);
void osd_cdda_get_totaltime(int *minutes, int *seconds);
int  osd_cdda_get_track_type(int track);
int  osd_cdda_has_audio_track(void);
int  osd_cdda_get_current_track(void);
int  osd_cdda_get_current_program(void);

// TOC`FbNp
int  osd_cdda_get_track_lba(int track);

// CDDAʑ
void osd_cdda_init_volume(void);
void osd_cdda_set_volume(int volume);
void osd_cdda_restore_volume(void);


/*------------------------------------------------------
  O
 -----------------------------------------------------*/

void logerror(const char *text, ...);


/*------------------------------------------------------
  ̑
 -----------------------------------------------------*/

#ifndef CPUID_RESULT
#define CPUID_RESULT
#define HAS_MMX      0x00000001 // MMX
#define HAS_MMX2     0x00000002 // Enhanced MMX
#define HAS_SSE      0x00000010 // Stream SIMD Extention
#define HAS_SSE2     0x00000020 // Stream SIMD Extention 2
#define HAS_3DNow    0x00000100 // 3DNow!
#define HAS_E3DNow   0x00000200 // 3DNow! + Enhanced MMX
#define HAS_3DNowPro 0x00000310 // Enhanced 3DNow! + SSE
#define HAS_RDTSC    0x00010000 // RDSTC
#endif /* CPUID_RESULT */

// EBhE^Cgݒ
void osd_set_title(const char *text, ...);

// [Uւ̃bZ[W\
void osd_show_message(const char *text, ...);

#endif /* OSDEPEND_H */
