/***************************************************************************

	neogeocd.c

	G~[^̃C[`

***************************************************************************/

#include "neogeocd.h"


/***************************************************************************
	O[o֐
 ***************************************************************************/

/*--------------------------------------------------------

	G~[V̎s

	  : Ȃ
	߂l: IR[h 1=I,0=ċN

 -------------------------------------------------------*/

int neogeo_main(void)
{
	int quit = 0;

	first_time_boot = 1;

	cdrom_current_drive = -1;
	game_index = -1;
	cdrom_loading_state = CDROM_IDLE;

	timer_init();

	logerror("Start memory emulation.\n");
	if (memory_init())
	{
		logerror("Start CD-ROM emulation.\n");
		if (cdrom_init())
		{
			logerror("Start input device emulation.\n");
			if (input_init())
			{
				logerror("Start video emulation.\n");
				if (video_init())
				{
					logerror("Start sound emulation.\n");
					if (sound_init())
					{
						logerror("Initialize user interface.\n");
						if (ui_init())
						{
							cpu_init();

							while (osd_get_app_state() <= OSD_RESTART)
							{
								osd_set_app_state(OSD_EXEC);
								neogeo_run();
							}

							cpu_exit();
						}
						else
						{
							quit = 1;
							logerror("Could not initialize user interface.\n");
						}
						ui_exit();
					}
					else
					{
						quit = 1;
						logerror("Could not start sound emulation.\n");
					}
					sound_shutdown();
				}
				else if (!quit)
				{
					quit = 1;
					logerror("Could not start video emulation.\n");
				}
				video_shutdown();
			}
			else
			{
				quit = 1;
				logerror("Could not start input devicee emulation.\n");
			}
			input_shutdown();
		}
		else if (!quit)
		{
			quit = 1;
			logerror("Could not start CD-ROM emulation.\n");
		}
		cdrom_shutdown();
	}
	else if (!quit)
	{
		quit = 1;
		logerror("Could not start memory emulation.\n");
	}
	memory_shutdown();

	timer_free();

	if (quit) osd_set_app_state(OSD_QUIT);

	return osd_get_app_state();
}



/*--------------------------------------------------------

	ʂƃTEh̍XV

	  : Ȃ
	߂l: IR[h 1=I,0=ċN

 -------------------------------------------------------*/

void updatescreen(void)
{
	if (cdrom_loading_state != CDROM_IDLE)
	{
		loading_updatescreen();
		return;
	}

	if (driver_flag & PATCH_AOF2)
		m68000_write_memory_8(0x108000 + 0x280, 0);

	neogeo_cdda_check();
	sound_update();

	if (osd_skip_this_frame() == 0)
	{
		if (driver_type > 1)
			neogeo_raster_screenrefresh();
		else
			neogeo_screenrefresh();
	}

	if (boot_bios)
	{
		bios_run();
		if (osd_get_app_state())
			return;
	}
	else
	{
		bios_check_exit();
	}

	ui_menu();
	ui_show_popup();

	osd_update_video(1);
}
