/***************************************************************************

	memintrf.c

	C^[tF[XyM68000pANZX֐

***************************************************************************/

#ifndef MEMINTRF_H
#define MEMINTRF_H

/*------------------------------------------------------
  C^[tF[X
 -----------------------------------------------------*/

#define MAX_MEMORY_REGIONS 16

typedef UINT32  offs_t;

enum
{
	REGION_INVALID = 0xff,
	REGION_CPU1 = 0,
	REGION_CPU2,
	REGION_GFX1,
	REGION_GFX2,
	REGION_GFX3,
	REGION_GFX4,
#if ENABLE_SYSTEM_CHECK
	REGION_GFX5,
	REGION_GFX6,
#endif
	REGION_SOUND1,
	REGION_USER1,
	REGION_USER2,
	REGION_USER3,
	REGION_MAX
};

typedef struct RegionInfo
{
	UINT8  *base;
	size_t length;
	UINT32 type;
	UINT32 flags;
} MEMREGION;


/*------------------------------------------------------
  C^[tF[Xp֐
 -----------------------------------------------------*/

int  memory_region_init(void);
void memory_region_shutdown(void);

int  memory_init(void);
void memory_shutdown(void);

UINT8  *memory_region(int region_type);
size_t memory_region_length(int region_type);


/*------------------------------------------------------
  M68000ANZX
 -----------------------------------------------------*/

extern UINT8 *m68k_rombase;
extern UINT8 *m68k_rambase;
extern UINT8 *opcode_base;
extern UINT8 *opcode_rambase;
extern UINT8 *opcode_entry;

#define READ8_HANDLER(name) 	UINT8  name(offs_t offset)
#define WRITE8_HANDLER(name) 	void   name(offs_t offset, UINT8 data)
#define READ16_HANDLER(name)	UINT16 name(offs_t offset, UINT16 mem_mask)
#define WRITE16_HANDLER(name)	void   name(offs_t offset, UINT16 data, UINT16 mem_mask)
#define READ32_HANDLER(name)	UINT32 name(offs_t offset)
#define WRITE32_HANDLER(name)	void   name(offs_t offset, UINT32 data)

/* ----- 16/32-bit memory accessing ----- */
#define COMBINE_DATA(varptr)		(*(varptr) = (*(varptr) & mem_mask) | (data & ~mem_mask))
#define COMBINE_SWABDATA(varptr)	(*(varptr) = (*(varptr) & (mem_mask << 8)) | (data & ~(mem_mask >> 8)))

/* ----- 16-bit memory accessing ----- */
#define ACCESSING_LSB16				((mem_mask & 0x00ff) == 0)
#define ACCESSING_MSB16				((mem_mask & 0xff00) == 0)
#define ACCESSING_LSB				ACCESSING_LSB16
#define ACCESSING_MSB				ACCESSING_MSB16

#define MEM_END	    -1
#define MEM_BAD     0
#define MEM_ROM     1
#define MEM_RAM     2
#define MEM_NOP     3
#define MEM_MAP     4

typedef struct readmem_t
{
	int type;
	offs_t start;
	offs_t end;
	UINT16 (*func)(offs_t offset, UINT16 mem_mask);
} READMEM;

typedef struct writemem_t
{
	int type;
	offs_t start;
	offs_t end;
	void (*func)(offs_t offset, UINT16 data, UINT16 mem_mask);
} WRITEMEM;


/*------------------------------------------------------
  M68000ANZXp֐
 -----------------------------------------------------*/

void initialize_memmap(void);

UINT8  __cdecl m68000_read_memory_8(offs_t offset);
UINT16 __cdecl m68000_read_memory_16(offs_t offset);
UINT32 __cdecl m68000_read_memory_32(offs_t offset);
void __cdecl m68000_write_memory_8(offs_t offset, UINT8 data);
void __cdecl m68000_write_memory_16(offs_t offset, UINT16 data);
void __cdecl m68000_write_memory_32(offs_t offset, UINT32 data);

void __cdecl m68000_setopbase(offs_t offset);

extern int m68000_read_memory_8_debug(int offset);
extern int m68000_read_memory_16_debug(int offset);
extern int m68000_read_memory_32_debug(int offset);

#endif /* MEMINTRF_H */
