/***************************************************************************

	loadscr.c

	NEOGEO CD [hʏ

***************************************************************************/

#include "neogeocd.h"


/****************************************************************************
	vg^Cv
 ***************************************************************************/

static void update_screen(int clear);
static int check_screen_data(offs_t offset, int type);
static void loading_upload_fix(void);
static void loading_upload_palette(void);


/****************************************************************************
	[Jϐ
 ***************************************************************************/

static int loading_wait;
static int ssg_cleared;
static int ssg_first_check;
static int ssg_check;


/****************************************************************************
	Oϐ
 ***************************************************************************/

extern int ssg_playing;


/***************************************************************************
	O[o֐
 ***************************************************************************/

/*--------------------------------------------------------

	[hʊJn

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

void loading_screen_start(void)
{
	loading_wait = 0;
	ssg_cleared = 0;
	ssg_check = 0;

	ssg_first_check = ssg_playing ? 0 : 1;

	if (with_image())
	{
		int i;
		offs_t offset;

		// FIXv[ޔ
		for (i = 0; i < 0x500; i++)
			m68000_write_memory_16(0x110804 + i * 2, neogeo_vidram16[0x7000 + i]);

		// [hʃZbgAbv
		m68000_interpreter(m68000_read_memory_32(0xc11c808), 0);

		loading_upload_fix();
		loading_upload_palette();

		// ȉ̃Q[͉ʍXVI܂ő҂ȂƁA`悷̂
		// Ă܂ׁAɎsFIXv[ɕ`悵Ă
		// Ղ̌O`A؂̌mA؂̌m2
		offset = m68000_read_memory_32(0x11c80c);
		if (offset != 0xc0c814)
		{
			i = 64; // Ö׃[vݒ

			if (GAME_NAME("aof3"))
			{
				while (i--)
				{
					offset = m68000_read_memory_32(0x11c80c);
					m68000_interpreter(offset, 0);

					if (offset == 0x1244f0 || offset == 0x124534
					||  offset == 0x1245b2 || offset == 0x1245ce)
						break;
				}
			}
			else if (GAME_NAME("lastblad"))
			{
				while (i--)
				{
					offset = m68000_read_memory_32(0x11c80c);
					m68000_interpreter(offset, 0);

					if (offset == 0x124550 || offset == 0x124b28)
						break;
				}
			}
			else if (GAME_NAME("lastbld2"))
			{
				while (i--)
				{
					if (offset == 0x1244aa || offset == 0x124d9c)
						break;
				}
			}
		}

		if (!(driver_flag & PATCH_SSRPG))
			loading_wait = 30;

		fix_disable_w(0);
		spr_disable_w(1);
		video_enable_w(1);
	}
	else if (GAME_NAME("overtop"))
	{
		UINT8 *src, *dst;

		src = memory_region(REGION_CPU1) + 0xe0000;
		dst = memory_region(REGION_GFX1);
		swab(src, dst, 0x20000);
#if ENABLE_SYSTEM_CHECK
		dst = memory_region(REGION_GFX5);
		swab(src, dst, 0x20000);
#endif
		neogeo_decode_fix(dst, 0, 0x20000);

		m68000_write_memory_32(0x11c80c, 0x8db0);	// ftHgƏIɗ̂ŕύX
	}
}


/*--------------------------------------------------------

	[hʏI

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

void loading_screen_stop(void)
{
	if (with_image())
	{
		UINT8 *src, *dst;
		offs_t src_offs, dst_offs;
		int i;

		// pbg𕜋A
		src_offs = 0x11be06;
		dst_offs = 0x400000;

		for (i = 0; i < 0x200; i += 4)
		{
			m68000_write_memory_32(dst_offs, m68000_read_memory_32(src_offs));
			src_offs += 4;
			dst_offs += 4;
		}

		// FIXf[^𕜋A
		src = memory_region(REGION_CPU1) + 0x115e06;
		dst = memory_region(REGION_GFX1);
		memcpy(dst, src, 0x6000);
#if ENABLE_SYSTEM_CHECK
		dst = memory_region(REGION_GFX5);
		memcpy(dst, src, 0x6000);
#endif
		neogeo_decode_fix(dst, 0, 0x6000);

		// FIXv[𕜋A
		for (i = 0; i < 0x500; i++)
			neogeo_vidram16[0x7000 + i] = m68000_read_memory_16(0x110804 + i * 2);

		fix_disable_w(0);
		spr_disable_w(0);
		video_enable_w(1);
	}
	else if (GAME_NAME("overtop"))
	{
		// svƎv邪AÖז߂
		m68000_write_memory_32(0x11c80c, 0x8854);
	}

	neogeo_set_title();
}


/*------------------------------------------------------

	ǂݍݐisxXV

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void loading_update_progress(void)
{
	UINT32 progress;
	UINT8 prev_progress;

	progress = m68000_read_memory_32(0x108000 + 0x7690);
	prev_progress = progress >> 16;

	progress += m68000_read_memory_32(0x108000 + 0x768c);
	m68000_write_memory_32(0x108000 + 0x7690, progress);

	if (progress >= 0x800000)
		m68000_write_memory_32(0x108000 + 0x7690, 0x800000);

	m68000_interpreter(m68000_read_memory_32(0x11c80c), 0);

	// watchdog
	m68000_write_memory_8(0x300001, m68000_get_reg(M68K_D0));
}


/*--------------------------------------------------------

	[hʂ̍XV

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

void loading_updatescreen(void)
{
	int update = with_image();

	if (!ssg_cleared)
	{
		if (ssg_playing)
		{
			ssg_first_check = 0;
			ssg_check = 0;
		}
		else
			ssg_check++;

		if (ssg_check > 20 || (ssg_first_check && ssg_check > 5))
			ssg_cleared = 1;

		if (update)
			neogeo_loading_screenrefresh();

		m68000_write_memory_8(0x300001, m68000_get_reg(M68K_D0));
	}
	else
	{
		// CD-ROMǂݍ݊҂
		if (cdrom_loading_state == CDROM_LOADING)
		{
			cdrom_load_next_data();
		}
		else if (cdrom_loading_state == CDROM_DONE)
		{
			if (loading_wait)
			{
				loading_wait = 0;
				loading_update_progress();
			}
			else
			{
				if (!(driver_flag & LOADING_TYPE1) && !cdrom_ipl_loading)
					cdrom_finish_load_files();

				update = 0;
				cdrom_loading_state = CDROM_IDLE;
			}
		}

		if (osd_skip_this_frame() == 0)
		{
			// Aj[VXVXgbvtO
			m68000_write_memory_8(0x108000 + 0x7793, 0x00);

			// Aj[V ({̓f[^ǂݍނƂɏ)
			m68000_interpreter(0xc0c8b2, 0);

			neogeo_loading_screenrefresh();
		}

		// I[o[gbv̓tOɊ֌WȂɍXV
		if (GAME_NAME("overtop")) update = 1;
	}

	sound_update();

	ui_menu();
	ui_show_popup();

	osd_update_video(update);
}


/***************************************************************************
	[J֐
 ***************************************************************************/

/*--------------------------------------------------------

	w肵f[^̃ItZbg擾

	  : int type   f[^`
	߂l: ItZbg

 -------------------------------------------------------*/

static offs_t check_offset;

static int check_screen_data(offs_t offset, int type)
{
	offs_t data_offset;
	int data_type;

	check_offset = offset;

	do
	{
		data_type = m68000_read_memory_32(check_offset);
		check_offset += 4;

		data_offset = m68000_read_memory_32(check_offset);
		check_offset += 4;

		if (data_type == type + 1)
			return -1;

		if (data_type == -1)
			return -1;

	} while (data_type != type);

	return data_offset;
}


/*--------------------------------------------------------

	[hʂFIXf[^]

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

static void loading_upload_fix(void)
{
	UINT8 *src, *dst;
	offs_t offset;

	// ݂FIXf[^ۑ
	src = memory_region(REGION_GFX1);
	dst = memory_region(REGION_CPU1) + 0x115e06;
#if (ENABLE_SYSTEM_CHECK == 0)
	neogeo_undecode_fix(src, 0, 0x6000);
#endif
	memcpy(dst, src, 0x6000);

	// BIOSFIXf[^]
	src = memory_region(REGION_USER1) + 0x7c000;
	dst = memory_region(REGION_GFX1);
	memcpy(dst, src, 0x4000);
#if ENABLE_SYSTEM_CHECK
	dst = memory_region(REGION_GFX5);
	memcpy(dst, src, 0x4000);
#endif
	neogeo_decode_fix(dst, 0, 0x4000);

	offset = 0x120002;

	// Q[ʂFIXf[^]
	while (1)
	{
		UINT16 fix_offs, size;

		offset = check_screen_data(offset, 1);
		if (offset == -1)
			break;

		fix_offs = m68000_read_memory_32(offset);
		offset += 4;

		size = m68000_read_memory_32(offset);
		offset += 4;

		src = memory_region(REGION_CPU1);
		dst = memory_region(REGION_GFX1);
		memcpy(dst + (fix_offs >> 1), src + offset, size);
#if ENABLE_SYSTEM_CHECK
		dst = memory_region(REGION_GFX5);
		memcpy(dst + (fix_offs >> 1), src + offset, size);
#endif
		neogeo_decode_fix(dst, fix_offs, size);

		offset = check_offset;
	}
}


/*--------------------------------------------------------

	[hʂ̃pbg]

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

static void loading_upload_palette(void)
{
	int i;
	offs_t src, dst, offset;

	// ݂̃pbgf[^ۑ
	src = 0x400000;
	dst = 0x11be06;

	for (i = 0; i < 0x200; i += 4)
	{
		m68000_write_memory_32(dst, m68000_read_memory_32(src));
		src += 4;
		dst += 4;
	}

	// BIOS̃pbgݒ
	src = 0xc1701c;
	dst = 0x400000;

	for (i = 0; i < 0x200; i += 4)
	{
		m68000_write_memory_32(dst, m68000_read_memory_32(src));
		src += 4;
		dst += 4;
	}

	offset = 0x120002;

	// Q[ʂ̃pbg]
	while (1)
	{
		UINT16 palno;

		src = check_screen_data(offset, 2);
		if (src == -1)
			break;

		palno = m68000_read_memory_16(src);
		src += 2;

		dst = 0x400000 + (palno << 5);

		for (i = 0; i < 16; i++)
		{
			m68000_write_memory_16(dst, m68000_read_memory_16(src));
			src += 2;
			dst += 2;
		}

		offset = check_offset;
	}
}
