/***************************************************************************

	driver.c

	NEOGEO CDhCoRA (based on M.A.M.E.'s neogeo driver)

***************************************************************************/

#ifndef NEOGEO_DRIVER_H
#define NEOGEO_DRIVER_H

#if FAST_SPRITE_DRAW
#define NEOGEO      0
#define NEOGEO_FAST 1
#define RASTER      2
#define RASTER_FAST 3
#define RASTER_BUSY 4
#define RBUSY_FAST  5
#else
#define NEOGEO      0
#define NEOGEO_FAST 0
#define RASTER      2
#define RASTER_FAST 2
#define RASTER_BUSY 4
#define RBUSY_FAST  4
#endif

#define RASTER_LINES		264
#define FIRST_VISIBLE_LINE	16
#define	LAST_VISIBLE_LINE	239
#define	SCREEN_WIDTH		320
#define	SCREEN_HEIGHT		256

// hCõtO
#define PATCH_NONE		0			// pb`Ȃ
#define PATCH_SSRPG		(1 << 0)	// ^TCXsbcp
#define PATCH_AOF2		(1 << 1)	// Ղ̌2p
#define PATCH_ADKWORLD	(1 << 2)	// ADK[hp
#define PATCH_CRSWORD2	(1 << 3)	// NX\[h2p
#define PATCH_RBFF2		(1 << 4)	// AoEgT`2p
#define PATCH_TYPE6		(1 << 5)	// gp
#define LOADING_TYPE1	(1 << 6)	// ǂݍ݃^Cv1 ʏ
#define LOADING_TYPE2	(1 << 7)	// ǂݍ݃^Cv2 [hʂɃTEhԂQ[
#define LOADING_TYPE3	(1 << 8)	// ǂݍ݃^Cv3 ՊO`A1A2p

// Q[ʃ}N
#define GAME_NAME(name)  (strcmp(game_name, name) == 0)


// ̓|[gp
enum
{
	NEOGEO_INPUT_UP = 0,
	NEOGEO_INPUT_DOWN,
	NEOGEO_INPUT_LEFT,
	NEOGEO_INPUT_RIGHT,
	NEOGEO_INPUT_BUTTONA,
	NEOGEO_INPUT_BUTTONB,
	NEOGEO_INPUT_BUTTONC,
	NEOGEO_INPUT_BUTTOND,
	NEOGEO_INPUT_START,
	NEOGEO_INPUT_SELECT,
	NEOGEO_INPUT_MAX
};


/*------------------------------------------------------
  \
 -----------------------------------------------------*/

typedef struct cdrom_t
{
	const int num_tracks;
	const int num_trackdata;
	const UINT32 *tracks[];
} CDROM;

typedef struct gamename_t
{
	const char *name;
	const char *id;
	const int  year;
	const char *manufacture;
	const int  driver;
	const int  flag;
	const CDROM *cdrom;
	const char *title[3];
} GAMES;


/*------------------------------------------------------
  O[oϐ
 -----------------------------------------------------*/

extern GAMES games[];
extern MEMREGION neogeo_memory_region[];
extern READMEM  neogeo_readmem[];
extern WRITEMEM neogeo_writemem[];

extern UINT32 neogeo_frame_counter;
extern struct rectangle visible_area;
extern double video_fps;


/*------------------------------------------------------
  O[o֐
 -----------------------------------------------------*/

void neogeo_driver_reset(void);
void neogeo_interrupt(void);
void neogeo_raster_interrupt(void);
void neogeo_raster_interrupt_busy(void);

READ16_HANDLER( neogeo_controler1_16_r );
READ16_HANDLER( neogeo_controler2_16_r );
READ16_HANDLER( neogeo_controler3_16_r );

UINT8 neogeo_z80_port_r(UINT16 port);
void neogeo_z80_port_w(UINT16 port, UINT8 data);

#endif /* NEOGEO_DRIVER_H */
