#ifndef M68KNCDZ__HEADER
#define M68KNCDZ__HEADER

/* ======================================================================== */
/* ====================== NEOGEO CD Emulator STUFF ======================== */
/* ======================================================================== */

#include "neogeocd.h"

/* Configuration switches (see m68kconf.h for explanation) */
#define M68K_SEPARATE_READS         OPT_OFF

#define M68K_SIMULATE_PD_WRITES     OPT_OFF

#define M68K_EMULATE_INT_ACK        OPT_ON
#define M68K_INT_ACK_CALLBACK(A)

#define M68K_EMULATE_BKPT_ACK       OPT_OFF
#define M68K_BKPT_ACK_CALLBACK()    your_bkpt_ack_handler_function()

#define M68K_EMULATE_TRACE          OPT_OFF

#define M68K_EMULATE_RESET          OPT_OFF
#define M68K_RESET_CALLBACK()       your_reset_handler_function()

#define M68K_CMPILD_HAS_CALLBACK    OPT_OFF
#define M68K_CMPILD_CALLBACK(v,r)   your_cmpild_handler_function(v,r)

#define M68K_RTE_HAS_CALLBACK       OPT_OFF
#define M68K_RTE_CALLBACK()         your_rte_handler_function()

#define M68K_EMULATE_FC             OPT_OFF
#define M68K_SET_FC_CALLBACK(A)     your_set_fc_handler_function(A)

#define M68K_MONITOR_PC             OPT_SPECIFY_HANDLER
#define M68K_SET_PC_CALLBACK(A)     (*m68k_memory_intf.changepc)(A)

#define M68K_INSTRUCTION_HOOK       OPT_OFF
#define M68K_INSTRUCTION_CALLBACK() your_instruction_hook_function()

#define M68K_EMULATE_PREFETCH       OPT_OFF

#define M68K_EMULATE_ADDRESS_ERROR  OPT_OFF

#define M68K_LOG_ENABLE             OPT_OFF
#define M68K_LOG_1010_1111          OPT_OFF
#define M68K_LOG_FILEHANDLE         errorlog

#define M68K_USE_64_BIT             OPT_OFF


#define m68ki_remaining_cycles m68k_ICount


extern struct m68k_memory_interface m68k_memory_intf;

#define m68k_read_memory_8(address)          (*m68k_memory_intf.read8)(address)
#define m68k_read_memory_16(address)         (*m68k_memory_intf.read16)(address)
#define m68k_read_memory_32(address)         (*m68k_memory_intf.read32)(address)

#define m68k_write_memory_8(address, value)  (*m68k_memory_intf.write8)(address, value)
#define m68k_write_memory_16(address, value) (*m68k_memory_intf.write16)(address, value)
#define m68k_write_memory_32(address, value) (*m68k_memory_intf.write32)(address, value)

/* M68K Variants */
#define M68K_EMULATE_008            OPT_OFF
#define M68K_EMULATE_010            OPT_OFF
#define M68K_EMULATE_EC020          OPT_OFF
#define M68K_EMULATE_020            OPT_OFF
#define M68K_EMULATE_040            OPT_OFF

/* ======================================================================== */
/* ============================== END OF FILE ============================= */
/* ======================================================================== */

#endif /* M68KNCDZ__HEADER */
