#ifndef D68K__HEADER
#define D68K__HEADER

/* ======================================================================== */
/* ========================= LICENSING & COPYRIGHT ======================== */
/* ======================================================================== */
/*
 *                                DEBABELIZER
 *                                Version 2.2
 *
 * A portable Motorola M680x0 disassembler.
 * Copyright 1999 Karl Stenerud.  All rights reserved.
 *
 * This code is freeware and may be freely used as long as this copyright
 * notice remains unaltered in the source code and any binary files
 * containing this code in compiled form.
 *
 * The latest version of this code can be obtained at:
 * http://milliways.scas.bcit.bc.ca/~karl/musashi
 */


/* ======================================================================== */
/* ============================= INSTRUCTIONS ============================= */
/* ======================================================================== */
/* 1. edit d68kconf.h and modify according to your needs.
 * 2. Implement in your host program the functions defined in
 *    "FUNCTIONS CALLED BY THE DISASSEMBLER" located later in this file.
 * 3. Your first call to m68k_disassemble will initialize the disassembler.
 */


/* ======================================================================== */
/* ================= FUNCTIONS CALLED BY THE DISASSEMBLER ================= */
/* ======================================================================== */

/* You will have to implement these functions */

#include "neogeocd.h"

#define Dasm68000(buff, pc) m68000_disassemble(buff, pc)


#undef m68k_read_memory_8
#undef m68k_read_memory_16
#undef m68k_read_memory_32

#define m68k_read_memory_8(address)  m68000_read_memory_8_debug(address)
#define m68k_read_memory_16(address) m68000_read_memory_16_debug(address)
#define m68k_read_memory_32(address) m68000_read_memory_32_debug(address)


/* ======================================================================== */
/* ====================== FUNCTIONS TO ACCESS THE CPU ===================== */
/* ======================================================================== */

/* Disassemble 1 instructionat pc.  Stores disassembly in str_buff and returns
 * the size of the instruction in bytes.
 */
int m68k_disassemble(char* str_buff, int pc);

/* Disassemble 1 instruction at pc.  Return disassembly as string pointer */
char* m68k_disassemble_quick(int pc);


/* ======================================================================== */
/* ============================== END OF FILE ============================= */
/* ======================================================================== */

#endif /* D68K__HEADER */
