/***************************************************************************

	config.c

	IvVݒt@C̓ǂݏ

***************************************************************************/

#ifndef CONFIG_H
#define CONFIG_H

#define CFG_STR_MAXLEN 256

typedef struct
{
    int    region;
    int    raster;
    int    drive;
    int    cdspeed;

    int    fullscreen;
    int    sw_stretch2x;
    int    scanlines;
    int    sl_brightness;
    int    hw_stretch;
    int    use_triplebuffer;
    int    wait_vsync;
    int    use_ddhel;
    int    use_sysmem;
    int    refreshrate;

    int    sound_volume;
    int    samplerate;
    int    latency;
    int    enable_cdda;
    int    cdda_volume;

    int    auto_pause;
    int    enable_mmx;
    int    enable_sse;
    int    sleep_time;
    int    errorlog;

    char   snapdir[CFG_STR_MAXLEN];

    int    key[2][14];

    int    joyid[2];
    int    joy[2][14];

    int    hotkey[2][4];
    int    afinterval[2];

	/* hidden values */
	char   drive_str[CFG_STR_MAXLEN];
	UINT32 cpuid_result;
	int    sound_enable;
} options_type;

extern options_type options;

void load_config(void);
void save_config(void);
void load_game_config(void);
void save_game_config(void);
void parse_commandline(int argc, char *argv[]);
const char *get_appname(void);
const char *get_version(void);

#endif /* CONFIG_H */
