/***************************************************************************

	win32.c

	32bit Windowsˑ

***************************************************************************/

#include "neogeocd.h"
#include "win32/win32.h"
#include <shellapi.h>
#include "DirectDraw.h"
#include "DirectInput.h"
#include "DirectSound.h"
#include "ticker.h"
#include "osd_cdda.h"
#include "osd_video.h"
#include "osd_key.h"
#include "misc.h"
#include "resource.h"


/****************************************************************************
	vg^Cv
 ***************************************************************************/

static void log_open(void);
static void log_close(void);

#ifndef BUILD_CONSOLE
static int DecodeCommandline(LPSTR lpCmdLine, char *argv[]);
#endif

static LRESULT CALLBACK MessageProc(HWND, UINT, WPARAM, LPARAM);
static void ProcessMessages(void);
static BOOL PumpAndReturnMessage(MSG *pMsg);
static void HandleAutoPause(void);

static BOOL OnMessage(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam, LRESULT *pResult);
static void OnActivateApp(HWND hWnd, BOOL fActivate, DWORD dwThreadId);
static void OnSysCommand(HWND hWnd, UINT cmd, int x, int y);
static void OnClose(HWND hWnd);


/***************************************************************************
	O[o\
 ***************************************************************************/

struct tMyApp MyApp =
{
	NULL,					// m_hwndUI
	NULL,					// m_hWnd
	NULL,					// m_hIcon
	NULL,					// m_hCursor
	APPNAME,				// m_pName

	FALSE,					// m_bIsInitialized
	FALSE,					// m_bIsActive
	FALSE,					// m_bAutoPaused
	OSD_EXEC,				// m_nState

	ProcessMessages,		// WindowsbZ[W
	PumpAndReturnMessage,	// WindowsbZ[W擾āAlԂ
	HandleAutoPause,		// I[g|[Y
};


/***************************************************************************
	O[oϐ
 ***************************************************************************/

FILE *errorlog;		// logerror()֐p̃t@C|C^


/***************************************************************************
	[Jϐ
 ***************************************************************************/

static const char *className = "classNeoGeoCDZEmulator";
static BOOL bCDDAAutoPaused;
static BOOL bScreenSaverActive;
static BOOL bPowerOffActive;


/***************************************************************************
	O[o֐
 ***************************************************************************/

/*------------------------------------------------------

	C֐

	  : R}hCȂ
	߂l: AvP[V̏I

 -----------------------------------------------------*/

#ifdef BUILD_CONSOLE
int main(int argc, char *argv[])
{
	int res = 1;
	HINSTANCE hInstance;
	WNDCLASSEX WndClass;
#else
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	int argc, res = 1;
	char *argv[256];
	WNDCLASSEX WndClass;

	// R\[łłȂꍇ̓R}hC
	argc = DecodeCommandline(lpCmdLine, argv);
#endif

	SystemParametersInfo(SPI_GETSCREENSAVEACTIVE, 0, &bScreenSaverActive, 0);
	if (bScreenSaverActive)
	{
		// XN[Z[o[N}~
		SystemParametersInfo(SPI_SETSCREENSAVEACTIVE, FALSE, NULL, 0);
	}

	SystemParametersInfo(SPI_GETPOWEROFFACTIVE, 0, &bPowerOffActive, 0);
	if (bPowerOffActive)
	{
		// ʂ̓d͒~}~
		SystemParametersInfo(SPI_SETPOWEROFFACTIVE, FALSE, NULL, 0);
	}

	while (1)
	{
		osd_set_app_state(OSD_EXEC);

		// init@Cݒǂݍ
		load_config();

		// R}hCŎw肳ꂽIvV𔽉f
		parse_commandline(argc, argv);

		// ŐL^Jn
		log_open();

		logerror("HAS_MMX = %s\n", (options.cpuid_result & HAS_MMX) ? "yes" : "no");
		logerror("HAS_SSE = %s\n", (options.cpuid_result & HAS_SSE) ? "yes" : "no");
		logerror("HAS_RDTSC = %s\n", (options.cpuid_result & HAS_RDTSC) ? "yes" : "no");

		// AvP[VCX^X̎擾
		hInstance = GetModuleHandle(NULL);

		// ACRƃJ[\\[X쐬
//		MyApp.m_hCursor = LoadImage(hInstance, MAKEINTRESOURCE(IDC_NCDZCUR), IMAGE_CURSOR, 0, 0, LR_DEFAULTCOLOR);
		MyApp.m_hCursor = LoadImage(NULL, IDC_ARROW, IMAGE_CURSOR, 0, 0, LR_DEFAULTCOLOR);
		MyApp.m_hIcon = LoadImage(hInstance, MAKEINTRESOURCE(IDI_NCDZICON), IMAGE_ICON, 0, 0, LR_DEFAULTCOLOR);

		// EBhENX̐ݒ
		WndClass.cbSize         = sizeof(WNDCLASSEX);
		WndClass.style          = CS_BYTEALIGNCLIENT;
		WndClass.lpfnWndProc    = MessageProc;
		WndClass.cbClsExtra     = 0;
		WndClass.cbWndExtra     = 0;
		WndClass.hInstance      = hInstance;
		WndClass.hIcon          = MyApp.m_hIcon;
		WndClass.hCursor        = MyApp.m_hCursor;
		WndClass.hbrBackground  = (HBRUSH)GetStockObject(BLACK_BRUSH);
		WndClass.lpszMenuName   = NULL;
		WndClass.lpszClassName  = (LPCSTR)className;
		WndClass.hIconSm        = MyApp.m_hIcon;

		// EBhENXo^
		if (RegisterClassEx(&WndClass) != 0)
		{
			// EBhE쐬
			MyApp.m_hWnd = CreateWindowEx(0,
									  className,
									  MyApp.m_Name,
									  WS_OVERLAPPEDWINDOW,
									  CW_USEDEFAULT,
									  CW_USEDEFAULT,
									  0, 0,
									  NULL,
									  NULL,
									  hInstance,
									  NULL);

			if (MyApp.m_hWnd != NULL)
			{
				// DirectDraw̏
				if (DirectDraw_Initialize() == OSD_OK)
				{
					// DirectInput̏
					if (DirectInput_Initialize() == OSD_OK)
					{
						// DirectSound̏
						// sĂTEhĐȂȂ̂ŁÂ܂ܑs
						DirectSound_Initialize();

						// ^C~OvpJE^̏
						ticker_init();

						// AvP[V̊etO
						MyApp.m_bIsInitialized = FALSE;
						MyApp.m_bIsActive      = FALSE;
						MyApp.m_bAutoPaused    = FALSE;

						bCDDAAutoPaused = FALSE;

						res = neogeo_main();

						ticker_exit();
						DirectSound_Close();
						DirectInput_Close();
					}
					else
					{
						logerror("Could not initialize DirectInput.\n");
					}

					DirectDraw_Close();
				}
				else
				{
					logerror("Could not initialize DirectDraw.\n");
				}

				DestroyWindow(MyApp.m_hWnd);
			}
			else
			{
				logerror("Could not create window.\n");
			}

			UnregisterClass((LPCSTR)className, GetModuleHandle(NULL));
		}
		else
		{
			logerror("Could not register window class.\n");
		}

		DestroyIcon(MyApp.m_hIcon);
		DestroyCursor(MyApp.m_hCursor);

		// ŐL^I
		log_close();

		// init@C֐ݒ
		save_config();

		if (res == OSD_QUIT)
		{
			res = 0;
			break;
		}
	}

	if (bPowerOffActive)
	{
		// ʂ̓d͒~ĊJ
		SystemParametersInfo(SPI_SETPOWEROFFACTIVE, TRUE, NULL, 0);
	}

	if (bScreenSaverActive)
	{
		// XN[Z[o[NĊJ
		SystemParametersInfo(SPI_SETSCREENSAVEACTIVE, TRUE, NULL, 0);
	}

	// I
	exit(res);
}


/*------------------------------------------------------

	G[OɎw肳ꂽo

	  : const char *text,,, o͂镶
	߂l: Ȃ

 -----------------------------------------------------*/

void logerror(const char *text, ...)
{
	va_list arg;

#ifdef BUILD_CONSOLE
	va_start(arg, text);
	vprintf(text, arg);
	va_end(arg);
#endif

	if (errorlog)
	{
		va_start(arg, text);
		vfprintf(errorlog, text, arg);
		va_end(arg);
	}
}


/*------------------------------------------------------

	EBhE^Cg̐ݒ

	  : const char *text,,, ݒ肷镶
	߂l: Ȃ

 -----------------------------------------------------*/

void osd_set_title(const char *text, ...)
{
	char buf[256];
	va_list arg;

	va_start(arg, text);
	vsprintf(buf, text, arg);
	va_end(arg);

	SetWindowText(MyApp.m_hWnd, buf);

}


/*------------------------------------------------------

	[U[ւ̃bZ[W\

	  : const char *text,,, ݒ肷镶
	߂l: Ȃ

   G[Oɂo͂܂

 -----------------------------------------------------*/

void osd_show_message(const char *text, ...)
{
	char buf[256];
	va_list arg;

	va_start(arg, text);
	vsprintf(buf, text, arg);
	va_end(arg);

	// bZ[W{bNX\
	MessageBox(MyApp.m_hWnd, buf, MyApp.m_Name, MB_OK);

	// G[Oɏo
	logerror("%s\n", buf);
}


int osd_get_app_state(void)
{
	return MyApp.m_nState;
}

void osd_set_app_state(int state)
{
	MyApp.m_nState = state;
}


/***************************************************************************
	[J֐
 ***************************************************************************/

/*------------------------------------------------------

	G[OJ

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

static void log_open(void)
{
	errorlog = NULL;

	if (options.errorlog)
	{
		errorlog = fopen("error.log", "w");

		if (errorlog)
		{
			// Õ^Cgo
			logerror(";----------------------------------------\n");
			logerror("; " APPNAME " ver." APPVER "\n");
			logerror(";----------------------------------------\n\n");
		}
	}
}


/*------------------------------------------------------

	G[O̕

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

static void log_close(void)
{
	if (errorlog)
	{
		// obt@tbVĂ
		fflush(errorlog);
		fclose(errorlog);
		errorlog = NULL;
	}
}


/***************************************************************************
	[J֐ for Win32
 ***************************************************************************/

#ifndef BUILD_CONSOLE
/*------------------------------------------------------

	R}hC̉(EBhEAvp)

	  : LPSTR lpCmdLine R}hC
			char *argv[]    i[|C^
	߂l: R}hC̐

  R\[AvƂ̌݊̂ߗp

 -----------------------------------------------------*/

static int DecodeCommandline(LPSTR lpCmdLine, char *argv[])
{
	int argc;
	static char command_line[512];

	argc = 1;
	strcpy(command_line, lpCmdLine);
	argv[argc] = strtok(command_line, " \t\n");

	if (argv[1] != NULL)
	{
		argc++;
		while ((argv[argc] = strtok(NULL, " \t\n")) != NULL)
			argc++;
	}

	return argc;
}
#endif

static void ProcessMessages(void)
{
	MSG Msg;

	while (PeekMessage(&Msg, NULL, 0, 0, PM_REMOVE))
	{
		if (Msg.message == WM_QUIT)
		{
			osd_set_app_state(OSD_QUIT);
			return;
		}

		TranslateMessage(&Msg);
		DispatchMessage(&Msg);
	}
}


static BOOL PumpAndReturnMessage(MSG *pMsg)
{
	if ((GetMessage(pMsg, NULL, 0, 0)) == 0)
		return FALSE;

	TranslateMessage(pMsg);
	DispatchMessage(pMsg);
	return TRUE;
}


static void HandleAutoPause(void)
{
	if (MyApp.m_bAutoPaused == TRUE)
	{
		MSG msg;

		if (osd_cdda_get_status() == CDDA_PLAY)
		{
			osd_cdda_pause();
			bCDDAAutoPaused = TRUE;
		}

		/* Go into 'nice' Pause loop until re-activated. */
		while (GetMessage(&msg, NULL, 0, 0) != 0)
		{
			DispatchMessage(&msg);

			if (msg.message == WM_QUIT)
			{
				osd_set_app_state(OSD_QUIT);
				return;
			}

			if (MyApp.m_bAutoPaused == FALSE)
				return;
		}
	}

	if (bCDDAAutoPaused == TRUE && osd_cdda_get_status() == CDDA_PAUSE)
	{
		osd_cdda_resume();
		bCDDAAutoPaused = FALSE;
	}
}


static LRESULT CALLBACK MessageProc(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	LRESULT Result = 0;

	if (OnMessage(hWnd, Msg, wParam, lParam, &Result) == TRUE)
		return Result;

	if (CDDA_OnMessage(hWnd, Msg, wParam, lParam, &Result) == TRUE)
		return Result;

	if (DirectDraw_OnMessage(hWnd, Msg, wParam, lParam, &Result) == TRUE)
		return Result;

	if (Keyboard_OnMessage(hWnd, Msg, wParam, lParam, &Result) == TRUE)
		return Result;

	return DefWindowProc(hWnd, Msg, wParam, lParam);
}


static BOOL OnMessage(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam, LRESULT* pResult)
{
	switch (Msg)
	{
		PEEK_MESSAGE(hWnd, WM_ACTIVATEAPP,  OnActivateApp);
		HANDLE_MESSAGE(hWnd, WM_SYSCOMMAND, OnSysCommand);
		HANDLE_MESSAGE(hWnd, WM_CLOSE,      OnClose);
	}
	return FALSE;
}


static void OnActivateApp(HWND hWnd, BOOL fActivate, DWORD dwThreadId)
{
	MyApp.m_bIsActive = fActivate && MyApp.m_hWnd == hWnd;

	if (MyApp.m_bIsInitialized == FALSE)
		return;

	if (MyApp.m_bIsActive == FALSE)
	{
		if (options.auto_pause && MyApp.m_bAutoPaused == FALSE)
		{
			MyApp.m_bAutoPaused = TRUE;
			osd_sound_enable(0);
		}
	}
	else
	{
		if (options.auto_pause && MyApp.m_bAutoPaused == TRUE)
		{
			MyApp.m_bAutoPaused = FALSE;
			osd_sound_enable(1);
		}
	}
}


static void OnSysCommand(HWND hWnd, UINT cmd, int x, int y)
{
	if (cmd != SC_KEYMENU)
		FORWARD_WM_SYSCOMMAND(hWnd, cmd, x, y, DefWindowProc);
}


static void OnClose(HWND hWnd)
{
	/* This makes sure we don't autopause after the call below. */
	MyApp.m_bIsInitialized = FALSE;

	/* hide window to prevent orphan empty rectangles on the taskbar */
	ShowWindow(hWnd, SW_HIDE);

	/* Don't call DestroyWindow, it will be called by osd_exit. */
	osd_set_app_state(OSD_QUIT);
}
