/***************************************************************************

	ticker.c

	^C~ÕJE^p֐

***************************************************************************/

#include "neogeocd.h"
#include <mmsystem.h>
#include "win32.h"
#include "win32/ticker.h"


/***************************************************************************
	vg^Cv
 ***************************************************************************/

TICKER RDTSC(void);
static TICKER ReadPaformanceCounter(void);
static TICKER TimeGetTime(void);


/***************************************************************************
	O[oϐ
 ***************************************************************************/

LONGLONG TICKS_PER_SEC;


/***************************************************************************
	O[o֐
 ***************************************************************************/

/*--------------------------------------------------------

	^C~Ovp̃JE^̒lԂ

	  : Ȃ
	߂l: JE^̒l

 -------------------------------------------------------*/

TICKER (*ticker)(void);


/*--------------------------------------------------------

	^C~Ovp̃JE^

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

void ticker_init(void)
{
	LARGE_INTEGER tick_frequency;
	LONGLONG start, end;
	TICKER a, b;

	// ^C}[̕\グ (sĂCɂȂ)
	timeBeginPeriod(1);

	if ((options.cpuid_result & HAS_RDTSC) != 0)
	{
		// Ԍvp̊֐Ƃ肠ݒ
		if (QueryPerformanceFrequency(&tick_frequency) != 0)
		{
			// }`fBA\JE^gp
			ticker = ReadPaformanceCounter;
			TICKS_PER_SEC = tick_frequency.QuadPart;
		}
		else
		{
			// timeGetTime()gp
			ticker = TimeGetTime;
			TICKS_PER_SEC = CLOCKS_PER_SEC;
		}

		// ticker()̒lv܂ő҂
		a = (*ticker)();
		do
		{
			b = (*ticker)();
		} while (a == b);

		// vJñJE^擾
		start = RDTSC();

		// 1bo߂܂ő҂
		do
		{
			a = (*ticker)();
		} while (a - b < TICKS_PER_SEC);

		// vĨJE^擾
		end = RDTSC();

		// RDTSCgp
		ticker = RDTSC;
		TICKS_PER_SEC = end - start;
	}
	else if (QueryPerformanceFrequency(&tick_frequency) != 0)
	{
		// }`fBA\JE^gp
		ticker = ReadPaformanceCounter;
		TICKS_PER_SEC = tick_frequency.QuadPart;
	}
	else
	{
		// timeGetTime()gp
		ticker = TimeGetTime;
		TICKS_PER_SEC = CLOCKS_PER_SEC;
	}
}


/*--------------------------------------------------------

	^C~Ovp̃JE^I

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

void ticker_exit(void)
{
	// ^C}[̕\߂
	timeEndPeriod(1);
}


/***************************************************************************
	O[o֐
 ***************************************************************************/

/*--------------------------------------------------------

	^C~Ovp̃JE^̒lԂ
	(}`fBA\JE^gp)

	  : Ȃ
	߂l: JE^̒l

 -------------------------------------------------------*/

static TICKER ReadPaformanceCounter(void)
{
	LARGE_INTEGER tick_count;

	QueryPerformanceCounter(&tick_count);
	return tick_count.QuadPart;
}


/*--------------------------------------------------------

	^C~Ovp̃JE^̒lԂ
	(timeGetTime()֐gp)

	  : Ȃ
	߂l: JE^̒l

 -------------------------------------------------------*/

static TICKER TimeGetTime(void)
{
	return (TICKER)timeGetTime();
}
