/***************************************************************************

	osd_sound.c

	OSˑTEh

***************************************************************************/

#include "osdepend.h"
#include <windowsx.h>
#include "win32.h"
#include "DirectSound.h"
#include "osd_video.h"
#include "config.h"


#define INGORE_UNDERFLOW_FRAMES 100
#define MAX_BUFFER_SIZE         (128 * 1024)
#define MAX_SAMPLE_ADJUST       16


/***************************************************************************
	Oϐ
 ***************************************************************************/

extern double video_fps;
extern int sample_rate;


/***************************************************************************
	[Jϐ
 ***************************************************************************/

static WAVEFORMATEX         stream_format;

static int                  stream_buffer_in;
static int                  stream_buffer_size;

static double               samples_per_frame;
static UINT32               samples_this_frame;
static double               samples_left_over;
static int                  current_adjustment;

static int                  lower_thresh;
static int                  upper_thresh;

static int					buffer_underflows;
static int					buffer_overflows;

static int                  consecutive_lows;
static int                  consecutive_mids;
static int                  consecutive_highs;


/***************************************************************************
	O[o֐
 ***************************************************************************/

/*--------------------------------------------------------

	TEhXg[~OJn

	  : Ȃ
	߂l: :1t[̃Tv s:0

 -------------------------------------------------------*/

int osd_start_audio_stream(void)
{
	LPDIRECTSOUNDBUFFER primary_buffer;
	DSBUFFERDESC dsb_desc;
	void *buffer;
	DWORD length;

	dsb = NULL;

	if (sample_rate == 0)
		return 0;

	stream_format.wBitsPerSample  = 16;
	stream_format.wFormatTag      = WAVE_FORMAT_PCM;
	stream_format.nChannels       = 2;
	stream_format.nSamplesPerSec  = sample_rate;
	stream_format.nBlockAlign     = stream_format.wBitsPerSample * stream_format.nChannels / 8;
	stream_format.nAvgBytesPerSec = stream_format.nSamplesPerSec * stream_format.nBlockAlign;

	stream_buffer_size = ((UINT64)MAX_BUFFER_SIZE * (UINT64)stream_format.nSamplesPerSec) / sample_rate;
	stream_buffer_size = (stream_buffer_size * stream_format.nBlockAlign) / 4;
	stream_buffer_size = (stream_buffer_size * 30) / video_fps;
	stream_buffer_size = (stream_buffer_size / 1024) * 1024;

	lower_thresh = options.latency * 1 * stream_buffer_size / 10;
	upper_thresh = options.latency * 2 * stream_buffer_size / 10;


	memset(&dsb_desc, 0, sizeof(dsb_desc));
	dsb_desc.dwSize = sizeof(dsb_desc);
	dsb_desc.dwFlags = DSBCAPS_PRIMARYBUFFER | DSBCAPS_GETCURRENTPOSITION2;
	dsb_desc.lpwfxFormat = NULL;

	if (IDirectSound_SetCooperativeLevel(ds, MyApp.m_hWnd, DSSCL_PRIORITY) != DS_OK)
	{
		logerror("IDirectSound::SetCooperativeLevel failed.\n");
		return 0;
	}

	if (IDirectSound_CreateSoundBuffer(ds, &dsb_desc, &primary_buffer, NULL) != DS_OK)
	{
		logerror("IDirectSound::CreateSoundBuffer (primary buffer) failed.\n");
		return 0;
	}

	if (IDirectSoundBuffer_SetFormat(primary_buffer, &stream_format) != DS_OK)
	{
		logerror("IDirectSound::SetFormat (primary buffer) failed.\n");
		IDirectSoundBuffer_Release(primary_buffer);
		return 0;
	}

	if (IDirectSoundBuffer_GetFormat(primary_buffer, &stream_format, sizeof(stream_format), NULL) != DS_OK)
	{
		logerror("IDirectSound::GetFormat (primary buffer) failed.\n");
		IDirectSoundBuffer_Release(primary_buffer);
		return 0;
	}

	// tH[}bg擾sv
	IDirectSoundBuffer_Release(primary_buffer);


	memset(&dsb_desc, 0, sizeof(dsb_desc));
	dsb_desc.dwSize = sizeof(dsb_desc);
	dsb_desc.dwFlags = DSBCAPS_CTRLVOLUME | DSBCAPS_GLOBALFOCUS | DSBCAPS_GETCURRENTPOSITION2;
	dsb_desc.dwBufferBytes = stream_buffer_size;
	dsb_desc.lpwfxFormat = &stream_format;

	if (IDirectSound_CreateSoundBuffer(ds, &dsb_desc, &dsb, NULL) != DS_OK)
	{
		logerror("IDirectSound::CreateSoundBuffer (stream buffer) failed.\n");
		dsb = NULL;
		return 0;
	}

	if (IDirectSoundBuffer_Lock(dsb, 0, stream_buffer_size, &buffer, &length, NULL, NULL, 0) != DS_OK)
	{
		logerror("IDirectSound::Lock (stream buffer) failed.\n");
		IDirectSoundBuffer_Release(dsb);
		dsb = NULL;
		return 0;
	}

	memset(buffer, 0, length);
	IDirectSoundBuffer_Unlock(dsb, buffer, length, NULL, 0);

	if (IDirectSoundBuffer_Play(dsb, 0, 0, DSBPLAY_LOOPING) != DS_OK)
	{
		logerror("IDirectSound::Play (stream buffer) failed.\n");
		IDirectSoundBuffer_Release(dsb);
		dsb = NULL;
		return 0;
	}

	IDirectSoundBuffer_SetVolume(dsb, DSBVOLUME_MAX);

	samples_per_frame = (double)sample_rate / (double)video_fps;

	samples_left_over = samples_per_frame;
	samples_this_frame = (UINT32)samples_left_over;
	samples_left_over -= (double)samples_this_frame;

	stream_buffer_in = 0;

	current_adjustment = 0;
	consecutive_lows   = 0;
	consecutive_mids   = 0;
	consecutive_highs  = 0;

	return samples_this_frame;
}


/*--------------------------------------------------------

	TEhXg[~OI

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

void osd_stop_audio_stream(void)
{
	if (dsb)
	{
		IDirectSoundBuffer_Stop(dsb);
		IDirectSoundBuffer_Release(dsb);
		dsb = NULL;
	}
}


/*--------------------------------------------------------

	TEhXg[XV

	  : INT16 *buffer  TEhf[^̃obt@
	߂l: t[ԂɍXVłTv

 -------------------------------------------------------*/

int osd_update_audio_stream(INT16 *buffer)
{
	if (dsb)
	{
		DWORD play_position;
		int	original_bytes;
		int input_bytes;
		int	cur_bytes;
		int	final_bytes;
		INT16 *stream_data = buffer;
		void *buffer1, *buffer2;
		DWORD length1, length2;
		HRESULT result;

		input_bytes = samples_this_frame * stream_format.nBlockAlign;

		IDirectSoundBuffer_GetCurrentPosition(dsb, &play_position, NULL);
		if (stream_buffer_in > play_position)
			original_bytes = stream_buffer_in - play_position;
		else
			original_bytes = stream_buffer_size + stream_buffer_in - play_position;

		if (throttled())
		{
			if (original_bytes < lower_thresh)
			{
				consecutive_lows++;
				consecutive_mids = 0;
				consecutive_highs = 0;
				current_adjustment = (consecutive_lows < MAX_SAMPLE_ADJUST) ? consecutive_lows : MAX_SAMPLE_ADJUST;
			}
			else if (original_bytes > upper_thresh)
			{
				consecutive_lows = 0;
				consecutive_mids = 0;
				consecutive_highs++;
				current_adjustment = (consecutive_highs < MAX_SAMPLE_ADJUST) ? -consecutive_highs : -MAX_SAMPLE_ADJUST;
			}
			else
			{
				consecutive_lows = 0;
				consecutive_mids++;
				consecutive_highs = 0;
				if (consecutive_mids > 10 && current_adjustment != 0)
				{
					current_adjustment = 0;
				}
			}
		}
		else
		{
			consecutive_lows = 0;
			consecutive_mids = 0;
			consecutive_highs = 0;
			current_adjustment = 0;
		}

		result = IDirectSoundBuffer_Lock(dsb, stream_buffer_in, input_bytes, &buffer1, &length1, &buffer2, &length2, 0);
		if (result == DS_OK)
		{
			stream_buffer_in = (stream_buffer_in + input_bytes) % stream_buffer_size;

			cur_bytes = (input_bytes > length1) ? length1 : input_bytes;
			memcpy(buffer1, stream_data, cur_bytes);

			input_bytes -= cur_bytes;
			stream_data = (INT16 *)((INT8 *)stream_data + cur_bytes);

			if (input_bytes != 0)
			{
				cur_bytes = (input_bytes > length2) ? length2 : input_bytes;
				memcpy(buffer2, stream_data, cur_bytes);
			}

			IDirectSoundBuffer_Unlock(dsb, buffer1, length1, buffer2, length2);
		}
		else
		{
			buffer_underflows++;
		}

		IDirectSoundBuffer_GetCurrentPosition(dsb, &play_position, NULL);
		if (stream_buffer_in > play_position)
			final_bytes = stream_buffer_in - play_position;
		else
			final_bytes = stream_buffer_size + stream_buffer_in - play_position;

		if (final_bytes < original_bytes)
			buffer_overflows++;

		samples_left_over += samples_per_frame;
		samples_this_frame = (UINT32)samples_left_over;
		samples_left_over -= (double)samples_this_frame;

		samples_this_frame += current_adjustment;
	}

	return samples_this_frame;
}


/*--------------------------------------------------------

	TEhI/It؂ւ

	  : int enable_it  L/tO
	߂l: Ȃ

 -------------------------------------------------------*/

void osd_sound_enable(int enable_it)
{
	if (dsb)
	{
		if (enable_it)
			IDirectSoundBuffer_SetVolume(dsb, DSBVOLUME_MAX);
		else
			IDirectSoundBuffer_SetVolume(dsb, DSBVOLUME_MIN);
	}
}


/*--------------------------------------------------------

	WAVf[^Đ

	  : unsigned char *wav WAṼ̃|C^
	߂l: Ȃ

 -------------------------------------------------------*/

void osd_play_wav(unsigned char *wav)
{
	sndPlaySound(wav, SND_MEMORY | SND_ASYNC);
}
