/***************************************************************************

	osd_joy.c

	OSˑQ[Rg[[

***************************************************************************/

#include "neogeocd.h"
#include <dinput.h>
#include "DirectInput.h"


#define MAX_JOYSTICKS   8
#define MAX_PLAYERS     2
#define MAX_AXES        16
#define MAX_BUTTONS     32

#define JOYTYPE_STICK   0
#define JOYTYPE_BUTTON  1
#define JOYTYPE_UNKNOWN 2

#define JOYAXIS_X       0
#define JOYAXIS_Y       1
#define JOYAXIS_Z       2
#define JOYAXIS_RX      3
#define JOYAXIS_RY      4
#define JOYAXIS_RZ      5
#define JOYAXIS_UNKNOWN 6

#define JOYAXIS_NEG     0
#define JOYAXIS_POS     1

#define MAKE_JOYCODE(p, t, a, d, b) ((p << 28) | (t << 24) | (a << 16) | (d << 8) | (b))

#define GET_PLAYER(n)    (((n) >> 28) & 0x03)
#define GET_JOYTYPE(n)   (((n) >> 24) & 0x03)
#define GET_JOYAXIS(n)   (((n) >> 16) & 0x0f)
#define GET_JOYDIR(n)    (((n) >>  8) & 0x0f)
#define GET_JOYBUTTON(n) (((n) >>  0) & 0xff)

/***************************************************************************
	[J\
 ***************************************************************************/

typedef struct
{
	LPDIRECTINPUTDEVICE2 did;
	DIJOYSTATE           dijs;
	GUID                 guid;
	char                 *name;
	DWORD                axis_offs[MAX_AXES];
	int                  num_axes;
	int                  num_buttons;
} DIJOYSTICK;


static const struct JoystickInfo joylist[] =
{
	{ JOY_AXIS_X_NEG,  "JOY_AXIS_X_NEG",  "X AXIS - (LEFT)"  },
	{ JOY_AXIS_X_POS,  "JOY_AXIS_X_POS",  "X AXIS + (RIGHT)" },
	{ JOY_AXIS_Y_NEG,  "JOY_AXIS_Y_NEG",  "Y AXIS - (UP)"    },
	{ JOY_AXIS_Y_POS,  "JOY_AXIS_Y_POS",  "Y AXIS + (DOWN)"  },
	{ JOY_AXIS_Z_NEG,  "JOY_AXIS_Z_NEG",  "Z AXIS -"         },
	{ JOY_AXIS_Z_POS,  "JOY_AXIS_Z_POS",  "Z AXIS +"         },
	{ JOY_AXIS_RX_NEG, "JOY_AXIS_RX_NEG", "Rx AXIS -"        },
	{ JOY_AXIS_RX_POS, "JOY_AXIS_RX_POS", "Rx AXIS +"        },
	{ JOY_AXIS_RY_NEG, "JOY_AXIS_RY_NEG", "Ry AXIS -"        },
	{ JOY_AXIS_RY_POS, "JOY_AXIS_RY_POS", "Ry AXIS +"        },
	{ JOY_AXIS_RZ_NEG, "JOY_AXIS_RZ_NEG", "Rz AXIS -"        },
	{ JOY_AXIS_RZ_POS, "JOY_AXIS_RZ_POS", "Rz AXIS +"        },
	{ JOY_BUTTON1,     "JOY_BUTTON1",     "BUTTON 1"         },
	{ JOY_BUTTON2,     "JOY_BUTTON2",     "BUTTON 2"         },
	{ JOY_BUTTON3,     "JOY_BUTTON3",     "BUTTON 3"         },
	{ JOY_BUTTON4,     "JOY_BUTTON4",     "BUTTON 4"         },
	{ JOY_BUTTON5,     "JOY_BUTTON5",     "BUTTON 5"         },
	{ JOY_BUTTON6,     "JOY_BUTTON6",     "BUTTON 6"         },
	{ JOY_BUTTON7,     "JOY_BUTTON7",     "BUTTON 7"         },
	{ JOY_BUTTON8,     "JOY_BUTTON8",     "BUTTON 8"         },
	{ JOY_BUTTON9,     "JOY_BUTTON9",     "BUTTON 9"         },
	{ JOY_BUTTON10,    "JOY_BUTTON10",    "BUTTON 10"        },
	{ JOY_BUTTON11,    "JOY_BUTTON11",    "BUTTON 11"        },
	{ JOY_BUTTON12,    "JOY_BUTTON12",    "BUTTON 12"        },
	{ JOY_BUTTON13,    "JOY_BUTTON13",    "BUTTON 13"        },
	{ JOY_BUTTON14,    "JOY_BUTTON14",    "BUTTON 14"        },
	{ JOY_BUTTON15,    "JOY_BUTTON15",    "BUTTON 15"        },
	{ JOY_BUTTON16,    "JOY_BUTTON16",    "BUTTON 16"        },
	{ JOY_UNKNOWN,     "JOY_UNKNOWN",     "BUTTON 17"        },
	{ 0, 0, 0 }
};


/***************************************************************************
	vg^Cv
 ***************************************************************************/

static BOOL CALLBACK DIJoystick_EnumDeviceProc(LPDIDEVICEINSTANCE pdidi, LPVOID pv);
static BOOL CALLBACK DIJoystick_EnumAxisObjectsProc(LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID pvRef);
static BOOL CALLBACK DIJoystick_EnumPOVObjectsProc(LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID pvRef);
static BOOL CALLBACK DIJoystick_EnumButtonObjectsProc(LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID pvRef);

static void ClearJoyState(DIJOYSTATE *pdijs);
static void ReleaseJoystick(DIJOYSTICK *dijoy);
static void CreateJoystick(DIJOYSTICK *dijoy);

static void InitJoystick(void);
static void ExitJoystick(void);


/***************************************************************************
	[Jϐ
 ***************************************************************************/

static int nNumJyoisticks;
static DIJOYSTICK *joysticks[MAX_PLAYERS];
static DIJOYSTICK dijoysticks[MAX_JOYSTICKS];

static int pressed_count[MAX_JOYSTICKS][28];

static const GUID guidNULL = {0, 0, 0, {0, 0, 0, 0, 0, 0, 0, 0}};


/***************************************************************************
	O[o֐
 ***************************************************************************/

/*------------------------------------------------------

	Q[Rg[Jn

	  : Ȃ
	߂l: :OSD_OK  s:OSD_ERROR

 -----------------------------------------------------*/

int osd_joystick_init(void)
{
	int i, j;

	nNumJyoisticks = 0;

	for (i = 0; i < MAX_PLAYERS; i++)
	{
		if (options.joyid[i] > MAX_JOYSTICKS)
			options.joyid[i] = MAX_JOYSTICKS - 1;
		joysticks[i] = NULL;
	}

	memset(&dijoysticks, 0, sizeof(DIJOYSTICK) * MAX_JOYSTICKS);
	memset(pressed_count, 0, sizeof(pressed_count));

	for (i = 0; i < MAX_JOYSTICKS; i++)
	{
		for (j = 0; j < MAX_AXES; j++)
		{
			dijoysticks[i].axis_offs[j] = JOYAXIS_UNKNOWN;
		}
	}

	if (di == NULL)
	{
		// DirectInputĂȂꍇ̓G[
		logerror("DirectInput not inisialized.\n");
		return OSD_ERROR;
	}

	// Q[Rg[[̈ꗗ擾
	if (IDirectInput_EnumDevices(di, DIDEVTYPE_JOYSTICK, (LPDIENUMDEVICESCALLBACK)DIJoystick_EnumDeviceProc, NULL, DIEDFL_ATTACHEDONLY) == DI_OK)
	{
		if (nNumJyoisticks > 0)
		{
			if (nNumJyoisticks > MAX_JOYSTICKS)
				nNumJyoisticks = MAX_JOYSTICKS;

			if (nNumJyoisticks == 1)
				logerror("%d game controler found.\n", nNumJyoisticks);
			else
				logerror("%d game controlers found.\n", nNumJyoisticks);

			// Q[Rg[[Ώ
			InitJoystick();
		}
		else
		{
			logerror("Game controler not found.\n");
		}

		osd_joystick_reset();
	}

	return OSD_OK;
}



/*------------------------------------------------------

	Q[Rg[I

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void osd_joystick_exit(void)
{
	int i;

	for (i = 0; i < MAX_PLAYERS; i++)
		joysticks[i] = NULL;

	ExitJoystick();
	nNumJyoisticks = 0;
}


/*------------------------------------------------------

	Rg[̏Zbg

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void osd_joystick_reset(void)
{
	int i, j;

	for (i = 0; i < MAX_PLAYERS; i++)
	{
		int id = options.joyid[i];

		if (id >= 0 && dijoysticks[id].did != NULL)
			joysticks[i] = &dijoysticks[id];
		else
			options.joyid[i] = -1;

		if (nNumJyoisticks > 0)
		{
			logerror("Player %d: ", i + 1);
			if (options.joyid[i] >= 0)
				logerror("Use game controler %d.\n", options.joyid[i]);
			else
				logerror("Not use.\n");
		}

		for (j = 0; j < 14; j++)
		{
			joy_code[i][j] = osd_make_internal_joycode(i, options.joy[i][j]);
		}
	}
}


/*------------------------------------------------------

	Rg[̏XV

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void osd_poll_joystick(void)
{
	HRESULT hResult;
	DWORD   i;

	for (i = 0; i < MAX_PLAYERS; i++)
	{
		if (joysticks[i])
		{
			ClearJoyState(&joysticks[i]->dijs);

			// |[O
			IDirectInputDevice2_Poll(joysticks[i]->did);

			// foCX擾
			hResult = IDirectInputDevice2_GetDeviceState(joysticks[i]->did, sizeof(DIJOYSTATE), &joysticks[i]->dijs);
			if (hResult != DI_OK)
			{
				// XgĂēxfoCXgpv
				if (hResult == DIERR_INPUTLOST || hResult == DIERR_NOTACQUIRED)
					hResult = IDirectInputDevice2_Acquire(joysticks[i]->did);
				continue;
			}
		}
	}
}


/*------------------------------------------------------

	gpRg[ݒ肳ꂽRg[ɕύX

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void osd_set_joystick(void)
{
	int i;

	for (i = 0; i < MAX_PLAYERS; i++)
	{
		int id = options.joyid[i];

		if (id >= 0 && dijoysticks[id].did != NULL)
			joysticks[i] = &dijoysticks[id];
		else
			options.joyid[i] = -1;
	}
}


/*------------------------------------------------------

	EFCgȂ̃{^擾

	  : int joycode  R[h
	߂l: 1:Ă 0:ĂȂ

 -----------------------------------------------------*/

int osd_is_joy_pressed(int joycode)
{
	int player;
	int stick;
	DIJOYSTICK *joystick;

	player = GET_PLAYER(joycode);
	joystick = joysticks[player];
	if (joystick == NULL)
		return 0;

	stick = GET_JOYTYPE(joycode);

	if (stick == JOYTYPE_STICK)
	{
		int dz = 60;
		int value;
		int axis;

		axis = GET_JOYAXIS(joycode);

		if (joystick->axis_offs[axis] != JOYAXIS_UNKNOWN)
		{
			value = *(int *)(((byte *)&joystick->dijs) + joystick->axis_offs[axis]);

			if (GET_JOYDIR(joycode))
				return value >= (128 + 128 * dz / 100);
			else
				return value <= (128 - 128 * dz / 100);
		}
	}
	else if (stick == JOYTYPE_BUTTON)
	{
		int button = GET_JOYBUTTON(joycode);

		if (button >= 1 && button <= 16)
			return joystick->dijs.rgbButtons[button - 1] != 0;
	}

	return 0;
}


/*------------------------------------------------------

	EFCg̃{^擾

	  : int joycode  R[h
	߂l: 1:Ă 0:ĂȂ

 -----------------------------------------------------*/

int osd_is_joy_pressed_memory(int joycode)
{
	int pressed;
	int player;
	int code;
	static int counter,inputdelay;

	pressed = osd_is_joy_pressed(joycode);
	player = GET_PLAYER(joycode);
	code = osd_restore_internal_joycode(joycode);

	if (pressed)
	{
		if (pressed_count[player][code] == 0)
		{
			pressed_count[player][code] = 1;
			inputdelay = 3;
			counter = 0;
		}
		else if (++counter > inputdelay * 4)
		{
			inputdelay = 1;
			counter = 0;
		}
		else
			pressed = 0;
	}
	else
		pressed_count[player][code] = 0;

	return pressed;
}


/*------------------------------------------------------

	ėpR[hƃvC[ԍR[h쐬

	  : int player vC[ԍ
			int code   ėpR[h
	߂l: ėpR[h

 -----------------------------------------------------*/

int osd_make_internal_joycode(int player, int code)
{
	switch (code)
	{
	case JOY_AXIS_X_NEG: return MAKE_JOYCODE(player, JOYTYPE_STICK, JOYAXIS_X, JOYAXIS_NEG, 0);
	case JOY_AXIS_X_POS: return MAKE_JOYCODE(player, JOYTYPE_STICK, JOYAXIS_X, JOYAXIS_POS, 0);
	case JOY_AXIS_Y_NEG: return MAKE_JOYCODE(player, JOYTYPE_STICK, JOYAXIS_Y, JOYAXIS_NEG, 0);
	case JOY_AXIS_Y_POS: return MAKE_JOYCODE(player, JOYTYPE_STICK, JOYAXIS_Y, JOYAXIS_POS, 0);
	case JOY_AXIS_Z_NEG: return MAKE_JOYCODE(player, JOYTYPE_STICK, JOYAXIS_Z, JOYAXIS_NEG, 0);
	case JOY_AXIS_Z_POS: return MAKE_JOYCODE(player, JOYTYPE_STICK, JOYAXIS_Z, JOYAXIS_POS, 0);
	case JOY_AXIS_RX_NEG: return MAKE_JOYCODE(player, JOYTYPE_STICK, JOYAXIS_RX, JOYAXIS_NEG, 0);
	case JOY_AXIS_RX_POS: return MAKE_JOYCODE(player, JOYTYPE_STICK, JOYAXIS_RX, JOYAXIS_POS, 0);
	case JOY_AXIS_RY_NEG: return MAKE_JOYCODE(player, JOYTYPE_STICK, JOYAXIS_RY, JOYAXIS_NEG, 0);
	case JOY_AXIS_RY_POS: return MAKE_JOYCODE(player, JOYTYPE_STICK, JOYAXIS_RY, JOYAXIS_POS, 0);
	case JOY_AXIS_RZ_NEG: return MAKE_JOYCODE(player, JOYTYPE_STICK, JOYAXIS_RZ, JOYAXIS_NEG, 0);
	case JOY_AXIS_RZ_POS: return MAKE_JOYCODE(player, JOYTYPE_STICK, JOYAXIS_RZ, JOYAXIS_POS, 0);
	case JOY_BUTTON1: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 1);
	case JOY_BUTTON2: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 2);
	case JOY_BUTTON3: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 3);
	case JOY_BUTTON4: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 4);
	case JOY_BUTTON5: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 5);
	case JOY_BUTTON6: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 6);
	case JOY_BUTTON7: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 7);
	case JOY_BUTTON8: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 8);
	case JOY_BUTTON9: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 9);
	case JOY_BUTTON10: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 10);
	case JOY_BUTTON11: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 11);
	case JOY_BUTTON12: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 12);
	case JOY_BUTTON13: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 13);
	case JOY_BUTTON14: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 14);
	case JOY_BUTTON15: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 15);
	case JOY_BUTTON16: return MAKE_JOYCODE(player, JOYTYPE_BUTTON, 0, 0, 16);
	}
	return MAKE_JOYCODE(player, JOYTYPE_UNKNOWN, 0, 0, 0);
}


/*------------------------------------------------------

	R[hėpR[hɖ߂

	  : int code R[h
	߂l: ėpR[h

 -----------------------------------------------------*/

int osd_restore_internal_joycode(int code)
{
	code &= ~(3 << 28);

	switch (code)
	{
	case MAKE_JOYCODE(0, JOYTYPE_STICK, JOYAXIS_X, JOYAXIS_NEG, 0): return JOY_AXIS_X_NEG;
	case MAKE_JOYCODE(0, JOYTYPE_STICK, JOYAXIS_X, JOYAXIS_POS, 0): return JOY_AXIS_X_POS;
	case MAKE_JOYCODE(0, JOYTYPE_STICK, JOYAXIS_Y, JOYAXIS_NEG, 0): return JOY_AXIS_Y_NEG;
	case MAKE_JOYCODE(0, JOYTYPE_STICK, JOYAXIS_Y, JOYAXIS_POS, 0): return JOY_AXIS_Y_POS;
	case MAKE_JOYCODE(0, JOYTYPE_STICK, JOYAXIS_Z, JOYAXIS_NEG, 0): return JOY_AXIS_Z_NEG;
	case MAKE_JOYCODE(0, JOYTYPE_STICK, JOYAXIS_Z, JOYAXIS_POS, 0): return JOY_AXIS_Z_POS;
	case MAKE_JOYCODE(0, JOYTYPE_STICK, JOYAXIS_RX, JOYAXIS_NEG, 0): return JOY_AXIS_RX_NEG;
	case MAKE_JOYCODE(0, JOYTYPE_STICK, JOYAXIS_RX, JOYAXIS_POS, 0): return JOY_AXIS_RX_POS;
	case MAKE_JOYCODE(0, JOYTYPE_STICK, JOYAXIS_RY, JOYAXIS_NEG, 0): return JOY_AXIS_RY_NEG;
	case MAKE_JOYCODE(0, JOYTYPE_STICK, JOYAXIS_RY, JOYAXIS_POS, 0): return JOY_AXIS_RY_POS;
	case MAKE_JOYCODE(0, JOYTYPE_STICK, JOYAXIS_RZ, JOYAXIS_NEG, 0): return JOY_AXIS_RZ_NEG;
	case MAKE_JOYCODE(0, JOYTYPE_STICK, JOYAXIS_RZ, JOYAXIS_POS, 0): return JOY_AXIS_RZ_POS;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 1): return JOY_BUTTON1;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 2): return JOY_BUTTON2;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 3): return JOY_BUTTON3;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 4): return JOY_BUTTON4;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 5): return JOY_BUTTON5;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 6): return JOY_BUTTON6;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 7): return JOY_BUTTON7;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 8): return JOY_BUTTON8;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 9): return JOY_BUTTON9;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 10): return JOY_BUTTON10;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 11): return JOY_BUTTON11;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 12): return JOY_BUTTON12;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 13): return JOY_BUTTON13;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 14): return JOY_BUTTON14;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 15): return JOY_BUTTON15;
	case MAKE_JOYCODE(0, JOYTYPE_BUTTON, 0, 0, 16): return JOY_BUTTON16;
	}
	return JOY_UNKNOWN;
}


/*------------------------------------------------------

	ėpR[h񂩂ėpR[h擾

	  : char *name  ėpR[h
	߂l: ėpR[h

 -----------------------------------------------------*/

int osd_get_joycode_by_name(char *name)
{
	int i;

	for (i = 0; joylist[i].name; i++)
	{
		if (strcmp(name, joylist[i].name) == 0)
			return joylist[i].code;
	}

	return JOY_UNKNOWN;
}


/*------------------------------------------------------

	ėpR[hԍėpR[h擾

	  : int code   ėpR[h
	߂l: R[h̖O

 -----------------------------------------------------*/

const char *osd_get_joyname_by_code(int code)
{
	int i;

	for (i = 0; joylist[i].name; i++)
	{
		if (code == joylist[i].code)
			return joylist[i].name;
	}

	return "JOY_UNKNOWN";
}


/*------------------------------------------------------

	ėpR[hԍʕ\擾

	  : int code   ėpR[h
	߂l: ʕ\

 -----------------------------------------------------*/

const char *osd_joystick_get_dispnamee(int code)
{
	int i;

	for (i = 0; joylist[i].name; i++)
	{
		if (code == joylist[i].code)
			return joylist[i].dispname;
	}

	return "UNKNOWN";
}


/*------------------------------------------------------

	UIj[p̃WCXeBbNIDXg쐬

	  : char list[][8]  Xg̕\
			char *subitem[] j[̃Tu
			int value[]     j[̒l
	߂l: Ȃ

 -----------------------------------------------------*/

void build_joyid_list(char list[][8], char *subitem[], int value[])
{
	int i, id;

	for (i = 0; i < 10; i++)
	{
		memset(list[i], 0, 8);
		subitem[i] = NULL;
		value[i] = 0;
	}

	strcpy(list[0], "NOT USE");
	subitem[0] = list[0];
	value[0] = -1;

	i = 1;
	for (id = 0; id < nNumJyoisticks; id++)
	{
		if (dijoysticks[id].did);
		{
			sprintf(list[i], "ID %d", id);
			subitem[i] = list[i];
			value[i] = id;
			i++;
		}
	}
}


/***************************************************************************
	[J֐
 ***************************************************************************/

/*------------------------------------------------------

	Q[Rg[[foCX񋓂

	  :
	߂l:

  A߂lDirectInput̃wvQ

 -----------------------------------------------------*/

BOOL CALLBACK DIJoystick_EnumDeviceProc(LPDIDEVICEINSTANCE pdidi, LPVOID pv)
{
	dijoysticks[nNumJyoisticks].guid = pdidi->guidInstance;
	dijoysticks[nNumJyoisticks].name = strdup(pdidi->tszProductName);

	nNumJyoisticks++;

	return DIENUM_CONTINUE;
}


/*------------------------------------------------------

	Q[Rg[[͉̓\ȕ񋓂

	  :
	߂l:

  A߂lDirectInput̃wvQ

 -----------------------------------------------------*/

static BOOL CALLBACK DIJoystick_EnumAxisObjectsProc(LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID pvRef)
{
	DIJOYSTICK *joystick = (DIJOYSTICK *)pvRef;
	DIPROPRANGE diprg;
	int axis;
	const char *name[7] = { "GUID_XAxis", "GUID_YAxis", "GUID_ZAxis",
							"GUID_RxAxis", "GUID_RyAxis", "GUID_RzAxis",
							"GUID_NONE" };

	if (memcmp(&lpddoi->guidType, &GUID_XAxis, sizeof(GUID)) == 0)			// X
		axis = 0;
	else if (memcmp(&lpddoi->guidType, &GUID_YAxis, sizeof(GUID)) == 0)		// Y
		axis = 1;
	else if (memcmp(&lpddoi->guidType, &GUID_ZAxis, sizeof(GUID)) == 0)		// Z
		axis = 2;
	else if (memcmp(&lpddoi->guidType, &GUID_RxAxis, sizeof(GUID)) == 0)	// X]
		axis = 3;
	else if (memcmp(&lpddoi->guidType, &GUID_RyAxis, sizeof(GUID)) == 0)	// Y]
		axis = 4;
	else if (memcmp(&lpddoi->guidType, &GUID_RzAxis, sizeof(GUID)) == 0)	// Z]
		axis = 5;
	else
		axis = 6; // ȏ̓T|[gȂ

	joystick->axis_offs[axis] = lpddoi->dwOfs;

	logerror("Axis %d offset: 0x%08x (%d:%s)\n", joystick->num_axes, lpddoi->dwOfs, axis, name[axis]);

	memset(&diprg, 0, sizeof(diprg));
	diprg.diph.dwSize = sizeof(diprg);
	diprg.diph.dwHeaderSize = sizeof(diprg.diph);
	diprg.diph.dwObj = lpddoi->dwOfs;
	diprg.diph.dwHow = DIPH_BYOFFSET;
	diprg.lMin = 0;
	diprg.lMax = 255;

	if (IDirectInputDevice2_SetProperty(joystick->did, DIPROP_RANGE, &diprg.diph) != DI_OK)
		goto error_axes;

	if (SetDIDwordProperty(joystick->did, DIPROP_DEADZONE, lpddoi->dwOfs, DIPH_BYOFFSET, 0) != DI_OK)
		goto error_axes;

	joystick->num_axes++;

error_axes:
	return DIENUM_CONTINUE;
}


/*------------------------------------------------------

	Q[Rg[[͉̓\ȃ{^񋓂

	  :
	߂l:

  A߂lDirectInput̃wvQ

 -----------------------------------------------------*/

static BOOL CALLBACK DIJoystick_EnumButtonObjectsProc(LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID pvRef)
{
	DIJOYSTICK *joystick = (DIJOYSTICK *)pvRef;
	joystick->num_buttons++;

	return DIENUM_CONTINUE;
}


/*------------------------------------------------------

	WCXeBbN̏Ԃ

	  : DIJOYSTATE *pdijs WCXeBbNԍ\
	߂l: Ȃ

 -----------------------------------------------------*/

static void ClearJoyState(DIJOYSTATE *pdijs)
{
	memset(pdijs, 0, sizeof(DIJOYSTATE));
	pdijs->lX           = 128;
	pdijs->lY           = 128;
	pdijs->lZ           = 128;
	pdijs->lRx          = 128;
	pdijs->lRy          = 128;
	pdijs->lRz          = 128;
	pdijs->rglSlider[0] = 128;
	pdijs->rglSlider[1] = 128;
	pdijs->rgdwPOV[0]   = -1;
	pdijs->rgdwPOV[1]   = -1;
	pdijs->rgdwPOV[2]   = -1;
	pdijs->rgdwPOV[3]   = -1;
}


/*------------------------------------------------------

	WCXeBbN

	  : DIJOYSTICK *dijoy  WCXeBbN\
	߂l: Ȃ

 -----------------------------------------------------*/

static void ReleaseJoystick(DIJOYSTICK *dijoy)
{
	if (dijoy->did != NULL)
	{
		IDirectInputDevice_Unacquire(dijoy->did);
		IDirectInputDevice_Release(dijoy->did);
		dijoy->num_axes = 0;
		dijoy->num_buttons = 0;
		dijoy->did = NULL;

		if (dijoy->name)
		{
			free(dijoy->name);
			dijoy->name = NULL;
		}
	}
}


/*------------------------------------------------------

	WCXeBbN쐬

	  : DIJOYSTICK *dijoy  WCXeBbN\
	߂l: Ȃ

 -----------------------------------------------------*/

static void CreateJoystick(DIJOYSTICK *dijoy)
{
	LPDIRECTINPUTDEVICE didTemp;
	HRESULT hResult;

	// foCX쐬
	if (IDirectInput_CreateDevice(di, &dijoy->guid, &didTemp, NULL) != DI_OK)
		return;

	// NGĂ݂Ď擾łȂG[
	hResult = IDirectInputDevice_QueryInterface(didTemp, &IID_IDirectInputDevice2, (void **)&dijoy->did);
	IDirectInputDevice_Release(didTemp);
	if (hResult != DI_OK)
	{
		dijoy->did = NULL;
		return;
	}

	logerror("Device name: %s\n", dijoy->name);

	// xݒ
	if (IDirectInputDevice2_SetCooperativeLevel(dijoy->did, MyApp.m_hWnd, DISCL_NONEXCLUSIVE | DISCL_BACKGROUND) != DI_OK)
		goto release;

	// f[^`ݒ
	if (IDirectInputDevice2_SetDataFormat(dijoy->did, &c_dfDIJoystick) != DI_OK)
		goto release;

	// 
	if (IDirectInputDevice_EnumObjects(dijoy->did, DIJoystick_EnumAxisObjectsProc, dijoy, DIDFT_AXIS) != DI_OK)
		goto release;

	// {^
	if (IDirectInputDevice_EnumObjects(dijoy->did, DIJoystick_EnumButtonObjectsProc, dijoy, DIDFT_BUTTON) != DI_OK)
		goto release;

	logerror("%d buttons found.\n", dijoy->num_buttons);

	// foCXm
	if (IDirectInputDevice2_Acquire(dijoy->did) != DI_OK)
		goto release;

	// ԏ
	ClearJoyState(&dijoy->dijs);
	return;

release:
	// G[Ȃ
	ReleaseJoystick(dijoy);
}


/*------------------------------------------------------

	WCXeBbNSď

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

static void InitJoystick(void)
{
	int i;

	for (i = 0; i < nNumJyoisticks; i++)
	{
		logerror("Initialize game contoroler %d.\n", i);
		CreateJoystick(&dijoysticks[i]);
	}
}


/*------------------------------------------------------

	WCXeBbNSĉ

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

static void ExitJoystick(void)
{
	int i;

	for (i = 0; i < nNumJyoisticks; i++)
		 ReleaseJoystick(&dijoysticks[i]);
}
