/***************************************************************************

	blit.c

	zXN[DirectDrawT[tFXւ̉摜]֐

    AZuł͓]̉16Ŋ؂sNZ̓]̂ݑΉ

***************************************************************************/

#include "win32.h"
#include "blit.h"

// AZułgp邩ǂ̐ݒ
#define ENABLE_ASMBLIT16	1
#define ENABLE_ASMBLIT24	1
#define ENABLE_ASMBLIT32	1

#define ENABLE_MMX			(ENABLE_ASMBLIT16 | ENABLE_ASMBLIT24 | ENABLE_ASMBLIT32)
#define ENABLE_SSE			ENABLE_MMX

#include "asmblit.h"

#define VERBOSE 0
#if VERBOSE
#define LOG(x) logerror x
#else
#define LOG(x)
#endif


/****************************************************************************
	vg^Cv
 ***************************************************************************/

#if (ENABLE_ASMBLIT16 == 0)
static void blit16(BLITERARGS);
static void blit16_double(BLITERARGS);
static void blit16_scanline0(BLITERARGS);
static void blit16_scanline25(BLITERARGS);
static void blit16_scanline50(BLITERARGS);
static void blit16_scanline75(BLITERARGS);
#endif

#if (ENABLE_ASMBLIT24 == 0)
static void blit24(BLITERARGS);
static void blit24_double(BLITERARGS);
static void blit24_scanline0(BLITERARGS);
static void blit24_scanline25(BLITERARGS);
static void blit24_scanline50(BLITERARGS);
static void blit24_scanline75(BLITERARGS);
#endif

#if (ENABLE_ASMBLIT32 == 0)
static void blit32(BLITERARGS);
static void blit32_double(BLITERARGS);
static void blit32_scanline0(BLITERARGS);
static void blit32_scanline25(BLITERARGS);
static void blit32_scanline50(BLITERARGS);
static void blit32_scanline75(BLITERARGS);
#endif


/****************************************************************************
	Oϐ
 ***************************************************************************/

extern DWORD *palette_lookup;	// 24/32bitppbgQƃe[u


/****************************************************************************
	O[oϐ
 ***************************************************************************/

// p[Zgw̃XLC\Ŏgp
DWORD brightmask50[2];	// 50%}XN
DWORD brightmask25[2];	// 25%}XN


/***************************************************************************
	O[o֐
 ***************************************************************************/

/*------------------------------------------------------

	摜]֐̑I

	  : int nDstDepth     ]̐F[x
			BOOL bDouble      2{g又tO
			BOOL bScanline    XLC\tO
			int bSLBrightness XLC̖邳
			BOOL bEnableMMX   MMXLtO
			BOOL bEnableSSE   SSELtO

	߂l: : ]t@NṼ|C^
	        s: NULL

 -----------------------------------------------------*/

bliter_func SelectBliter(int nDstDepth,
						 BOOL bDouble,
						 BOOL bScanLines,
						 int  nSLBrightness,
						 BOOL bEnableMMX,
						 BOOL bEnableSSE)
{
	bliter_func bliter = NULL;

	if (bScanLines == FALSE)
		nSLBrightness = 0;

#if ENABLE_SSE
	if (bEnableSSE == TRUE)
	{
		switch (nDstDepth)
		{
#if ENABLE_ASMBLIT16
		case 15:
		case 16:
			if (bScanLines)
			{
				if (nSLBrightness == 75)
				{
					bliter = asmblit16_scanline75_sse;
					logerror("SelectBliter(): set bliter function \"asmblit16_scanline75_sse\"\n");
				}
				else if (nSLBrightness == 50)
				{
					bliter = asmblit16_scanline50_sse;
					logerror("SelectBliter(): set bliter function \"asmblit16_scanline50_sse\"\n");
				}
				else if (nSLBrightness == 25)
				{
					bliter = asmblit16_scanline25_sse;
					logerror("SelectBliter(): set bliter function \"asmblit16_scanline25_sse\"\n");
				}
				else if (nSLBrightness == 0)
				{
					bliter = asmblit16_scanline0_sse;
					logerror("SelectBliter(): set bliter function \"asmblit16_scanline0_sse\"\n");
				}
			}
			else if (bDouble)
			{
				bliter = asmblit16_double_sse;
				logerror("SelectBliter(): set bliter function \"asmblit16_double_sse\"\n");
			}
			else
			{
				bliter = asmblit16_sse;
				logerror("SelectBliter(): set bliter function \"asmblit16_sse\"\n");
			}
			break;
#endif
#if ENABLE_ASMBLIT24
		case 24:
			if (bScanLines)
			{
				if (nSLBrightness == 75)
				{
					bliter = asmblit24_scanline75_sse;
					logerror("SelectBliter(): set bliter function \"asmblit24_scanline75_sse\"\n");
				}
				else if (nSLBrightness == 50)
				{
					bliter = asmblit24_scanline50_sse;
					logerror("SelectBliter(): set bliter function \"asmblit24_scanline50_sse\"\n");
				}
				else if (nSLBrightness == 25)
				{
					bliter = asmblit24_scanline25_sse;
					logerror("SelectBliter(): set bliter function \"asmblit24_scanline25_sse\"\n");
				}
				else if (nSLBrightness == 0)
				{
					bliter = asmblit24_scanline0_sse;
					logerror("SelectBliter(): set bliter function \"asmblit24_scanline0_sse\"\n");
				}
			}
			else if (bDouble)
			{
				bliter = asmblit24_double_sse;
				logerror("SelectBliter(): set bliter function \"asmblit24_double_sse\"\n");
			}
			else
			{
				bliter = asmblit24_sse;
				logerror("SelectBliter(): set bliter function \"asmblit24_sse\"\n");
			}
			break;
#endif
#if ENABLE_ASMBLIT32
		case 32:
			if (bScanLines)
			{
				if (nSLBrightness == 75)
				{
					bliter = asmblit32_scanline75_sse;
					logerror("SelectBliter(): set bliter function \"asmblit32_scanline75_sse\"\n");
				}
				else if (nSLBrightness == 50)
				{
					bliter = asmblit32_scanline50_sse;
					logerror("SelectBliter(): set bliter function \"asmblit32_scanline50_sse\"\n");
				}
				else if (nSLBrightness == 25)
				{
					bliter = asmblit32_scanline25_sse;
					logerror("SelectBliter(): set bliter function \"asmblit32_scanline25_sse\"\n");
				}
				else if (nSLBrightness == 0)
				{
					bliter = asmblit32_scanline0_sse;
					logerror("SelectBliter(): set bliter function \"asmblit32_scanline0_sse\"\n");
				}
			}
			else if (bDouble)
			{
				bliter = asmblit32_double_sse;
				logerror("SelectBliter(): set bliter function \"asmblit32_double_sse\"\n");
			}
			else
			{
				bliter = asmblit32_sse;
				logerror("SelectBliter(): set bliter function \"asmblit32_sse\"\n");
			}
			break;
#endif
		}

		if (bliter != NULL)
			return bliter;
	}
#endif /* ENABLE_SSE */


#if ENABLE_MMX
	if (bEnableMMX == TRUE)
	{
		switch (nDstDepth)
		{
#if ENABLE_ASMBLIT16
		case 15:
		case 16:
			if (bScanLines)
			{
				if (nSLBrightness == 75)
				{
					bliter = asmblit16_scanline75_mmx;
					logerror("SelectBliter(): set bliter function \"asmblit16_scanline75_mmx\"\n");
				}
				else if (nSLBrightness == 50)
				{
					bliter = asmblit16_scanline50_mmx;
					logerror("SelectBliter(): set bliter function \"asmblit16_scanline50_mmx\"\n");
				}
				else if (nSLBrightness == 25)
				{
					bliter = asmblit16_scanline25_mmx;
					logerror("SelectBliter(): set bliter function \"asmblit16_scanline25_mmx\"\n");
				}
				else if (nSLBrightness == 0)
				{
					bliter = asmblit16_scanline0_mmx;
					logerror("SelectBliter(): set bliter function \"asmblit16_scanline0_mmx\"\n");
				}
			}
			else if (bDouble)
			{
				bliter = asmblit16_double_mmx;
				logerror("SelectBliter(): set bliter function \"asmblit16_double_mmx\"\n");
			}
			else
			{
				bliter = asmblit16_mmx;
				logerror("SelectBliter(): set bliter function \"asmblit16_mmx\"\n");
			}
			break;
#endif
#if ENABLE_ASMBLIT24
		case 24:
			if (bScanLines)
			{
				if (nSLBrightness == 75)
				{
					bliter = asmblit24_scanline75_mmx;
					logerror("SelectBliter(): set bliter function \"asmblit24_scanline75_mmx\"\n");
				}
				else if (nSLBrightness == 50)
				{
					bliter = asmblit24_scanline50_mmx;
					logerror("SelectBliter(): set bliter function \"asmblit24_scanline50_mmx\"\n");
				}
				else if (nSLBrightness == 25)
				{
					bliter = asmblit24_scanline25_mmx;
					logerror("SelectBliter(): set bliter function \"asmblit24_scanline25_mmx\"\n");
				}
				else if (nSLBrightness == 0)
				{
					bliter = asmblit24_scanline0_mmx;
					logerror("SelectBliter(): set bliter function \"asmblit24_scanline0_mmx\"\n");
				}
			}
			else if (bDouble)
			{
				bliter = asmblit24_double_mmx;
				logerror("SelectBliter(): set bliter function \"asmblit24_double_mmx\"\n");
			}
			else
			{
				bliter = asmblit24_mmx;
				logerror("SelectBliter(): set bliter function \"asmblit24_mmx\"\n");
			}
			break;
#endif
#if ENABLE_ASMBLIT32
		case 32:
			if (bScanLines)
			{
				if (nSLBrightness == 75)
				{
					bliter = asmblit32_scanline75_mmx;
					logerror("SelectBliter(): set bliter function \"asmblit32_scanline75_mmx\"\n");
				}
				else if (nSLBrightness == 50)
				{
					bliter = asmblit32_scanline50_mmx;
					logerror("SelectBliter(): set bliter function \"asmblit32_scanline50_mmx\"\n");
				}
				else if (nSLBrightness == 25)
				{
					bliter = asmblit32_scanline25_mmx;
					logerror("SelectBliter(): set bliter function \"asmblit32_scanline25_mmx\"\n");
				}
				else if (nSLBrightness == 0)
				{
					bliter = asmblit32_scanline0_mmx;
					logerror("SelectBliter(): set bliter function \"asmblit32_scanline0_mmx\"\n");
				}
			}
			else if (bDouble)
			{
				bliter = asmblit32_double_mmx;
				logerror("SelectBliter(): set bliter function \"asmblit32_double_mmx\"\n");
			}
			else
			{
				bliter = asmblit32_mmx;
				logerror("SelectBliter(): set bliter function \"asmblit32_mmx\"\n");
			}
			break;
#endif
		}

		if (bliter != NULL)
			return bliter;
	}
#endif /* ENABLE_MMX */


	switch (nDstDepth)
	{
	case 15:
	case 16:
#if ENABLE_ASMBLIT16
		if (bScanLines)
		{
			if (nSLBrightness == 75)
			{
				bliter = asmblit16_scanline75;
				logerror("SelectBliter(): set bliter function \"asmblit16_scanline75\"\n");
			}
			else if (nSLBrightness == 50)
			{
				bliter = asmblit16_scanline50;
				logerror("SelectBliter(): set bliter function \"asmblit16_scanline50\"\n");
			}
			else if (nSLBrightness == 25)
			{
				bliter = asmblit16_scanline25;
				logerror("SelectBliter(): set bliter function \"asmblit16_scanline25\"\n");
			}
			else if (nSLBrightness == 0)
			{
				bliter = asmblit16_scanline0;
				logerror("SelectBliter(): set bliter function \"asmblit16_scanline0\"\n");
			}
		}
		else if (bDouble)
		{
			bliter = asmblit16_double;
			logerror("SelectBliter(): set bliter function \"asmblit16_double\"\n");
		}
		else
		{
			bliter = asmblit16;
			logerror("SelectBliter(): set bliter function \"asmblit16\"\n");
		}
#else
		if (bScanLines)
		{
			if (nSLBrightness == 75)
			{
				bliter = blit16_scanline75;
				logerror("SelectBliter(): set bliter function \"blit16_scanline75\"\n");
			}
			else if (nSLBrightness == 50)
			{
				bliter = blit16_scanline50;
				logerror("SelectBliter(): set bliter function \"blit16_scanline50\"\n");
			}
			else if (nSLBrightness == 25)
			{
				bliter = blit16_scanline25;
				logerror("SelectBliter(): set bliter function \"blit16_scanline25\"\n");
			}
			else if (nSLBrightness == 0)
			{
				bliter = blit16_scanline0;
				logerror("SelectBliter(): set bliter function \"blit16_scanline0\"\n");
			}
		}
		else if (bDouble)
		{
			bliter = blit16_double;
			logerror("SelectBliter(): set bliter function \"blit16_double\"\n");
		}
		else
		{
			bliter = blit16;
			logerror("SelectBliter(): set bliter function \"blit16\"\n");
		}
#endif
		break;

	case 24:
#if ENABLE_ASMBLIT24
		if (bScanLines)
		{
			if (nSLBrightness == 75)
			{
				bliter = asmblit24_scanline75;
				logerror("SelectBliter(): set bliter function \"asmblit24_scanline75\"\n");
			}
			else if (nSLBrightness == 50)
			{
				bliter = asmblit24_scanline50;
				logerror("SelectBliter(): set bliter function \"asmblit24_scanline50\"\n");
			}
			else if (nSLBrightness == 25)
			{
				bliter = asmblit24_scanline25;
				logerror("SelectBliter(): set bliter function \"asmblit24_scanline25\"\n");
			}
			else if (nSLBrightness == 0)
			{
				bliter = asmblit24_scanline0;
				logerror("SelectBliter(): set bliter function \"asmblit24_scanline0\"\n");
			}
		}
		else if (bDouble)
		{
			bliter = asmblit24_double;
			logerror("SelectBliter(): set bliter function \"asmblit24_double\"\n");
		}
		else
		{
			bliter = asmblit24;
			logerror("SelectBliter(): set bliter function \"asmblit24\"\n");
		}
#else
		if (bScanLines)
		{
			if (nSLBrightness == 75)
			{
				bliter = blit24_scanline75;
				logerror("SelectBliter(): set bliter function \"blit24_scanline75\"\n");
			}
			else if (nSLBrightness == 50)
			{
				bliter = blit24_scanline50;
				logerror("SelectBliter(): set bliter function \"blit24_scanline50\"\n");
			}
			else if (nSLBrightness == 25)
			{
				bliter = blit24_scanline25;
				logerror("SelectBliter(): set bliter function \"blit24_scanline25\"\n");
			}
			else if (nSLBrightness == 0)
			{
				bliter = blit24_scanline0;
				logerror("SelectBliter(): set bliter function \"blit24_scanline0\"\n");
			}
		}
		else if (bDouble)
		{
			bliter = blit24_double;
			logerror("SelectBliter(): set bliter function \"blit24_double\"\n");
		}
		else
		{
			bliter = blit24;
			logerror("SelectBliter(): set bliter function \"blit24\"\n");
		}
#endif
		break;

	case 32:
#if ENABLE_ASMBLIT32
		if (bScanLines)
		{
			if (nSLBrightness == 75)
			{
				bliter = asmblit32_scanline75;
				logerror("SelectBliter(): set bliter function \"asmblit32_scanline75\"\n");
			}
			else if (nSLBrightness == 50)
			{
				bliter = asmblit32_scanline50;
				logerror("SelectBliter(): set bliter function \"asmblit32_scanline50\"\n");
			}
			else if (nSLBrightness == 25)
			{
				bliter = asmblit32_scanline25;
				logerror("SelectBliter(): set bliter function \"asmblit32_scanline25\"\n");
			}
			else if (nSLBrightness == 0)
			{
				bliter = asmblit32_scanline0;
				logerror("SelectBliter(): set bliter function \"asmblit32_scanline0\"\n");
			}
		}
		else if (bDouble)
		{
			bliter = asmblit32_double;
			logerror("SelectBliter(): set bliter function \"asmblit32_double\"\n");
		}
		else
		{
			bliter = asmblit32;
			logerror("SelectBliter(): set bliter function \"asmblit32\"\n");
		}
#else
		if (bScanLines)
		{
			if (nSLBrightness == 75)
			{
				bliter = blit32_scanline75;
				logerror("SelectBliter(): set bliter function \"blit32_scanline75\"\n");
			}
			else if (nSLBrightness == 50)
			{
				bliter = blit32_scanline50;
				logerror("SelectBliter(): set bliter function \"blit32_scanline50\"\n");
			}
			else if (nSLBrightness == 25)
			{
				bliter = blit32_scanline25;
				logerror("SelectBliter(): set bliter function \"blit32_scanline25\"\n");
			}
			else if (nSLBrightness == 0)
			{
				bliter = blit32_scanline0;
				logerror("SelectBliter(): set bliter function \"blit32_scanline0\"\n");
			}
		}
		else if (bDouble)
		{
			bliter = blit32_double;
			logerror("SelectBliter(): set bliter function \"blit32_double\"\n");
		}
		else
		{
			bliter = blit32;
			logerror("SelectBliter(): set bliter function \"blit32\"\n");
		}
#endif
		break;
	}

	if (bliter == NULL)
		logerror("SelectBliter(): blit 16bpp to %dbpp not support.\n", nDstDepth);

	return bliter;
}



/*------------------------------------------------------

	p[ZgwXLC\p̃}XNݒ

	  : int nRSize   ԋPx̃TCY(bit)
			int nGSize   ΋Px̃TCY(bit)
			int nBSize   Px̃TCY(bit)
			int nRShift  ԋPx̃Vtg(bit)
			int nGShift  ΋Px̃Vtg(bit)
			int nBShift  Px̃Vtg(bit)
	߂l: Ȃ

  zɂȂĂ̂́AMMX64bit]邽

 -----------------------------------------------------*/

void SetBrightmask(int nRSize, int nGSize, int nBSize, int nRShift, int nGShift, int nBShift)
{
	int nDepth = nRSize + nGSize + nBSize;
	DWORD dwRMask50 = 0x7f >> (8 - nRSize) << nRShift;
	DWORD dwGMask50 = 0x7f >> (8 - nGSize) << nGShift;
	DWORD dwBMask50 = 0x7f >> (8 - nBSize) << nBShift;
	DWORD dwRMask25 = 0x3f >> (8 - nRSize) << nRShift;
	DWORD dwGMask25 = 0x3f >> (8 - nGSize) << nGShift;
	DWORD dwBMask25 = 0x3f >> (8 - nBSize) << nBShift;
	DWORD dwRGBMask50, dwRGBMask25;

	dwRGBMask50 = dwRMask50 | dwGMask50 | dwBMask50;
	dwRGBMask25 = dwRMask25 | dwGMask25 | dwBMask25;

	switch (nDepth)
	{
	case 15:	/* 0x3def3def */
	case 16:	/*  */
		brightmask50[0] = dwRGBMask50 | (dwRGBMask50 << 16);
		brightmask50[1] = brightmask50[0];
		brightmask25[0] = dwRGBMask25 | (dwRGBMask25 << 16);
		brightmask25[1] = brightmask25[0];
		break;

	case 24:	/* 0x7f7f7f7f */
		// RGB̊eTCY͂Ԃ񓯂ł傤
		brightmask50[0] = dwRGBMask50 | (dwRGBMask50 << 24);
		brightmask50[1] = brightmask50[0];
		brightmask25[0] = dwRGBMask25 | (dwRGBMask25 << 24);
		brightmask25[1] = brightmask25[0];
		break;

	case 32:	/* 0x007f7f7f */
		brightmask50[0] = dwRGBMask50;
		brightmask50[1] = dwRGBMask50;
		brightmask25[0] = dwRGBMask25;
		brightmask25[1] = dwRGBMask25;
		break;

	default:
		brightmask50[0] = 0;
		brightmask50[1] = 0;
		brightmask25[0] = 0;
		brightmask25[1] = 0;
		logerror("SetBrightmask(): %d bit color not support.\n", nDepth);
		return;
	}

	LOG(("SetBrightmask(): %d bit brightmask25 = %08x, brightmask50 = %08x\n", nDepth, brightmask25[0], brightmask50[0]));
}


/***************************************************************************
	[J֐
 ***************************************************************************/

#if !ENABLE_ASMBLIT16

/*------------------------------------------------------
	16bit  16bit ]
 -----------------------------------------------------*/

static void blit16(BLITERARGS)
{
	int y;
	BYTE *pSrc2, *pDst2;

	pSrc2 = pSrc;
	pDst2 = pDst;

	nWidth *= 2; // sNZ * sizeof(WORD)

	for (y = 0; y < nHeight; y++)
	{
		memcpy(pDst2, pSrc2, nWidth);	// memcpy1CCɓ]
		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}


/*------------------------------------------------------
	16bit  16bit sNZ2{]
 -----------------------------------------------------*/

static void blit16_double(BLITERARGS)
{
	int x, y;
	BYTE *pSrc2, *pDst2;
	WORD  pixel;
	WORD  *pSrc3;
	DWORD *pDst3;

	pSrc2 = pSrc;
	pDst2 = pDst;

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 1C
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 2{Ɋg
			*pDst3++ = (pixel << 16) | pixel;
		}

		pDst2 += nDstLen;
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 2C
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 2{Ɋg
			*pDst3++ = (pixel << 16) | pixel;
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}


/*------------------------------------------------------
	16bit  16bit XLC0%]
 -----------------------------------------------------*/

static void blit16_scanline0(BLITERARGS)
{
	int x, y;
	BYTE *pSrc2, *pDst2;
	WORD  pixel;
	WORD  *pSrc3;
	DWORD *pDst3;

	pSrc2 = pSrc;
	pDst2 = pDst;
	nDstLen *= 2;	// 1Cɓ]

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 1C
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 2{Ɋg
			*pDst3++ = (pixel << 16) | pixel;
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}


/*------------------------------------------------------
	16bit  16bit XLC25%]
 -----------------------------------------------------*/

static void blit16_scanline25(BLITERARGS)
{
	int x, y;
	BYTE *pSrc2, *pDst2;
	WORD  pixel, *pSrc3;
	DWORD pixel2, *pDst3;

	pSrc2 = pSrc;
	pDst2 = pDst;

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 1Cڂ͕ʂɓ]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 2{Ɋg
			*pDst3++ = (pixel << 16) | pixel;
		}

		pDst2 += nDstLen;
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 2Cڂ25%̋Pxɂē]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 2{Ɋg
			pixel2 = (pixel << 16) | pixel;

			// 2rbgEɃVtg25%
			pixel2 = (pixel2 >> 2) & brightmask25[0];

			*pDst3++ = pixel2;
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}


/*------------------------------------------------------
	16bit  16bit XLC50%]
 -----------------------------------------------------*/

static void blit16_scanline50(BLITERARGS)
{
	int x, y;
	BYTE *pSrc2, *pDst2;
	WORD  pixel, *pSrc3;
	DWORD pixel2, *pDst3;

	pSrc2 = pSrc;
	pDst2 = pDst;

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 1Cڂ͕ʂɓ]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 2{Ɋg
			*pDst3++ = (pixel << 16) | pixel;
		}

		pDst2 += nDstLen;
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 2Cڂ50%̋Pxɂē]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 2{Ɋg
			pixel2 = (pixel << 16) | pixel;

			// 1rbgEɃVtg50%
			*pDst3++ = (pixel2 >> 1) & brightmask50[0];
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}


/*------------------------------------------------------
	16bit  16bit XLC75%]
 -----------------------------------------------------*/

static void blit16_scanline75(BLITERARGS)
{
	int x, y;
	BYTE *pSrc2, *pDst2;
	WORD  pixel, *pSrc3;
	DWORD pixel2, pixel3, *pDst3;

	pSrc2 = pSrc;
	pDst2 = pDst;

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 1Cڂ͕ʂɓ]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;
			*pDst3++ = (pixel << 16) | pixel;
		}

		pDst2 += nDstLen;
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 2Cڂ50%̋Pxɂē]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 2{Ɋg
			pixel2 = (pixel << 16) | pixel;

			// Rs[
			pixel3 = pixel2;

			// 1rbgEɃVtg50%
			pixel2 = (pixel2 >> 1) & brightmask50[0];

			// 2rbgEɃVtg25%
			pixel3 = (pixel3 >> 2) & brightmask25[0];

			// 25% + 50% = 75%
			*pDst3++ = pixel2 += pixel3;
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}

#endif /* ENABLE_ASMBLIT16 */

/************************************************************************************************/

#if !ENABLE_ASMBLIT24

/*------------------------------------------------------
	16bit  24bit ]
 -----------------------------------------------------*/

static void blit24(BLITERARGS)
{
	int x, y;
	BYTE *pSrc2, *pDst2, *pDst3;
	WORD pixel, *pSrc3;
	DWORD pixel2;

	pSrc2 = pSrc;
	pDst2 = pDst;

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = pDst2;

		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 24bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			*pDst3++ =  pixel2        & 0xff;	// 1oCg
			*pDst3++ = (pixel2 >>  8) & 0xff;	// 2oCg
			*pDst3++ = (pixel2 >> 16) & 0xff;	// 3oCg
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}


/*------------------------------------------------------
	16bit  24bit sNZ2{]
 -----------------------------------------------------*/

static void blit24_double(BLITERARGS)
{
	int x, y;
	BYTE r, g, b, *pSrc2, *pDst2, *pDst3;
	WORD pixel, *pSrc3;
	DWORD pixel2;

	pSrc2 = pSrc;
	pDst2 = pDst;

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = pDst2;

		// 1C
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 24bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			// rgbɕ (ۂ̕т͈قȂꍇ)
			r =  pixel2        & 0xff;	// 1oCg
			g = (pixel2 >>  8) & 0xff;	// 2oCg
			b = (pixel2 >> 16) & 0xff;	// 3oCg

			// 1sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg

			// 2sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg
		}

		pDst2 += nDstLen;
		pSrc3 = (WORD *)pSrc2;
		pDst3 = pDst2;

		// 2C
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 24bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			// rgbɕ (ۂ̕т͈قȂꍇ)
			r =  pixel2        & 0xff;	// 1oCg
			g = (pixel2 >>  8) & 0xff;	// 2oCg
			b = (pixel2 >> 16) & 0xff;	// 3oCg

			// 1sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg

			// 2sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}


/*------------------------------------------------------
	16bit  24bit XLC0%]
 -----------------------------------------------------*/

static void blit24_scanline0(BLITERARGS)
{
	int x, y;
	BYTE r, g, b, *pSrc2, *pDst2, *pDst3;
	WORD pixel, *pSrc3;
	DWORD pixel2;

	pSrc2 = pSrc;
	pDst2 = pDst;
	nDstLen *= 2;	// 1Cɓ]

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = pDst2;

		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 24bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			// rgbɕ (ۂ̕т͈قȂꍇ)
			r =  pixel2        & 0xff;	// 1oCg
			g = (pixel2 >>  8) & 0xff;	// 2oCg
			b = (pixel2 >> 16) & 0xff;	// 3oCg

			// 1sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg

			// 2sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}


/*------------------------------------------------------
	16bit  24bit XLC25%]
 -----------------------------------------------------*/

static void blit24_scanline25(BLITERARGS)
{
	int x, y;
	BYTE r, g, b, *pSrc2, *pDst2, *pDst3;
	WORD pixel, *pSrc3;
	DWORD pixel2;

	pSrc2 = pSrc;
	pDst2 = pDst;

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = pDst2;

		// 1Cڂ͕ʂɓ]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 24bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			// rgbɕ (ۂ̕т͈قȂꍇ)
			r =  pixel2        & 0xff;	// 1oCg
			g = (pixel2 >>  8) & 0xff;	// 2oCg
			b = (pixel2 >> 16) & 0xff;	// 3oCg

			// 1sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg

			// 2sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg
		}

		pDst2 += nDstLen;
		pSrc3 = (WORD *)pSrc2;
		pDst3 = pDst2;

		// 2Cڂ25%̋Pxɂē]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 24bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			// 2rbgEɃVtg25%
			pixel2 = (pixel2 >> 1) & brightmask25[0];

			// rgbɕ (ۂ̕т͈قȂꍇ)
			r =  pixel2        & 0xff;	// 1oCg
			g = (pixel2 >>  8) & 0xff;	// 2oCg
			b = (pixel2 >> 16) & 0xff;	// 3oCg

			// 1sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg

			// 2sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}


/*------------------------------------------------------
	16bit  24bit XLC50%]
 -----------------------------------------------------*/

static void blit24_scanline50(BLITERARGS)
{
	int x, y;
	BYTE r, g, b, *pSrc2, *pDst2, *pDst3;
	WORD pixel, *pSrc3;
	DWORD pixel2;

	pSrc2 = pSrc;
	pDst2 = pDst;

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = pDst2;

		// 1Cڂ͕ʂɓ]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 24bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			// rgbɕ (ۂ̕т͈قȂꍇ)
			r =  pixel2        & 0xff;	// 1oCg
			g = (pixel2 >>  8) & 0xff;	// 2oCg
			b = (pixel2 >> 16) & 0xff;	// 3oCg

			// 2sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg

			// 2sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg
		}

		pDst2 += nDstLen;
		pSrc3 = (WORD *)pSrc2;
		pDst3 = pDst2;

		// 2Cڂ50%̋Pxɂē]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 24bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			// 1rbgEɃVtg50%
			pixel2 = (pixel2 >> 1) & brightmask50[0];

			// rgbɕ (ۂ̕т͈قȂꍇ)
			r =  pixel2        & 0xff;	// 1oCg
			g = (pixel2 >>  8) & 0xff;	// 2oCg
			b = (pixel2 >> 16) & 0xff;	// 3oCg

			// 1sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg

			// 2sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}


/*------------------------------------------------------
	16bit  24bit XLC75%]
 -----------------------------------------------------*/

static void blit24_scanline75(BLITERARGS)
{
	int x, y;
	BYTE r, g, b, *pSrc2, *pDst2, *pDst3;
	WORD pixel, *pSrc3;
	DWORD pixel2, pixel3;

	pSrc2 = pSrc;
	pDst2 = pDst;

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = pDst2;

		// 1Cڂ͕ʂɓ]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 24bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			// rgbɕ (ۂ̕т͈قȂꍇ)
			r =  pixel2        & 0xff;	// 1oCg
			g = (pixel2 >>  8) & 0xff;	// 2oCg
			b = (pixel2 >> 16) & 0xff;	// 3oCg

			// 2sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg

			// 2sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg
		}

		pDst2 += nDstLen;
		pSrc3 = (WORD *)pSrc2;
		pDst3 = pDst2;

		// 2Cڂ50%̋Pxɂē]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 24bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			// Rs[
			pixel3 = pixel2;

			// 1rbgEɃVtg50%
			pixel2 = (pixel2 >> 1) & brightmask50[0];

			// 2rbgEɃVtg25%
			pixel3 = (pixel3 >> 2) & brightmask25[0];

			// 25% + 50% = 75%
			pixel2 += pixel3;

			// rgbɕ (ۂ̕т͈قȂꍇ)
			r =  pixel2        & 0xff;	// 1oCg
			g = (pixel2 >>  8) & 0xff;	// 2oCg
			b = (pixel2 >> 16) & 0xff;	// 3oCg

			// 1sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg

			// 2sNZ
			*pDst3++ = r;	// 1oCg
			*pDst3++ = g;	// 2oCg
			*pDst3++ = b;	// 3oCg
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}

#endif /* ENABLE_ASMBLIT24 */

/************************************************************************************************/

#if !ENABLE_ASMBLIT32

/*------------------------------------------------------
	16bit  32bit ]
 -----------------------------------------------------*/

static void blit32(BLITERARGS)
{
	int x, y;
	BYTE *pSrc2, *pDst2;
	WORD pixel, *pSrc3;
	DWORD *pDst3;

	pSrc2 = pSrc;
	pDst2 = pDst;

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 32bitJ[ɕϊ
			*pDst3++ = palette_lookup[pixel];
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}


/*------------------------------------------------------
	16bit  32bit sNZ2{]
 -----------------------------------------------------*/

static void blit32_double(BLITERARGS)
{
	int x, y;
	BYTE *pSrc2, *pDst2;
	WORD pixel, *pSrc3;
	DWORD pixel2, *pDst3;

	pSrc2 = pSrc;
	pDst2 = pDst;

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 1C
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 32bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			*pDst3++ = pixel2;	// 1sNZ
			*pDst3++ = pixel2; 	// 2sNZ
		}

		pDst2 += nDstLen;
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 2C
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 32bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			*pDst3++ = pixel2;	// 1sNZ
			*pDst3++ = pixel2; 	// 2sNZ
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}


/*------------------------------------------------------
	16bit  32bit XLC0%]
 -----------------------------------------------------*/

static void blit32_scanline0(BLITERARGS)
{
	int x, y;
	BYTE *pSrc2, *pDst2;
	WORD pixel, *pSrc3;
	DWORD pixel2, *pDst3;

	pSrc2 = pSrc;
	pDst2 = pDst;
	nDstLen *= 2;	// 1Cɓ]

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 32bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			*pDst3++ = pixel2;	// 1sNZ
			*pDst3++ = pixel2; 	// 2sNZ
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}


/*------------------------------------------------------
	16bit  32bit XLC25%]
 -----------------------------------------------------*/

static void blit32_scanline25(BLITERARGS)
{
	int x, y;
	BYTE *pSrc2, *pDst2;
	WORD pixel, *pSrc3;
	DWORD pixel2, *pDst3;

	pSrc2 = pSrc;
	pDst2 = pDst;

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 1Cڂ͕ʂɓ]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 32bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			*pDst3++ = pixel2;	// 1sNZ
			*pDst3++ = pixel2; 	// 2sNZ
		}

		pDst2 += nDstLen;
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 2Cڂ25%̋Pxɂē]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 32bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			// 2rbgEɃVtg50%
			pixel2 = (pixel2 >> 1) & brightmask25[0];

			*pDst3++ = pixel2;	// 1sNZ
			*pDst3++ = pixel2; 	// 2sNZ
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}


/*------------------------------------------------------
	16bit  32bit XLC50%]
 -----------------------------------------------------*/

static void blit32_scanline50(BLITERARGS)
{
	int x, y;
	BYTE *pSrc2, *pDst2;
	WORD pixel, *pSrc3;
	DWORD pixel2, *pDst3;

	pSrc2 = pSrc;
	pDst2 = pDst;

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 1Cڂ͕ʂɓ]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 32bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			*pDst3++ = pixel2;	// 1sNZ
			*pDst3++ = pixel2; 	// 2sNZ
		}

		pDst2 += nDstLen;
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 2Cڂ50%̋Pxɂē]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 32bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			// 1rbgEɃVtg50%
			pixel2 = (pixel2 >> 1) & brightmask50[0];

			*pDst3++ = pixel2;	// 1sNZ
			*pDst3++ = pixel2; 	// 2sNZ
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}


/*------------------------------------------------------
	16bit  32bit XLC75%]
 -----------------------------------------------------*/

static void blit32_scanline75(BLITERARGS)
{
	int x, y;
	BYTE *pSrc2, *pDst2;
	WORD pixel, *pSrc3;
	DWORD pixel2, pixel3, *pDst3;

	pSrc2 = pSrc;
	pDst2 = pDst;

	for (y = 0; y < nHeight; y++)
	{
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 1Cڂ͕ʂɓ]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 32bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			*pDst3++ = pixel2;	// 1sNZ
			*pDst3++ = pixel2; 	// 2sNZ
		}

		pDst2 += nDstLen;
		pSrc3 = (WORD *)pSrc2;
		pDst3 = (DWORD *)pDst2;

		// 2Cڂ75%̋Pxɂē]
		for (x = 0; x < nWidth; x++)
		{
			pixel = *pSrc3++;

			// 32bitJ[ɕϊ
			pixel2 = palette_lookup[pixel];

			// Rs[
			pixel3 = pixel2;

			// 1rbgEɃVtg50%
			pixel2 = (pixel2 >> 1) & brightmask50[0];

			// 2rbgEɃVtg25%
			pixel3 = (pixel3 >> 2) & brightmask25[0];

			// 25% + 50% = 75%
			pixel2 += pixel3;

			*pDst3++ = pixel2;	// 1sNZ
			*pDst3++ = pixel2; 	// 2sNZ
		}

		pSrc2 += nSrcLen;
		pDst2 += nDstLen;
	}
}

#endif /* ENABLE_ASMBLIT32 */
