/***************************************************************************

	vidhrdw.c

	NEOGEO CD 摜RA

***************************************************************************/

#ifndef NEOGEO_VIDEO_H
#define NEOGEO_VIDEO_H

#define PALETTE_SIZE (0x2000 >> 1)

extern UINT16 *neogeo_vidram16;
extern UINT16 neogeo_vidram16_modulo;
extern UINT16 neogeo_vidram16_offset;

extern UINT16 *video_palette;
extern UINT16 *neogeo_paletteram16;
extern UINT16 neogeo_bios_palette[2][PALETTE_SIZE];
extern UINT8  video_fix_usage[];
extern UINT8  video_spr_usage[];
extern UINT16 video_color_lut[];

extern int video_enable;
extern int fix_disable;
extern int spr_disable;

int  video_init(void);
void video_shutdown(void);

int  neogeo_video_init(void);
void neogeo_video_exit(void);
void neogeo_video_reset(void);
void neogeo_setpalbank(int n);
void neogeo_screenrefresh(void);
void neogeo_partial_screenrefresh(int current_line);
void neogeo_raster_screenrefresh(void);
void neogeo_loading_screenrefresh(void);

#if FAST_SPRITE_DRAW
void neogeo_change_sprite_func(int type, int show_message);
#endif
void neogeo_draw_fix(UINT8 *gfx, int no, int x, int y, UINT16 *paldata, int opaque);
void neogeo_draw_gfx(UINT8 *gfx, int no, int x, int y, UINT16 *paldata, int opaque);
void neogeo_bios_get_cursor_pos(int *cx, int *cy, int *tileno, int *tileatr);
void neogeo_clear_vram(void);
void clear_screen(void);

#endif /* NEOGEO_VIDEO_H */
