/***************************************************************************

	vidhrdw.c

	NEOGEO CD 摜RA

***************************************************************************/

#include "neogeocd.h"

/******************************************************************************/

static int neogeo_palette_index;
static int next_update_first_line;

static UINT16 neogeo_palettebank[2][PALETTE_SIZE];
static UINT16 video_palettebank[2][PALETTE_SIZE];

static UINT8 *l_y_skip;

#if FAST_SPRITE_DRAW
static void (*draw_sprites_func)(int start, int end, const struct rectangle *clip);
#endif

static int line_gap;

/******************************************************************************/

UINT16 *neogeo_vidram16;
UINT16 neogeo_vidram16_modulo;
UINT16 neogeo_vidram16_offset;

UINT16 *neogeo_paletteram16;
UINT16 *video_palette;
UINT8  video_fix_usage[0x1000];
UINT8  video_spr_usage[0x100000];
UINT16 video_color_lut[0x8000];

int video_enable;
int fix_disable;
int spr_disable;


/******************************************************************************/

/*  XvCg`֐̓t@C荞ł܂ */

#if FAST_SPRITE_DRAW
#include "spritef.c"
#endif

#include "sprite.c"

/******************************************************************************/

/*------------------------------------------------------

	NEOGEỎ摜

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

int neogeo_video_init(void)
{
	UINT16 pen;
	int r, g, b;

	// rfIRAMm
	neogeo_vidram16 = (UINT16 *)malloc(0x80000);
	if (!neogeo_vidram16)
	{
		logerror("Could not allocate video RAM.\n");
		return 0;
	}

	// e탁NA
	memset(neogeo_vidram16, 0, 0x80000);
	memset(neogeo_palettebank, 0, 0x2000 * 2);
	memset(video_palettebank, 0, 0x2000 * 2);
	memset(video_fix_usage, 0, 0x1000);
	memset(video_spr_usage, 0, 0x100000);

	// ʕύXsꂽꍇɁAIɃpbgC邽߂ɓo^
	osd_register_palette(video_color_lut, 0x8000);
	osd_register_palette(video_palettebank[0], PALETTE_SIZE);
	osd_register_palette(video_palettebank[1], PALETTE_SIZE);

	// pbgQƃe[u쐬
	for (r = 0; r < 32; r++)
	{
		for (g = 0; g < 32; g++)
		{
			for (b = 0; b < 32; b++)
			{
				int r1 = (r << 3) | (r >> 2);
				int g1 = (g << 3) | (g >> 2);
				int b1 = (b << 3) | (b >> 2);

				pen = ((r & 1) << 14) | ((r & 0x1e) << 7)
					| ((g & 1) << 13) | ((g & 0x1e) << 3)
					| ((b & 1) << 12) | ((b & 0x1e) >> 1);

				video_color_lut[pen] = osd_set_palette(r1, g1, b1);
			}
		}
	}

#if FAST_SPRITE_DRAW
	neogeo_init_sprite();
#endif

	// Zbg
	neogeo_video_reset();

	return 1;
}


/*------------------------------------------------------

	NEOGEỎ摜I

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void neogeo_video_exit(void)
{
	// pbgo^
	osd_unregister_palette(video_color_lut);
	osd_unregister_palette(video_palettebank[0]);
	osd_unregister_palette(video_palettebank[1]);

	// rfIRAM
	if (neogeo_vidram16)
	{
		free(neogeo_vidram16);
		neogeo_vidram16 = NULL;
	}
}


/*------------------------------------------------------

	NEOGEỎ摜Zbg

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void neogeo_video_reset(void)
{
	neogeo_paletteram16 = neogeo_palettebank[0];
	video_palette = video_palettebank[0];
	neogeo_vidram16_modulo = 0;
	neogeo_vidram16_offset = 0;

	neogeo_palette_index = 0;
	next_update_first_line = 0;

	video_enable = 1;
	fix_disable = 0;
	spr_disable = 0;

	line_gap = ((int)scrbitmap.line[1] - (int)scrbitmap.line[0]) >> 1;

#if FAST_SPRITE_DRAW
	if (driver_type & 1)
		draw_sprites_func = draw_sprites_fast;
	else
		draw_sprites_func = draw_sprites;
#else
	draw_sprites_func = draw_sprites;
#endif
}


/*------------------------------------------------------

	pbgBANK̕ύX

	  : int n  oNԍ
	߂l: Ȃ

 -----------------------------------------------------*/

void neogeo_setpalbank(int n)
{
	if (neogeo_palette_index != n)
	{
		neogeo_palette_index = n;
		neogeo_paletteram16 = neogeo_palettebank[n];
		video_palette = video_palettebank[n];
	}
}


/*------------------------------------------------------

	TCYŒXvCg(FIX)̕`

	  : UINT16 *bm       rbg}bv̕`Jnʒu
	        UINT8 *gfx       FIX̃
	        UINT16 *paldata  pbgf[^
	        int opaque       ߃tO
	߂l: Ȃ

 -----------------------------------------------------*/

static void neo_draw_fix(UINT16 *bm, UINT8 *gfx, UINT16 *paldata, int opaque)
{
	int y = 8;
	UINT32 *sprite4 = (UINT32 *)gfx;
	UINT32 tile;

	if (opaque)
	{
		while (y--)
		{
			tile = *sprite4++;
						bm[0] = paldata[tile & 0x0f];
			tile >>= 4; bm[1] = paldata[tile & 0x0f];
			tile >>= 4; bm[2] = paldata[tile & 0x0f];
			tile >>= 4; bm[3] = paldata[tile & 0x0f];
			tile >>= 4; bm[4] = paldata[tile & 0x0f];
			tile >>= 4; bm[5] = paldata[tile & 0x0f];
			tile >>= 4; bm[6] = paldata[tile & 0x0f];
			tile >>= 4; bm[7] = paldata[tile & 0x0f];
			bm += line_gap;
		}
	}
	else
	{
		while (y--)
		{
			tile = *sprite4++;
						if (tile & 0x0f) bm[0] = paldata[tile & 0x0f];
			tile >>= 4; if (tile & 0x0f) bm[1] = paldata[tile & 0x0f];
			tile >>= 4; if (tile & 0x0f) bm[2] = paldata[tile & 0x0f];
			tile >>= 4; if (tile & 0x0f) bm[3] = paldata[tile & 0x0f];
			tile >>= 4; if (tile & 0x0f) bm[4] = paldata[tile & 0x0f];
			tile >>= 4; if (tile & 0x0f) bm[5] = paldata[tile & 0x0f];
			tile >>= 4; if (tile & 0x0f) bm[6] = paldata[tile & 0x0f];
			tile >>= 4; if (tile & 0x0f) bm[7] = paldata[tile & 0x0f];
			bm += line_gap;
		}
	}
}


/*------------------------------------------------------

	TCYŒXvCg(FIX)̕`(Sʕ)

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

static void draw_fix(void)
{
	int x, y;
	int code, color;
#if ENABLE_SYSTEM_CHECK
	UINT8 *gfx = memory_region(REGION_GFX5);
#else
	UINT8 *gfx = memory_region(REGION_GFX1);
#endif

	/* Character foreground */
	for (y = 16/8; y < 240/8; y++)
	{
		for (x = 0/8; x < 320/8; x++)
		{
			code  = neogeo_vidram16[(0xe000 >> 1) + y + 32 * x];
			color = (code >> 8) & 0x00f0;
			code &= 0x0fff;

			if (video_fix_usage[code])
			{
				neo_draw_fix(&scrbitmap.line[y * 8][x * 8], gfx + code * 32, &video_palette[color], video_fix_usage[code] & 1);
			}
		}
	}
}


/*------------------------------------------------------

	ʂw肳ꂽFœhԂ

	  : int pen   hԂF̃pbgԍ
	߂l: Ȃ

 -----------------------------------------------------*/

#ifdef _MSC_VER
static void fillbitmap(int pen)
{
	UINT16 *pDst = &scrbitmap.line[FIRST_VISIBLE_LINE][0];

	pen *= 0x00010001;

	__asm {
		mov       edi, pDst
		mov       eax, pen
		mov       edx, SCREEN_HEIGHT
		mov       ebx, 16 * 2
		cld
L1:
		mov       ecx, (SCREEN_WIDTH * 2) / 4
		rep       stosd
		dec       edx
		lea       edi, [edi + ebx]
		jnz       L1
	}
}
#else
static void fillbitmap(int pen)
{
	int height = SCREEN_HEIGHT;
	UINT32 *pDst = (UINT32 *)(&scrbitmap.line[FIRST_VISIBLE_LINE][0]);

	pen *= 0x00010001;

	while (height--)
	{
		int width = (SCREEN_WIDTH * 2) / 4;

		while (width--)
		{
			*pDst++ = pen;
		}
		pDst += 8;
	}
}
#endif


/*------------------------------------------------------

	AoEgT`2 ppb`
	fʂ̃SC (s)

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

static void patch_vram_rbff2(void)
{
	UINT16 offs;

	for (offs = 0; offs < ((0x300 >> 1) << 6) ; offs += 2)
	{
		UINT16 tileno  = neogeo_vidram16[offs];
		UINT16 tileatr = neogeo_vidram16[offs + 1];

		if (tileno == 0x7a00 && (tileatr == 0x4b00 || tileatr == 0x1400))
		{
			// Ȃ8bit0ɉĂ̂ŏC
			neogeo_vidram16[offs] = 0x7ae9;
			return;
		}
	}
}


/*------------------------------------------------------

	ADK[h ppb`
	19YŶ݂ (s)

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

static void patch_vram_adkworld(void)
{
	UINT16 offs;

	for (offs = 0; offs < ((0x300 >> 1) << 6) ; offs += 2)
	{
		UINT16 tileno  = neogeo_vidram16[offs];
		UINT16 tileatr = neogeo_vidram16[offs + 1];

		if ((tileno == 0x14c0 || tileno == 0x1520) && tileatr == 0x0000)
			neogeo_vidram16[offs] = 0x0000;
	}
}


/*------------------------------------------------------

	NX\[h2 ppb`
	fʉÊ݂ (s)

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

static void patch_vram_crsword2(void)
{
	UINT16 offs;

	for (offs = 0; offs < ((0x300 >> 1) << 6) ; offs += 2)
	{
		UINT16 tileno  = neogeo_vidram16[offs];
		UINT16 tileatr = neogeo_vidram16[offs + 1];

		if (tileno == 0x52a0 && tileatr == 0x0000)
			neogeo_vidram16[offs] = 0x0000;
	}
}


/*------------------------------------------------------

	ʍXV(XLC荞ݖgp)

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void neogeo_screenrefresh(void)
{
#if FAST_SPRITE_DRAW
	if (osd_is_key_pressed_memory(KEYCODE_F2))
		neogeo_change_sprite_func((driver_type ^ 1) & 1, 1);
#endif

	if (!video_enable)
	{
		clear_screen();
		return;
	}

	fillbitmap(video_palette[4095]);

	if (!spr_disable)
	{
		if (driver_flag & PATCH_SSRPG)
		{
			int t1, pass1_start;

			t1 = neogeo_vidram16[(0x10400 + 4) >> 1];

			if ((t1 & 0x40) == 0)
			{
				for (pass1_start = (6 >> 1); pass1_start < (0x300 >> 1); pass1_start++)
				{
					t1 = neogeo_vidram16[(0x10400 >> 1) + pass1_start];

					if ((t1 & 0x40) == 0)
						break;
				}

				if (pass1_start == (6 >> 1))
					pass1_start = 0;
			}
			else
				pass1_start = 0;

			(*draw_sprites_func)(pass1_start, 0x300 >> 1, &visible_area);

			if (pass1_start)
			{
				struct rectangle clip;

				clip.min_x = visible_area.min_x;
				clip.max_x = visible_area.max_x;
				clip.min_y = 176;
				clip.max_y = visible_area.max_y;

				(*draw_sprites_func)(0, pass1_start, &clip);
			}
		}
		else
		{
			if (driver_flag & PATCH_RBFF2)		patch_vram_rbff2();
			if (driver_flag & PATCH_ADKWORLD)	patch_vram_adkworld();
			if (driver_flag & PATCH_CRSWORD2)	patch_vram_crsword2();

			(*draw_sprites_func)(0, 0x300 >> 1, &visible_area);
		}
	}

	if (!fix_disable)
		draw_fix();
}


/*------------------------------------------------------

    X^hCop
	ʍXV(XLC荞ݎ)

	  : int current_line  ʏ݂̌̕`惉C
	߂l: Ȃ

 -----------------------------------------------------*/

void neogeo_partial_screenrefresh(int current_line)
{
	struct rectangle clip;

	if (current_line < next_update_first_line)
	{
		next_update_first_line = FIRST_VISIBLE_LINE;

		if (video_enable)
			fillbitmap(video_palette[4095]);
	}

	if (!spr_disable)
	{
		clip.min_x = visible_area.min_x;
		clip.max_x = visible_area.max_x;
		clip.min_y = next_update_first_line;
		clip.max_y = current_line;

		if (GAME_NAME("turfmast")) clip.max_y++;

		if (clip.min_y < visible_area.min_y)
			clip.min_y = visible_area.min_y;
		if (clip.max_y > visible_area.max_y)
			clip.max_y = visible_area.max_y;

		if (clip.max_y >= clip.min_y)
			(*draw_sprites_func)(0, 0x300 >> 1, &clip);
	}

	next_update_first_line = current_line + 1;
}


/*------------------------------------------------------

    X^hCop
	ʍXV(VBLANK荞ݎ)

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void neogeo_raster_screenrefresh(void)
{
#if FAST_SPRITE_DRAW
	if (osd_is_key_pressed_memory(KEYCODE_F2))
		neogeo_change_sprite_func((driver_type ^ 1) & 1, 1);
#endif

	if (!video_enable)
	{
		clear_screen();
		return;
	}

	neogeo_partial_screenrefresh(248);

	if (!fix_disable)
		draw_fix();
}


/*------------------------------------------------------

    [h̉ʍXV

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void neogeo_loading_screenrefresh(void)
{
	clear_screen();

	if (!fix_disable)
		draw_fix();
}


/******************************************************************************/

/*------------------------------------------------------

    XvCg`֐؂ւ

	  : int type           ύX^Cv
	        int show_message   bZ[W\
	߂l: Ȃ

 -----------------------------------------------------*/

#if FAST_SPRITE_DRAW
void neogeo_change_sprite_func(int type, int show_message)
{
	if (type)
	{
		draw_sprites_func = draw_sprites_fast;
		driver_type |= 1;
	}
	else
	{
		draw_sprites_func = draw_sprites;
		driver_type &= ~1;
	}

	if (show_message)
	{
		const char *func_name[] = { "NEOGEO NORMAL", "NEOGEO FAST", "RASTER NORMAL", "RASTER FAST", "BUSY NORMAL", "BUSY FAST" };

		ui_popup("Change driver to \"%s\"", func_name[driver_type]);
	}
}
#endif


/*------------------------------------------------------

	ʂւNEOGEOXvCg`

	  : UINT8t gfx       XvCgp̈
	        int no           XvCgԍ
	        int x            W
	        int y            cW
	        UINT16 *paldata  pbg̃|C^
	        int opaque       ߃tO
	߂l: Ȃ

 -----------------------------------------------------*/

void neogeo_draw_gfx(UINT8 *gfx, int no, int x, int y, UINT16 *paldata, int opaque)
{
	int yy;
	UINT32 *fspr;

	for (yy = 0; yy < 16; yy++)
	{
		fspr = (UINT32 *)gfx + no * 32 + 2 * yy;
		(*neo_draw_sprite[opaque][0][15])(fspr, scrbitmap.line[yy + y] + x, paldata);
	}
}


/*------------------------------------------------------

	ʂւNEOGEOŒXvCg`

	  : UINT8t gfx       XvCgp̈
	        int no           XvCgԍ
	        int x            W
	        int y            cW
	        UINT16 *paldata  pbg̃|C^
	        int opaque       ߃tO
	߂l: Ȃ

 -----------------------------------------------------*/

void neogeo_draw_fix(UINT8 *gfx, int no, int x, int y, UINT16 *paldata, int opaque)
{
	neo_draw_fix(&scrbitmap.line[y][x], gfx + no * 32, paldata, opaque);
}


/*------------------------------------------------------

	BIOSʂ̃J[\擾

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void neogeo_bios_get_cursor_pos(int *cx, int *cy, int *tileno, int *tileatr)
{
	*cx = neogeo_vidram16[(0x10800 >> 1) + 0x83] >> 7;
	*cy = 0x200 - (neogeo_vidram16[(0x10400 >> 1) + 0x83] >> 7);
	*tileno  = neogeo_vidram16[(0x83 << 6)];
	*tileatr = neogeo_vidram16[(0x83 << 6) + 1];
}


/*------------------------------------------------------

	BIOSʂ̃J[\擾

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void neogeo_clear_vram(void)
{
	int i;

	memset(neogeo_vidram16, 0, 0x80000);

	for (i = 0; i < 0x500; i++)
		neogeo_vidram16[0x7000 + i] = 0;

	memset(neogeo_palettebank, 0, 0x2000 * 2);
	memset(video_palettebank, 0, 0x2000 * 2);
}


/*------------------------------------------------------

	ʂNA

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void clear_screen(void)
{
	fillbitmap(0);
}
