/***************************************************************************

	sprite.c

	NEOGEO CD XvCg`揈

***************************************************************************/

#ifndef SELF_INCLUDE

#define ARGS	UINT32 *sprite, UINT16 *bm, UINT16 *paldata

/******************************************************************************/
#define SELF_INCLUDE
/******************************************************************************/

#ifdef OPAQUE
#undef OPAQUE
#endif

#define OPAQUE 0
	#define FLIPY 0
		#define FLIPX 0
			#include "sprite.c" /* opaque = no, flipx = no, flipy = no */
		#undef  FLIPX
		#define FLIPX 1
			#include "sprite.c" /* opaque = no, flipx = yes, flipy = no */
		#undef  FLIPX
	#undef  FLIPY
	#define FLIPY 1
		#define FLIPX 0
			#include "sprite.c" /* opaque = no, flipx = no, flipy = yes */
		#undef  FLIPX
		#define FLIPX 1
			#include "sprite.c" /* opaque = no, flipx = yes, flipy = yes */
		#undef  FLIPX
	#undef  FLIPY
#undef  OPAQUE

#define OPAQUE 1
	#define FLIPY 0
		#define FLIPX 0
			#include "sprite.c" /* opaque = yes, flipx = no, flipy = no */
		#undef  FLIPX
		#define FLIPX 1
			#include "sprite.c" /* opaque = yes, flipx = yes, flipy = no */
		#undef  FLIPX
	#undef  FLIPY
	#define FLIPY 1
		#define FLIPX 0
			#include "sprite.c" /* opaque = yes, flipx = no, flipy = yes */
		#undef  FLIPX
		#define FLIPX 1
			#include "sprite.c" /* opaque = yes, flipx = yes, flipy = yes */
		#undef  FLIPX
	#undef  FLIPY
#undef OPAQUE

/******************************************************************************/
#undef  SELF_INCLUDE
/******************************************************************************/

static void (*neo_draw_sprite[2][4][16])(UINT32 *sprite, UINT16 *bm, UINT16 *paldata) =
{
	{
		{
			draw_sprite_0_0_1,  draw_sprite_0_0_2,
			draw_sprite_0_0_3,  draw_sprite_0_0_4,
			draw_sprite_0_0_5,  draw_sprite_0_0_6,
			draw_sprite_0_0_7,  draw_sprite_0_0_8,
			draw_sprite_0_0_9,  draw_sprite_0_0_10,
			draw_sprite_0_0_11, draw_sprite_0_0_12,
			draw_sprite_0_0_13, draw_sprite_0_0_14,
			draw_sprite_0_0_15, draw_sprite_0_0_16
		},
		{
			draw_sprite_0_1_1,  draw_sprite_0_1_2,
			draw_sprite_0_1_3,  draw_sprite_0_1_4,
			draw_sprite_0_1_5,  draw_sprite_0_1_6,
			draw_sprite_0_1_7,  draw_sprite_0_1_8,
			draw_sprite_0_1_9,  draw_sprite_0_1_10,
			draw_sprite_0_1_11, draw_sprite_0_1_12,
			draw_sprite_0_1_13, draw_sprite_0_1_14,
			draw_sprite_0_1_15, draw_sprite_0_1_16
		},
		{
			draw_sprite_0_2_1,  draw_sprite_0_2_2,
			draw_sprite_0_2_3,  draw_sprite_0_2_4,
			draw_sprite_0_2_5,  draw_sprite_0_2_6,
			draw_sprite_0_2_7,  draw_sprite_0_2_8,
			draw_sprite_0_2_9,  draw_sprite_0_2_10,
			draw_sprite_0_2_11, draw_sprite_0_2_12,
			draw_sprite_0_2_13, draw_sprite_0_2_14,
			draw_sprite_0_2_15, draw_sprite_0_2_16
		},
		{
			draw_sprite_0_3_1,  draw_sprite_0_3_2,
			draw_sprite_0_3_3,  draw_sprite_0_3_4,
			draw_sprite_0_3_5,  draw_sprite_0_3_6,
			draw_sprite_0_3_7,  draw_sprite_0_3_8,
			draw_sprite_0_3_9,  draw_sprite_0_3_10,
			draw_sprite_0_3_11, draw_sprite_0_3_12,
			draw_sprite_0_3_13, draw_sprite_0_3_14,
			draw_sprite_0_3_15, draw_sprite_0_3_16
		}
	},
	{
		{
			draw_sprite_1_0_1,  draw_sprite_1_0_2,
			draw_sprite_1_0_3,  draw_sprite_1_0_4,
			draw_sprite_1_0_5,  draw_sprite_1_0_6,
			draw_sprite_1_0_7,  draw_sprite_1_0_8,
			draw_sprite_1_0_9,  draw_sprite_1_0_10,
			draw_sprite_1_0_11, draw_sprite_1_0_12,
			draw_sprite_1_0_13, draw_sprite_1_0_14,
			draw_sprite_1_0_15, draw_sprite_1_0_16
		},
		{
			draw_sprite_1_1_1,  draw_sprite_1_1_2,
			draw_sprite_1_1_3,  draw_sprite_1_1_4,
			draw_sprite_1_1_5,  draw_sprite_1_1_6,
			draw_sprite_1_1_7,  draw_sprite_1_1_8,
			draw_sprite_1_1_9,  draw_sprite_1_1_10,
			draw_sprite_1_1_11, draw_sprite_1_1_12,
			draw_sprite_1_1_13, draw_sprite_1_1_14,
			draw_sprite_1_1_15, draw_sprite_1_1_16
		},
		{
			draw_sprite_1_2_1,  draw_sprite_1_2_2,
			draw_sprite_1_2_3,  draw_sprite_1_2_4,
			draw_sprite_1_2_5,  draw_sprite_1_2_6,
			draw_sprite_1_2_7,  draw_sprite_1_2_8,
			draw_sprite_1_2_9,  draw_sprite_1_2_10,
			draw_sprite_1_2_11, draw_sprite_1_2_12,
			draw_sprite_1_2_13, draw_sprite_1_2_14,
			draw_sprite_1_2_15, draw_sprite_1_2_16
		},
		{
			draw_sprite_1_3_1,  draw_sprite_1_3_2,
			draw_sprite_1_3_3,  draw_sprite_1_3_4,
			draw_sprite_1_3_5,  draw_sprite_1_3_6,
			draw_sprite_1_3_7,  draw_sprite_1_3_8,
			draw_sprite_1_3_9,  draw_sprite_1_3_10,
			draw_sprite_1_3_11, draw_sprite_1_3_12,
			draw_sprite_1_3_13, draw_sprite_1_3_14,
			draw_sprite_1_3_15, draw_sprite_1_3_16
		}
	}
};


/******************************************************************************/

INLINE void neo_draw_gfx(UINT16 **line, UINT16 *paldata, unsigned int code,
		int flipx, int sx, int sy, int zx, int yoffs, int opaque)
{
	UINT32 *fspr;

	if (sx <= -16) return;

#if ENABLE_SYSTEM_CHECK
	fspr = (UINT32 *)memory_region(REGION_GFX6) + code * 32 + 2 * yoffs;
#else
	fspr = (UINT32 *)memory_region(REGION_GFX2) + code * 32 + 2 * yoffs;
#endif

	(*neo_draw_sprite[opaque][flipx][zx])(fspr, line[sy] + sx, paldata);
}


static void draw_sprites(int start, int end, const struct rectangle *clip)
{
	int sx = 0, sy = 0, my = 0, zx = 0x0f, zy = 0xff;
	int offs, count;
	int t1, t3;
	char fullmode = 0;
	UINT16 **line = scrbitmap.line;

	/* Draw sprites */
	for (count = start; count < end; count++)
	{
		UINT8 *zoomy_rom;
		int drawn_lines;

		t1 = neogeo_vidram16[(0x10400 >> 1) + count];
		t3 = neogeo_vidram16[(0x10000 >> 1) + count];

		/* If this bit is set this new column is placed next to last one */
		if (t1 & 0x40)
		{
			sx += zx + 1;
		}
		else /* nope it is a new block */
		{
			/* Sprite scaling */
			zy = t3 & 0xff;

			sx = neogeo_vidram16[(0x10800 >> 1) + count] >> 7;

			/* Number of tiles in this strip */
			my = t1 & 0x3f;

			sy = 0x200 - (t1 >> 7);

			if (my > 0x20)
			{
				my = 0x20;

//				if (sy < 248)
					fullmode = 1;
//				else
					/* kludge to avoid a white line in KOF94 Japan stage... */
					/* probably indication of a subtle bug somewhere else */
//					fullmode = 0;
			}
			else
				fullmode = 0;
		}

		/* Get new zoom for this column */
		zx = (t3 >> 8) & 0x0f;

		if (sx >= 0x1f0) sx -= 0x200;

		/* No point doing anything if tile strip is 0 */
		if (my == 0) continue;

		if (sx >= 320) continue;

		offs = count << 6;

		/* get pointer to table in zoom ROM (thanks to Miguel Angel Horna for the info) */
		zoomy_rom = memory_region(REGION_GFX3) + (zy << 8);
		drawn_lines = 0;

		/* my holds the number of tiles in each vertical multisprite block */
		while (drawn_lines < my * 0x10)
		{
			int yy = (sy + drawn_lines) & 0x1ff;

			if (yy >= clip->min_y && yy <= clip->max_y)
			{
				int tileno, tileatr;
				int tile, yoffs;
				int zoom_line;
				int invert = 0;

				zoom_line = drawn_lines & 0xff;
				if (drawn_lines & 0x100)
				{
					zoom_line ^= 0xff;
					invert = 1;
				}
				if (fullmode)	/* fix for joyjoy, trally... */
				{
					if (zy)
					{
						zoom_line %= 2 * (zy + 1);
						if (zoom_line >= (zy + 1))
						{
							zoom_line = 2 * (zy + 1) - 1 - zoom_line;
							invert ^= 1;
						}
					}
				}

				yoffs = zoomy_rom[zoom_line] & 0x0f;
				tile = zoomy_rom[zoom_line] >> 4;

				if (invert)
				{
					tile ^= 0x1f;
					yoffs ^= 0x0f;
				}

				tileno  = neogeo_vidram16[offs + 2 * tile];
				tileatr = neogeo_vidram16[offs + 2 * tile + 1];

				if (tileatr & 0x8)
					tileno = (tileno & ~7) | (neogeo_frame_counter & 7);
				else
				if (tileatr & 0x4)
					tileno = (tileno & ~3) | (neogeo_frame_counter & 3);

				if (tileatr & 0x02) yoffs ^= 0x0f;	/* flip y */

				if (video_spr_usage[tileno])
				{
					UINT16 color = tileatr >> 8;

					neo_draw_gfx(line,
						&video_palette[color << 4],
						tileno,
						tileatr & 0x01,
						sx, yy,
						zx, yoffs,
						video_spr_usage[tileno] & 1
					);
				}
			}

			drawn_lines++;
		}
	}
}

#undef ARGS

/******************************************************************************/

#else	/* SELF_INCLUDE */

#define TILE(x)			tile = sprite[x];

#if (OPAQUE == 0)

#define B0(x, shift)	if (tile & 0x0f) bm[x] = paldata[tile & 0x0f];
#define BX(x, shift)	tile >>= (shift*4); B0(x, 0);

#if (FLIPX == 0 && FLIPY == 0)
#define FUNC_START(zx)	static void draw_sprite_0_0_##zx(ARGS)
#elif (FLIPX == 1 && FLIPY == 0)
#define FUNC_START(zx)	static void draw_sprite_0_1_##zx(ARGS)
#elif (FLIPX == 0 && FLIPY == 1)
#define FUNC_START(zx)	static void draw_sprite_0_2_##zx(ARGS)
#else
#define FUNC_START(zx)	static void draw_sprite_0_3_##zx(ARGS)
#endif

#else /* OPAQUE */

#define B0(x, shift)	bm[x] = paldata[tile & 0x0f];
#define BX(x, shift)	tile >>= (shift*4); B0(x, 0);

#if (FLIPX == 0 && FLIPY == 0)
#define FUNC_START(zx)	static void draw_sprite_1_0_##zx(ARGS)
#elif (FLIPX == 1 && FLIPY == 0)
#define FUNC_START(zx)	static void draw_sprite_1_1_##zx(ARGS)
#elif (FLIPX == 0 && FLIPY == 1)
#define FUNC_START(zx)	static void draw_sprite_1_2_##zx(ARGS)
#else
#define FUNC_START(zx)	static void draw_sprite_1_3_##zx(ARGS)
#endif

#endif /* OPAQUE */

#define UPDATE_SPRITE_POS								\
{														\
	UINT32 tile;										\

#define FUNC_END										\
}


/*--------------------------------------------*/
/*  1 : -------- O------- :          0        */
/*  2 : ----O--- O------- :     4    0        */
/*  3 : ----O--- O---O--- :     4    0   4    */
/*  4 : --O-O--- O---O--- :   2 2    0   4    */
/*  5 : --O-O--- O---O-O- :   2 2    0   4 2  */
/*  6 : --O-O-O- O---O-O- :   2 2 2  0   4 2  */
/*  7 : --O-O-O- O-O-O-O- :   2 2 2  0 2 2 2  */
/*  8 : O-O-O-O- O-O-O-O- : 0 2 2 2  0 2 2 2  */
/*  9 : O-O-O-O- OOO-O-O- : 0 2 2 2  011 2 2  */
/* 10 : O-OOO-O- OOO-O-O- : 0 211 2  011 2 2  */
/* 11 : O-OOO-O- OOO-O-OO : 0 211 2  011 2 21 */
/* 12 : O-OOO-OO OOO-O-OO : 0 211 21 011 2 21 */
/* 13 : O-OOO-OO OOO-OOOO : 0 211 21 011 2111 */
/* 14 : OOOOO-OO OOO-OOOO : 01111 21 011 2111 */
/* 15 : OOOOO-OO OOOOOOOO : 01111 21 01111111 */
/* 16 : OOOOOOOO OOOOOOOO : 01111111 01111111 */
/*--------------------------------------------*/

#if (FLIPX == 0)

FUNC_START(1)
	UPDATE_SPRITE_POS
	TILE(1) B0( 0,0)
FUNC_END

FUNC_START(2)
	UPDATE_SPRITE_POS
	TILE(0) BX( 0,4)
	TILE(1) B0( 1,0)
FUNC_END

FUNC_START(3)
	UPDATE_SPRITE_POS
	TILE(0) BX( 0,4)
	TILE(1) B0( 1,0) BX( 2,4)
FUNC_END

FUNC_START(4)
	UPDATE_SPRITE_POS
	TILE(0) BX( 0,2) BX( 1,2)
	TILE(1) B0( 2,0) BX( 3,4)
FUNC_END

FUNC_START(5)
	UPDATE_SPRITE_POS
	TILE(0) BX( 0,2) BX( 1,2)
	TILE(1) B0( 2,0) BX( 3,4) BX( 4,2)
FUNC_END

FUNC_START(6)
	UPDATE_SPRITE_POS
	TILE(0) BX( 0,2) BX( 1,2) BX( 2,2)
	TILE(1) B0( 3,0) BX( 4,4) BX( 5,2)
FUNC_END

FUNC_START(7)
	UPDATE_SPRITE_POS
	TILE(0) BX( 0,2) BX( 1,2) BX( 2,2)
	TILE(1) B0( 3,0) BX( 4,2) BX( 5,2) BX( 6,2)
FUNC_END

FUNC_START(8)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,2) BX( 2,2) BX( 3,2)
	TILE(1) B0( 4,0) BX( 5,2) BX( 6,2) BX( 7,2)
FUNC_END

FUNC_START(9)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,2) BX( 2,2) BX( 3,2)
	TILE(1) B0( 4,0) BX( 5,1) BX( 6,1) BX( 7,2) BX( 8,2)
FUNC_END

FUNC_START(10)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,2) BX( 2,1) BX( 3,1) BX( 4,2)
	TILE(1) B0( 5,0) BX( 6,1) BX( 7,1) BX( 8,2) BX( 9,2)
FUNC_END

FUNC_START(11)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,2) BX( 2,1) BX( 3,1) BX( 4,2)
	TILE(1) B0( 5,0) BX( 6,1) BX( 7,1) BX( 8,2) BX( 9,2) BX(10,1)
FUNC_END

FUNC_START(12)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,2) BX( 2,1) BX( 3,1) BX( 4,2) BX( 5,1)
	TILE(1) B0( 6,0) BX( 7,1) BX( 8,1) BX( 9,2) BX(10,2) BX(11,1)
FUNC_END

FUNC_START(13)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,2) BX( 2,1) BX( 3,1) BX( 4,2) BX( 5,1)
	TILE(1) B0( 6,0) BX( 7,1) BX( 8,1) BX( 9,2) BX(10,1) BX(11,1) BX(12,1)
FUNC_END

FUNC_START(14)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,1) BX( 2,1) BX( 3,1) BX( 4,1) BX( 5,2) BX( 6,1)
	TILE(1) B0( 7,0) BX( 8,1) BX( 9,1) BX(10,2) BX(11,1) BX(12,1) BX(13,1)
FUNC_END

FUNC_START(15)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,1) BX( 2,1) BX( 3,1) BX( 4,1) BX( 5,2) BX( 6,1)
	TILE(1) B0( 7,0) BX( 8,1) BX( 9,1) BX(10,1) BX(11,1) BX(12,1) BX(13,1) BX(14,1)
FUNC_END

FUNC_START(16)
	UPDATE_SPRITE_POS
	TILE(0) B0( 0,0) BX( 1,1) BX( 2,1) BX( 3,1) BX( 4,1) BX( 5,1) BX( 6,1) BX( 7,1)
	TILE(1) B0( 8,0) BX( 9,1) BX(10,1) BX(11,1) BX(12,1) BX(13,1) BX(14,1) BX(15,1)
FUNC_END

#else /* FLIPX */

FUNC_START(1)
	UPDATE_SPRITE_POS
	TILE(1) B0( 0,0)
FUNC_END

FUNC_START(2)
	UPDATE_SPRITE_POS
	TILE(0) BX( 1,4)
	TILE(1) B0( 0,0)
FUNC_END

FUNC_START(3)
	UPDATE_SPRITE_POS
	TILE(0) BX( 2,4)
	TILE(1) B0( 1,0) BX( 0,4)
FUNC_END

FUNC_START(4)
	UPDATE_SPRITE_POS
	TILE(0) BX( 3,2) BX( 2,2)
	TILE(1) B0( 1,0) BX( 0,4)
FUNC_END

FUNC_START(5)
	UPDATE_SPRITE_POS
	TILE(0) BX( 4,2) BX( 3,2)
	TILE(1) B0( 2,0) BX( 1,4) BX( 0,2)
FUNC_END

FUNC_START(6)
	UPDATE_SPRITE_POS
	TILE(0) BX( 5,2) BX( 4,2) BX( 3,2)
	TILE(1) B0( 2,0) BX( 1,4) BX( 0,2)
FUNC_END

FUNC_START(7)
	UPDATE_SPRITE_POS
	TILE(0) BX( 6,2) BX( 5,2) BX( 4,2)
	TILE(1) B0( 3,0) BX( 2,2) BX( 1,2) BX( 0,2)
FUNC_END

FUNC_START(8)
	UPDATE_SPRITE_POS
	TILE(0) B0( 7,0) BX( 6,2) BX( 5,2) BX( 4,2)
	TILE(1) B0( 3,0) BX( 2,2) BX( 1,2) BX( 0,2)
FUNC_END

FUNC_START(9)
	UPDATE_SPRITE_POS
	TILE(0) B0( 8,0) BX( 7,2) BX( 6,2) BX( 5,2)
	TILE(1) B0( 4,0) BX( 3,1) BX( 2,1) BX( 1,2) BX( 0,2)
FUNC_END

FUNC_START(10)
	UPDATE_SPRITE_POS
	TILE(0) B0( 9,0) BX( 8,2) BX( 7,1) BX( 6,1) BX( 5,2)
	TILE(1) B0( 4,0) BX( 3,1) BX( 2,1) BX( 1,2) BX( 0,2)
FUNC_END

FUNC_START(11)
	UPDATE_SPRITE_POS
	TILE(0) B0(10,0) BX( 9,2) BX( 8,1) BX( 7,1) BX( 6,2)
	TILE(1) B0( 5,0) BX( 4,1) BX( 3,1) BX( 2,2) BX( 1,2) BX( 0,1)
FUNC_END

FUNC_START(12)
	UPDATE_SPRITE_POS
	TILE(0) B0(11,0) BX(10,2) BX( 9,1) BX( 8,1) BX( 7,2) BX( 6,1)
	TILE(1) B0( 5,0) BX( 4,1) BX( 3,1) BX( 2,2) BX( 1,2) BX( 0,1)
FUNC_END

FUNC_START(13)
	UPDATE_SPRITE_POS
	TILE(0) B0(12,0) BX(11,2) BX(10,1) BX( 9,1) BX( 8,2) BX( 7,1)
	TILE(1) B0( 6,0) BX( 5,1) BX( 4,1) BX( 3,2) BX( 2,1) BX( 1,1) BX( 0,1)
FUNC_END

FUNC_START(14)
	UPDATE_SPRITE_POS
	TILE(0) B0(13,0) BX(12,1) BX(11,1) BX(10,1) BX( 9,1) BX( 8,2) BX( 7,1)
	TILE(1) B0( 6,0) BX( 5,1) BX( 4,1) BX( 3,2) BX( 2,1) BX( 1,1) BX( 0,1)
FUNC_END

FUNC_START(15)
	UPDATE_SPRITE_POS
	TILE(0) B0(14,0) BX(13,1) BX(12,1) BX(11,1) BX(10,1) BX( 9,2) BX( 8,1)
	TILE(1) B0( 7,0) BX( 6,1) BX( 5,1) BX( 4,1) BX( 3,1) BX( 2,1) BX( 1,1) BX( 0,1)
FUNC_END

FUNC_START(16)
	UPDATE_SPRITE_POS
	TILE(0) B0(15,0) BX(14,1) BX(13,1) BX(12,1) BX(11,1) BX(10,1) BX( 9,1) BX( 8,1)
	TILE(1) B0( 7,0) BX( 6,1) BX( 5,1) BX( 4,1) BX( 3,1) BX( 2,1) BX( 1,1) BX( 0,1)
FUNC_END

#endif /* FLIPX */

#undef FUNC_START
#undef FUNC_END
#undef UPDATE_SPRITE_POS
#undef TILE
#undef B0
#undef BX

#endif /* SELF_INCLUDE */
