/***************************************************************************

	2610intf.c

	YM2610pC^tF[X

***************************************************************************/

#include "neogeocd.h"

static void IRQHandler(int irq);
static void timer_callback_2610(int param);
static void TimerHandler(int channel, int count, double stepTime);


/****************************************************************************
	[Jϐ
 ***************************************************************************/

static void *Timer[2];


/***************************************************************************
	O[o֐
 ***************************************************************************/

/*------------------------------------------------------

	YM2610G~[V̊Jn

	  : Ȃ
	߂l: 1: 0:s

 -----------------------------------------------------*/

int YM2610_sh_start(void)
{
	void *pcmbufa;
	int  pcmsizea;

	Timer[0] = timer_alloc(timer_callback_2610);
	Timer[1] = timer_alloc(timer_callback_2610);

	stream_init(YM2610Update);

	pcmbufa = (void *)memory_region(REGION_SOUND1);
	pcmsizea = memory_region_length(REGION_SOUND1);

	return YM2610Init(8000000, sample_rate, pcmbufa, pcmsizea, TimerHandler, IRQHandler);
}


/*------------------------------------------------------

	YM2610G~[V̒~

	  : Ȃ
	߂l: 1: 0:s

 -----------------------------------------------------*/

void YM2610_sh_stop(void)
{
}


/*------------------------------------------------------

	YM2610G~[ṼZbg

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void YM2610_sh_reset(void)
{
	YM2610Reset();
}


/*------------------------------------------------------

	YM2610̍XVv

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void YM2610UpdateRequest(void)
{
	stream_update(100);
}


/*------------------------------------------------------

	YM2610̃|[g[h

	  : offs_t offset ItZbg(gp)
	߂l: |[g̒l

 -----------------------------------------------------*/

READ8_HANDLER( YM2610_status_port_A_r )
{
	return YM2610Read(0);
}

READ8_HANDLER( YM2610_status_port_B_r )
{
	return YM2610Read(2);
}

READ8_HANDLER( YM2610_read_port_r )
{
	return YM2610Read(1);
}


/*------------------------------------------------------

	YM2610̃|[gCg

	  : offs_t offset ItZbg(gp)
			UINT8 data    f[^
	߂l: Ȃ

 -----------------------------------------------------*/

WRITE8_HANDLER( YM2610_control_port_A_w )
{
	YM2610Write(0, data);
}

WRITE8_HANDLER( YM2610_control_port_B_w )
{
	YM2610Write(2, data);
}

WRITE8_HANDLER( YM2610_data_port_A_w )
{
	YM2610Write(1, data);
}

WRITE8_HANDLER( YM2610_data_port_B_w )
{
	YM2610Write(3, data);
}


/***************************************************************************
	[J֐
 ***************************************************************************/

/*------------------------------------------------------

	YM2610 IRQnh

	  : int irq  IRQ
	߂l: Ȃ

 -----------------------------------------------------*/

static void IRQHandler(int irq)
{
	if (irq)
		z80_set_irq_line(irq, ASSERT_LINE);
	else
		z80_set_irq_line(0, CLEAR_LINE);
}


/*------------------------------------------------------

	YM2610 ^C}[R[obN֐

	  : int param  ^C}[̔ԍ
	߂l: Ȃ

 -----------------------------------------------------*/

static void timer_callback_2610(int param)
{
//	logerror("2610 TimerOver %d\n", param);
	YM2610TimerOver(param);
}


/*------------------------------------------------------

	YM2610 ^C}[nh

	  : int channel      ^C}[̔ԍ
	        int count        ^C}[sJEg
	        double stepTime  1JEg̎
	߂l: Ȃ

 -----------------------------------------------------*/

static void TimerHandler(int channel, int count, double stepTime)
{
	if (count == 0)
	{
		/* Reset FM Timer */
//		logerror("2610 TimerReset %d\n", channel);
		timer_enable(Timer[channel], 0);
	}
	else
	{
		/* Start FM Timer */
		double timeSec = (double)count * stepTime;

		if (!timer_enable(Timer[channel], 1))
			timer_adjust(Timer[channel], timeSec, channel, 0);
	}
}
