/***************************************************************************

	sndintrf.c

	TEhC^tF[X

***************************************************************************/

#include "neogeocd.h"


/****************************************************************************
	O[oϐ
 ***************************************************************************/

int sample_rate;


/****************************************************************************
	[Jϐ
 ***************************************************************************/

static void *sound_update_timer = NULL;
static double refresh_period;
static double refresh_period_inv;

static int cleared_value = 0x00;
static int latch = 0x00;


/***************************************************************************
	O[o֐
 ***************************************************************************/

/*--------------------------------------------------------

	TEhĐ

	  : Ȃ
	߂l: 1:  0:s

 -------------------------------------------------------*/

int sound_init(void)
{
	sample_rate = options.samplerate;

	refresh_period = TIME_IN_HZ(video_fps);
	refresh_period_inv = 1.0 / refresh_period;
	sound_update_timer = timer_alloc(NULL);

	if (streams_sh_start() != 0)
		return 0;

	if (YM2610_sh_start() != 0)
		return 0;

	return 1;
}


/*--------------------------------------------------------

	TEhĐI

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

void sound_shutdown(void)
{
	YM2610_sh_stop();
	streams_sh_stop();
}


/*--------------------------------------------------------

	TEhXV

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

void sound_update(void)
{
	if (sample_rate)
	{
		if (cdrom_loading_state != CDROM_IDLE)
			stream_update(1000000 / (sample_rate * video_fps));
		streams_sh_update();
		timer_adjust(sound_update_timer, TIME_NEVER, 0, 0);
	}
}


/*--------------------------------------------------------

	TEhZbg

	  : Ȃ
	߂l: Ȃ

 -------------------------------------------------------*/

void sound_reset(void)
{
	if (sample_rate)
		YM2610_sh_reset();
}


/*--------------------------------------------------------

	TEh̃obt@݈̌ʒu擾

	  : int value
	߂l: ݂̈ʒu

 -------------------------------------------------------*/

int sound_scalebufferpos(int value)
{
	int result = (int)((double)value * timer_timeelapsed(sound_update_timer) * refresh_period_inv);

	if (value >= 0)
		return (result < value) ? result : value;
	else
		return (result > value) ? result : value;
}


/*--------------------------------------------------------

	TEhĐ̃f[^̏

	  : offs_t offset  ItZbg(gp)
	        UINT8 data     f[^(TEhԍ)
	߂l: Ȃ

 -------------------------------------------------------*/

WRITE8_HANDLER( soundlatch_w )
{
	latch = data;
}


/*--------------------------------------------------------

	TEhĐ̃f[^̓ǂݍ

	  : offs_t offset  ItZbg(gp)
	߂l: Đ҂̃f[^

 -------------------------------------------------------*/

READ8_HANDLER( soundlatch_r )
{
	return latch;
}


/*--------------------------------------------------------

	TEhĐ̃f[^̃NA

	  : offs_t offset  ItZbg(gp)
	        UINT8 data     f[^(TEhNAl)
	߂l: Ȃ

 -------------------------------------------------------*/

WRITE8_HANDLER( soundlatch_clear_w )
{
	latch = cleared_value;
}


/*--------------------------------------------------------

	TEhĐ̃f[^̃NAlݒ

	  : int value    f[^̃NAɎgpl
	߂l: Ȃ

 -------------------------------------------------------*/

void soundlatch_setclearedvalue(int value)
{
	cleared_value = value;
}
