/***************************************************************************

	machine.c

	NEOGEO CD }VG~[VRA

***************************************************************************/

#ifndef MACHINE_H
#define MACHINE_H

#include "cdda.h"
#include "cdrom.h"
#include "loadscr.h"
#include "simbios.h"
#include "pd4990a.h"
#include "i68k.h"

// O]^Cv
#define	EXMEM_OBJ		0x00
#define	EXMEM_PCMA		0x01
#define	EXMEM_Z80		0x04
#define	EXMEM_FIX		0x05
#define	EXMEM_UNKNOWN	0xff

// n[hEFA]^Cv
#define	PRG_TYPE		0x00
#define FIX_TYPE		0x01
#define SPR_TYPE		0x02
#define Z80_TYPE		0x03
#define PCM_TYPE		0x04
#define PAT_TYPE		0x05
#define PAL_TYPE		0x06
#define OBJ_TYPE		0x07
#define AXX_TYPE		0x08
#define BACKUP_RAM		0x09
#define UNKNOWN_TYPE	0x0f

#define	BIOS_PRG_TYPE	0x10	// gp
#define BIOS_FIX_TYPE	0x11
#define BIOS_SPR_TYPE	0x12
#define BIOS_Z80_TYPE	0x13
#define BIOS_PCM_TYPE	0x14
#define BIOS_PAT_TYPE	0x15	// gp
#define BIOS_PAL_TYPE	0x16	// gp
#define BIOS_OBJ_TYPE	0x17	// gp
#define BIOS_AXX_TYPE	0x18	// gp

// n[hEFA]@
#define UPLOAD_IMMIDIATE	0x00
#define UPLOAD_PATTERN		0x01
#define UPLOAD_MEMORY		0x02
#define UPLOAD_FILE			0x03

// n[hEFA]p}N
#define upload_get_type()		m68000_read_memory_8(0x108000 + 0x7eda)
#define upload_get_bank()		m68000_read_memory_8(0x108000 + 0x7edb)
#define upload_get_dst()		m68000_read_memory_32(0x108000 + 0x7ef4)
#define upload_get_src()		m68000_read_memory_32(0x108000 + 0x7ef8)
#define upload_get_length()		m68000_read_memory_32(0x108000 + 0x7efc)

// [hʗp}N
#define with_image()			m68000_read_memory_8(0x108000 + 0x7ddc)
#define spr_disable_w(data)		m68000_write_memory_8(0xff0111, data)
#define fix_disable_w(data)		m68000_write_memory_8(0xff0115, data)
#define video_enable_w(data)	m68000_write_memory_8(0xff0119, data)

extern int  game_index;
extern char game_name[];
extern int  driver_type;
extern int  driver_flag;

void neogeo_run(void);
void neogeo_reset(void);

void neogeo_decode_spr(UINT8 *mem, offs_t offset, UINT32 length);
void neogeo_decode_fix(UINT8 *mem, offs_t offset, UINT32 length);
void neogeo_undecode_fix(UINT8 *mem, offs_t offset, UINT32 length);
void neogeo_apply_patch(UINT16 *src, int bank, offs_t offset);

WRITE16_HANDLER( neogeo_select_bios_vectors );
WRITE16_HANDLER( neogeo_select_game_vectors );

READ16_HANDLER( neogeo_memcard16_r );
WRITE16_HANDLER( neogeo_memcard16_w );

READ16_HANDLER( neogeo_externalmem_16_r );
WRITE16_HANDLER( neogeo_externalmem_16_w );

READ16_HANDLER( neogeo_hardcontrol_16_r );
WRITE16_HANDLER( neogeo_hardcontrol_16_w );

void neogeo_set_title(void);

#endif /* MACHINE_H */
