/***************************************************************************

	input.c

	̓foCX

***************************************************************************/

#include "neogeocd.h"


/****************************************************************************
	O[oϐ
 ***************************************************************************/

int key_code[MAX_PLAYER][MAX_BUTTON];
int joy_code[MAX_PLAYER][MAX_BUTTON];
int autofire[MAX_PLAYER][4];
int button_mask[MAX_PLAYER][4];

static int afcounter[MAX_PLAYER][4];


/***************************************************************************
	O[o֐
 ***************************************************************************/

/*------------------------------------------------------

	̓foCX̏

	  : Ȃ
	߂l: 1: 0:s

 -----------------------------------------------------*/

int input_init(void)
{
	if (osd_keyboard_init() == OSD_OK)
	{
		if (osd_joystick_init() == OSD_OK)
			return 1;

		osd_joystick_exit();
	}
	osd_keyboard_exit();

	build_hotkey();

	return 0;
}


/*------------------------------------------------------

	̓foCX̐I

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void input_shutdown(void)
{
	osd_joystick_exit();
	osd_keyboard_exit();
}


/*------------------------------------------------------

	̓foCXZbg

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void input_reset(void)
{
	osd_joystick_reset();
	osd_keyboard_reset();
	build_hotkey();
}


/*------------------------------------------------------

	̓foCX̏ԂXV

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void update_input_port(void)
{
	osd_poll_joystick();
	osd_poll_keyboard();
}


/*------------------------------------------------------

	zbgL[쐬

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void build_hotkey(void)
{
	int player, button;

	for (player = 0; player < 2; player++)
	{
		for (button = 0; button < 4; button++)
		{
			int type = options.hotkey[player][button];

			afcounter[player][button] = 0;
			autofire[player][button] = 1;
			button_mask[player][button] = 0xff;

			switch (type)
			{
			case 5: // A+B
				button_mask[player][button] &= ~((1 << NEOGEO_INPUT_BUTTONA) | (1 << NEOGEO_INPUT_BUTTONB));
				break;

			case 6: // A+C
				button_mask[player][button] &= ~((1 << NEOGEO_INPUT_BUTTONA) | (1 << NEOGEO_INPUT_BUTTONC));
				break;

			case 7: // A+D
				button_mask[player][button] &= ~((1 << NEOGEO_INPUT_BUTTONA) | (1 << NEOGEO_INPUT_BUTTOND));
				break;

			case 8: // B+C
				button_mask[player][button] &= ~((1 << NEOGEO_INPUT_BUTTONB) | (1 << NEOGEO_INPUT_BUTTONC));
				break;

			case 9: // B+D
				button_mask[player][button] &= ~((1 << NEOGEO_INPUT_BUTTONB) | (1 << NEOGEO_INPUT_BUTTOND));
				break;

			case 10: // C+D
				button_mask[player][button] &= ~((1 << NEOGEO_INPUT_BUTTONC) | (1 << NEOGEO_INPUT_BUTTOND));
				break;

			case 11: // A+B+C
				button_mask[player][button] &= ~((1 << NEOGEO_INPUT_BUTTONA) | (1 << NEOGEO_INPUT_BUTTONB) | (1 << NEOGEO_INPUT_BUTTONC));
				break;

			case 12: // A+B+D
				button_mask[player][button] &= ~((1 << NEOGEO_INPUT_BUTTONA) | (1 << NEOGEO_INPUT_BUTTONB) | (1 << NEOGEO_INPUT_BUTTOND));
				break;

			case 13: // A+C+D
				button_mask[player][button] &= ~((1 << NEOGEO_INPUT_BUTTONA) | (1 << NEOGEO_INPUT_BUTTONC) | (1 << NEOGEO_INPUT_BUTTOND));
				break;

			case 14: // B+C+D
				button_mask[player][button] &= ~((1 << NEOGEO_INPUT_BUTTONB) | (1 << NEOGEO_INPUT_BUTTONC) | (1 << NEOGEO_INPUT_BUTTOND));
				break;

			case 15: // A+B+C+D
				button_mask[player][button] &= ~((1 << NEOGEO_INPUT_BUTTONA) | (1 << NEOGEO_INPUT_BUTTONB) | (1 << NEOGEO_INPUT_BUTTONC) | (1 << NEOGEO_INPUT_BUTTOND));
				break;
			}
		}
	}
}


/*------------------------------------------------------

	A˃tOXV

	  : Ȃ
	߂l: Ȃ

 -----------------------------------------------------*/

void update_autofire_flag(void)
{
	int player, button;

	for (player = 0; player < 2; player++)
	{
		for (button = 0; button < 4; button++)
		{
			if (options.hotkey[player][button] == button + 1)
			{
				if (osd_is_joy_pressed(joy_code[player][button + 10]))
				{
					afcounter[player][button]++;
					if (afcounter[player][button] == options.afinterval[player])
					{
						afcounter[player][button] = 0;
						autofire[player][button] ^= 1;
					}
				}
				else
				{
					afcounter[player][button] = 0;
					autofire[player][button] = 1;
				}
			}
			else
			{
				afcounter[player][button] = 0;
				autofire[player][button] = 1;
			}
		}
	}
}


/*------------------------------------------------------

	zbgL[𔽉f

	  : int player    vC[ԍ
	        UINT8 value   ݂̃{^̏
	߂l: zbgL[𔽉f{^

 -----------------------------------------------------*/

UINT8 apply_hotkey(int player, UINT8 value)
{
	int button;

	for (button = 0; button < 4; button++)
	{
		// Rg[[ɔf
		if (options.hotkey[player][button])
		{
			if (osd_is_joy_pressed(joy_code[player][button + 10]))
			{
				switch (options.hotkey[player][button])
				{
				case 1:	// autofire A
					value &= ~(autofire[player][0] << NEOGEO_INPUT_BUTTONA);
					break;

				case 2:	// autofire B
					value &= ~(autofire[player][1] << NEOGEO_INPUT_BUTTONB);
					break;

				case 3:	// autofire C
					value &= ~(autofire[player][2] << NEOGEO_INPUT_BUTTONC);
					break;

				case 4:	// autofire D
					value &= ~(autofire[player][3] << NEOGEO_INPUT_BUTTOND);
					break;

				default:
					value &= button_mask[player][button];
					break;
				}
			}
		}
	}

	return value;
}


/*------------------------------------------------------

	NEOGEORg[1̓`FbN

	  : Ȃ
	߂l: |[g̓͏Ԃ̃f[^

 -----------------------------------------------------*/

UINT16 read_controler1(void)
{
	int button;
	UINT8 mask = 0x01, value = 0xff;

	update_input_port();

	for (button = NEOGEO_INPUT_UP; button <= NEOGEO_INPUT_BUTTOND; button++, mask <<= 1)
		if (osd_is_key_pressed(key_code[PLAYER1][button]) || osd_is_joy_pressed(joy_code[PLAYER1][button]))
			value &= ~mask;

	value = apply_hotkey(0, value);

	return value << 8;
}


/*------------------------------------------------------

	NEOGEORg[2̓`FbN

	  : Ȃ
	߂l: |[g̓͏Ԃ̃f[^

 -----------------------------------------------------*/

UINT16 read_controler2(void)
{
	int button;
	UINT8 mask = 0x01, value = 0xff;

	update_input_port();

	for (button = NEOGEO_INPUT_UP; button <= NEOGEO_INPUT_BUTTOND; button++, mask <<= 1)
		if (osd_is_key_pressed(key_code[PLAYER2][button]) || osd_is_joy_pressed(joy_code[PLAYER2][button]))
			value &= ~mask;

	value = apply_hotkey(1, value);

	return value << 8;
}


/*------------------------------------------------------

	[UC^tF[X̃{^ꂽ`FbN

	  : int port  |[gԍ
	߂l: |[g̓͏Ԃ̃f[^

 -----------------------------------------------------*/

int input_ui_pressed(int code, int flag)
{
	int pressed = 0;

	if (flag & UI_PLAYER1)
	{
		if (flag & UI_KEYBOARD) pressed |= osd_is_key_pressed_memory(key_code[PLAYER1][code]);
		if (flag & UI_JOYSTICK) pressed |= osd_is_joy_pressed_memory(joy_code[PLAYER1][code]);
	}
	if (flag & UI_PLAYER2)
	{
		if (flag & UI_KEYBOARD) pressed |= osd_is_key_pressed_memory(key_code[PLAYER2][code]);
		if (flag & UI_JOYSTICK) pressed |= osd_is_joy_pressed_memory(joy_code[PLAYER2][code]);
	}
	if (code == INPUT_UP)
	{
		pressed |= osd_is_key_pressed_memory(KEYCODE_UP);
		pressed |= osd_is_key_pressed_memory(KEYCODE_8_PAD);
	}
	if (code == INPUT_DOWN)
	{
		pressed |= osd_is_key_pressed_memory(KEYCODE_DOWN);
		pressed |= osd_is_key_pressed_memory(KEYCODE_2_PAD);
	}
	if (code == INPUT_LEFT)
	{
		pressed |= osd_is_key_pressed_memory(KEYCODE_LEFT);
		pressed |= osd_is_key_pressed_memory(KEYCODE_4_PAD);
	}
	if (code == INPUT_RIGHT)
	{
		pressed |= osd_is_key_pressed_memory(KEYCODE_RIGHT);
		pressed |= osd_is_key_pressed_memory(KEYCODE_6_PAD);
	}
	if (code == INPUT_SELECT)
	{
		pressed |= osd_is_key_pressed_memory(KEYCODE_ENTER);
		pressed |= osd_is_key_pressed_memory(KEYCODE_ENTER_PAD);
	}
	if (code == INPUT_CANCEL)
	{
		pressed |= osd_is_key_pressed_memory(KEYCODE_ESC);
	}

	return pressed;
}


/*------------------------------------------------------

	͂ꂽL[b܂ő҂

	  : int interval  `FbNԊu(~b)
	߂l: Ȃ

 -----------------------------------------------------*/

void input_ui_wait_keyclear(int interval)
{
	int pressed = 1;

	do
	{
		int i, player;

		Sleep(interval);
		osd_poll_joystick();
		osd_poll_keyboard();

		pressed = 0;
		for (player = 0; player < 2; player++)
		{
			for (i = 0; i < 10; i++)
				pressed |= osd_is_key_pressed(key_code[player][i]);
			for (i = 0; i < 10; i++)
				pressed |= osd_is_joy_pressed(joy_code[player][i]);
		}
	} while (pressed);
}
